/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapLoadTableLevelsTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(MapLoadTableLevelsTableModel.class);
    public static final int LEVEL_NAME = 0;
    public static final int COLUMN_NAME = 1;
    public static final int CAPTION = 2;
    private static final int TOTAL_COLS = 3;
    private static final int TOTAL_HIDDEN_COLS = 0;
    private Object[] levels;
    private DimensionSet dimensionSet;
    private PhysicalTable mappedTable;
    private String[] columns;
    private Map columnMap;
    private boolean isShared;
    private OLAPSharedDimension sharedDim;

    public MapLoadTableLevelsTableModel(DimensionSet inputDimensionSet, PhysicalTable inputMappedTable, AbstractOLAPModel object) throws OLAPException {
        int i;
        this.dimensionSet = inputDimensionSet;
        this.mappedTable = inputMappedTable;
        TableSet tableSet = null;
        if (object instanceof OLAPCube) {
            OLAPCube owningCube = this.dimensionSet.getOwningCube();
            tableSet = owningCube.getTableSet();
            this.levels = this.dimensionSet.getLevels().values().toArray();
        } else {
            this.sharedDim = (OLAPSharedDimension)object;
            tableSet = this.sharedDim.getTableSet();
            this.levels = this.sharedDim.getLevels().toArray();
            this.isShared = true;
        }
        ArrayList<OLAPLevel> missingColumns = new ArrayList<OLAPLevel>();
        ArrayList<Object> allColumns = new ArrayList<Object>();
        for (int i2 = this.levels.length - 1; i2 >= 0; --i2) {
            if (!this.isShared) {
                List listOfLevels = (List)this.levels[i2];
                int size = listOfLevels.size();
                for (int t = 0; t < size; ++t) {
                    OLAPLevel level = (OLAPLevel)listOfLevels.get(t);
                    OLAPDimension dimension = level.getDimension();
                    if (tableSet.isLoadStarSchema() && (!tableSet.isLoadStarSchema() || dimension.isStarDimension())) continue;
                    Column column = this.dimensionSet.getMappedLevel(level);
                    if (column == null) {
                        missingColumns.add(level);
                        continue;
                    }
                    allColumns.add(level);
                }
                continue;
            }
            OLAPLevel level = (OLAPLevel)this.levels[i2];
            OLAPDimension dimension = level.getDimension();
            Column column = this.dimensionSet.getMappedLevel(level);
            if (column == null) {
                missingColumns.add(level);
                continue;
            }
            allColumns.add(level);
        }
        Object[] tempAllColumns = allColumns.toArray();
        Arrays.sort(tempAllColumns);
        Object[] tempMissingColumns = missingColumns.toArray();
        Arrays.sort(tempMissingColumns);
        allColumns.clear();
        for (i = tempAllColumns.length - 1; i >= 0; --i) {
            allColumns.add(0, tempAllColumns[i]);
        }
        for (i = tempMissingColumns.length - 1; i >= 0; --i) {
            allColumns.add(0, tempMissingColumns[i]);
        }
        this.levels = allColumns.toArray();
        try {
            this.columnMap = new HashMap();
            AssociationList jomaColumns = this.mappedTable.getColumns(false);
            this.columns = new String[jomaColumns.size()];
            int count = 0;
            for (int i3 = jomaColumns.size() - 1; i3 >= 0; --i3) {
                Column column = (Column)jomaColumns.get(i3);
                String name = column.getSASColumnName();
                this.columnMap.put(name.toUpperCase(), column);
                this.columns[count] = column.getSASColumnName();
                ++count;
            }
        }
        catch (MdException jomaColumns) {
        }
        catch (RemoteException re) {
            Workspace.handleRemoteException((RemoteException)re);
        }
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("MapLoadTable.LevelsDetail.Name.txt"), 100, 32);
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("MapLoadTable.Detail.Column.txt"), 100, this.columns);
        this.m_aColumns[1].setEditable(true);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("CubeDesigner.MeasuresModel.Caption.header.title"), 200, 200);
        this.m_aColumns[2].setEditable(false);
    }

    public int getColumnCount() {
        return 3;
    }

    public int getHiddenColumnCount() {
        return 0;
    }

    public void moveDataToModel() {
        try {
            int nRows = this.m_lData.size();
            if (nRows > 0) {
                this.m_lData.clear();
                this.fireTableRowsDeleted(0, nRows - 1);
            }
            nRows = this.levels.length;
            for (int i = 0; i < nRows; ++i) {
                ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
                OLAPLevel level = (OLAPLevel)this.levels[i];
                alRow.add(0, level);
                Column column = null;
                column = !this.isShared ? this.dimensionSet.getMappedLevel(level) : this.sharedDim.getMappedLevel(level);
                if (column != null) {
                    alRow.add(1, column.getSASColumnName());
                } else {
                    alRow.add(1, "");
                }
                alRow.add(2, level);
                this.m_lData.add(alRow);
            }
            if (nRows > 0) {
                this.fireTableRowsInserted(0, nRows - 1);
            }
            this.m_nRowInstances = nRows;
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    Column getColumn(String name) {
        return (Column)this.columnMap.get(name.toUpperCase());
    }

    public void populateStore() {
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        super.setValueAt(value, iRow, iCol);
    }
}

