/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.Column;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MapLoadTableFactKeysTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(MapLoadTableFactKeysTableModel.class);
    static final int DIMENSION_NAME = 0;
    static final int COLUMN_NAME = 1;
    private static final int TOTAL_COLS = 2;
    private static final int TOTAL_HIDDEN_COLS = 0;
    private Object[] dimensions;
    private DimensionSet dimensionSet;
    private PhysicalTable mappedTable;
    private String[] columns;
    private Map columnMap;

    public MapLoadTableFactKeysTableModel(DimensionSet inputDimensionSet, PhysicalTable inputMappedTable) throws OLAPException {
        int i;
        this.dimensionSet = inputDimensionSet;
        this.mappedTable = inputMappedTable;
        List tempDimensions = this.dimensionSet.getAllCubeDimensions();
        ArrayList<OLAPDimension> missingColumns = new ArrayList<OLAPDimension>();
        ArrayList<Object> allColumns = new ArrayList<Object>();
        for (int i2 = tempDimensions.size() - 1; i2 >= 0; --i2) {
            OLAPDimension dimension = (OLAPDimension)tempDimensions.get(i2);
            if (!dimension.isStarDimension()) continue;
            Column column = this.dimensionSet.getMappedFactKey(dimension);
            if (column == null) {
                missingColumns.add(dimension);
                continue;
            }
            allColumns.add(dimension);
        }
        Object[] tempAllColumns = allColumns.toArray();
        Arrays.sort(tempAllColumns);
        Object[] tempMissingColumns = missingColumns.toArray();
        Arrays.sort(tempMissingColumns);
        allColumns.clear();
        for (i = tempAllColumns.length - 1; i >= 0; --i) {
            allColumns.add(0, tempAllColumns[i]);
        }
        for (i = tempMissingColumns.length - 1; i >= 0; --i) {
            allColumns.add(0, tempMissingColumns[i]);
        }
        this.dimensions = allColumns.toArray();
        this.columnMap = new HashMap();
        AssociationList jomaColumns = null;
        try {
            jomaColumns = this.mappedTable.getColumns(false);
            this.columns = new String[jomaColumns.size()];
            for (int i3 = jomaColumns.size() - 1; i3 >= 0; --i3) {
                Column column = (Column)jomaColumns.get(i3);
                String name = column.getSASColumnName();
                this.columnMap.put(name, column);
                this.columns[i3] = name;
            }
        }
        catch (MdException mdException) {
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("MapLoadTable.FactKeys.Dimension.header.title"), 100, 32);
        this.m_aColumns[0].setEditable(false);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("MapLoadTable.Detail.Column.txt"), 100, this.columns);
        this.m_aColumns[1].setEditable(true);
    }

    public int getColumnCount() {
        return 2;
    }

    Column getColumn(String name) {
        return (Column)this.columnMap.get(name);
    }

    public int getHiddenColumnCount() {
        return 0;
    }

    public void moveDataToModel() {
        try {
            int nRows = this.m_lData.size();
            if (nRows > 0) {
                this.m_lData.clear();
                this.fireTableRowsDeleted(0, nRows - 1);
            }
            nRows = this.dimensions.length;
            for (int i = 0; i < nRows; ++i) {
                ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
                OLAPDimension dimension = (OLAPDimension)this.dimensions[i];
                alRow.add(0, dimension);
                Column column = this.dimensionSet.getMappedFactKey(dimension);
                if (column != null) {
                    alRow.add(1, column.getSASColumnName());
                } else {
                    alRow.add(1, "");
                }
                this.m_lData.add(alRow);
            }
            if (nRows > 0) {
                this.fireTableRowsInserted(0, nRows - 1);
            }
            this.m_nRowInstances = nRows;
        }
        catch (RemoteException e) {
            ExceptionHandler.handleException((Exception)e);
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() {
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        super.setValueAt(value, iRow, iCol);
    }
}

