/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class GeneralAdvancedStarOptionsTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(GeneralAdvancedStarOptionsTab.class);
    private OLAPCube cubeModel;
    private JCheckBox compact;
    private JRadioButton error;
    private JRadioButton terse;
    private JRadioButton verbose;
    private ButtonGroup missingKeys;

    public GeneralAdvancedStarOptionsTab(OLAPCube cm) {
        this.cubeModel = cm;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("cd_general_cmpctnwy_dimkey");
        this.layoutWidgets();
        this.initializeFields();
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (!saveToModel) {
            // empty if block
        }
        return true;
    }

    private void initializeFields() {
        try {
            String compactProperty = this.cubeModel.getCompact();
            if (compactProperty != null && compactProperty.equals("1")) {
                this.compact.setSelected(true);
            } else {
                this.compact.setSelected(false);
            }
            String missingKeysProperty = this.cubeModel.getMissingDimensionKeys();
            if (missingKeysProperty == null) {
                this.error.setSelected(true);
            } else if (missingKeysProperty.equals("TERSE")) {
                this.terse.setSelected(true);
            } else if (missingKeysProperty.equals("VERBOSE")) {
                this.verbose.setSelected(true);
            } else {
                this.error.setSelected(true);
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.compact = new JCheckBox();
        this.compact.setName("StarOptionsTabCompactCheckbox");
        VisualUtilities.setButtonTextAndMnemonic(this.compact, bundle.getString("CubeDesigner.StarOptionsTab.Compact.txt"));
        this.compact.setToolTipText(bundle.getString("CubeDesigner.StarOptionsTab.Compact.ToolTip.txt"));
        this.add(this.compact, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        JLabel handleError = new JLabel();
        handleError = new JLabel(bundle.getString("CubeDesigner.StarOptionsTab.MissingKeys.radio.label"));
        panel.add((Component)handleError, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.error = new JRadioButton();
        this.error.setActionCommand("ERROR");
        this.error.setName("StarOptionsTabErrorRadio");
        VisualUtilities.setButtonTextAndMnemonic(this.error, bundle.getString("CubeDesigner.StarOptionsTab.Error.txt"));
        this.error.setToolTipText(bundle.getString("CubeDesigner.StarOptionsTab.Error.ToolTip.txt"));
        panel.add((Component)this.error, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.terse = new JRadioButton();
        this.terse.setActionCommand("TERSE");
        this.terse.setName("StarOptionsTabTerseRadio");
        VisualUtilities.setButtonTextAndMnemonic(this.terse, bundle.getString("CubeDesigner.StarOptionsTab.Terse.txt"));
        this.terse.setToolTipText(bundle.getString("CubeDesigner.StarOptionsTab.Terse.ToolTip.txt"));
        panel.add((Component)this.terse, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0));
        this.verbose = new JRadioButton();
        this.verbose.setActionCommand("VERBOSE");
        this.verbose.setName("StarOptionsTabVerboseRadio");
        VisualUtilities.setButtonTextAndMnemonic(this.verbose, bundle.getString("CubeDesigner.StarOptionsTab.Verbose.txt"));
        this.verbose.setToolTipText(bundle.getString("CubeDesigner.StarOptionsTab.Verbose.ToolTip.txt"));
        panel.add((Component)this.verbose, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add(panel, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.missingKeys = new ButtonGroup();
        this.missingKeys.add(this.error);
        this.error.setSelected(true);
        this.missingKeys.add(this.terse);
        this.missingKeys.add(this.verbose);
    }

    public void saveDataToCubeModel() {
        try {
            if (this.compact.isSelected()) {
                this.cubeModel.setCompact("1");
            } else {
                this.cubeModel.setCompact("0");
            }
            this.cubeModel.setMissingDimensionKeys(this.missingKeys.getSelection().getActionCommand());
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }
}

