/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.CubeGeneralLanguageTab;
import com.sas.olapadmin.designer.visuals.CubeGeneralRaggedHierarchyTab;
import com.sas.olapadmin.designer.visuals.GeneralAdvancedFMTSearchTab;
import com.sas.olapadmin.designer.visuals.GeneralAdvancedSASCodeTab;
import com.sas.olapadmin.designer.visuals.GeneralAdvancedStarOptionsTab;
import com.sas.olapadmin.designer.visuals.SortingTab;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAPropertyDialog;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Frame;

public class GeneralAdvancedDialog
extends WAPropertyDialog {
    private static final long serialVersionUID = 1L;
    static WAdminResource bundle = new WAdminResource(GeneralAdvancedDialog.class);
    protected GeneralAdvancedFMTSearchTab FMTTab;
    protected GeneralAdvancedSASCodeTab codeTab;
    protected CubeGeneralLanguageTab langTab;
    protected CubeGeneralRaggedHierarchyTab ragHierTab;
    private GeneralAdvancedStarOptionsTab optionsTab;
    private SortingTab sortTab;
    protected String loadType = null;
    private TableSet tableSet;

    public GeneralAdvancedDialog(OLAPCube CM) {
        super((Frame)Workspace.getWorkspace(), bundle.getString("CubeDesigner.General.Advanced.Title.txt"), true);
        this.ragHierTab = new CubeGeneralRaggedHierarchyTab(CM);
        this.tableSet = CM.getTableSet();
        this.ragHierTab.setName("genAdvRagHierTab");
        this.addTab(bundle.getString("DimDesigner.Hierarchy.Missing.txt"), this.ragHierTab);
        this.sortTab = new SortingTab(CM);
        this.sortTab.setName("genAdvSortTab");
        this.addTab(bundle.getString("CubeDesigner.SortingTab.title.txt"), (WAPropertyTab)this.sortTab);
        try {
            if (this.tableSet.isLoadStarSchema()) {
                this.optionsTab = new GeneralAdvancedStarOptionsTab(CM);
                this.optionsTab.setName("genStarOptionsTab");
                this.addTab(bundle.getString("CubeDesigner.StarOptionsTab.Title.txt"), this.optionsTab);
                this.langTab = new CubeGeneralLanguageTab(CM);
                this.langTab.setName("genAdvLangTab");
                this.addTab(bundle.getString("CubeDesigner.TranslationTab.Title.txt"), this.langTab);
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        this.codeTab = new GeneralAdvancedSASCodeTab(CM);
        this.codeTab.setName("genAdvSASCodeTab");
        this.addTab(bundle.getString("General.Advanced.SASCode.tab.txt"), this.codeTab);
        this.FMTTab = new GeneralAdvancedFMTSearchTab(CM);
        this.FMTTab.setName("genAdvFMTSearchTab");
        this.addTab(bundle.getString("General.Advanced.FMTSearch.tab.txt"), this.FMTTab);
    }

    protected boolean onOK() {
        if (super.onOK()) {
            this.FMTTab.saveDataToCubeModel();
            this.codeTab.saveDataToCubeModel();
            this.ragHierTab.saveDataToCubeModel();
            this.sortTab.saveDataToCubeModel();
            try {
                if (this.tableSet.isLoadStarSchema()) {
                    if (this.langTab != null) {
                        this.langTab.saveDataToCubeModel();
                    }
                    this.optionsTab.saveDataToCubeModel();
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            return true;
        }
        return false;
    }

    public boolean onCancel() {
        if (this.langTab != null) {
            this.langTab.onCancel();
        }
        return true;
    }
}

