/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.visuals.DimLevelSuppliedDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsBooleanTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DimLevelSuppliedTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(DimLevelSuppliedTableModel.class);
    public static final int CHECKBOX = 0;
    public static final int HIERARCHIES = 1;
    public static final int LEVELS = 2;
    public static final int FORMAT = 3;
    public static final int RECORDNUMBER = 9;
    private static final int TOTAL_COLS = 4;
    private static final int TOTAL_HIDDEN_COLS = 0;
    private static final String YEAR = "YEAR4.";
    private static final String QUARTER = "QTR1.";
    private static final String MONTH = "MONNAME9.";
    private static final String WEEK = "WEEKV3.";
    private static final String DAY = "DOWNAME.";
    private static final String HOUR = "HOUR4.";
    private List levelsToCreate;
    private List hierarchyNames;
    private List formatNames;
    private DimLevelSuppliedDialog dialog;
    Map mapOfHierarchyLevels;
    Map mapOfFormats;
    Map mapOfTypes;

    public DimLevelSuppliedTableModel() {
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[4];
        WsBooleanTableColumn booleanColumn = new WsBooleanTableColumn(0, " ", 40);
        booleanColumn.setUseCheckboxSemantics(true);
        this.m_aColumns[0] = booleanColumn;
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("DimDesigner.AddSupplied.SuppliedHierarchies.header.title"), 150, 40);
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("DimDesigner.AddSupplied.LevelsCreate.header.title"), 150, 40);
        this.m_aColumns[2].setEditable(false);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("DimDesigner.AddSupplied.LevelsFormat.header.title"), 200, 40);
        this.m_aColumns[3].setEditable(false);
        this.createHierarchyNames();
        this.createFormatNames();
    }

    public void setValueAt(Object inValue, int row, int column) {
        super.setValueAt(inValue, row, column);
        int numberRows = this.getRowCount();
        boolean found = false;
        for (int i = 0; i < numberRows && !found; ++i) {
            List rowValues = this.getRowValues(i);
            Boolean checkbox = (Boolean)rowValues.get(0);
            if (!checkbox.booleanValue()) continue;
            found = true;
        }
        this.dialog.setOKButton(found);
    }

    public void setDialog(DimLevelSuppliedDialog inDialog) {
        this.dialog = inDialog;
    }

    public int getColumnCount() {
        return 4;
    }

    public int getHiddenColumnCount() {
        return 0;
    }

    public void moveDataToModel() {
        int nRows = 9;
        for (int i = 0; i < nRows; ++i) {
            ArrayList<Boolean> alRow = new ArrayList<Boolean>(this.getColumnCount() + this.getHiddenColumnCount());
            alRow.add(0, Boolean.FALSE);
            alRow.add(1, (Boolean)this.hierarchyNames.get(i));
            alRow.add(2, (Boolean)this.levelsToCreate.get(i));
            alRow.add(3, (Boolean)this.formatNames.get(i));
            this.m_lData.add(alRow);
        }
        this.fireTableModelPopulated();
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() {
    }

    public void createHierarchyNames() {
        this.hierarchyNames = new ArrayList();
        this.mapOfHierarchyLevels = new HashMap();
        this.mapOfFormats = new HashMap();
        this.mapOfTypes = new HashMap();
        String hierarchy1 = bundle.getString("DimDesigner.Level.Supplied.WDHMS.txt");
        this.hierarchyNames.add(hierarchy1);
        String hierarchy2 = bundle.getString("DimDesigner.Level.Supplied.YM.txt");
        this.hierarchyNames.add(hierarchy2);
        String hierarchy3 = bundle.getString("DimDesigner.Level.Supplied.YMD.txt");
        this.hierarchyNames.add(hierarchy3);
        String hierarchy4 = bundle.getString("DimDesigner.Level.Supplied.YQ.txt");
        this.hierarchyNames.add(hierarchy4);
        String hierarchy5 = bundle.getString("DimDesigner.Level.Supplied.YQD.txt");
        this.hierarchyNames.add(hierarchy5);
        String hierarchy6 = bundle.getString("DimDesigner.Level.Supplied.YQM.txt");
        this.hierarchyNames.add(hierarchy6);
        String hierarchy7 = bundle.getString("DimDesigner.Level.Supplied.YQMD.txt");
        this.hierarchyNames.add(hierarchy7);
        String hierarchy9 = bundle.getString("DimDesigner.Level.Supplied.YW.txt");
        this.hierarchyNames.add(hierarchy9);
        String hierarchy10 = bundle.getString("DimDesigner.Level.Supplied.YWD.txt");
        this.hierarchyNames.add(hierarchy10);
        String yearName = bundle.getString("DimDesigner.Level.SuppliedName.Year.txt");
        String quarterName = bundle.getString("DimDesigner.Level.SuppliedName.Quarter.txt");
        String monthName = bundle.getString("DimDesigner.Level.SuppliedName.Month.txt");
        String weekName = bundle.getString("DimDesigner.Level.SuppliedName.Week.txt");
        String dayName = bundle.getString("DimDesigner.Level.SuppliedName.Day.txt");
        this.mapOfFormats.put(yearName, YEAR);
        this.mapOfFormats.put(quarterName, QUARTER);
        this.mapOfFormats.put(monthName, MONTH);
        this.mapOfFormats.put(weekName, WEEK);
        this.mapOfFormats.put(dayName, DAY);
        this.mapOfTypes.put(yearName, new Integer(16));
        this.mapOfTypes.put(quarterName, new Integer(64));
        this.mapOfTypes.put(monthName, new Integer(128));
        this.mapOfTypes.put(weekName, new Integer(256));
        this.mapOfTypes.put(dayName, new Integer(512));
        ArrayList<String> hier1List = new ArrayList<String>();
        ArrayList<String> hier2List = new ArrayList<String>();
        ArrayList<String> hier3List = new ArrayList<String>();
        ArrayList<String> hier4List = new ArrayList<String>();
        ArrayList<String> hier5List = new ArrayList<String>();
        ArrayList<String> hier6List = new ArrayList<String>();
        ArrayList<String> hier7List = new ArrayList<String>();
        ArrayList<String> hier9List = new ArrayList<String>();
        ArrayList<String> hier10List = new ArrayList<String>();
        this.mapOfHierarchyLevels.put(hierarchy1, hier1List);
        this.mapOfHierarchyLevels.put(hierarchy2, hier2List);
        this.mapOfHierarchyLevels.put(hierarchy3, hier3List);
        this.mapOfHierarchyLevels.put(hierarchy4, hier4List);
        this.mapOfHierarchyLevels.put(hierarchy5, hier5List);
        this.mapOfHierarchyLevels.put(hierarchy6, hier6List);
        this.mapOfHierarchyLevels.put(hierarchy7, hier7List);
        this.mapOfHierarchyLevels.put(hierarchy9, hier9List);
        this.mapOfHierarchyLevels.put(hierarchy10, hier10List);
        hier1List.add(weekName);
        hier1List.add(dayName);
        hier2List.add(yearName);
        hier2List.add(monthName);
        hier3List.add(yearName);
        hier3List.add(monthName);
        hier3List.add(dayName);
        hier4List.add(yearName);
        hier4List.add(quarterName);
        hier5List.add(yearName);
        hier5List.add(quarterName);
        hier5List.add(dayName);
        hier6List.add(yearName);
        hier6List.add(quarterName);
        hier6List.add(monthName);
        hier7List.add(yearName);
        hier7List.add(quarterName);
        hier7List.add(monthName);
        hier7List.add(dayName);
        hier9List.add(yearName);
        hier9List.add(weekName);
        hier10List.add(yearName);
        hier10List.add(weekName);
        hier10List.add(dayName);
        this.levelsToCreate = new ArrayList();
        StringBuffer setUpWDH = new StringBuffer();
        setUpWDH.append(weekName).append(" ").append(dayName).append(" ");
        this.levelsToCreate.add(setUpWDH);
        StringBuffer setUpYM = new StringBuffer();
        setUpYM.append(yearName).append(" ").append(monthName);
        this.levelsToCreate.add(setUpYM);
        StringBuffer setUpYMD = new StringBuffer();
        setUpYMD.append(yearName).append(" ").append(monthName).append(" ").append(dayName);
        this.levelsToCreate.add(setUpYMD);
        StringBuffer setUpYQ = new StringBuffer();
        setUpYQ.append(yearName).append(" ").append(quarterName);
        this.levelsToCreate.add(setUpYQ);
        StringBuffer setUpYQD = new StringBuffer();
        setUpYQD.append(yearName).append(" ").append(quarterName).append(" ").append(dayName);
        this.levelsToCreate.add(setUpYQD);
        StringBuffer setUpYQM = new StringBuffer();
        setUpYQM.append(yearName).append(" ").append(quarterName).append(" ").append(monthName);
        this.levelsToCreate.add(setUpYQM);
        StringBuffer setUpYQMD = new StringBuffer();
        setUpYQMD.append(yearName).append(" ").append(quarterName).append(" ").append(monthName).append(" ").append(dayName);
        this.levelsToCreate.add(setUpYQMD);
        StringBuffer setUpYW = new StringBuffer();
        setUpYW.append(yearName).append(" ").append(weekName);
        this.levelsToCreate.add(setUpYW);
        StringBuffer setUpYWD = new StringBuffer();
        setUpYWD.append(yearName).append(" ").append(weekName).append(" ").append(dayName);
        this.levelsToCreate.add(setUpYWD);
    }

    public void createFormatNames() {
        this.formatNames = new ArrayList();
        StringBuffer setUpWDH = new StringBuffer();
        setUpWDH.append(WEEK).append(" ").append(DAY);
        this.formatNames.add(setUpWDH);
        StringBuffer setUpYM = new StringBuffer();
        setUpYM.append(YEAR).append(" ").append(MONTH);
        this.formatNames.add(setUpYM);
        StringBuffer setUpYMD = new StringBuffer();
        setUpYMD.append(YEAR).append(" ").append(MONTH).append(" ").append(DAY);
        this.formatNames.add(setUpYMD);
        StringBuffer setUpYQ = new StringBuffer();
        setUpYQ.append(YEAR).append(" ").append(QUARTER);
        this.formatNames.add(setUpYQ);
        StringBuffer setUpYQD = new StringBuffer();
        setUpYQD.append(YEAR).append(" ").append(QUARTER).append(" ").append(DAY);
        this.formatNames.add(setUpYQD);
        StringBuffer setUpYQM = new StringBuffer();
        setUpYQM.append(YEAR).append(" ").append(QUARTER).append(" ").append(MONTH);
        this.formatNames.add(setUpYQM);
        StringBuffer setUpYQMD = new StringBuffer();
        setUpYQMD.append(YEAR).append(" ").append(QUARTER).append(" ").append(MONTH).append(" ").append(DAY);
        this.formatNames.add(setUpYQMD);
        StringBuffer setUpYW = new StringBuffer();
        setUpYW.append(YEAR).append(" ").append(WEEK);
        this.formatNames.add(setUpYW);
        StringBuffer setUpYWD = new StringBuffer();
        setUpYWD.append(YEAR).append(" ").append(WEEK).append(" ").append(DAY);
        this.formatNames.add(setUpYWD);
    }

    public List getSelectedCheckboxValues() {
        ArrayList<Integer> selectedItems = new ArrayList<Integer>();
        int numberRows = this.getRowCount();
        for (int i = 0; i < numberRows; ++i) {
            List rowValues = this.getRowValues(i);
            Boolean checkbox = (Boolean)rowValues.get(0);
            if (!checkbox.booleanValue()) continue;
            selectedItems.add(new Integer(i));
        }
        return selectedItems;
    }
}

