/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.nls.collator.SASCollatorFactory;
import com.sas.nls.collator.SASStringComparator;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractPopulateOnDemandTableColumn;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDefaultCellEditor;
import com.sas.workspace.WsStringTableColumn;
import com.sas.workspace.WsTable;
import java.awt.Color;
import java.awt.SystemColor;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;

public class DimDetailLevelTable
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(DimDetailLevelTable.class);
    public Object[][] values;
    public DimDetailLevelTable tcm;
    private DimensionSet dimensionSet;
    private OLAPDimension dimensionModel;
    private Map levelsByName;
    private Map initialEmpty;
    protected String[] dimensionTimeList;
    protected String[] dimensionStandardList;
    protected String[] sortList;
    protected String dimensionType;
    protected OLAPList levels;
    private boolean backedUp;
    private String type;
    private int startSelected;
    private int stopSelected;
    private EnterStringValue enterString;
    private EnterStringValue inheritIgnore;
    private EnterStringValue inheritNotSpecified;
    private EnterStringValue blankSpace;
    private EnterStringValue singlePeriod;
    private EnterStringValue ignore;
    private EnterStringValue inheritBlankSpace;
    private EnterStringValue inheritSinglePeriod;
    private EnterStringValue dimensionEmptyCharValue;
    private EnterStringValue dimensionEmptyNumValue;
    private EnterStringValue cubeEmptyCharValue;
    private EnterStringValue cubeEmptyNumValue;
    private Map previousFormats;
    private List newList;
    private Map userEnteredValue;
    private List listOfSortOrders;
    private List listOfOrderedLevels;
    private static final String CHARACTER = "C";
    private static final String NUMERIC = "N";
    public static final int LEVEL_NAME = 0;
    public static final int INPUT_COLUMN = 1;
    public static final int FORMAT = 2;
    public static final int CAPTION = 3;
    public static final int TYPE = 4;
    public static final int SORT_ORDER = 5;
    public static final int EMPTY = 6;
    public static final int NOTES = 7;
    public static final int LEVEL = 8;
    private static final int TOTAL_COLS = 8;
    private static final int TOTAL_HIDDEN_COLS = 1;
    private SASStringComparator stringCompare;

    public DimDetailLevelTable(OLAPDimension inDimensionModel) {
        this.dimensionModel = inDimensionModel;
        this.dimensionSet = this.dimensionModel.getDimensionSet();
        this.tcm = this;
        this.createColumnDefinitions();
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void createColumnDefinitions() {
        this.newList = new ArrayList();
        this.levelsByName = new HashMap();
        this.initialEmpty = new HashMap();
        this.previousFormats = new HashMap();
        this.userEnteredValue = new HashMap();
        this.listOfSortOrders = new ArrayList();
        this.listOfSortOrders.add(bundle.getString("DimDesigner.General.dimsortascending.txt"));
        this.listOfSortOrders.add(bundle.getString("DimDesigner.General.dimsortdescending.txt"));
        this.listOfSortOrders.add(bundle.getString("DimDesigner.General.dimsortascformatted.txt"));
        this.listOfSortOrders.add(bundle.getString("DimDesigner.General.dimsortdescformatted.txt"));
        this.listOfSortOrders.add(bundle.getString("DimDesigner.General.dimsortdsorder.txt"));
        OLAPCube cube = this.dimensionSet.getOwningCube();
        this.type = cube != null ? cube.getType() : " ";
        this.createDefaultTypeList();
        this.inheritIgnore = new EnterStringValue(bundle.formatString("DimDesigner.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("DimDesigner.MissingMemberValues.Ignore.txt")), 0);
        this.inheritNotSpecified = new EnterStringValue(bundle.getString("DimDesigner.MissingMemberValues.NotSpecified.txt"), 1);
        this.blankSpace = new EnterStringValue(bundle.getString("DimDesigner.MissingMemberValues.Blank.txt"), 2);
        this.ignore = new EnterStringValue(bundle.getString("DimDesigner.MissingMemberValues.Ignore.txt"), 3);
        this.enterString = new EnterStringValue(bundle.getString("DimDesigner.MissingMemberValues.Enter.txt"), 4);
        this.singlePeriod = new EnterStringValue(bundle.getString("DimDesigner.MissingMemberValues.Period.txt"), 2);
        this.inheritBlankSpace = new EnterStringValue(bundle.formatString("DimDesigner.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("DimDesigner.MissingMemberValues.Blank.txt")), 6);
        this.inheritSinglePeriod = new EnterStringValue(bundle.formatString("DimDesigner.MissingMemberValues.Inherit.fmt.txt", (Object)bundle.getString("DimDesigner.MissingMemberValues.Period.txt")), 6);
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("DimDesigner.Column.LevelName.header.title"), 100, 32);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("DimDesigner.Column.LevelColumn.header.title"), 100, 32);
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[2] = this.createFormatsTableColumn();
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("DimDesigner.Column.Caption.txt"), 100, 200);
        this.m_aColumns[4] = this.createLevelTypeTableColumn();
        this.m_aColumns[5] = this.createSortOrderTableColumn();
        this.m_aColumns[6] = this.createEmptyTableColumn();
        this.m_aColumns[7] = new WsStringTableColumn(7, bundle.getString("DimDesigner.Column.Notes.txt"), 100, 300);
        this.stringCompare = SASCollatorFactory.createComparatorIgnoreCase();
    }

    private void createDefaultTypeList() {
        this.dimensionTimeList = new String[10];
        this.dimensionTimeList[0] = bundle.getString("DimDesigner.Format.None.txt");
        this.dimensionTimeList[1] = bundle.getString("DimDesigner.General.dimleveltypeyear.txt");
        this.dimensionTimeList[2] = bundle.getString("DimDesigner.General.dimleveltypehalfyear.txt");
        this.dimensionTimeList[3] = bundle.getString("DimDesigner.General.dimleveltypequarters.txt");
        this.dimensionTimeList[4] = bundle.getString("DimDesigner.General.dimleveltypemonths.txt");
        this.dimensionTimeList[5] = bundle.getString("DimDesigner.General.dimleveltypeweeks.txt");
        this.dimensionTimeList[6] = bundle.getString("DimDesigner.General.dimleveltypedays.txt");
        this.dimensionTimeList[7] = bundle.getString("DimDesigner.General.dimleveltypehours.txt");
        this.dimensionTimeList[8] = bundle.getString("DimDesigner.General.dimleveltypeminutes.txt");
        this.dimensionTimeList[9] = bundle.getString("DimDesigner.General.dimleveltypeseconds.txt");
        this.dimensionStandardList = new String[1];
        this.dimensionStandardList[0] = bundle.getString("DimDesigner.General.dimleveltyperegular.txt");
    }

    protected WsAbstractTableColumn createEmptyTableColumn() {
        return new ObjectTableColumn();
    }

    protected WsAbstractTableColumn createFormatsTableColumn() {
        return new FormatTableColumn();
    }

    protected WsAbstractTableColumn createLevelTypeTableColumn() {
        return new LevelTypeTableColumn();
    }

    protected WsAbstractTableColumn createSortOrderTableColumn() {
        return new SortOrderTableColumn();
    }

    public void clearTable() {
        int nRows = this.m_lData.size();
        this.m_lData.clear();
        this.fireTableRowsDeleted(0, nRows - 1);
        this.levelsByName.clear();
        this.populateStore();
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public void populateStore() {
        try {
            this.dimensionSet = this.dimensionModel.getDimensionSet();
            this.levels = this.dimensionModel.getLevels();
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
    }

    public void duplicateRow(List dataList, int rowSelected) throws OLAPException {
        ArrayList<String> alRow = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
        OLAPLevel level = (OLAPLevel)this.levelsByName.get(dataList.get(0));
        OLAPColumn column = level.getColumn();
        OLAPLevel newLevel = this.dimensionModel.createOLAPSuppliedTimeLevel(column, level.getName());
        alRow.add(0, newLevel.getName());
        alRow.add(1, (String)dataList.get(1));
        alRow.add(2, (String)dataList.get(2));
        alRow.add(3, (String)dataList.get(3));
        alRow.add(4, (String)dataList.get(4));
        alRow.add(5, (String)dataList.get(5));
        alRow.add(6, (String)dataList.get(6));
        alRow.add(7, (String)dataList.get(7));
        alRow.add(8, (String)newLevel);
        this.levelsByName.put(newLevel.getName(), newLevel);
        String format = (String)dataList.get(2);
        if (format != null && this.stringCompare.compare(format, bundle.getString("DimDesigner.Format.None.txt")) != 0 && !ModelUtilities.isBlank((String)format)) {
            newLevel.setFormat(format);
        }
        newLevel.setDesc(level.getDesc());
        newLevel.setType(level.getType());
        newLevel.setEmpty(level.getEmpty());
        newLevel.setIgnoreEmpty(level.getIgnoreEmpty());
        newLevel.setNotes(level.getNotes());
        newLevel.setSortOrder(level.getSortOrder());
        int rowInserted = rowSelected + 1;
        this.m_lData.add(rowInserted, alRow);
        this.fireTableRowsInserted(rowInserted, rowInserted);
    }

    public Map getLevelsByName() {
        return this.levelsByName;
    }

    public int getStartSelected() {
        return this.startSelected;
    }

    public int getStopSelected() {
        return this.stopSelected;
    }

    public List getOrderLevels() {
        if (this.listOfOrderedLevels == null) {
            this.listOfOrderedLevels = new ArrayList();
        }
        return this.listOfOrderedLevels;
    }

    public void setOrderLevels(List inOrderOfLevels) {
        this.listOfOrderedLevels = inOrderOfLevels;
        this.backedUp = true;
    }

    public void moveDataToModel() {
        this.getOrderLevels();
        int nLevels = this.levels.size();
        if (!this.listOfOrderedLevels.isEmpty() && !this.listOfOrderedLevels.equals(this.levels) && this.backedUp) {
            this.levels.reOrderLevels(this.listOfOrderedLevels);
        }
        this.backedUp = false;
        int sizeOfCurrentModel = this.m_lData.size();
        int numberOfLevelsAdded = 0;
        this.dimensionType = this.dimensionModel.getType();
        Object levelsList = null;
        levelsList = this.listOfOrderedLevels.isEmpty() ? this.levels : this.listOfOrderedLevels;
        try {
            for (int i = 0; i < nLevels; ++i) {
                OLAPLevel level = (OLAPLevel)levelsList.get(i);
                if (this.levelsByName.containsKey(level.getName())) continue;
                ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
                ++numberOfLevelsAdded;
                alRow.add(0, level.getName());
                this.levelsByName.put(level.getName(), level);
                String inputColumnName = level.getColumn().getSASColumnName();
                alRow.add(1, inputColumnName);
                String format = level.getFormat();
                if (format != null && !ModelUtilities.isBlank((String)format)) {
                    alRow.add(2, format);
                } else {
                    alRow.add(2, bundle.getString("DimDesigner.Format.None.txt"));
                }
                alRow.add(3, level.getDesc());
                int textnumber = 0;
                int number = level.getType();
                if (this.dimensionType.equals("STANDARD")) {
                    number = 1;
                }
                switch (number) {
                    case 1: {
                        textnumber = 0;
                        break;
                    }
                    case 8192: {
                        textnumber = 0;
                        break;
                    }
                    case 16: {
                        textnumber = 1;
                        break;
                    }
                    case 32: {
                        textnumber = 2;
                        break;
                    }
                    case 64: {
                        textnumber = 3;
                        break;
                    }
                    case 128: {
                        textnumber = 4;
                        break;
                    }
                    case 256: {
                        textnumber = 5;
                        break;
                    }
                    case 512: {
                        textnumber = 6;
                        break;
                    }
                    case 1024: {
                        textnumber = 7;
                        break;
                    }
                    case 2048: {
                        textnumber = 8;
                        break;
                    }
                    case 4096: {
                        textnumber = 9;
                    }
                }
                if (this.dimensionType.endsWith("TIME")) {
                    alRow.add(4, this.dimensionTimeList[textnumber]);
                } else {
                    alRow.add(4, this.dimensionStandardList[textnumber]);
                }
                int dimensionSortOrder = this.dimensionSet.getDisplaySort(this.dimensionModel.getSortOrder());
                int levelSortOrder = this.dimensionSet.getDisplaySort(level.getSortOrder());
                if (dimensionSortOrder == levelSortOrder) {
                    alRow.add(5, bundle.formatString("DimDesigner.MissingMemberValues.Inherit.fmt.txt", this.listOfSortOrders.get(levelSortOrder)));
                } else {
                    alRow.add(5, this.listOfSortOrders.get(levelSortOrder));
                }
                String empty = level.getEmpty();
                String emptyIgnore = level.getIgnoreEmpty();
                String cubeEmpty = null;
                String dimensionEmpty = null;
                String typeOfColumn = level.getColumn().getSASColumnType();
                if (typeOfColumn.equals(CHARACTER)) {
                    dimensionEmpty = this.dimensionModel.getEmptyChar();
                    if (dimensionEmpty != null) {
                        this.dimensionEmptyCharValue = ModelUtilities.isBlank((String)dimensionEmpty) ? this.inheritBlankSpace : new EnterStringValue(bundle.formatString("DimDesigner.MissingMemberValues.Inherit.fmt.txt", (Object)dimensionEmpty), 8);
                    }
                    if ((cubeEmpty = this.dimensionModel.getOwningCube().getEmptyChar()) != null) {
                        this.cubeEmptyCharValue = ModelUtilities.isBlank((String)cubeEmpty) ? this.inheritBlankSpace : new EnterStringValue(bundle.formatString("DimDesigner.MissingMemberValues.Inherit.fmt.txt", (Object)cubeEmpty), 8);
                    }
                } else {
                    dimensionEmpty = this.dimensionModel.getEmptyNum();
                    if (dimensionEmpty != null) {
                        this.dimensionEmptyNumValue = dimensionEmpty.equals(".") ? this.inheritSinglePeriod : new EnterStringValue(bundle.formatString("DimDesigner.MissingMemberValues.Inherit.fmt.txt", (Object)dimensionEmpty), 8);
                    }
                    if ((cubeEmpty = this.dimensionModel.getOwningCube().getEmptyNum()) != null) {
                        this.cubeEmptyNumValue = cubeEmpty.equals(".") ? this.inheritSinglePeriod : new EnterStringValue(bundle.formatString("DimDesigner.MissingMemberValues.Inherit.fmt.txt", (Object)cubeEmpty), 8);
                    }
                }
                String dimensionIgnore = this.dimensionModel.getIgnoreEmpty();
                if (empty != null) {
                    if (ModelUtilities.isBlank((String)empty)) {
                        alRow.add(6, this.blankSpace);
                    } else if (empty.equals(".")) {
                        alRow.add(6, this.singlePeriod);
                    } else {
                        this.initialEmpty.put(level, empty);
                        alRow.add(6, empty);
                    }
                } else if (emptyIgnore != null && emptyIgnore.equals("1")) {
                    alRow.add(6, this.ignore);
                } else if (dimensionEmpty == null && dimensionIgnore != null && dimensionIgnore.equals("1")) {
                    alRow.add(6, this.inheritIgnore);
                } else if (dimensionEmpty != null) {
                    EnterStringValue dimensionEmptyValue = null;
                    dimensionEmptyValue = typeOfColumn.equals(CHARACTER) ? this.dimensionEmptyCharValue : this.dimensionEmptyNumValue;
                    alRow.add(6, dimensionEmptyValue);
                } else if (cubeEmpty != null) {
                    EnterStringValue cubeEmptyValue = null;
                    cubeEmptyValue = typeOfColumn.equals(CHARACTER) ? this.cubeEmptyCharValue : this.cubeEmptyNumValue;
                    alRow.add(6, cubeEmptyValue);
                } else {
                    alRow.add(6, this.inheritNotSpecified);
                }
                String notes = level.getNotes();
                if (notes != null) {
                    alRow.add(7, notes);
                }
                alRow.add(8, level);
                this.m_lData.add(alRow);
            }
            if (numberOfLevelsAdded > 0) {
                this.fireTableRowsInserted(sizeOfCurrentModel, nLevels - 1);
            }
            this.setStartSelected(sizeOfCurrentModel);
            this.setStopSelected(nLevels);
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
    }

    public int getColumnCount() {
        return 8;
    }

    public boolean isCellEditable(int row, int Column) {
        return !(Column == 2 ? this.type.equals("HOLAP") : Column == 1);
    }

    public void setStartSelected(int inStart) {
        this.startSelected = inStart;
    }

    public void setStopSelected(int inStop) {
        this.stopSelected = inStop;
    }

    public void setValueAt(Object inValue, int row, int column) {
        EnterStringValue value;
        int placementValue;
        List listOfData = (List)this.m_lData.get(row);
        String levelName = (String)listOfData.get(0);
        OLAPLevel level = (OLAPLevel)this.levelsByName.get(levelName);
        if (level == null) {
            return;
        }
        WsDefaultCellEditor edt1 = null;
        WAComboBox cmb = null;
        if (column == 2) {
            edt1 = (WsDefaultCellEditor)this.m_aColumns[2].getCellEditor();
        } else if (column == 6) {
            edt1 = (WsDefaultCellEditor)this.m_aColumns[6].getCellEditor();
        } else if (column == 5) {
            edt1 = (WsDefaultCellEditor)this.m_aColumns[5].getCellEditor();
        } else if (column == 4) {
            edt1 = (WsDefaultCellEditor)this.m_aColumns[4].getCellEditor();
        }
        if (edt1 != null) {
            cmb = (WAComboBox)edt1.getComponent();
        }
        if (inValue instanceof EnterStringValue && (placementValue = (value = (EnterStringValue)inValue).getPlacement()) == 4) {
            super.setValueAt((Object)" ", row, column);
            cmb.setEditable(true);
            return;
        }
        switch (column) {
            case 0: {
                String newLevelName = (String)inValue;
                String oldLevelName = level.getName();
                try {
                    if (!newLevelName.equalsIgnoreCase(oldLevelName)) {
                        level.setName(newLevelName);
                        this.dimensionSet.verifyLevelNameUnique(level);
                    }
                }
                catch (OLAPException oError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                    level.setName(oldLevelName);
                    return;
                }
                this.levelsByName.remove(oldLevelName);
                this.levelsByName.put(newLevelName, level);
                break;
            }
            case 3: {
                level.setDesc((String)inValue);
                break;
            }
            case 4: {
                if (!this.dimensionType.equals("TIME")) break;
                int location = cmb.getSelectedIndex();
                switch (location) {
                    case 0: {
                        level.setType(8192);
                        break;
                    }
                    case 1: {
                        level.setType(16);
                        break;
                    }
                    case 2: {
                        level.setType(32);
                        break;
                    }
                    case 3: {
                        level.setType(64);
                        break;
                    }
                    case 4: {
                        level.setType(128);
                        break;
                    }
                    case 5: {
                        level.setType(256);
                        break;
                    }
                    case 6: {
                        level.setType(512);
                        break;
                    }
                    case 7: {
                        level.setType(1024);
                        break;
                    }
                    case 8: {
                        level.setType(2048);
                        break;
                    }
                    case 9: {
                        level.setType(4096);
                    }
                }
                break;
            }
            case 5: {
                int sortLocation = cmb.getSelectedIndex();
                level.setSortOrder(this.dimensionSet.getProcSort(sortLocation));
                break;
            }
            case 6: {
                String empty = null;
                int type = -1;
                cmb.setEditable(false);
                cmb.setForeground((Color)SystemColor.controlText);
                if (inValue instanceof EnterStringValue) {
                    EnterStringValue enterValue = (EnterStringValue)inValue;
                    empty = enterValue.getValue();
                    type = enterValue.getPlacement();
                } else {
                    empty = (String)inValue;
                    String initialValue = (String)this.initialEmpty.get(level);
                    if (initialValue == null) {
                        this.userEnteredValue.put(level, empty);
                    } else if (!initialValue.equals(empty)) {
                        this.userEnteredValue.put(level, empty);
                    }
                }
                try {
                    String columnType = level.getColumn().getSASColumnType();
                    if (type == -1 || type == 2) {
                        if (type == 2 && columnType.equals(CHARACTER)) {
                            level.setEmpty(" ");
                        } else if (type == 2 && columnType.equals(NUMERIC)) {
                            level.setEmpty(".");
                        } else {
                            level.setEmpty(empty);
                        }
                        if (type == -1 && columnType.equals(CHARACTER) && ModelUtilities.isBlank((String)empty)) {
                            cmb.setSelectedItem((Object)this.blankSpace);
                            break;
                        }
                        if (type != -1 || !columnType.equals(NUMERIC) || !empty.equals(".")) break;
                        cmb.setSelectedItem((Object)this.singlePeriod);
                        break;
                    }
                    if (type == 3) {
                        level.setIgnoreEmpty("1");
                        level.setEmpty(null);
                        break;
                    }
                    level.setEmpty(null);
                }
                catch (OLAPException oError) {
                    ExceptionHandler.handleException((Exception)((Object)oError));
                }
                break;
            }
            case 2: {
                String formatValue = (String)inValue;
                if (this.stringCompare.compare(formatValue, bundle.getString("DimDesigner.Format.None.txt")) == 0) {
                    level.setFormat(" ");
                    break;
                }
                level.setFormat(formatValue);
                break;
            }
            case 7: {
                level.setNotes((String)inValue);
            }
        }
        super.setValueAt(inValue, row, column);
    }

    protected class SortOrderTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public SortOrderTableColumn() {
            super(5, bundle.getString("DimDesigner.Column.Sort.txt"), 200, bundle.getString("DimDesigner.General.dimleveltyperegular.txt"));
            this.setEditorEditable(false);
        }

        public TableCellEditor createCellEditor() {
            WAComboBox comboBox = new WAComboBox();
            comboBox.setEditable(false);
            comboBox.setBorder((Border)new LineBorder(Color.black));
            WsAbstractPopulateOnDemandTableColumn.PopulateOnDemandEditor editor = new WsAbstractPopulateOnDemandTableColumn.PopulateOnDemandEditor((WsAbstractPopulateOnDemandTableColumn)this, comboBox);
            editor.setClicksToStart(1);
            return editor;
        }

        public void populate(JTable tbl, int row, int col) {
            row = ((WsTable)tbl).convertRowIndexToModel(row);
            OLAPLevel level = (OLAPLevel)DimDetailLevelTable.this.levels.get(row);
            int dimensionSortOrder = DimDetailLevelTable.this.dimensionSet.getDisplaySort(DimDetailLevelTable.this.dimensionModel.getSortOrder());
            int levelSortOrder = DimDetailLevelTable.this.dimensionSet.getDisplaySort(level.getSortOrder());
            String[] possibleValues = this.createSortOrder(dimensionSortOrder, levelSortOrder);
            this.setPossibleValues(possibleValues);
        }

        private String[] createSortOrder(int dimensionSortOrder, int levelSortOrder) {
            String[] sortList = new String[5];
            sortList[dimensionSortOrder] = bundle.formatString("DimDesigner.MissingMemberValues.Inherit.fmt.txt", DimDetailLevelTable.this.listOfSortOrders.get(dimensionSortOrder));
            for (int i = 0; i < 5; ++i) {
                if (i == dimensionSortOrder) continue;
                sortList[i] = (String)DimDetailLevelTable.this.listOfSortOrders.get(i);
            }
            return sortList;
        }
    }

    protected class LevelTypeTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public LevelTypeTableColumn() {
            super(4, bundle.getString("DimDesigner.Column.Type.txt"), 100, bundle.getString("DimDesigner.General.dimleveltyperegular.txt"));
            this.setEditorEditable(false);
        }

        public TableCellEditor createCellEditor() {
            WAComboBox comboBox = new WAComboBox();
            comboBox.setEditable(false);
            comboBox.setBorder((Border)new LineBorder(Color.black));
            WsAbstractPopulateOnDemandTableColumn.PopulateOnDemandEditor editor = new WsAbstractPopulateOnDemandTableColumn.PopulateOnDemandEditor((WsAbstractPopulateOnDemandTableColumn)this, comboBox);
            editor.setClicksToStart(1);
            return editor;
        }

        public void populate(JTable tbl, int row, int col) {
            DimDetailLevelTable.this.dimensionType = DimDetailLevelTable.this.dimensionModel.getType();
            if (DimDetailLevelTable.this.dimensionType.equals("TIME")) {
                this.setPossibleValues(DimDetailLevelTable.this.dimensionTimeList);
            } else {
                this.setPossibleValues(DimDetailLevelTable.this.dimensionStandardList);
            }
        }
    }

    protected class FormatTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public FormatTableColumn() {
            super(2, bundle.getString("DimDesigner.Column.Format.txt"), 100, bundle.getString("DimDesigner.Format.None.txt"));
            this.setEditorEditable(true);
        }

        public void setPossibleValues(List saValues) {
            if (this.m_edtCell != null) {
                WsAbstractPopulateOnDemandTableColumn.PopulateOnDemandEditor editor = (WsAbstractPopulateOnDemandTableColumn.PopulateOnDemandEditor)this.m_edtCell;
                JComboBox comboBox = (JComboBox)editor.getComponent();
                comboBox.removeAllItems();
                for (int valueIndex = 0; valueIndex < saValues.size(); ++valueIndex) {
                    comboBox.addItem(saValues.get(valueIndex));
                }
            }
        }

        public TableCellEditor createCellEditor() {
            WAComboBox comboBox = new WAComboBox();
            comboBox.setEditable(true);
            comboBox.setBorder((Border)new LineBorder(Color.black));
            WsAbstractPopulateOnDemandTableColumn.PopulateOnDemandEditor editor = new WsAbstractPopulateOnDemandTableColumn.PopulateOnDemandEditor((WsAbstractPopulateOnDemandTableColumn)this, comboBox);
            editor.setClicksToStart(1);
            return editor;
        }

        public void populate(JTable tbl, int row, int col) {
            try {
                row = ((WsTable)tbl).convertRowIndexToModel(row);
                OLAPLevel level = (OLAPLevel)DimDetailLevelTable.this.levels.get(row);
                String sType = level.getColumn().getSASColumnType();
                List populateNewList = null;
                populateNewList = sType.equalsIgnoreCase(DimDetailLevelTable.NUMERIC) ? this.createFormats(level, sType, ModelUtilities.numericFormats) : this.createFormats(level, sType, ModelUtilities.characterFormat);
                this.setPossibleValues(populateNewList);
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }

        private List createFormats(OLAPLevel level, String inputType, String[] typeOfFormats) {
            DimDetailLevelTable.this.newList.clear();
            int size = typeOfFormats.length;
            for (int i = 0; i < size; ++i) {
                DimDetailLevelTable.this.newList.add(typeOfFormats[i]);
            }
            String format = level.getFormat();
            ArrayList<String> formatsList = (ArrayList<String>)DimDetailLevelTable.this.previousFormats.get(inputType);
            if (formatsList == null) {
                formatsList = new ArrayList<String>();
                DimDetailLevelTable.this.previousFormats.put(inputType, formatsList);
            }
            if (format != null && !DimDetailLevelTable.this.newList.contains(format) & !formatsList.contains(format) & !format.startsWith("(") & !ModelUtilities.isBlank((String)format)) {
                formatsList.add(format);
            }
            int size2 = formatsList.size();
            int i = size2 - 1;
            int t = 0;
            while (i > -1) {
                DimDetailLevelTable.this.newList.add(t, formatsList.get(i));
                --i;
                ++t;
            }
            if (size2 > 0) {
                DimDetailLevelTable.this.newList.add(size2, WAComboBox.SEPARATOR);
                DimDetailLevelTable.this.newList.add(size2 + 1, bundle.getString("DimDesigner.Format.None.txt"));
            } else {
                DimDetailLevelTable.this.newList.add(size2, bundle.getString("DimDesigner.Format.None.txt"));
            }
            return DimDetailLevelTable.this.newList;
        }
    }

    protected class ObjectTableColumn
    extends WsAbstractPopulateOnDemandTableColumn {
        public ObjectTableColumn() {
            super(6, bundle.getString("DimDesigner.Column.MissingMember.header.title"), 150);
        }

        public TableCellEditor createCellEditor() {
            WAComboBox comboBox = new WAComboBox();
            comboBox.setEditable(false);
            comboBox.setBorder((Border)new LineBorder(Color.black));
            WsAbstractPopulateOnDemandTableColumn.PopulateOnDemandEditor editor = new WsAbstractPopulateOnDemandTableColumn.PopulateOnDemandEditor((WsAbstractPopulateOnDemandTableColumn)this, comboBox);
            editor.setClicksToStart(1);
            return editor;
        }

        public void populate(JTable tbl, int row, int col) {
            try {
                row = ((WsTable)tbl).convertRowIndexToModel(row);
                OLAPLevel level = (OLAPLevel)DimDetailLevelTable.this.levels.get(row);
                String sType = level.getColumn().getSASColumnType();
                if (sType.equalsIgnoreCase(DimDetailLevelTable.NUMERIC)) {
                    DimDetailLevelTable.this.newList = this.createEmpty(level, sType);
                } else {
                    DimDetailLevelTable.this.newList = this.createEmpty(level, sType);
                }
                this.setPossibleValues(DimDetailLevelTable.this.newList);
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }

        public void setPossibleValues(List saValues) {
            if (this.m_edtCell != null) {
                WsAbstractPopulateOnDemandTableColumn.PopulateOnDemandEditor editor = (WsAbstractPopulateOnDemandTableColumn.PopulateOnDemandEditor)this.m_edtCell;
                JComboBox comboBox = (JComboBox)editor.getComponent();
                comboBox.removeAllItems();
                for (int valueIndex = 0; valueIndex < saValues.size(); ++valueIndex) {
                    comboBox.addItem(saValues.get(valueIndex));
                }
            }
        }

        private List createEmpty(OLAPLevel level, String inputType) {
            try {
                DimDetailLevelTable.this.newList.clear();
                String dimensionEmpty = DimDetailLevelTable.this.dimensionModel.getEmptyChar();
                String dimensionEmptyNum = DimDetailLevelTable.this.dimensionModel.getEmptyNum();
                String dimensionIgnore = DimDetailLevelTable.this.dimensionModel.getIgnoreEmpty();
                if (inputType.equals(DimDetailLevelTable.CHARACTER)) {
                    if (dimensionEmpty == null) {
                        if (dimensionIgnore != null) {
                            DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.inheritIgnore);
                        } else {
                            DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.ignore);
                        }
                        String cubeEmpty = DimDetailLevelTable.this.dimensionModel.getOwningCube().getEmptyChar();
                        if (cubeEmpty == null) {
                            if (dimensionIgnore == null) {
                                DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.inheritNotSpecified);
                            }
                            DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.blankSpace);
                            DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.enterString);
                        } else if (ModelUtilities.isBlank((String)cubeEmpty)) {
                            if (dimensionIgnore == null) {
                                DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.inheritBlankSpace);
                            } else {
                                DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.blankSpace);
                            }
                            DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.enterString);
                        } else {
                            if (dimensionIgnore == null) {
                                DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.cubeEmptyCharValue);
                            }
                            DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.blankSpace);
                            DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.enterString);
                        }
                    } else {
                        DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.ignore);
                        if (ModelUtilities.isBlank((String)dimensionEmpty)) {
                            DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.inheritBlankSpace);
                            DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.enterString);
                        } else {
                            DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.dimensionEmptyCharValue);
                            DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.blankSpace);
                            DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.enterString);
                        }
                    }
                } else if (dimensionEmptyNum == null) {
                    if (dimensionIgnore != null) {
                        DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.inheritIgnore);
                    } else {
                        DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.ignore);
                    }
                    String cubeEmpty = DimDetailLevelTable.this.dimensionModel.getOwningCube().getEmptyNum();
                    if (cubeEmpty == null) {
                        if (dimensionIgnore == null) {
                            DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.inheritNotSpecified);
                        }
                        DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.singlePeriod);
                        DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.enterString);
                    } else if (cubeEmpty.trim().equals(".")) {
                        if (dimensionIgnore == null) {
                            DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.inheritSinglePeriod);
                        } else {
                            DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.singlePeriod);
                        }
                        DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.enterString);
                    } else {
                        DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.cubeEmptyNumValue);
                        DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.singlePeriod);
                        DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.enterString);
                    }
                } else {
                    DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.ignore);
                    if (dimensionEmptyNum.trim().equals(".")) {
                        DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.inheritSinglePeriod);
                        DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.enterString);
                    } else {
                        DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.dimensionEmptyNumValue);
                        DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.singlePeriod);
                        DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.enterString);
                    }
                }
                if (DimDetailLevelTable.this.userEnteredValue.containsKey(level)) {
                    DimDetailLevelTable.this.newList.add(0, DimDetailLevelTable.this.userEnteredValue.get(level));
                }
                if (DimDetailLevelTable.this.initialEmpty.containsKey(level)) {
                    DimDetailLevelTable.this.newList.add(DimDetailLevelTable.this.initialEmpty.get(level));
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
            return DimDetailLevelTable.this.newList;
        }
    }

    private class EnterStringValue {
        String text;
        int placement;

        private EnterStringValue(String value, int inPlacement) {
            this.text = value;
            this.placement = inPlacement;
        }

        private String getValue() {
            return this.text;
        }

        private int getPlacement() {
            return this.placement;
        }

        public String toString() {
            if (this.text == null) {
                this.text = " ";
            }
            return this.text;
        }
    }
}

