/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.CubeUserAggregationAddDialog;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.CubeButtons;
import com.sas.olapadmin.utilities.studio.PerformancePropertyDialog;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CubeUserAggregationsPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeUserAggregationsPanel.class);
    private JList aggregations;
    private CubeButtons topbuttons;
    private JButton add;
    private JButton modify;
    private JButton delete;
    private JButton advanced;
    private DefaultListModel aggrlistModel;
    private JCheckBox inp_noNWAY;
    private OLAPCube cubeModel;
    private boolean initialized;
    private List Existingaggrs;
    private List alldimlevels;
    private TableSet tableSet;
    private AggregationSet aggregationSet;
    private DimensionSet dimensionSet;
    private Vector globalDataPaths;
    private Vector globalIndexPaths;
    private Vector aggregationDataPaths;
    private Vector aggregationIndexPaths;

    public CubeUserAggregationsPanel(OLAPCube CM) {
        this.cubeModel = CM;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean validateData() {
        try {
            if (this.inp_noNWAY.isSelected()) {
                this.aggregationSet.setNwayGenerated(false);
            } else {
                this.aggregationSet.setNwayGenerated(true);
            }
        }
        catch (OLAPException OLAPError) {
            return ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
        return true;
    }

    protected void initialize() {
        this.aggregationSet = this.cubeModel.getAggregationSet();
        this.tableSet = this.cubeModel.getTableSet();
        this.alldimlevels = new ArrayList();
        this.dimensionSet = this.cubeModel.getDimensionSet();
        this.aggregations.addListSelectionListener(new LevelSelectionListener());
        this.modify.setEnabled(false);
        this.delete.setEnabled(false);
        this.add.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    OLAPAggregation UAM = CubeUserAggregationsPanel.this.aggregationSet.createOLAPAggregation();
                    WAStandardDialog m_parent = (WAStandardDialog)CubeUserAggregationsPanel.this.getTopLevelAncestor();
                    CubeUserAggregationAddDialog UserAggrDialog = new CubeUserAggregationAddDialog((Dialog)m_parent, bundle.getString("CubeDesigner.UserAggregations.Contruct.txt"), CubeUserAggregationsPanel.this.cubeModel, UAM, CubeUserAggregationsPanel.this.alldimlevels);
                    UserAggrDialog.show();
                    if (UserAggrDialog.getReturnValue() == 1) {
                        CubeUserAggregationsPanel.this.aggrlistModel.addElement(UAM);
                    } else {
                        UAM.delete();
                    }
                }
                catch (OLAPException OLAPError) {
                    ExceptionHandler.handleException((Exception)((Object)OLAPError));
                }
            }
        });
        this.modify.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OLAPAggregation UAM = (OLAPAggregation)CubeUserAggregationsPanel.this.aggregations.getSelectedValue();
                WAStandardDialog m_parent = (WAStandardDialog)CubeUserAggregationsPanel.this.getTopLevelAncestor();
                CubeUserAggregationAddDialog UserAggrDialog = new CubeUserAggregationAddDialog((Dialog)m_parent, bundle.getString("CubeDesigner.UserAggregations.Contruct.txt"), CubeUserAggregationsPanel.this.cubeModel, UAM, CubeUserAggregationsPanel.this.alldimlevels);
                UserAggrDialog.show();
                if (UserAggrDialog.getReturnValue() == 1) {
                    int where = CubeUserAggregationsPanel.this.aggrlistModel.indexOf(UAM);
                    CubeUserAggregationsPanel.this.aggrlistModel.removeElement(UAM);
                    CubeUserAggregationsPanel.this.aggrlistModel.add(where, UAM);
                }
            }
        });
        this.delete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                Object[] selectedAggregations = CubeUserAggregationsPanel.this.aggregations.getSelectedValues();
                OLAPAggregation tempAggregation = null;
                int choice = 0;
                if (selectedAggregations.length == 1) {
                    tempAggregation = (OLAPAggregation)selectedAggregations[0];
                    choice = MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.Delete.Message.fmt.txt", (Object)tempAggregation.getName()), (String)bundle.getString("CubeDesigner.DeleteAggregations.window.title"), (int)1, (int)0);
                } else if (selectedAggregations.length > 1) {
                    choice = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.DeleteAggregations.txt"), (String)bundle.getString("CubeDesigner.DeleteAggregations.window.title"), (int)1, (int)0);
                }
                if (choice == 0) {
                    for (int i = selectedAggregations.length - 1; i >= 0; --i) {
                        tempAggregation = (OLAPAggregation)selectedAggregations[i];
                        CubeUserAggregationsPanel.this.aggrlistModel.removeElement(tempAggregation);
                        CubeUserAggregationsPanel.this.modify.setEnabled(false);
                        CubeUserAggregationsPanel.this.delete.setEnabled(false);
                        try {
                            tempAggregation.delete();
                            continue;
                        }
                        catch (OLAPException OLAPError) {
                            ExceptionHandler.handleException((Exception)((Object)OLAPError));
                        }
                    }
                }
            }
        });
        this.advanced.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                WAWizardDialog parent = (WAWizardDialog)CubeUserAggregationsPanel.this.getTopLevelAncestor();
                CubeUserAggregationsPanel.this.globalDataPaths = (Vector)parent.getWizardData("GLOBALDATAPATHS");
                if (CubeUserAggregationsPanel.this.globalDataPaths == null) {
                    CubeUserAggregationsPanel.this.globalDataPaths = VisualUtilities.getGlobalDataPaths();
                    parent.addWizardData("GLOBALDATAPATHS", (Object)CubeUserAggregationsPanel.this.globalDataPaths);
                }
                CubeUserAggregationsPanel.this.globalIndexPaths = (Vector)parent.getWizardData("GLOBALINDEXPATHS");
                if (CubeUserAggregationsPanel.this.globalIndexPaths == null) {
                    CubeUserAggregationsPanel.this.globalIndexPaths = VisualUtilities.getGlobalIndexPaths();
                    parent.addWizardData("GLOBALINDEXPATHS", (Object)CubeUserAggregationsPanel.this.globalIndexPaths);
                }
                CubeUserAggregationsPanel.this.aggregationDataPaths = (Vector)parent.getWizardData("AGGREGATIONDATAPATHS");
                if (CubeUserAggregationsPanel.this.aggregationDataPaths == null) {
                    CubeUserAggregationsPanel.this.aggregationDataPaths = VisualUtilities.getAggregationDataPaths();
                    parent.addWizardData("AGGREGATIONDATAPATHS", (Object)CubeUserAggregationsPanel.this.aggregationDataPaths);
                }
                CubeUserAggregationsPanel.this.aggregationIndexPaths = (Vector)parent.getWizardData("AGGREGATIONINDEXPATHS");
                if (CubeUserAggregationsPanel.this.aggregationIndexPaths == null) {
                    CubeUserAggregationsPanel.this.aggregationIndexPaths = VisualUtilities.getAggregationIndexPaths();
                    parent.addWizardData("AGGREGATIONINDEXPATHS", (Object)CubeUserAggregationsPanel.this.aggregationIndexPaths);
                }
                PerformancePropertyDialog optionsDialog = new PerformancePropertyDialog(CubeUserAggregationsPanel.this.cubeModel, CubeUserAggregationsPanel.this.globalDataPaths, CubeUserAggregationsPanel.this.globalIndexPaths, CubeUserAggregationsPanel.this.aggregationDataPaths, CubeUserAggregationsPanel.this.aggregationIndexPaths, false, null, null, null, false);
                optionsDialog.show();
            }
        });
        this.inp_noNWAY.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int aggrlistSize = CubeUserAggregationsPanel.this.aggrlistModel.size();
                OLAPAggregation Useraggr = null;
                if (aggrlistSize > 0 && !(Useraggr = (OLAPAggregation)CubeUserAggregationsPanel.this.aggrlistModel.elementAt(0)).isNway()) {
                    Useraggr = null;
                }
                if (CubeUserAggregationsPanel.this.inp_noNWAY.isSelected()) {
                    try {
                        CubeUserAggregationsPanel.this.aggregationSet.setNwayGenerated(false);
                        OLAPAggregation defaultAggregation = CubeUserAggregationsPanel.this.aggregationSet.getDefaultAggregation();
                        OLAPAggregation firstAggregation = (OLAPAggregation)CubeUserAggregationsPanel.this.aggrlistModel.get(0);
                        if (firstAggregation.isNway()) {
                            CubeUserAggregationsPanel.this.aggrlistModel.remove(0);
                        }
                        if (defaultAggregation != null && !defaultAggregation.isDeleted()) {
                            defaultAggregation.delete();
                        }
                    }
                    catch (OLAPException OLAPError) {
                        ExceptionHandler.handleException((Exception)((Object)OLAPError));
                    }
                } else {
                    try {
                        CubeUserAggregationsPanel.this.aggregationSet.setNwayGenerated(true);
                        OLAPAggregation defaultAggregation = CubeUserAggregationsPanel.this.aggregationSet.getDefaultAggregation();
                        CubeUserAggregationsPanel.this.aggrlistModel.insertElementAt(defaultAggregation, 0);
                    }
                    catch (OLAPException OLAPError) {
                        ExceptionHandler.handleException((Exception)((Object)OLAPError));
                    }
                }
                CubeUserAggregationsPanel.this.aggregations.clearSelection();
                CubeUserAggregationsPanel.this.modify.setEnabled(false);
                CubeUserAggregationsPanel.this.delete.setEnabled(false);
            }
        });
        this.initialized = true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            if (!this.initialized) {
                this.initialize();
            }
            try {
                int i;
                List allDimModels = null;
                allDimModels = this.dimensionSet.getAllCubeDimensions();
                this.alldimlevels.clear();
                int size = allDimModels.size();
                for (i = 0; i < size; ++i) {
                    OLAPDimension DM = (OLAPDimension)allDimModels.get(i);
                    OLAPList allLevels = null;
                    allLevels = DM.getLevels();
                    int sizeLevels = allLevels.size();
                    for (int j = 0; j < sizeLevels; ++j) {
                        OLAPLevel LM = (OLAPLevel)allLevels.get(j);
                        this.alldimlevels.add(LM);
                    }
                }
                if (this.tableSet.isLoadClassicSAS()) {
                    this.inp_noNWAY.setEnabled(false);
                } else {
                    this.inp_noNWAY.setEnabled(true);
                    boolean nwayselected = false;
                    nwayselected = this.aggregationSet.isNWAYGenerated();
                    if (nwayselected) {
                        this.inp_noNWAY.setSelected(false);
                    } else {
                        this.inp_noNWAY.setSelected(true);
                    }
                }
                this.add.setEnabled(true);
                this.Existingaggrs = this.aggregationSet.getGeneratedAggregations();
                this.aggrlistModel.clear();
                for (i = 0; i < this.Existingaggrs.size(); ++i) {
                    OLAPAggregation UAM = (OLAPAggregation)this.Existingaggrs.get(i);
                    this.aggrlistModel.addElement(UAM);
                }
            }
            catch (OLAPException OLAPError) {
                return ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
        return true;
    }

    private void _layoutWidgets() {
        this.aggrlistModel = new DefaultListModel();
        this.aggregations = new JList(this.aggrlistModel);
        this.aggregations.setName("MOLAPDefinedAggregations");
        this.inp_noNWAY = new JCheckBox(bundle.getString("CubeDesigner.General.NONWAY.txt"));
        this.topbuttons = new CubeButtons();
        this.add = this.topbuttons.getAddButton();
        this.modify = this.topbuttons.getModifyButton();
        this.delete = this.topbuttons.getDeleteButton();
        this.add.setName("MOLAPAddButton");
        this.modify.setName("MOLAPModifyButton");
        this.delete.setName("MOLAPDeleteButton");
        this.topbuttons.removeApplyButton();
        this.topbuttons.removeDefaultButton();
        this.topbuttons.removeResetButton();
        this.add.setToolTipText(bundle.getString("CubeDesigner.UserAggregations.Add.tooltip.txt"));
        this.modify.setToolTipText(bundle.getString("CubeDesigner.UserAggregations.Modify.tooltip.txt"));
        this.delete.setToolTipText(bundle.getString("CubeDesigner.UserAggregations.Delete.tooltip.txt"));
        VisualUtilities.setButtonTextAndMnemonic(this.inp_noNWAY, bundle.getString("CubeDesigner.General.NONWAY.txt"));
        this.inp_noNWAY.setName("MOLAPSetNWAY");
        this.add(this.inp_noNWAY, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 5, 0), 0, 0));
        JLabel labelListBox = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(labelListBox, bundle.getString("CubeDesigner.UserAggregations.Listbox.control.label"));
        labelListBox.setLabelFor(this.aggregations);
        JScrollPane topPanel = new JScrollPane(this.aggregations);
        topPanel.setName("MOLAPScrollPane");
        topPanel.setPreferredSize(new Dimension(500, 200));
        this.add(labelListBox, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 0, 5, 0), 0, 0));
        this.add(topPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 5), 0, 0));
        this.add((Component)((Object)this.topbuttons), new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 0, 0), 0, 0));
        this.advanced = new JButton();
        this.advanced.setSize(this.delete.getSize());
        this.advanced.setName("MOLAPAdvanced");
        this.advanced.setToolTipText(bundle.getString("CubeDesigner.UserAggregations.Advanced.tooltip.txt"));
        VisualUtilities.setButtonTextAndMnemonic(this.advanced, bundle.getString("CubeDesigner.UserAggregations.Advanced.txt"));
        this.add(this.advanced, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
    }

    class LevelSelectionListener
    implements ListSelectionListener {
        LevelSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            if (CubeUserAggregationsPanel.this.aggregations.getSelectedIndex() == -1) {
                CubeUserAggregationsPanel.this.delete.setEnabled(false);
                CubeUserAggregationsPanel.this.modify.setEnabled(false);
            } else if (CubeUserAggregationsPanel.this.aggregations.getSelectedIndex() == 0) {
                OLAPAggregation UAM = (OLAPAggregation)CubeUserAggregationsPanel.this.aggrlistModel.elementAt(0);
                if (UAM.isNway()) {
                    CubeUserAggregationsPanel.this.modify.setEnabled(false);
                    CubeUserAggregationsPanel.this.delete.setEnabled(false);
                } else {
                    CubeUserAggregationsPanel.this.modify.setEnabled(CubeUserAggregationsPanel.this.aggregations.getSelectedIndices().length == 1);
                    CubeUserAggregationsPanel.this.delete.setEnabled(true);
                }
            } else {
                CubeUserAggregationsPanel.this.delete.setEnabled(true);
                CubeUserAggregationsPanel.this.modify.setEnabled(CubeUserAggregationsPanel.this.aggregations.getSelectedIndices().length == 1);
            }
        }
    }
}

