/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.visuals.CubeGeneralPanel;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.workspace.WATextPane;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.StyledDocument;

public class CubeStructureMessagePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeGeneralPanel.class);
    JScrollPane scrollPaneForText;
    private OLAPCube olapCube;
    private OLAPSharedDimension sharedDimension;
    private boolean isShared;
    private List cubeOptions;
    private JCheckBox sasCode;
    private JCheckBox sasFormat;
    private JCheckBox raggedOptions;
    private JCheckBox dimensionTableTranslations;
    private JCheckBox compactNway;
    private static final int SAS_CODE_INDEX = 0;
    private static final int FORMAT_SEARCH_INDEX = 1;
    private static final int EMPTY_CHAR_INDEX = 2;
    private static final int EMPTY_NUM_INDEX = 3;
    private static final int DIMENSION_TABLE_TRANSLATIONS_INDEX = 4;
    private static final int COMPACT_NWAY_INDEX = 5;
    private static final int CUBE_MESSAGES = 6;

    public CubeStructureMessagePanel(List messages, AbstractOLAPModel inputObject, List inputCubeOptions) {
        if (inputObject instanceof OLAPCube) {
            this.olapCube = (OLAPCube)inputObject;
        } else {
            this.sharedDimension = (OLAPSharedDimension)inputObject;
            this.isShared = true;
        }
        this.cubeOptions = inputCubeOptions;
        if (messages != null) {
            StringBuffer areaText = new StringBuffer();
            int size22 = messages.size();
            for (int i = 0; i < size22; ++i) {
                areaText.append((String)messages.get(i));
                if (i >= size22 - 1) continue;
                areaText.append("\n\n");
            }
            DefaultStyledDocument doc = new DefaultStyledDocument();
            try {
                doc.insertString(doc.getLength(), areaText.toString(), null);
            }
            catch (BadLocationException size22) {
                // empty catch block
            }
            WATextPane area = new WATextPane((StyledDocument)doc);
            area.setEnabled(true);
            area.setBehavior(2);
            area.setCaretPosition(0);
            area.setMargin(new Insets(5, 5, 5, 5));
            area.setAutoSelect(false);
            area.getAdapter().setPrintable(false);
            if (WAWizardDialog.isUsingNewStyle()) {
                area.setBackground((Color)SystemColor.window);
            }
            Font fnt = area.getFont();
            fnt = new Font("Monospaced", fnt.getStyle(), fnt.getSize());
            area.setFont(fnt);
            area.setEditable(false);
            this.scrollPaneForText = new JScrollPane((Component)area);
            this.scrollPaneForText.setPreferredSize(new Dimension(400, 100));
        }
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
    }

    protected void layoutWidgets() {
        String option = null;
        if (this.cubeOptions.size() > 0) {
            option = (String)this.cubeOptions.get(0);
        }
        if (!ModelUtilities.isBlank(option)) {
            this.sasCode = new JCheckBox();
            this.sasCode.setSelected(true);
            this.sasCode.setToolTipText(bundle.getString("Reset.SASCode.tooltip.txt"));
            VisualUtilities.setButtonTextAndMnemonic(this.sasCode, bundle.getString("Reset.SASCode.txt"));
            this.sasCode.setName("ResetSASCode");
            this.add((Component)this.sasCode, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        }
        if (this.cubeOptions.size() > 1) {
            option = (String)this.cubeOptions.get(1);
        }
        if (!ModelUtilities.isBlank((String)option)) {
            this.sasFormat = new JCheckBox();
            this.sasFormat.setSelected(true);
            this.sasFormat.setToolTipText(bundle.getString("Reset.FormatSearchOptions.tooltip.txt"));
            VisualUtilities.setButtonTextAndMnemonic(this.sasFormat, bundle.getString("Reset.FormatSearchOptions.txt"));
            this.sasFormat.setName("ResetFormatSearchOptions");
            this.add((Component)this.sasFormat, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        }
        if (this.cubeOptions.size() > 2) {
            option = (String)this.cubeOptions.get(2);
        }
        if (option == null && this.cubeOptions.size() > 3) {
            option = (String)this.cubeOptions.get(3);
        }
        if (option != null) {
            this.raggedOptions = new JCheckBox();
            this.raggedOptions.setSelected(true);
            this.raggedOptions.setToolTipText(bundle.getString("Reset.RaggedHierarchyOptions.tooltip.txt"));
            VisualUtilities.setButtonTextAndMnemonic(this.raggedOptions, bundle.getString("Reset.RaggedHierarchyOptions.txt"));
            this.raggedOptions.setName("ResetRaggedHierarchyOptions");
            this.add((Component)this.raggedOptions, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        }
        if (this.cubeOptions.size() > 4) {
            option = (String)this.cubeOptions.get(4);
        }
        if (!ModelUtilities.isBlank((String)option)) {
            this.dimensionTableTranslations = new JCheckBox();
            this.dimensionTableTranslations.setSelected(true);
            this.dimensionTableTranslations.setToolTipText(bundle.getString("Reset.DimensionTableTranslations.tooltip.txt"));
            VisualUtilities.setButtonTextAndMnemonic(this.dimensionTableTranslations, bundle.getString("Reset.DimensionTableTranslations.txt"));
            this.dimensionTableTranslations.setName("DimensionTableTranslations");
            this.add((Component)this.dimensionTableTranslations, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        }
        if (this.cubeOptions.size() > 5) {
            option = (String)this.cubeOptions.get(5);
        }
        if (!ModelUtilities.isBlank((String)option)) {
            this.compactNway = new JCheckBox();
            this.compactNway.setSelected(true);
            this.compactNway.setToolTipText(bundle.getString("Reset.CompactNwayOption.tooltip.txt"));
            VisualUtilities.setButtonTextAndMnemonic(this.compactNway, bundle.getString("Reset.CompactNwayOption.txt"));
            this.compactNway.setName("CompactNwayOption");
            this.add((Component)this.compactNway, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        }
        if (this.scrollPaneForText != null) {
            this.add((Component)this.scrollPaneForText, new GridBagConstraints(0, 6, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 5, 5), 0, 0));
        }
    }

    public boolean saveToModel() {
        if (this.sasCode != null) {
            if (!this.isShared) {
                this.olapCube.setResetSasCode(this.sasCode.isSelected());
            } else {
                this.sharedDimension.setResetSasCode(this.sasCode.isSelected());
            }
        }
        if (this.sasFormat != null) {
            this.olapCube.setResetFormatSearchOptions(this.sasFormat.isSelected());
        }
        if (this.raggedOptions != null) {
            if (!this.isShared) {
                this.olapCube.setResetRaggedHierarchyOptions(this.raggedOptions.isSelected());
            } else {
                this.sharedDimension.setResetRaggedHierarchyOptions(this.raggedOptions.isSelected());
            }
        }
        if (this.dimensionTableTranslations != null) {
            if (!this.isShared) {
                this.olapCube.setResetDimensionTableTranslations(this.dimensionTableTranslations.isSelected());
            } else {
                this.sharedDimension.setResetDimensionTableTranslations(this.dimensionTableTranslations.isSelected());
            }
        }
        if (this.compactNway != null) {
            this.olapCube.setResetCompactNwayOption(this.compactNway.isSelected());
        }
        return true;
    }
}

