/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.visuals.CubeSharedDimensionModel;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.swing.visuals.ButtonBorderRollOverHandler;
import com.sas.visuals.Resources;
import com.sas.workspace.CustomLayoutFocusTraversalPolicy;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDecoratableIcon;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CubeSharedDimensionPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeSharedDimensionPanel.class);
    private DefaultTreeModel treeModel;
    private JTree tree;
    private DefaultTreeModel treeModelView;
    private JTree treeView;
    private SharedDimTreeCellRenderer renderer;
    private WAPanel informationPanel;
    private List selectedSharedDimensions;
    private List recentlyAddedDims;
    private List recentlyDeletedDims;
    private WATextField inp_name;
    private WATextField inp_table;
    private WATextField inp_key;
    private OLAPSharedDimension lastSelectedDimension;
    private OLAPCube olapCube;
    private String collation;
    private String locale;
    private String[] cubeSortingValues;
    private JButton rightArrow;
    private JButton deleteButton;
    private WsTable detailsTable;
    private CubeSharedDimensionModel tableModel;
    private List privateDimNames;
    private List privateHierNames;
    private List privateLevelNames;

    public CubeSharedDimensionPanel(OLAPCube incube) {
        this.setLayout(new GridBagLayout());
        this.olapCube = incube;
        this._layoutWidgets();
        this.cubeSortingValues = new String[2];
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            this.initialize();
            try {
                this.collation = this.olapCube.getCollation();
                this.locale = this.olapCube.getLocale();
            }
            catch (OLAPException OLAPError) {
                ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        } else {
            try {
                this.tableModel.moveDataToStore();
                for (int i = 0; i < this.recentlyDeletedDims.size(); ++i) {
                    OLAPSharedDimension dim = (OLAPSharedDimension)this.recentlyDeletedDims.get(i);
                    dim.setFactKey(null);
                    if (!this.selectedSharedDimensions.contains(dim)) continue;
                    this.selectedSharedDimensions.remove(dim);
                }
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
            catch (MdException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
        return true;
    }

    public void initialize() {
        try {
            CustomLayoutFocusTraversalPolicy.setNextFocusableComponent((Component)this.tree, (Component)this.rightArrow);
            this.selectedSharedDimensions = this.olapCube.getDimensionSet().getSharedDimensions();
            this.recentlyAddedDims = new ArrayList();
            this.recentlyDeletedDims = new ArrayList();
            DimensionSet dimensionSet = this.olapCube.getDimensionSet();
            Map sharedDims = dimensionSet.getAllSharedDimensions();
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
            root.removeAllChildren();
            for (OLAPSchema schema : sharedDims.keySet()) {
                List listOfSharedDims = (List)sharedDims.get(schema);
                Collections.sort(listOfSharedDims);
                if (listOfSharedDims.isEmpty()) continue;
                DefaultMutableTreeNode schemaNode = new DefaultMutableTreeNode(schema);
                root.add(schemaNode);
                schemaNode.setAllowsChildren(true);
                int size = listOfSharedDims.size();
                for (int a = 0; a < size; ++a) {
                    OLAPSharedDimension dim = (OLAPSharedDimension)listOfSharedDims.get(a);
                    DefaultMutableTreeNode dimNode = new DefaultMutableTreeNode(dim);
                    dimNode.setAllowsChildren(false);
                    schemaNode.add(dimNode);
                }
            }
            this.treeModel.reload();
            this.expandAll(this.tree, new TreePath(root.getPath()));
            this.detailsTable.clearSortMemory();
            this.tableModel.addDimensions(this.selectedSharedDimensions);
            this.detailsTable.sort(1);
            this.tree.addMouseListener(new TreeMouseListener());
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    private void expandAll(JTree tree, TreePath parent) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path);
            }
        }
        tree.expandPath(parent);
    }

    public List getRecentlyAddSharedDimensions() {
        return this.recentlyAddedDims;
    }

    public String[] getSortingOptionsForProc() {
        return this.cubeSortingValues;
    }

    private void _layoutWidgets() {
        ButtonBorderRollOverHandler handler = new ButtonBorderRollOverHandler();
        this.treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.tree = new JTree(this.treeModel);
        this.renderer = new SharedDimTreeCellRenderer();
        this.tree.setCellRenderer(this.renderer);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        JScrollPane scrollPane = new JScrollPane(this.tree);
        scrollPane.setPreferredSize(new Dimension(200, 200));
        JLabel labelBox = new JLabel();
        Utilities.setLabelTextAndMnemonic((JLabel)labelBox, (String)bundle.getString("CubeDesigner.SharedDimension.tree.control.label"));
        labelBox.setLabelFor(this.tree);
        this.tree.addTreeSelectionListener(new DimensionSelectedListener());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addFocusListener(new TreeFocusListener());
        this.rightArrow = new JButton(Resources.getImageIcon((String)"ArrowRightAdd.gif", (int)16));
        this.rightArrow.setToolTipText(bundle.getString("CubeDesigner.MeasuresSelect.Copy.tooltip.txt"));
        this.rightArrow.setPreferredSize(new Dimension(25, 25));
        this.rightArrow.setEnabled(false);
        this.rightArrow.addActionListener(new RightArrowListener());
        handler.addButton((AbstractButton)this.rightArrow);
        JLabel tableLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(tableLabel, bundle.getString("CubeDesigner.SharedDimension.selectedTable.control.label"));
        tableLabel.setLabelFor((Component)this.detailsTable);
        this.tableModel = new CubeSharedDimensionModel(this.olapCube);
        this.detailsTable = new WsTable((WsAbstractTableModel)this.tableModel);
        tableLabel.setLabelFor((Component)this.detailsTable);
        this.detailsTable.setSortingEnabled(true);
        this.detailsTable.setKeepSortedEnabled(true);
        this.detailsTable.setColumnHidingEnabled(false);
        this.detailsTable.setColumnsReorderable(false);
        this.detailsTable.setRowHoldingEnabled(false);
        this.detailsTable.setColumnHeaderPopupMenuEnabled(false);
        this.detailsTable.setOriginPopupMenuEnabled(false);
        this.detailsTable.setPopupMenuEnabled(false);
        this.detailsTable.setRowHeaderPopupMenuEnabled(false);
        this.detailsTable.setTablePopupMenuEnabled(false);
        this.detailsTable.setViewportPopupMenuEnabled(false);
        this.detailsTable.setPreferredScrollableViewportSize(new Dimension(425, 200));
        this.detailsTable.setAutoResizeMode(0);
        this.detailsTable.setNonEditableCellBackground(UIManager.getColor("TextField.inactiveBackground"));
        this.detailsTable.getSelectionModel().addListSelectionListener(new RowSelectionListener());
        JScrollPane tableScroll = new JScrollPane((Component)this.detailsTable);
        tableScroll.setPreferredSize(new Dimension(400, 200));
        this.deleteButton = new JButton(Resources.getImageIcon((String)"Delete.gif", (int)16));
        this.deleteButton.setToolTipText(bundle.getString("CubeDesigner.MeasuresSelect.Remove.tooltip.txt"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.setPreferredSize(new Dimension(25, 25));
        this.deleteButton.addActionListener(new DeleteButtonListener());
        handler.addButton((AbstractButton)this.deleteButton);
        JLabel label_name = new JLabel(bundle.getString("CubeDesigner.SharedDimension.name.control.label"));
        this.inp_name = new WATextField(20);
        this.inp_name.setBehavior(1);
        JLabel label_table = new JLabel(bundle.getString("CubeDesigner.SharedDimension.table.control.label"));
        this.inp_table = new WATextField(20);
        this.inp_table.setBehavior(1);
        JLabel label_key = new JLabel(bundle.getString("CubeDesigner.SharedDimension.key.control.label"));
        this.inp_key = new WATextField(20);
        this.inp_key.setBehavior(1);
        this.treeModelView = new DefaultTreeModel(new DefaultMutableTreeNode(bundle.getString("CubeDesigner.NoItemsSelected.txt")));
        this.treeView = new JTree(this.treeModelView);
        this.treeView.setRootVisible(true);
        this.treeView.setEditable(false);
        JScrollPane scrollPaneView = new JScrollPane(this.treeView);
        this.treeView.setCellRenderer(new HierarchyLevelTreeRenderer());
        scrollPaneView.setPreferredSize(new Dimension(175, 100));
        scrollPaneView.setBorder(new TitledBorder(bundle.getString("CubeDesigner.SharedDimension.treeView.groupbox.title")));
        this.treeView.setBackground(SystemColor.control);
        this.informationPanel = new WAPanel();
        this.informationPanel.setLayout((LayoutManager)new GridBagLayout());
        this.informationPanel.setBorder(BorderFactory.createEtchedBorder());
        this.informationPanel.add((Component)label_name, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.informationPanel.add((Component)this.inp_name, (Object)new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 5, 5), 0, 0));
        this.informationPanel.add((Component)label_table, (Object)new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.informationPanel.add((Component)this.inp_table, (Object)new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.informationPanel.add((Component)label_key, (Object)new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.informationPanel.add((Component)this.inp_key, (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 5), 0, 0));
        this.informationPanel.add((Component)scrollPaneView, (Object)new GridBagConstraints(0, 3, 2, 1, 0.0, 0.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(labelBox, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(scrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.rightArrow, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(tableLabel, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(tableScroll, new GridBagConstraints(2, 1, 1, 2, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.deleteButton, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.informationPanel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        int rowCount = this.tableModel.getRowCount();
        OLAPList noFactKeys = new OLAPList(OLAPSharedDimension.class);
        for (int i = 0; i < rowCount; ++i) {
            List rowValues = this.tableModel.getRowValues(i);
            OLAPSharedDimension dim = (OLAPSharedDimension)rowValues.get(5);
            String factKeyName = (String)rowValues.get(2);
            if (!Utilities.isBlank((String)factKeyName)) continue;
            noFactKeys.add((Object)dim);
        }
        if (!noFactKeys.isEmpty()) {
            StringBuffer dims = ModelUtilities.listFormatter((OLAPList)noFactKeys, (String)"      ", (String)",");
            MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.SharedDimension.MissingFactKey.fmt.txt", (Object)dims));
            return false;
        }
        return true;
    }

    private boolean verifyNames(OLAPSharedDimension newdim) throws OLAPException {
        boolean namesOK = true;
        DimensionSet dimensionSet = this.olapCube.getDimensionSet();
        if (this.privateDimNames == null) {
            this.privateDimNames = new ArrayList();
            this.privateHierNames = new ArrayList();
            this.privateLevelNames = new ArrayList();
            OLAPList privateDims = dimensionSet.getCubeDimensions();
            for (int dimNum = 0; dimNum < privateDims.size(); ++dimNum) {
                OLAPDimension dim = (OLAPDimension)privateDims.get(dimNum);
                this.privateDimNames.add(dim.getName().toUpperCase());
                OLAPList privateHiers = dim.getHierarchies();
                for (int hierNum = 0; hierNum < privateHiers.size(); ++hierNum) {
                    OLAPHierarchy hier = (OLAPHierarchy)privateHiers.get(hierNum);
                    this.privateHierNames.add(hier.getName().toUpperCase());
                }
                OLAPList privateLevels = dim.getLevels();
                for (int levNum = 0; levNum < privateLevels.size(); ++levNum) {
                    OLAPLevel level = (OLAPLevel)privateLevels.get(levNum);
                    this.privateLevelNames.add(level.getName().toUpperCase());
                }
            }
        }
        int rowCount = this.tableModel.getRowCount();
        ArrayList<String> currentSharedDimNames = new ArrayList<String>();
        ArrayList<String> currentSharedHierNames = new ArrayList<String>();
        ArrayList<String> currentSharedLevelNames = new ArrayList<String>();
        for (int i = 0; i < rowCount; ++i) {
            List rowValues = this.tableModel.getRowValues(i);
            OLAPSharedDimension dim = (OLAPSharedDimension)rowValues.get(5);
            currentSharedDimNames.add(dim.getName().toUpperCase());
            Map s = dim.getDisplayHierarchies();
            Iterator iterator = s.keySet().iterator();
            while (iterator.hasNext() && namesOK) {
                String hierarchyName = (String)iterator.next();
                currentSharedHierNames.add(hierarchyName.toUpperCase());
                List listOfLevels = (List)s.get(hierarchyName);
                for (int levNum = 0; levNum < listOfLevels.size(); ++levNum) {
                    String levName = ((String)listOfLevels.get(levNum)).toUpperCase();
                    currentSharedLevelNames.add(levName.toUpperCase());
                }
            }
        }
        if (this.privateDimNames.contains(newdim.getName().toUpperCase()) || currentSharedDimNames.contains(newdim.getName().toUpperCase())) {
            namesOK = false;
            MessageUtil.displayMessage((String)bundle.getString("OLAPDimension.DuplicateDimensionNameWithinCube.txt"));
        } else {
            Map sharedDimHiersLevels = newdim.getDisplayHierarchies();
            ArrayList<String> sharedDimLevelNames = new ArrayList<String>();
            Iterator iterator = sharedDimHiersLevels.keySet().iterator();
            while (iterator.hasNext() && namesOK) {
                String hierarchyName = (String)iterator.next();
                namesOK = !this.privateHierNames.contains(hierarchyName.toUpperCase()) && !currentSharedHierNames.contains(hierarchyName.toUpperCase());
                List listOfLevels = (List)sharedDimHiersLevels.get(hierarchyName);
                for (int levNum = 0; levNum < listOfLevels.size(); ++levNum) {
                    String levName = ((String)listOfLevels.get(levNum)).toUpperCase();
                    if (sharedDimLevelNames.contains(levName)) continue;
                    sharedDimLevelNames.add(levName);
                }
            }
            if (!namesOK) {
                MessageUtil.displayMessage((String)bundle.getString("OLAPDimension.DuplicateHierarchyNameWithinCube.txt"));
            } else {
                for (int levNum = 0; levNum < sharedDimLevelNames.size() && namesOK; ++levNum) {
                    String levName = (String)sharedDimLevelNames.get(levNum);
                    namesOK = !this.privateLevelNames.contains(levName) && !currentSharedLevelNames.contains(levName);
                }
                if (!namesOK) {
                    MessageUtil.displayMessage((String)bundle.getString("OLAPDimension.DuplicateLevelNameWithinCube.txt"));
                }
            }
        }
        return namesOK;
    }

    private void fillPanels() {
        try {
            PhysicalTable table;
            this.inp_name.setText(this.lastSelectedDimension.getName());
            this.inp_name.setToolTipText(this.inp_name.getText());
            SharedDimensionTable dimensionTable = this.lastSelectedDimension.getSharedDimensionTable();
            String tableName = "";
            if (dimensionTable != null && (table = dimensionTable.getTable()) != null) {
                tableName = ModelUtilities.generateTableName((PhysicalTable)table);
            }
            this.inp_table.setText(tableName);
            this.inp_table.setToolTipText(this.inp_table.getText());
            OLAPColumn dimKeyCol = this.lastSelectedDimension.getDimensionKey();
            if (dimKeyCol != null) {
                this.inp_key.setText(dimKeyCol.toString());
            } else {
                this.inp_key.setText("");
            }
            this.inp_key.setToolTipText(this.inp_key.getText());
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModelView.getRoot();
            root.removeAllChildren();
            Map listOfHierarchies = this.lastSelectedDimension.getDisplayHierarchies();
            for (String hierarchyName : listOfHierarchies.keySet()) {
                DefaultMutableTreeNode hierNode = new DefaultMutableTreeNode(hierarchyName);
                root.add(hierNode);
                hierNode.setAllowsChildren(true);
                List listOfLevels = (List)listOfHierarchies.get(hierarchyName);
                int sizeLevels = listOfLevels.size();
                for (int a = 0; a < sizeLevels; ++a) {
                    String levelName = (String)listOfLevels.get(a);
                    DefaultMutableTreeNode levelNode = new DefaultMutableTreeNode(levelName);
                    hierNode.add(levelNode);
                }
            }
            this.treeModelView.reload();
            this.treeView.setRootVisible(false);
            this.expandAll(this.treeView, new TreePath(root.getPath()));
        }
        catch (OLAPException OLAPError) {
            ExceptionHandler.handleException((Exception)((Object)OLAPError));
        }
    }

    private void clearPanels() {
        this.inp_name.setText("");
        this.inp_table.setText("");
        this.inp_key.setText("");
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModelView.getRoot();
        root.removeAllChildren();
        this.treeModelView.reload();
        this.treeView.setRootVisible(true);
    }

    private class TreeFocusListener
    implements FocusListener {
        private TreeFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (CubeSharedDimensionPanel.this.tree.getMaxSelectionRow() < 0) {
                CubeSharedDimensionPanel.this.tree.setSelectionRow(0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    private class TreeMouseListener
    extends MouseAdapter {
        private TreeMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int selRow = CubeSharedDimensionPanel.this.tree.getRowForLocation(e.getX(), e.getY());
            if (selRow != -1 && e.getClickCount() == 2) {
                CubeSharedDimensionPanel.this.rightArrow.doClick();
            }
        }
    }

    private class RightArrowListener
    implements ActionListener {
        private RightArrowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                if (CubeSharedDimensionPanel.this.lastSelectedDimension == null) {
                    return;
                }
                boolean optionsOK = this.checkSortingOptions(CubeSharedDimensionPanel.this.lastSelectedDimension);
                if (optionsOK) {
                    SharedDimensionTable table = CubeSharedDimensionPanel.this.lastSelectedDimension.getSharedDimensionTable();
                    if (table == null) {
                        MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.SharedDimension.NoTable.txt"));
                        return;
                    }
                    OLAPColumn key = CubeSharedDimensionPanel.this.lastSelectedDimension.getDimensionKey();
                    if (key == null) {
                        MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.SharedDimension.NoKey.txt"));
                        return;
                    }
                    boolean namesOK = CubeSharedDimensionPanel.this.verifyNames(CubeSharedDimensionPanel.this.lastSelectedDimension);
                    if (namesOK) {
                        ArrayList<OLAPSharedDimension> newdims = new ArrayList<OLAPSharedDimension>();
                        newdims.add(CubeSharedDimensionPanel.this.lastSelectedDimension);
                        int start = CubeSharedDimensionPanel.this.tableModel.getRowCount();
                        CubeSharedDimensionPanel.this.tableModel.addDimensions(newdims);
                        CubeSharedDimensionPanel.this.detailsTable.clearSelection();
                        CubeSharedDimensionPanel.this.detailsTable.selectRows(start, start + newdims.size() - 1);
                        CubeSharedDimensionPanel.this.detailsTable.requestFocusInWindow();
                        if (!CubeSharedDimensionPanel.this.recentlyAddedDims.contains(CubeSharedDimensionPanel.this.lastSelectedDimension)) {
                            CubeSharedDimensionPanel.this.recentlyAddedDims.add(CubeSharedDimensionPanel.this.lastSelectedDimension);
                        }
                        if (CubeSharedDimensionPanel.this.recentlyDeletedDims.contains(CubeSharedDimensionPanel.this.lastSelectedDimension)) {
                            CubeSharedDimensionPanel.this.recentlyDeletedDims.remove(CubeSharedDimensionPanel.this.lastSelectedDimension);
                        }
                        CubeSharedDimensionPanel.this.treeModel.reload();
                        DefaultMutableTreeNode root = (DefaultMutableTreeNode)CubeSharedDimensionPanel.this.treeModel.getRoot();
                        CubeSharedDimensionPanel.this.expandAll(CubeSharedDimensionPanel.this.tree, new TreePath(root.getPath()));
                    }
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                return;
            }
        }

        private boolean checkSortingOptions(OLAPSharedDimension dim) {
            boolean optionsOK = true;
            try {
                String newLocaleDisplayValue;
                String newCollationDisplayValue;
                String dimCollation = dim.getCollation();
                String dimLocale = dim.getLocale();
                String defaultValue = bundle.getString("Common.Default.Item.txt");
                String dimCollationValue = dimCollation;
                String dimLocaleValue = dimLocale;
                if (dimCollation == null) {
                    dimCollationValue = defaultValue;
                }
                if (dimLocale == null) {
                    dimLocaleValue = defaultValue;
                }
                if ((newCollationDisplayValue = CubeSharedDimensionPanel.this.cubeSortingValues[0]) == null) {
                    newCollationDisplayValue = defaultValue;
                }
                if ((newLocaleDisplayValue = CubeSharedDimensionPanel.this.cubeSortingValues[1]) == null) {
                    newLocaleDisplayValue = defaultValue;
                }
                if (CubeSharedDimensionPanel.this.collation == null && CubeSharedDimensionPanel.this.locale == null) {
                    if (dimCollation == null && dimLocale == null && CubeSharedDimensionPanel.this.cubeSortingValues[0] == null && CubeSharedDimensionPanel.this.cubeSortingValues[1] == null) {
                        return true;
                    }
                    if (dimCollation == null && dimLocale == null && (CubeSharedDimensionPanel.this.cubeSortingValues[0] != null || CubeSharedDimensionPanel.this.cubeSortingValues[1] != null)) {
                        MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.SharedDimension.NoMatchDimSort.fmt.txt", (Object)newCollationDisplayValue, (Object)newLocaleDisplayValue), (int)1);
                        return false;
                    }
                    if (CubeSharedDimensionPanel.this.cubeSortingValues[0] == null && CubeSharedDimensionPanel.this.cubeSortingValues[1] == null) {
                        int rowCount = CubeSharedDimensionPanel.this.tableModel.getRowCount();
                        if (rowCount > 0) {
                            MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.SharedDimension.ExistingDimNoOptions.fmt.txt", (Object)dimCollationValue, (Object)dimLocaleValue), (int)1);
                            return false;
                        }
                        int selectValue = MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.SharedDimension.NOProc.Sorting.Options.fmt.txt", (Object)dimCollationValue, (Object)dimLocaleValue), (int)1, (int)0);
                        if (selectValue == 1) {
                            return false;
                        }
                        ((CubeSharedDimensionPanel)CubeSharedDimensionPanel.this).cubeSortingValues[0] = dimCollation;
                        ((CubeSharedDimensionPanel)CubeSharedDimensionPanel.this).cubeSortingValues[1] = dimLocale;
                        return true;
                    }
                    if (CubeSharedDimensionPanel.this.cubeSortingValues[0] != null && !CubeSharedDimensionPanel.this.cubeSortingValues[0].equalsIgnoreCase(dimCollation) || CubeSharedDimensionPanel.this.cubeSortingValues[1] != null && !CubeSharedDimensionPanel.this.cubeSortingValues[1].equalsIgnoreCase(dimLocale)) {
                        MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.SharedDimension.Sorting.NoMatch.fmt.txt", (Object)dimCollationValue, (Object)dimLocaleValue, (Object)newCollationDisplayValue, (Object)newLocaleDisplayValue), (int)1);
                        return false;
                    }
                } else {
                    String collationValue = CubeSharedDimensionPanel.this.collation;
                    String localeValue = CubeSharedDimensionPanel.this.locale;
                    if (CubeSharedDimensionPanel.this.collation == null) {
                        collationValue = defaultValue;
                    }
                    if (CubeSharedDimensionPanel.this.locale == null) {
                        localeValue = defaultValue;
                    }
                    if (dimCollation == null && dimLocale == null) {
                        MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.SharedDimension.DimNoOptions.fmt.txt", (Object)collationValue, (Object)localeValue), (int)1);
                        return false;
                    }
                    if (!collationValue.equals(dimCollationValue) || !localeValue.equals(dimLocaleValue)) {
                        MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.SharedDimension.Different.Sorting.Options.fmt.txt", (Object)dimCollationValue, (Object)dimLocaleValue, (Object)collationValue, (Object)localeValue), (int)1);
                        return false;
                    }
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            return optionsOK;
        }
    }

    private class HierarchyLevelTreeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        private HierarchyLevelTreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setIcon(null);
            this.setBackgroundSelectionColor(SystemColor.control);
            this.setBackgroundNonSelectionColor(SystemColor.control);
            this.setForeground(SystemColor.textText);
            return this;
        }
    }

    private class SharedDimTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        protected Icon sharedDimIcon = Resources.getImageIcon((String)"OLAPDimension_shared.gif", (int)16);
        protected Icon olapSchemaIcon = Resources.getImageIcon((String)"OLAPSchema.gif", (int)16);

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object userObject = node.getUserObject();
            if (userObject instanceof OLAPSharedDimension) {
                WsDecoratableIcon decoratedIcon = new WsDecoratableIcon(this.sharedDimIcon);
                OLAPSharedDimension dim = (OLAPSharedDimension)userObject;
                if (!dim.physicallyExists()) {
                    ImageIcon decoration = bundle.getImageIcon("CubeDesigner.SharedDimension.Decorator.Definition.image");
                    decoratedIcon.setSEDecoration((Icon)decoration);
                }
                this.setIcon((Icon)decoratedIcon);
                this.setDisabledIcon((Icon)decoratedIcon);
                if (CubeSharedDimensionPanel.this.selectedSharedDimensions.contains(userObject) && !CubeSharedDimensionPanel.this.recentlyDeletedDims.contains(userObject) || CubeSharedDimensionPanel.this.recentlyAddedDims.contains(userObject)) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(true);
                }
            } else if (userObject instanceof OLAPSchema) {
                this.setIcon(this.olapSchemaIcon);
            }
            return this;
        }
    }

    private class DeleteButtonListener
    implements ActionListener {
        private DeleteButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int[] rowsToDelete = CubeSharedDimensionPanel.this.detailsTable.getSelectedRowsFromSelectedCells();
            TableCellEditor cellEditor = CubeSharedDimensionPanel.this.detailsTable.getCellEditor();
            if (cellEditor != null) {
                cellEditor.cancelCellEditing();
            }
            if (rowsToDelete.length > 0) {
                for (int i = rowsToDelete.length - 1; i >= 0; --i) {
                    int rowNum = CubeSharedDimensionPanel.this.detailsTable.convertRowIndexToModel(rowsToDelete[i]);
                    OLAPSharedDimension dimToDelete = CubeSharedDimensionPanel.this.tableModel.getSharedDimensionForRow(rowNum);
                    if (CubeSharedDimensionPanel.this.recentlyAddedDims.contains(dimToDelete)) {
                        CubeSharedDimensionPanel.this.recentlyAddedDims.remove(dimToDelete);
                    }
                    CubeSharedDimensionPanel.this.recentlyDeletedDims.add(dimToDelete);
                    CubeSharedDimensionPanel.this.tableModel.deleteRow(rowNum);
                }
                CubeSharedDimensionPanel.this.treeModel.reload();
                DefaultMutableTreeNode root = (DefaultMutableTreeNode)CubeSharedDimensionPanel.this.treeModel.getRoot();
                CubeSharedDimensionPanel.this.expandAll(CubeSharedDimensionPanel.this.tree, new TreePath(root.getPath()));
            }
        }
    }

    private class RowSelectionListener
    implements ListSelectionListener {
        private RowSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
                CubeSharedDimensionPanel.this.deleteButton.setEnabled(!selectionModel.isSelectionEmpty());
            }
        }
    }

    private class DimensionSelectedListener
    implements TreeSelectionListener {
        private DimensionSelectedListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] selectedObjectPaths = CubeSharedDimensionPanel.this.tree.getSelectionPaths();
            if (selectedObjectPaths != null) {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)selectedObjectPaths[0].getLastPathComponent();
                Object nextObject = node.getUserObject();
                if (nextObject instanceof OLAPSharedDimension) {
                    CubeSharedDimensionPanel.this.lastSelectedDimension = (OLAPSharedDimension)nextObject;
                    CubeSharedDimensionPanel.this.fillPanels();
                    if (CubeSharedDimensionPanel.this.selectedSharedDimensions.contains(CubeSharedDimensionPanel.this.lastSelectedDimension) && !CubeSharedDimensionPanel.this.recentlyDeletedDims.contains(CubeSharedDimensionPanel.this.lastSelectedDimension) || CubeSharedDimensionPanel.this.recentlyAddedDims.contains(CubeSharedDimensionPanel.this.lastSelectedDimension)) {
                        CubeSharedDimensionPanel.this.rightArrow.setEnabled(false);
                    } else {
                        CubeSharedDimensionPanel.this.rightArrow.setEnabled(true);
                    }
                } else {
                    CubeSharedDimensionPanel.this.lastSelectedDimension = null;
                    CubeSharedDimensionPanel.this.clearPanels();
                    CubeSharedDimensionPanel.this.rightArrow.setEnabled(false);
                }
            } else {
                CubeSharedDimensionPanel.this.lastSelectedDimension = null;
                CubeSharedDimensionPanel.this.clearPanels();
                CubeSharedDimensionPanel.this.rightArrow.setEnabled(false);
            }
        }
    }
}

