/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPSharedDimension;
import com.sas.olapadmin.designer.model.SharedDimensionTable;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.visuals.Resources;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsDecoratableIcon;
import com.sas.workspace.WsIconTableColumn;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public class CubeSharedDimensionModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(CubeSharedDimensionModel.class);
    public static final int ICON = 0;
    public static final int NAME = 1;
    public static final int FACTKEY = 2;
    public static final int KEY = 3;
    public static final int TABLE = 4;
    public static final int SHAREDDIM_OBJECT = 5;
    private static final int TOTAL_VISIBLE_COLS = 5;
    private static final int TOTAL_HIDDEN_COLS = 1;
    private OLAPCube olapCube;
    private OLAPList columns;
    private String[] columnNames;

    public CubeSharedDimensionModel(OLAPCube cube) {
        this.olapCube = cube;
        this.createColumnDefinitions();
    }

    private void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsIconTableColumn(0, " ", 26);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("CubeDesigner.SharedDimensionModel.name.header.title"), 100);
        this.m_aColumns[1].setEditable(false);
        String[] values = this.getFactKeyColumns();
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("CubeDesigner.SharedDimensionModel.factkey.header.title"), 100, values);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("CubeDesigner.SharedDimensionModel.key.header.title"), 100);
        this.m_aColumns[3].setEditable(false);
        this.m_aColumns[4] = new WsStringTableColumn(4, bundle.getString("CubeDesigner.SharedDimensionModel.table.header.title"), 150);
        this.m_aColumns[4].setEditable(false);
        this.m_aColumns[5] = new WsObjectTableColumn();
    }

    private void addDimension(Object obj) throws OLAPException {
        List<String> namesList;
        if (!(obj instanceof OLAPSharedDimension)) {
            return;
        }
        OLAPSharedDimension newDim = (OLAPSharedDimension)obj;
        ArrayList<Object> alRow = new ArrayList<Object>(this.getColumnCount() + this.getHiddenColumnCount());
        ImageIcon sharedDimIcon = Resources.getImageIcon((String)"OLAPDimension_shared.gif", (int)16);
        WsDecoratableIcon decoratedIcon = new WsDecoratableIcon((Icon)sharedDimIcon);
        if (!newDim.physicallyExists()) {
            ImageIcon decoration = bundle.getImageIcon("CubeDesigner.SharedDimension.Decorator.Definition.image");
            decoratedIcon.setSEDecoration((Icon)decoration);
        }
        alRow.add(0, decoratedIcon);
        alRow.add(1, newDim.getName());
        SharedDimensionTable dimensionTable = newDim.getSharedDimensionTable();
        OLAPColumn factkeycol = newDim.getSharedDimensionFactKey(this.olapCube);
        OLAPColumn dimKey = null;
        if (dimensionTable != null) {
            dimKey = newDim.getDimensionKey();
        }
        String factColumnName = "";
        String keyColumnName = "";
        if (dimKey != null) {
            keyColumnName = dimKey.getSASColumnName();
        }
        if (factkeycol != null) {
            factColumnName = factkeycol.getSASColumnName();
        } else if (dimKey != null && (namesList = Arrays.asList(this.columnNames)).contains(keyColumnName)) {
            factColumnName = keyColumnName;
        }
        alRow.add(2, factColumnName);
        alRow.add(3, keyColumnName);
        String tableName = "";
        if (dimensionTable != null) {
            tableName = ModelUtilities.generateTableName((PhysicalTable)dimensionTable.getTable());
        }
        alRow.add(4, tableName);
        alRow.add(5, newDim);
        this.m_lData.add(alRow);
    }

    public void addDimensions(List newDimensions) throws OLAPException {
        int start = this.getRowCount();
        for (int i = 0; i < newDimensions.size(); ++i) {
            this.addDimension(newDimensions.get(i));
        }
        int end = this.getRowCount();
        if (start != end) {
            this.fireTableRowsInserted(start, end - 1);
        }
    }

    public String[] getFactKeyColumns() {
        TableSet tableSet = this.olapCube.getTableSet();
        try {
            this.columns = tableSet.getLoadTable().getColumns();
            this.columns.sort();
            this.columnNames = new String[this.columns.size()];
            for (int i = 0; i < this.columns.size(); ++i) {
                this.columnNames[i] = this.columns.get(i).toString();
            }
            return this.columnNames;
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
            return null;
        }
    }

    public int getColumnCount() {
        return 5;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public void moveDataToModel() throws MdException, RemoteException {
    }

    public void moveDataToStore() throws MdException, RemoteException {
        int rowCount = this.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            OLAPSharedDimension dim = this.getSharedDimensionForRow(i);
            String factKeyName = (String)this.getValueAt(i, 2);
            boolean found = false;
            for (int colNum = 0; colNum < this.columns.size() && !found; ++colNum) {
                OLAPColumn col = (OLAPColumn)this.columns.get(colNum);
                String name = col.getSASColumnName();
                if (!factKeyName.equalsIgnoreCase(name)) continue;
                dim.setFactKey(col);
                found = true;
            }
        }
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public OLAPSharedDimension getSharedDimensionForRow(int rowNum) {
        return (OLAPSharedDimension)this.getValueAt(rowNum, 5);
    }
}

