/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.visuals.CubeGeneralPanel;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

public class CubeResetOptionsPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeGeneralPanel.class);
    private OLAPCube olapCube;
    private List cubeOptions;
    private JCheckBox sasCode;
    private JCheckBox sasFormat;
    private JCheckBox raggedOptions;
    private JCheckBox dimensionTableTranslations;
    private JCheckBox compactNway;
    private static final int SAS_CODE_INDEX = 0;
    private static final int FORMAT_SEARCH_INDEX = 1;
    private static final int EMPTY_CHAR_INDEX = 2;
    private static final int EMPTY_NUM_INDEX = 3;
    private static final int DIMENSION_TABLE_TRANSLATIONS_INDEX = 4;
    private static final int COMPACT_NWAY_INDEX = 5;

    public CubeResetOptionsPanel(OLAPCube inputOLAPCube, List inputCubeOptions) {
        this.olapCube = inputOLAPCube;
        this.cubeOptions = inputCubeOptions;
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
    }

    protected void layoutWidgets() {
        String option = (String)this.cubeOptions.get(0);
        if (!ModelUtilities.isBlank((String)option)) {
            this.sasCode = new JCheckBox();
            this.sasCode.setSelected(true);
            this.sasCode.setToolTipText(bundle.getString("Reset.SASCode.tooltip.txt"));
            VisualUtilities.setButtonTextAndMnemonic(this.sasCode, bundle.getString("Reset.SASCode.txt"));
            this.sasCode.setName("ResetSASCode");
            this.add((Component)this.sasCode, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        }
        if (!ModelUtilities.isBlank((String)(option = (String)this.cubeOptions.get(1)))) {
            this.sasFormat = new JCheckBox();
            this.sasFormat.setSelected(true);
            this.sasFormat.setToolTipText(bundle.getString("Reset.FormatSearchOptions.tooltip.txt"));
            VisualUtilities.setButtonTextAndMnemonic(this.sasFormat, bundle.getString("Reset.FormatSearchOptions.txt"));
            this.sasFormat.setName("ResetFormatSearchOptions");
            this.add((Component)this.sasFormat, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        }
        if (ModelUtilities.isBlank((String)(option = (String)this.cubeOptions.get(2)))) {
            option = (String)this.cubeOptions.get(3);
        }
        if (!ModelUtilities.isBlank((String)option)) {
            this.raggedOptions = new JCheckBox();
            this.raggedOptions.setSelected(true);
            this.raggedOptions.setToolTipText(bundle.getString("Reset.RaggedHierarchyOptions.tooltip.txt"));
            VisualUtilities.setButtonTextAndMnemonic(this.raggedOptions, bundle.getString("Reset.RaggedHierarchyOptions.txt"));
            this.raggedOptions.setName("ResetRaggedHierarchyOptions");
            this.add((Component)this.raggedOptions, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        }
        if (!ModelUtilities.isBlank((String)(option = (String)this.cubeOptions.get(4)))) {
            this.dimensionTableTranslations = new JCheckBox();
            this.dimensionTableTranslations.setSelected(true);
            this.dimensionTableTranslations.setToolTipText(bundle.getString("Reset.DimensionTableTranslations.tooltip.txt"));
            VisualUtilities.setButtonTextAndMnemonic(this.dimensionTableTranslations, bundle.getString("Reset.DimensionTableTranslations.txt"));
            this.dimensionTableTranslations.setName("DimensionTableTranslations");
            this.add((Component)this.dimensionTableTranslations, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        }
        if (!ModelUtilities.isBlank((String)(option = (String)this.cubeOptions.get(5)))) {
            this.compactNway = new JCheckBox();
            this.compactNway.setSelected(true);
            this.compactNway.setToolTipText(bundle.getString("Reset.CompactNwayOption.tooltip.txt"));
            VisualUtilities.setButtonTextAndMnemonic(this.compactNway, bundle.getString("Reset.CompactNwayOption.txt"));
            this.compactNway.setName("CompactNwayOption");
            this.add((Component)this.compactNway, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        }
    }

    public boolean saveToModel() {
        if (this.sasCode != null) {
            this.olapCube.setResetSasCode(this.sasCode.isSelected());
        }
        if (this.sasFormat != null) {
            this.olapCube.setResetFormatSearchOptions(this.sasFormat.isSelected());
        }
        if (this.raggedOptions != null) {
            this.olapCube.setResetRaggedHierarchyOptions(this.raggedOptions.isSelected());
        }
        if (this.dimensionTableTranslations != null) {
            this.olapCube.setResetDimensionTableTranslations(this.dimensionTableTranslations.isSelected());
        }
        if (this.compactNway != null) {
            this.olapCube.setResetCompactNwayOption(this.compactNway.isSelected());
        }
        return true;
    }
}

