/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.Statistic;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.CubeDesigner;
import com.sas.olapadmin.designer.visuals.CubeMeasuresSelectModel;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.swing.visuals.ButtonBorderRollOverHandler;
import com.sas.visuals.Resources;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CubeMeasuresSelectPanel
extends WAPanel
implements TableModelListener {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeMeasuresSelectPanel.class);
    private OLAPCube olapCube;
    private JTree treeSelector;
    private DefaultTreeModel treeModel;
    private boolean initialized;
    private WAComboBox defaultMeasureBox;
    private CubeMeasuresSelectModel tableModel;
    private WsTable detailsTable;
    private MeasureSet measureSet;
    private JButton rightArrow;
    private JButton collapseArrow;
    private JButton expandArrow;
    private JButton deleteButton;
    private HashMap selectedNodes;
    private HashMap existingMeasures;
    private HashMap measureStat;
    private List expandNodes;
    private WAPanel hidePanel;
    private CubeDesigner designer;

    public CubeMeasuresSelectPanel(OLAPCube cube) {
        this.olapCube = cube;
        this.layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (!saveToModel) {
            try {
                WAWizardDialog parent;
                String tabledChanged;
                if (!this.initialized) {
                    this.initialized = true;
                    this.measureSet = this.olapCube.getMeasureSet();
                    this.designer = (CubeDesigner)((Object)this.getTopLevelAncestor());
                    this.treeSelector.addMouseListener(new TreeMouseListener());
                    this.selectedNodes = new HashMap();
                    this.existingMeasures = new HashMap();
                    this.measureStat = new HashMap();
                    this.expandNodes = new ArrayList();
                    this.populateTable();
                }
                if ((tabledChanged = (String)(parent = (WAWizardDialog)this.getTopLevelAncestor()).getWizardData("TABLECHANGEDMEASURES")) != null) {
                    if (this.initialized) {
                        this.populateTable();
                    }
                    parent.removeWizardData("TABLECHANGEDMEASURES");
                }
                this.existingMeasures.clear();
                this.measureStat.clear();
                this.selectedNodes.clear();
                OLAPList measures = this.measureSet.getMeasures();
                int size = measures.size();
                for (int i = 0; i < size; ++i) {
                    List<Statistic> statList;
                    OLAPMeasure measure = (OLAPMeasure)measures.get(i);
                    boolean nunique = measure.isNunique();
                    if (nunique) {
                        OLAPLevel level = measure.getLevel();
                        OLAPHierarchy hier = measure.getHierarchy();
                        this.measureStat.put(hier.getName() + level.getName(), measure);
                        continue;
                    }
                    OLAPColumn column = measure.getInputColumn();
                    if (!this.existingMeasures.containsKey(column)) {
                        statList = new ArrayList();
                        this.existingMeasures.put(column, statList);
                    } else {
                        statList = (List)this.existingMeasures.get(column);
                    }
                    Statistic stat = measure.getStatistic();
                    statList.add(stat);
                    String name = column.getSASColumnName() + stat.getName();
                    this.measureStat.put(name, measure);
                }
                DisabledNode root = (DisabledNode)this.treeModel.getRoot();
                root.removeAllChildren();
                DisabledNode numericColumnsRootNode = new DisabledNode(bundle.getString("CubeDesigner.MeasuresSelect.NumericAvailableNode.header.title"), true);
                this.treeModel.insertNodeInto(numericColumnsRootNode, root, root.getChildCount());
                DisabledNode distinctCountRootNode = new DisabledNode(bundle.getString("CubeDesigner.MeasuresSelelct.LevelAvailableNode.header.title"), true);
                this.treeModel.insertNodeInto(distinctCountRootNode, root, root.getChildCount());
                TableSet tableSet = this.olapCube.getTableSet();
                LoadTable loadtable = tableSet.getLoadTable();
                OLAPList numerics = loadtable.getAvailableNumericColumns();
                for (int i = 0; i < numerics.size(); ++i) {
                    OLAPColumn columnObject = (OLAPColumn)numerics.get(i);
                    DisabledNode column = new DisabledNode(columnObject, false);
                    column.setAllowsChildren(true);
                    this.treeModel.insertNodeInto(column, numericColumnsRootNode, numericColumnsRootNode.getChildCount());
                    List listOfStats = (List)this.existingMeasures.get(columnObject);
                    Object[] allStatistics = Statistic.getStatistics().toArray();
                    if (listOfStats != null && listOfStats.size() == allStatistics.length) {
                        column.setEnabled(false);
                    }
                    int kSize = allStatistics.length;
                    for (int j = 0; j < kSize; ++j) {
                        Statistic statistic = (Statistic)allStatistics[j];
                        StatisticItem statisticItem = new StatisticItem(statistic);
                        DisabledNode statisticNode = new DisabledNode(statisticItem);
                        if (listOfStats != null && listOfStats.contains(statistic)) {
                            statisticNode.setEnabled(false);
                            String name = columnObject.getSASColumnName() + statistic.getName();
                            this.selectedNodes.put(this.measureStat.get(name), statisticNode);
                        }
                        this.treeModel.insertNodeInto(statisticNode, column, column.getChildCount());
                        statisticNode.setAllowsChildren(false);
                    }
                }
                this.populateDistinctCountNode(distinctCountRootNode);
                this.treeModel.reload();
                Object[] expandDistinctCountNode = this.treeModel.getPathToRoot(distinctCountRootNode);
                this.expandAll(this.treeSelector, new TreePath(expandDistinctCountNode));
                Object[] expandMeasureNode = this.treeModel.getPathToRoot(numericColumnsRootNode);
                this.treeSelector.expandPath(new TreePath(expandMeasureNode));
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
        return true;
    }

    public boolean validateData() {
        TableCellEditor cellEditor = this.detailsTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.stopCellEditing();
        }
        boolean tableError = this.tableModel.isInError();
        this.tableModel.resetError();
        if (tableError) {
            return !tableError;
        }
        boolean returned = true;
        try {
            OLAPList listOfMeasures = this.measureSet.getMeasures();
            if (listOfMeasures.isEmpty()) {
                throw new OLAPException(bundle.getString("CubeDesigner.MeasuresDetails.NoMeasures.txt"), 0);
            }
            boolean foundNonNunique = false;
            int size = listOfMeasures.size();
            for (int i = 0; i < size && !foundNonNunique; ++i) {
                OLAPMeasure meas = (OLAPMeasure)listOfMeasures.get(i);
                if (meas.isNunique().booleanValue()) continue;
                foundNonNunique = true;
            }
            if (!foundNonNunique) {
                MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.MeasuresSelect.Nunique.Error.nonNunique.txt"), (int)0);
                return false;
            }
            StringBuffer isRolapOutOfSynch = this.measureSet.isRolapOutOfSynch();
            if (isRolapOutOfSynch.length() > 0) {
                throw new OLAPException(isRolapOutOfSynch.toString(), 0);
            }
        }
        catch (OLAPException error) {
            returned = false;
            ExceptionHandler.handleException((Exception)((Object)error));
        }
        return returned;
    }

    void expandAll(JTree tree, TreePath parent) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                this.expandAll(tree, path);
            }
        }
        tree.expandPath(parent);
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        ButtonBorderRollOverHandler handler = new ButtonBorderRollOverHandler();
        this.hidePanel = new WAPanel();
        this.hidePanel.setLayout((LayoutManager)new GridBagLayout());
        JLabel defaultLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(defaultLabel, bundle.getString("CubeDesigner.MeasuresSelect.Default.control.label"));
        this.defaultMeasureBox = new WAComboBox(true);
        defaultLabel.setLabelFor((Component)this.defaultMeasureBox);
        this.defaultMeasureBox.addActionListener((ActionListener)new DefaultBoxActionListener());
        this.defaultMeasureBox.setPrototypeDisplayValue((Object)"012345678901234567890");
        this.treeSelector = new JTree();
        this.treeModel = new DefaultTreeModel(new DisabledNode());
        this.treeSelector.setModel(this.treeModel);
        this.treeSelector.setCellRenderer(new DisableEnableRenderer());
        this.treeSelector.setRootVisible(false);
        this.treeSelector.setShowsRootHandles(true);
        this.treeSelector.addTreeSelectionListener(new AvailableTreeSelectionListener());
        JScrollPane treeScroll = new JScrollPane(this.treeSelector);
        treeScroll.setPreferredSize(new Dimension(150, 200));
        this.rightArrow = new JButton(Resources.getImageIcon((String)"ArrowRightAdd.gif", (int)16));
        this.rightArrow.setToolTipText(bundle.getString("CubeDesigner.MeasuresSelect.Copy.tooltip.txt"));
        this.rightArrow.setPreferredSize(new Dimension(25, 25));
        this.rightArrow.setEnabled(false);
        this.rightArrow.addActionListener(new RightArrowListener());
        handler.addButton((AbstractButton)this.rightArrow);
        JLabel tableLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(tableLabel, bundle.getString("CubeDesigner.MeasuresSelect.Table.control.label"));
        this.tableModel = new CubeMeasuresSelectModel(this.olapCube, this);
        this.detailsTable = new WsTable((WsAbstractTableModel)this.tableModel);
        tableLabel.setLabelFor((Component)this.detailsTable);
        this.detailsTable.setSortingEnabled(true);
        this.detailsTable.setKeepSortedEnabled(true);
        this.detailsTable.setColumnHidingEnabled(false);
        this.detailsTable.setColumnsReorderable(false);
        this.detailsTable.setRowHoldingEnabled(false);
        this.detailsTable.setColumnHeaderPopupMenuEnabled(false);
        this.detailsTable.setOriginPopupMenuEnabled(false);
        this.detailsTable.setPopupMenuEnabled(false);
        this.detailsTable.setRowHeaderPopupMenuEnabled(false);
        this.detailsTable.setTablePopupMenuEnabled(false);
        this.detailsTable.setViewportPopupMenuEnabled(false);
        this.detailsTable.setPreferredScrollableViewportSize(new Dimension(200, 200));
        this.detailsTable.setMaximumSize(this.detailsTable.getPreferredScrollableViewportSize());
        this.detailsTable.getModel().addTableModelListener(this);
        this.detailsTable.getSelectionModel().addListSelectionListener(new RowSelectionListener());
        this.detailsTable.getRowHeader().setWidth(30);
        JScrollPane tableScroll = new JScrollPane((Component)this.detailsTable);
        this.expandArrow = new JButton(bundle.getImageIcon("Common.ExpandRightArrows.image"));
        this.expandArrow.setToolTipText(bundle.getString("CubeDesigner.MeasuresSelect.Collapse.tooltip.txt"));
        this.expandArrow.setEnabled(true);
        this.expandArrow.setPreferredSize(new Dimension(25, 25));
        this.expandArrow.addActionListener(new ExpandButtonListener());
        handler.addButton((AbstractButton)this.expandArrow);
        this.deleteButton = new JButton(Resources.getImageIcon((String)"Delete.gif", (int)16));
        this.deleteButton.setToolTipText(bundle.getString("CubeDesigner.MeasuresSelect.Remove.tooltip.txt"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.setPreferredSize(new Dimension(25, 25));
        this.deleteButton.addActionListener(new DeleteButtonListener());
        handler.addButton((AbstractButton)this.deleteButton);
        this.collapseArrow = new JButton(bundle.getImageIcon("Common.CollapseLeftArrows.image"));
        this.collapseArrow.setToolTipText(bundle.getString("CubeDesigner.MeasuresSelect.Expand.tooltip.txt"));
        this.collapseArrow.setEnabled(true);
        this.collapseArrow.setPreferredSize(new Dimension(25, 25));
        this.collapseArrow.addActionListener(new CollapseButtonListener());
        handler.addButton((AbstractButton)this.collapseArrow);
        JLabel treeLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(treeLabel, bundle.getString("CubeDesigner.DualListbox.leftlistbox.txt"));
        treeLabel.setLabelFor(this.treeSelector);
        this.hidePanel.add((Component)treeLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.hidePanel.add((Component)treeScroll, (Object)new GridBagConstraints(0, 1, 2, 2, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 6), 0, 0));
        this.hidePanel.add((Component)this.rightArrow, (Object)new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)this.hidePanel, new GridBagConstraints(0, 2, 2, 2, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.collapseArrow, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.expandArrow, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.expandArrow.setVisible(false);
        this.add(defaultLabel, new GridBagConstraints(2, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.add((Component)this.defaultMeasureBox, new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(tableLabel, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 2, 0), 0, 0));
        this.add(tableScroll, new GridBagConstraints(2, 3, 2, 2, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        int height = this.detailsTable.getRowHeight();
        this.add(this.deleteButton, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 18, 0, new Insets(height, 0, 0, 0), 0, 0));
    }

    private void populateDistinctCountNode(DefaultMutableTreeNode levels) throws OLAPException {
        List dimensions = this.olapCube.getDimensionSet().getAllCubeDimensions();
        ArrayList newList = new ArrayList();
        newList.addAll(dimensions);
        Collections.sort(newList);
        int foundLevels = 0;
        int foundHiers = 0;
        for (int j = 0; j < newList.size(); ++j) {
            OLAPDimension dimension = (OLAPDimension)newList.get(j);
            DisabledNode dimensionNode = new DisabledNode(dimension, true);
            this.treeModel.insertNodeInto(dimensionNode, levels, levels.getChildCount());
            OLAPList hierarchies = dimension.getHierarchies();
            int hierarchySize = hierarchies.size();
            foundHiers = 0;
            for (int m = 0; m < hierarchySize; ++m) {
                OLAPHierarchy hierarchy = (OLAPHierarchy)hierarchies.get(m);
                DisabledNode hierarchyNode = new DisabledNode(hierarchy, true);
                this.treeModel.insertNodeInto(hierarchyNode, dimensionNode, dimensionNode.getChildCount());
                foundLevels = 0;
                OLAPList hierLevels = hierarchy.getLevels();
                int size = hierLevels.size();
                for (int p = 0; p < size; ++p) {
                    OLAPLevel level = (OLAPLevel)hierLevels.get(p);
                    String name = hierarchy.getName() + level.getName();
                    DisabledNode levelNode = new DisabledNode(level, false);
                    if (this.measureStat.containsKey(name)) {
                        this.selectedNodes.put(this.measureStat.get(name), levelNode);
                        levelNode.setEnabled(false);
                        ++foundLevels;
                    }
                    this.treeModel.insertNodeInto(levelNode, hierarchyNode, hierarchyNode.getChildCount());
                }
                if (foundLevels == size) {
                    hierarchyNode.setEnabled(false);
                    ++foundHiers;
                }
                if (hierLevels.size() > 0) continue;
                DisabledNode notSpecified = new DisabledNode(bundle.getString("Common.NotSpecified.txt"));
                this.treeModel.insertNodeInto(notSpecified, hierarchyNode, hierarchyNode.getChildCount());
            }
            if (foundHiers != hierarchySize) continue;
            dimensionNode.setEnabled(false);
        }
    }

    private void populateTable() throws OLAPException {
        OLAPList measures = this.measureSet.getMeasures();
        this.defaultMeasureBox.removeAllItems();
        if (!measures.isEmpty()) {
            this.defaultMeasureBox.addItems((List)measures);
            Object def = measures.get(0);
            this.defaultMeasureBox.setSelectedItem(def);
        }
        this.detailsTable.clearSortMemory();
        this.tableModel.setLists(measures);
        this.tableModel.moveDataToModel();
        this.detailsTable.sort(1);
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.defaultMeasureBox.repaint();
    }

    private List getDerivedMeasuresToRemove(List measuresToDelete) throws OLAPException {
        ArrayList<OLAPMeasure> removeDerived = new ArrayList<OLAPMeasure>();
        ArrayList<String> groupNames = new ArrayList<String>();
        HashMap<String, OLAPList> statisticsByGroupName = new HashMap<String, OLAPList>();
        int iSize = measuresToDelete.size();
        for (int i = 0; i < iSize; ++i) {
            OLAPMeasure measure1 = (OLAPMeasure)measuresToDelete.get(i);
            Statistic statistic = measure1.getStatistic();
            String groupName = measure1.getGroupName();
            if (ModelUtilities.isBlank((String)groupName)) continue;
            OLAPList statistics = (OLAPList)statisticsByGroupName.get(groupName);
            if (statistics == null) {
                statistics = new OLAPList(Statistic.class);
                statisticsByGroupName.put(groupName, statistics);
                OLAPList measuresByGroupName = this.measureSet.getStoredMeasuresByGroupName(groupName);
                for (int j = measuresByGroupName.size() - 1; j >= 0; --j) {
                    OLAPMeasure tempMeasure = (OLAPMeasure)measuresByGroupName.get(j);
                    statistics.add((Object)tempMeasure.getStatistic());
                }
            }
            statistics.remove((Object)statistic);
            if (groupNames.contains(groupName)) continue;
            groupNames.add(groupName);
        }
        for (String groupName : statisticsByGroupName.keySet()) {
            OLAPList statistics = (OLAPList)statisticsByGroupName.get(groupName);
            OLAPList possibleDerivedStatistics = Statistic.getPossibleDerivedStatistics((OLAPList)statistics);
            OLAPList derivedMeasures = this.measureSet.getDerivedMeasuresByGroupName(groupName);
            int jSize = derivedMeasures.size();
            for (int j = 0; j < jSize; ++j) {
                OLAPMeasure derivedMeasure = (OLAPMeasure)derivedMeasures.get(j);
                if (!(!possibleDerivedStatistics.contains((Object)derivedMeasure.getStatistic()) & !measuresToDelete.contains(derivedMeasure))) continue;
                removeDerived.add(derivedMeasure);
            }
        }
        return removeDerived;
    }

    private class StatisticItem
    implements Comparable {
        protected Statistic statistic;

        public StatisticItem(Statistic inputStatistic) {
            this.statistic = inputStatistic;
        }

        public String toString() {
            String label = this.statistic.getLabel();
            if (label.equals("")) {
                label = this.statistic.getName();
            }
            return label;
        }

        public Statistic getStatistic() {
            return this.statistic;
        }

        public int compareTo(Object obj) {
            int compnum = this.toString().compareToIgnoreCase(obj.toString());
            return compnum;
        }
    }

    class DisabledNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        protected boolean enabled;

        public DisabledNode() {
            this(null, true, true);
        }

        public DisabledNode(Object userObject) {
            this(userObject, true, true);
        }

        public DisabledNode(Object userObject, boolean allowsChildren) {
            this(userObject, allowsChildren, true);
        }

        public DisabledNode(Object userObject, boolean allowsChildren, boolean enabled) {
            super(userObject, allowsChildren);
            this.enabled = enabled;
        }

        @Override
        public int getChildCount() {
            return super.getChildCount();
        }

        @Override
        public boolean isLeaf() {
            return super.getChildCount() == 0;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    private class DisableEnableRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        protected Icon enabledColumnIcon = CubeMeasuresSelectPanel.access$1600().getImageIcon("Common.NumericType.image");
        protected Icon enabledDimIcon = Resources.getImageIcon((String)"OLAPDimension.gif", (int)16);
        protected Icon enabledHierIcon = Resources.getImageIcon((String)"OLAPHierarchy.gif", (int)16);
        protected Icon enabledLevelIcon = Resources.getImageIcon((String)"OLAPLevel.gif", (int)16);

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DisabledNode node = (DisabledNode)value;
            int level = node.getLevel();
            Object userObject = node.getUserObject();
            if (userObject instanceof String && level == 1) {
                this.setFont(this.getFont().deriveFont(1));
            } else {
                this.setFont(this.getFont().deriveFont(0));
            }
            if (userObject instanceof OLAPColumn) {
                boolean isEnabled = node.isEnabled();
                this.setIcon(this.enabledColumnIcon);
                if (isEnabled) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else if (userObject instanceof StatisticItem) {
                this.setIcon(null);
                this.setEnabled(node.isEnabled());
            } else if (userObject instanceof OLAPDimension) {
                boolean isEnabled = node.isEnabled();
                this.setIcon(this.enabledDimIcon);
                if (isEnabled) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else if (userObject instanceof OLAPHierarchy) {
                boolean isEnabled = node.isEnabled();
                this.setIcon(this.enabledHierIcon);
                if (isEnabled) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            } else if (userObject instanceof OLAPLevel) {
                boolean isEnabled = node.isEnabled();
                this.setIcon(this.enabledLevelIcon);
                if (isEnabled) {
                    this.setEnabled(true);
                } else {
                    this.setEnabled(false);
                }
            }
            return this;
        }
    }

    private class TreeMouseListener
    extends MouseAdapter {
        private TreeMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int selRow = CubeMeasuresSelectPanel.this.treeSelector.getRowForLocation(e.getX(), e.getY());
            TreePath selPath = CubeMeasuresSelectPanel.this.treeSelector.getPathForLocation(e.getX(), e.getY());
            if (selRow != -1 && e.getClickCount() == 2) {
                CubeMeasuresSelectPanel.this.rightArrow.doClick();
            }
        }
    }

    private class RowSelectionListener
    implements ListSelectionListener {
        private RowSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                ListSelectionModel selectionModel = (ListSelectionModel)e.getSource();
                CubeMeasuresSelectPanel.this.deleteButton.setEnabled(!selectionModel.isSelectionEmpty());
            }
        }
    }

    private class RightArrowListener
    implements ActionListener {
        private RightArrowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                ArrayList<OLAPMeasure> newMeasures = new ArrayList<OLAPMeasure>();
                HashMap<OLAPHierarchy, HashMap> nodeMap = new HashMap<OLAPHierarchy, HashMap>();
                CubeMeasuresSelectPanel.this.expandNodes.clear();
                TreePath[] paths = CubeMeasuresSelectPanel.this.treeSelector.getSelectionPaths();
                if (paths != null) {
                    List levels;
                    DisabledNode nextNode;
                    HashMap levelsMap = new HashMap();
                    for (int pathNum = 0; pathNum < paths.length; ++pathNum) {
                        List levels2;
                        HashMap hierNodeMap;
                        TreePath path = paths[pathNum];
                        DisabledNode selectedNode = (DisabledNode)path.getLastPathComponent();
                        if (selectedNode == null) continue;
                        Object currentObject = selectedNode.getUserObject();
                        CubeMeasuresSelectPanel.this.expandNodes.add(selectedNode);
                        if (currentObject instanceof StatisticItem) {
                            StatisticItem statItem = (StatisticItem)currentObject;
                            Statistic stat = statItem.getStatistic();
                            DisabledNode columnNode = (DisabledNode)selectedNode.getParent();
                            OLAPColumn column = (OLAPColumn)columnNode.getUserObject();
                            OLAPMeasure measure = CubeMeasuresSelectPanel.this.measureSet.createOLAPMeasure(column);
                            try {
                                measure.setStatistic(stat);
                            }
                            catch (OLAPException exc) {
                                measure.delete();
                                ExceptionHandler.handleException((Exception)((Object)exc));
                                continue;
                            }
                            selectedNode.setEnabled(false);
                            newMeasures.add(measure);
                            CubeMeasuresSelectPanel.this.selectedNodes.put(measure, selectedNode);
                            int numberOfNodes = columnNode.getChildCount();
                            int howManyNodesAreUsed = 0;
                            for (int t = 0; t < numberOfNodes; ++t) {
                                nextNode = (DisabledNode)columnNode.getChildAt(t);
                                if (nextNode.isEnabled()) continue;
                                ++howManyNodesAreUsed;
                            }
                            if (howManyNodesAreUsed != numberOfNodes) continue;
                            columnNode.setEnabled(false);
                            continue;
                        }
                        if (currentObject instanceof OLAPColumn) {
                            OLAPColumn column = (OLAPColumn)currentObject;
                            int numberOfStats = selectedNode.getChildCount();
                            selectedNode.setEnabled(false);
                            for (int i = numberOfStats - 1; i > -1; --i) {
                                DisabledNode nextStat = (DisabledNode)selectedNode.getChildAt(i);
                                if (CubeMeasuresSelectPanel.this.selectedNodes.containsValue(nextStat)) continue;
                                StatisticItem statObject = (StatisticItem)nextStat.getUserObject();
                                Statistic stat = statObject.getStatistic();
                                OLAPMeasure measure = CubeMeasuresSelectPanel.this.measureSet.createOLAPMeasure(column);
                                try {
                                    measure.setStatistic(stat);
                                }
                                catch (OLAPException exc) {
                                    measure.delete();
                                    ExceptionHandler.handleException((Exception)((Object)exc));
                                    continue;
                                }
                                nextStat.setEnabled(false);
                                newMeasures.add(measure);
                                CubeMeasuresSelectPanel.this.selectedNodes.put(measure, nextStat);
                            }
                            continue;
                        }
                        if (currentObject instanceof OLAPDimension) {
                            int numHiers = selectedNode.getChildCount();
                            for (int hierNum = 0; hierNum < numHiers; ++hierNum) {
                                DisabledNode hierNode = (DisabledNode)selectedNode.getChildAt(hierNum);
                                OLAPHierarchy hier = (OLAPHierarchy)hierNode.getUserObject();
                                if (!nodeMap.containsKey(hier)) {
                                    hierNodeMap = new HashMap();
                                    nodeMap.put(hier, hierNodeMap);
                                } else {
                                    hierNodeMap = (HashMap)nodeMap.get(hier);
                                }
                                if (!levelsMap.containsKey(hier)) {
                                    levelsMap.put(hier, new ArrayList());
                                }
                                List levels3 = (List)levelsMap.get(hier);
                                int numLevels = hierNode.getChildCount();
                                for (int levelNum = 0; levelNum < numLevels; ++levelNum) {
                                    DisabledNode levelNode = (DisabledNode)hierNode.getChildAt(levelNum);
                                    OLAPLevel level = (OLAPLevel)levelNode.getUserObject();
                                    hierNodeMap.put(level, levelNode);
                                    if (levels3.contains(level)) continue;
                                    levels3.add(level);
                                }
                            }
                            continue;
                        }
                        if (currentObject instanceof OLAPHierarchy) {
                            OLAPHierarchy hier = (OLAPHierarchy)currentObject;
                            if (!nodeMap.containsKey(hier)) {
                                hierNodeMap = new HashMap();
                                nodeMap.put(hier, hierNodeMap);
                            } else {
                                hierNodeMap = (HashMap)nodeMap.get(hier);
                            }
                            if (!levelsMap.containsKey(hier)) {
                                levelsMap.put(hier, new ArrayList());
                            }
                            List levels4 = (List)levelsMap.get(hier);
                            int numLevels = selectedNode.getChildCount();
                            for (int levelNum = 0; levelNum < numLevels; ++levelNum) {
                                DisabledNode levelNode = (DisabledNode)selectedNode.getChildAt(levelNum);
                                OLAPLevel level = (OLAPLevel)levelNode.getUserObject();
                                hierNodeMap.put(level, levelNode);
                                if (levels4.contains(level)) continue;
                                levels4.add(level);
                            }
                            continue;
                        }
                        if (!(currentObject instanceof OLAPLevel)) continue;
                        OLAPLevel level = (OLAPLevel)currentObject;
                        DisabledNode hierNode = (DisabledNode)selectedNode.getParent();
                        OLAPHierarchy hier = (OLAPHierarchy)hierNode.getUserObject();
                        if (!nodeMap.containsKey(hier)) {
                            hierNodeMap = new HashMap();
                            nodeMap.put(hier, hierNodeMap);
                        } else {
                            hierNodeMap = (HashMap)nodeMap.get(hier);
                        }
                        hierNodeMap.put(level, selectedNode);
                        if (!levelsMap.containsKey(hier)) {
                            levelsMap.put(hier, new ArrayList());
                        }
                        if ((levels2 = (List)levelsMap.get(hier)).contains(level)) continue;
                        levels2.add(level);
                    }
                    for (OLAPHierarchy hier : levelsMap.keySet()) {
                        levels = (List)levelsMap.get(hier);
                        for (int levelNum = 0; levelNum < levels.size(); ++levelNum) {
                            OLAPLevel level = (OLAPLevel)levels.get(levelNum);
                            HashMap hierMap = (HashMap)nodeMap.get(hier);
                            DisabledNode levelNode = (DisabledNode)hierMap.get(level);
                            if (CubeMeasuresSelectPanel.this.selectedNodes.containsValue(levelNode)) continue;
                            OLAPMeasure measure = CubeMeasuresSelectPanel.this.measureSet.createOLAPMeasure(level, hier);
                            String measureName = level.getName() + "_NUNIQUE_" + hier.getName();
                            if (measureName.length() > 32) {
                                measureName = measureName.substring(0, 32);
                            }
                            measure.setName(measureName);
                            String caption = measure.getStatistic().getDefaultMeasureCaption(level.getName(), hier.getName());
                            measure.setDesc(caption);
                            newMeasures.add(measure);
                            CubeMeasuresSelectPanel.this.selectedNodes.put(measure, levelNode);
                            levelNode.setEnabled(false);
                        }
                    }
                    for (OLAPHierarchy hier : levelsMap.keySet()) {
                        levels = (List)levelsMap.get(hier);
                        if (levels.isEmpty()) continue;
                        OLAPLevel level = (OLAPLevel)levels.get(0);
                        HashMap hierMap = (HashMap)nodeMap.get(hier);
                        DisabledNode levelNode = (DisabledNode)hierMap.get(level);
                        DisabledNode hierarchyNode = (DisabledNode)levelNode.getParent();
                        if (!hierarchyNode.isEnabled()) continue;
                        int countOfChildren = hierarchyNode.getChildCount();
                        boolean found = false;
                        for (int i = 0; i < countOfChildren && !found; ++i) {
                            DisabledNode nextLevel = (DisabledNode)hierarchyNode.getChildAt(i);
                            if (!nextLevel.isEnabled()) continue;
                            found = true;
                        }
                        if (found) continue;
                        hierarchyNode.setEnabled(false);
                        DisabledNode dimensionNode = (DisabledNode)hierarchyNode.getParent();
                        if (!dimensionNode.isEnabled()) continue;
                        boolean foundHier = false;
                        int howManyHierarchies = dimensionNode.getChildCount();
                        for (int i = 0; i < howManyHierarchies && !foundHier; ++i) {
                            nextNode = (DisabledNode)dimensionNode.getChildAt(i);
                            if (!nextNode.isEnabled()) continue;
                            foundHier = true;
                        }
                        if (foundHier) continue;
                        dimensionNode.setEnabled(false);
                    }
                    if (newMeasures.size() > 0) {
                        int count = CubeMeasuresSelectPanel.this.defaultMeasureBox.getItemCount();
                        Object item = CubeMeasuresSelectPanel.this.defaultMeasureBox.getSelectedItem();
                        if (count == 1 && item instanceof String) {
                            CubeMeasuresSelectPanel.this.defaultMeasureBox.removeAllItems();
                        }
                        CubeMeasuresSelectPanel.this.defaultMeasureBox.addItems(newMeasures);
                        if (CubeMeasuresSelectPanel.this.defaultMeasureBox.getSelectedIndex() < 0) {
                            CubeMeasuresSelectPanel.this.defaultMeasureBox.setSelectedIndex(0);
                        }
                        int start = CubeMeasuresSelectPanel.this.tableModel.getRowCount();
                        CubeMeasuresSelectPanel.this.tableModel.addMeasures(newMeasures);
                        if (CubeMeasuresSelectPanel.this.measureSet.getMeasures().size() < 1) {
                            CubeMeasuresSelectPanel.this.designer.setFinishExportEnabled(false);
                        } else if (CubeMeasuresSelectPanel.this.olapCube.getType().equals("HOLAP")) {
                            if (CubeMeasuresSelectPanel.this.olapCube.isNewObject()) {
                                CubeMeasuresSelectPanel.this.designer.setFinishExportEnabled(false);
                            } else {
                                boolean isMapOk = ((CubeDesigner.MapMeasuresAction)((CubeMeasuresSelectPanel)CubeMeasuresSelectPanel.this).designer.mapMeasuresAction).cubeIsOk();
                                boolean isStoredOk = ((CubeDesigner.StoredAggrAction)((CubeMeasuresSelectPanel)CubeMeasuresSelectPanel.this).designer.storedAggrAction).cubeIsOk();
                                if (isMapOk && isStoredOk) {
                                    CubeMeasuresSelectPanel.this.designer.setFinishExportEnabled(true);
                                } else {
                                    CubeMeasuresSelectPanel.this.designer.setFinishExportEnabled(false);
                                }
                            }
                        } else {
                            CubeMeasuresSelectPanel.this.designer.setFinishExportEnabled(true);
                        }
                        CubeMeasuresSelectPanel.this.detailsTable.clearSelection();
                        CubeMeasuresSelectPanel.this.detailsTable.selectRows(start, start + newMeasures.size() - 1);
                        CubeMeasuresSelectPanel.this.detailsTable.requestFocusInWindow();
                    }
                    int size = CubeMeasuresSelectPanel.this.expandNodes.size();
                    for (int i = 0; i < size; ++i) {
                        DisabledNode node = (DisabledNode)CubeMeasuresSelectPanel.this.expandNodes.get(i);
                        CubeMeasuresSelectPanel.this.treeModel.reload(node);
                        CubeMeasuresSelectPanel.this.treeSelector.expandPath(new TreePath(node.getPath()));
                    }
                }
                CubeMeasuresSelectPanel.this.treeSelector.getSelectionModel().clearSelection();
            }
            catch (OLAPException exc) {
                ExceptionHandler.handleException((Exception)((Object)exc));
            }
        }
    }

    private class ExpandButtonListener
    implements ActionListener {
        private ExpandButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CubeMeasuresSelectPanel.this.expandArrow.setVisible(false);
            CubeMeasuresSelectPanel.this.collapseArrow.setVisible(true);
            CubeMeasuresSelectPanel.this.hidePanel.setVisible(true);
        }
    }

    private class CollapseButtonListener
    implements ActionListener {
        private CollapseButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            CubeMeasuresSelectPanel.this.hidePanel.setVisible(false);
            CubeMeasuresSelectPanel.this.collapseArrow.setVisible(false);
            CubeMeasuresSelectPanel.this.expandArrow.setVisible(true);
        }
    }

    private class DeleteButtonListener
    implements ActionListener {
        private DeleteButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                int[] deletedRows = CubeMeasuresSelectPanel.this.detailsTable.getSelectedRowsFromSelectedCells();
                CubeMeasuresSelectPanel.this.expandNodes.clear();
                int choice = 0;
                TableCellEditor cellEditor = CubeMeasuresSelectPanel.this.detailsTable.getCellEditor();
                if (cellEditor != null) {
                    cellEditor.cancelCellEditing();
                }
                OLAPMeasure measure = null;
                ArrayList<OLAPMeasure> measuresList = new ArrayList<OLAPMeasure>();
                for (int i = deletedRows.length - 1; i >= 0; --i) {
                    int rowNum = CubeMeasuresSelectPanel.this.detailsTable.convertRowIndexToModel(deletedRows[i]);
                    measure = CubeMeasuresSelectPanel.this.tableModel.getMeasureForRow(rowNum);
                    measuresList.add(measure);
                }
                AggregationSet aggregationSet = CubeMeasuresSelectPanel.this.measureSet.getOwningCube().getAggregationSet();
                Boolean hasStoredAggregations = aggregationSet.hasStoredAggregations();
                List removedDerived = new ArrayList();
                if (hasStoredAggregations != null && hasStoredAggregations.booleanValue()) {
                    removedDerived = CubeMeasuresSelectPanel.this.getDerivedMeasuresToRemove(measuresList);
                }
                if (measuresList.size() == 1 && removedDerived.isEmpty()) {
                    measure = (OLAPMeasure)measuresList.get(0);
                    choice = MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.Delete.Message.fmt.txt", (Object)measure.getName()), (String)bundle.getString("CubeDesigner.DeleteMeasure.window.title"), (int)1, (int)0);
                } else if (measuresList.size() > 1 && removedDerived.isEmpty()) {
                    choice = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.DeleteMeasures.txt"), (String)bundle.getString("CubeDesigner.DeleteMeasures.window.title"), (int)1, (int)0);
                } else if (!removedDerived.isEmpty()) {
                    choice = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.DeleteDerivedMeasures.txt"), (String)bundle.getString("CubeDesigner.DeleteDerivedMeasures.window.title"), (int)1, (int)0);
                }
                if (choice == 0) {
                    int i;
                    int size = removedDerived.size();
                    for (i = 0; i < size; ++i) {
                        OLAPMeasure derivedMeasure = (OLAPMeasure)removedDerived.get(i);
                        OLAPMeasure defaultMeasure = (OLAPMeasure)CubeMeasuresSelectPanel.this.defaultMeasureBox.getSelectedItem();
                        CubeMeasuresSelectPanel.this.defaultMeasureBox.removeItem((Object)derivedMeasure);
                        if (derivedMeasure.equals(defaultMeasure) && CubeMeasuresSelectPanel.this.defaultMeasureBox.hasItems()) {
                            CubeMeasuresSelectPanel.this.defaultMeasureBox.setSelectedIndex(0);
                        }
                        DisabledNode nodeEnabled = (DisabledNode)CubeMeasuresSelectPanel.this.selectedNodes.get(derivedMeasure);
                        CubeMeasuresSelectPanel.this.expandNodes.add(nodeEnabled);
                        nodeEnabled.setEnabled(true);
                        DisabledNode parentNode = (DisabledNode)nodeEnabled.getParent();
                        if (parentNode != null && !parentNode.isEnabled()) {
                            boolean found = false;
                            int children = parentNode.getChildCount();
                            for (int t = 0; t < children && !found; ++t) {
                                DisabledNode nextNode = (DisabledNode)parentNode.getChildAt(t);
                                if (!nextNode.isEnabled()) continue;
                                parentNode.setEnabled(true);
                                found = true;
                            }
                        }
                        CubeMeasuresSelectPanel.this.selectedNodes.remove(derivedMeasure);
                        CubeMeasuresSelectModel cubeMeasuresSelectModel = CubeMeasuresSelectPanel.this.tableModel;
                        CubeMeasuresSelectPanel.this.tableModel;
                        int[] rowNumber = cubeMeasuresSelectModel.findRows(8, derivedMeasure);
                        if (rowNumber.length <= 0) continue;
                        CubeMeasuresSelectPanel.this.tableModel.deleteRow(rowNumber[0]);
                    }
                    size = measuresList.size();
                    for (i = 0; i < size; ++i) {
                        measure = (OLAPMeasure)measuresList.get(i);
                        OLAPMeasure defaultMeasure = (OLAPMeasure)CubeMeasuresSelectPanel.this.defaultMeasureBox.getSelectedItem();
                        DisabledNode nodeEnabled = (DisabledNode)CubeMeasuresSelectPanel.this.selectedNodes.get(measure);
                        CubeMeasuresSelectPanel.this.expandNodes.add(nodeEnabled);
                        nodeEnabled.setEnabled(true);
                        DisabledNode parentNode = (DisabledNode)nodeEnabled.getParent();
                        if (parentNode != null && !parentNode.isEnabled()) {
                            boolean found = false;
                            int children = parentNode.getChildCount();
                            for (int t = 0; t < children && !found; ++t) {
                                DisabledNode nextNode = (DisabledNode)parentNode.getChildAt(t);
                                if (!nextNode.isEnabled()) continue;
                                parentNode.setEnabled(true);
                                found = true;
                            }
                            DisabledNode previousParent = (DisabledNode)parentNode.getParent();
                            if (found && previousParent != null) {
                                found = false;
                                int parentChildren = previousParent.getChildCount();
                                for (int t = 0; t < parentChildren && !found; ++t) {
                                    DisabledNode nextNode = (DisabledNode)previousParent.getChildAt(t);
                                    if (!nextNode.isEnabled()) continue;
                                    previousParent.setEnabled(true);
                                    found = true;
                                }
                            }
                        }
                        CubeMeasuresSelectPanel.this.selectedNodes.remove(measure);
                        CubeMeasuresSelectPanel.this.defaultMeasureBox.removeItem((Object)measure);
                        if (measure.equals(defaultMeasure) && CubeMeasuresSelectPanel.this.defaultMeasureBox.hasItems()) {
                            CubeMeasuresSelectPanel.this.defaultMeasureBox.setSelectedIndex(0);
                        }
                        measure.delete();
                        CubeMeasuresSelectModel cubeMeasuresSelectModel = CubeMeasuresSelectPanel.this.tableModel;
                        CubeMeasuresSelectPanel.this.tableModel;
                        int[] rowNumber = cubeMeasuresSelectModel.findRows(8, measure);
                        if (rowNumber.length > 0) {
                            CubeMeasuresSelectPanel.this.tableModel.deleteRow(rowNumber[0]);
                        }
                        if (CubeMeasuresSelectPanel.this.measureSet.getMeasures().size() < 1) {
                            CubeMeasuresSelectPanel.this.designer.setFinishExportEnabled(false);
                            continue;
                        }
                        CubeMeasuresSelectPanel.this.designer.setFinishExportEnabled(true);
                    }
                    size = CubeMeasuresSelectPanel.this.expandNodes.size();
                    for (i = 0; i < size; ++i) {
                        DisabledNode node = (DisabledNode)CubeMeasuresSelectPanel.this.expandNodes.get(i);
                        CubeMeasuresSelectPanel.this.treeModel.reload(node);
                        CubeMeasuresSelectPanel.this.treeSelector.expandPath(new TreePath(node.getPath()));
                    }
                }
            }
            catch (OLAPException exc) {
                ExceptionHandler.handleException((Exception)((Object)exc));
            }
        }
    }

    private class AvailableTreeSelectionListener
    implements TreeSelectionListener {
        private AvailableTreeSelectionListener() {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            TreePath[] paths = CubeMeasuresSelectPanel.this.treeSelector.getSelectionPaths();
            boolean foundObject = false;
            if (paths != null) {
                for (int i = 0; i < paths.length && !foundObject; ++i) {
                    DisabledNode node = (DisabledNode)paths[i].getLastPathComponent();
                    if (node == null) continue;
                    Object currentObject = node.getUserObject();
                    foundObject = !(currentObject instanceof String) && node.isEnabled();
                }
            }
            CubeMeasuresSelectPanel.this.rightArrow.setEnabled(foundObject);
        }
    }

    private class DefaultBoxActionListener
    implements ActionListener {
        private DefaultBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            block6: {
                if (CubeMeasuresSelectPanel.this.defaultMeasureBox.hasItems()) {
                    TableCellEditor cellEditor = CubeMeasuresSelectPanel.this.detailsTable.getCellEditor();
                    if (cellEditor != null) {
                        cellEditor.stopCellEditing();
                    }
                    CubeMeasuresSelectPanel.this.defaultMeasureBox.setEnabled(true);
                    try {
                        Object selectedObj = CubeMeasuresSelectPanel.this.defaultMeasureBox.getSelectedItem();
                        if (!(selectedObj instanceof OLAPMeasure)) break block6;
                        OLAPMeasure newDefault = (OLAPMeasure)CubeMeasuresSelectPanel.this.defaultMeasureBox.getSelectedItem();
                        OLAPMeasure defaultMeasure = CubeMeasuresSelectPanel.this.measureSet.getDefaultMeasure();
                        if (newDefault != null && !newDefault.equals(defaultMeasure)) {
                            CubeMeasuresSelectPanel.this.measureSet.setDefaultMeasure(newDefault);
                        }
                    }
                    catch (OLAPException error) {
                        ExceptionHandler.handleException((Exception)((Object)error));
                    }
                } else {
                    CubeMeasuresSelectPanel.this.defaultMeasureBox.setEnabled(false);
                }
            }
        }
    }
}

