/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.Statistic;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.OLAPDualListSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public class CubeMeasuresHolapSelectPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeMeasuresHolapSelectPanel.class);
    private OLAPDualListSelector listbox;
    private DefaultListModel available;
    private DefaultListModel selected;
    private OLAPCube olapCube;
    private MeasureSet measureSet;
    private TableSet tableSet;
    private boolean initialized;
    private OLAPList measures;
    private LoadTable loadTable;
    private PhysicalTable oldLoadTable;

    public CubeMeasuresHolapSelectPanel(OLAPCube inputOLAPCube) {
        this.olapCube = inputOLAPCube;
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
    }

    public boolean validateData() {
        boolean returned = true;
        if (this.selected.isEmpty()) {
            MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.MeasuresDetails.NoMeasures.txt"), (int)2);
            returned = false;
        } else {
            returned = this.deleteMeasures();
            if (returned) {
                returned = this.createMeasures();
            }
        }
        try {
            StringBuffer isRolapOutOfSynch = this.measureSet.isRolapOutOfSynch();
            if (isRolapOutOfSynch.length() > 0) {
                throw new OLAPException(isRolapOutOfSynch.toString(), 0);
            }
        }
        catch (OLAPException error) {
            returned = ExceptionHandler.handleException((Exception)((Object)error));
        }
        return returned;
    }

    private boolean createMeasures() {
        boolean returned = true;
        try {
            if (this.measureSet == null) {
                this.measureSet = this.olapCube.getMeasureSet();
            }
            for (int i = this.selected.size() - 1; i >= 0; --i) {
                OLAPColumn selectedColumn = (OLAPColumn)this.selected.get(i);
                OLAPList columnMeasures = this.measureSet.getMeasuresByColumn(selectedColumn);
                if (!columnMeasures.isEmpty()) continue;
                this.measureSet.createOLAPMeasure(selectedColumn);
            }
        }
        catch (OLAPException error) {
            returned = ExceptionHandler.handleException((Exception)((Object)error));
        }
        return returned;
    }

    private List getMeasuresToDelete() {
        ArrayList<Object> measuresToDelete = new ArrayList<Object>();
        for (int i = this.available.size() - 1; i >= 0; --i) {
            OLAPColumn selectedColumn = (OLAPColumn)this.available.get(i);
            OLAPList columnMeasures = this.measureSet.getMeasuresByColumn(selectedColumn);
            if (columnMeasures.isEmpty()) continue;
            measuresToDelete.add(columnMeasures.get(0));
        }
        return measuresToDelete;
    }

    private boolean isDeleteDerivedRequired(List measuresToDelete) throws OLAPException {
        boolean deleteDerivedRequired = false;
        ArrayList<String> groupNames = new ArrayList<String>();
        HashMap<String, OLAPList> statisticsByGroupName = new HashMap<String, OLAPList>();
        int iSize = measuresToDelete.size();
        for (int i = 0; i < iSize; ++i) {
            OLAPMeasure measure = (OLAPMeasure)measuresToDelete.get(i);
            if (ModelUtilities.isBlank((String)measure.getName())) continue;
            Statistic statistic = measure.getStatistic();
            String groupName = measure.getGroupName();
            OLAPList statistics = (OLAPList)statisticsByGroupName.get(groupName);
            if (statistics == null) {
                statistics = new OLAPList(Statistic.class);
                statisticsByGroupName.put(groupName, statistics);
                OLAPList measuresByGroupName = this.measureSet.getStoredMeasuresByGroupName(groupName);
                for (int j = measuresByGroupName.size() - 1; j >= 0; --j) {
                    OLAPMeasure tempMeasure = (OLAPMeasure)measuresByGroupName.get(j);
                    statistics.add((Object)tempMeasure.getStatistic());
                }
            }
            statistics.remove((Object)statistic);
            if (groupNames.contains(groupName) || ModelUtilities.isBlank((String)groupName)) continue;
            groupNames.add(groupName);
        }
        Iterator i = statisticsByGroupName.keySet().iterator();
        while (i.hasNext() && !deleteDerivedRequired) {
            String groupName = (String)i.next();
            OLAPList statistics = (OLAPList)statisticsByGroupName.get(groupName);
            OLAPList possibleDerivedStatistics = Statistic.getPossibleDerivedStatistics((OLAPList)statistics);
            OLAPList derivedMeasures = this.measureSet.getDerivedMeasuresByGroupName(groupName);
            int jSize = derivedMeasures.size();
            for (int j = 0; j < jSize && !deleteDerivedRequired; ++j) {
                OLAPMeasure derivedMeasure = (OLAPMeasure)derivedMeasures.get(j);
                if (!(!possibleDerivedStatistics.contains((Object)derivedMeasure.getStatistic()) & !measuresToDelete.contains(derivedMeasure))) continue;
                deleteDerivedRequired = true;
            }
        }
        return deleteDerivedRequired;
    }

    private boolean deleteMeasures() {
        boolean returned = true;
        try {
            List measuresToDelete = this.getMeasuresToDelete();
            if (!measuresToDelete.isEmpty()) {
                if (this.isDeleteDerivedRequired(measuresToDelete)) {
                    Object[] choices = new String[]{bundle.getString("CubeDesigner.Delete.Choice1.txt"), bundle.getString("CubeDesigner.Delete.Choice2.txt")};
                    int choice = JOptionPane.showOptionDialog((Component)Workspace.getWorkspace(), bundle.getString("CubeDesigner.DeleteDerivedMeasures.txt"), bundle.getString("CubeDesigner.DeleteDerivedMeasures.window.title"), 0, 1, null, choices, bundle.getString("CubeDesigner.Delete.Choice2.txt"));
                    if (choice == 0) {
                        for (int i = measuresToDelete.size() - 1; i >= 0; --i) {
                            OLAPMeasure measure = (OLAPMeasure)measuresToDelete.get(i);
                            measure.delete();
                        }
                    } else {
                        returned = false;
                    }
                } else {
                    for (int i = measuresToDelete.size() - 1; i >= 0; --i) {
                        OLAPMeasure measure = (OLAPMeasure)measuresToDelete.get(i);
                        measure.delete();
                    }
                }
            }
        }
        catch (OLAPException error) {
            returned = ExceptionHandler.handleException((Exception)((Object)error));
        }
        return returned;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            this.initialize();
        }
        return true;
    }

    public void onBack() {
        this.deleteMeasures();
        this.createMeasures();
    }

    protected void initialize() {
        if (!this.initialized) {
            this.available = new DefaultListModel();
            this.selected = new DefaultListModel();
            this.listbox.setDragAndDropEnabled(false);
            this.listbox.setSourceLabel(bundle.getString("Common.Available.txt"));
            this.listbox.setTargetLabel(bundle.getString("Common.Selected.txt"));
            JLabel label = (JLabel)this.listbox.getSourceLabelComponent();
            VisualUtilities.setLabelTextAndMnemonic(label, bundle.getString("CubeDesigner.DualListbox.leftlistbox.txt"));
            label = (JLabel)this.listbox.getTargetLabelComponent();
            VisualUtilities.setLabelTextAndMnemonic(label, bundle.getString("CubeDesigner.DualListbox.rightlistbox.txt"));
            this.listbox.setTargetControlsVisible(false);
            this.listbox.setTransferAllControlsVisible(true);
            this.tableSet = this.olapCube.getTableSet();
            this.initialized = true;
        }
        try {
            if (this.loadTable == null || !this.loadTable.equals(this.oldLoadTable)) {
                int i;
                if (this.loadTable == null) {
                    this.loadTable = this.tableSet.getLoadTable();
                }
                this.oldLoadTable = this.tableSet.getLoadTable().getTable();
                this.available.clear();
                OLAPList availableColumns = this.loadTable.getAvailableNumericColumns();
                for (i = availableColumns.size() - 1; i >= 0; --i) {
                    this.available.add(0, availableColumns.get(i));
                }
                this.selected.clear();
                if (this.measureSet == null) {
                    this.measureSet = this.olapCube.getMeasureSet();
                }
                if (this.measures == null) {
                    this.measures = this.measureSet.getStoredMeasures();
                }
                this.measures.sort();
                for (i = this.measures.size() - 1; i >= 0; --i) {
                    OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
                    OLAPColumn olapColumn = measure.getInputColumn();
                    this.selected.add(0, olapColumn);
                    this.available.removeElement(olapColumn);
                }
            }
        }
        catch (OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
        this.listbox.setModel(this.available);
        this.listbox.setTargetModel(this.selected);
    }

    public void layoutWidgets() {
        this.listbox = new OLAPDualListSelector(bundle.getString("CubeDesigner.DeleteMeasure.window.title"), bundle.getString("CubeDesigner.DeleteMeasures.window.title"), bundle.getString("CubeDesigner.DeleteMeasures.txt"), bundle.getString("CubeDesigner.DeleteAllMeasures.txt"));
        this.listbox.setPreferredSize(new Dimension(150, 200));
        this.listbox.setName("dualListBoxSelector");
        this.add((Component)((Object)this.listbox), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }
}

