/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.AggregationTable;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.Statistic;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsObjectTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class CubeMeasuresHolapDetailTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = WAdminResource.getBundle(CubeMeasuresHolapDetailTableModel.class);
    public static final int MEASURE_NAME = 0;
    public static final int COLUMN_NAME = 1;
    public static final int STATISTIC_NAME = 2;
    public static final int ANALYSIS_GROUP = 3;
    public static final int CAPTION = 4;
    public static final int FORMAT = 5;
    public static final int UNITS = 6;
    public static final int NOTES = 7;
    private static final int TOTAL_COLS = 8;
    private static final int TOTAL_HIDDEN_COLS = 1;
    private ArrayList measures;
    private boolean error;
    private OLAPCube olapCube;

    public CubeMeasuresHolapDetailTableModel(OLAPCube cube) {
        this.olapCube = cube;
        this.createColumnDefinitions();
    }

    protected void createColumnDefinitions() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount() + this.getHiddenColumnCount()];
        this.m_aColumns[0] = new WsStringTableColumn(0, bundle.getString("CubeDesigner.MeasuresModel.Name.header.title"), 100, 32);
        this.m_aColumns[1] = new WsStringTableColumn(1, bundle.getString("CubeDesigner.MeasuresModel.Column.header.title"), 100, 32);
        this.m_aColumns[1].setEditable(false);
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("CubeDesigner.MeasuresModel.Stat.header.title"), 100, 10);
        this.m_aColumns[2].setEditable(false);
        this.m_aColumns[3] = new WsStringTableColumn(3, bundle.getString("CubeDesigner.MeasuresDetail.Analysis.txt"), 100, 32);
        this.m_aColumns[3].setEditable(false);
        this.m_aColumns[4] = new WsStringTableColumn(4, bundle.getString("CubeDesigner.MeasuresModel.Caption.header.title"), 200, 200);
        this.m_aColumns[5] = new WsStringTableColumn(5, bundle.getString("CubeDesigner.MeasuresModel.Formats.header.title"), 100, ModelUtilities.formats);
        this.m_aColumns[6] = new WsStringTableColumn(6, bundle.getString("CubeDesigner.MeasuresModel.Units.header.title"), 100, 32);
        this.m_aColumns[7] = new WsStringTableColumn(7, bundle.getString("CubeDesigner.MeasuresModel.Notes.header.title"), 100, 256);
        this.m_aColumns[this.getColumnCount()] = new WsObjectTableColumn();
    }

    public int getColumnCount() {
        return 8;
    }

    public int getHiddenColumnCount() {
        return 1;
    }

    public boolean isInError() {
        return this.error;
    }

    public void moveDataToModel() {
        int nRows = this.m_lData.size();
        if (nRows > 0) {
            this.m_lData.clear();
            this.fireTableRowsDeleted(0, nRows - 1);
        }
        try {
            boolean isSummarized = this.olapCube.getTableSet().isLoadClassicSAS();
            AggregationSet aggregationSet = this.olapCube.getAggregationSet();
            OLAPAggregation defaultAggregation = aggregationSet.getDefaultAggregation();
            AggregationTable loadTable = defaultAggregation.getAggregationTable();
            nRows = this.measures.size();
            for (int i = 0; i < nRows; ++i) {
                OLAPColumn olapColumn;
                ArrayList<String> alRow = new ArrayList<String>(this.getColumnCount() + this.getHiddenColumnCount());
                OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
                Statistic stat = measure.getStatistic();
                alRow.add(0, measure.getName());
                String inputColumnName = "";
                if (measure.isNunique().booleanValue()) {
                    inputColumnName = measure.getLevel().getName();
                } else if ((isSummarized && !stat.isDerived()) | !isSummarized && (olapColumn = measure.getAggregateColumn(loadTable)) != null) {
                    inputColumnName = olapColumn.getSASColumnName();
                }
                alRow.add(1, inputColumnName);
                alRow.add(2, stat.getName());
                String analysisGroup = "";
                if (!measure.isNunique().booleanValue()) {
                    analysisGroup = measure.getGroupName();
                }
                alRow.add(3, analysisGroup);
                alRow.add(4, measure.getDesc());
                alRow.add(5, measure.getSASFormat());
                alRow.add(6, measure.getUnits());
                alRow.add(7, measure.getNotes());
                alRow.add(this.getColumnCount(), (String)measure);
                this.m_lData.add(alRow);
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        if (nRows > 0) {
            this.fireTableRowsInserted(0, nRows - 1);
        }
        this.m_nRowInstances = nRows;
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() {
    }

    public void resetError() {
        this.error = false;
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        this.error = false;
        String oldValue = (String)this.getValueAt(iRow, iCol);
        OLAPMeasure measure = (OLAPMeasure)this.getValueAt(iRow, this.getColumnCount());
        if (iCol == 0) {
            measure.setName((String)value);
            try {
                measure.verifyName();
                value = measure.getName();
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
                measure.setName(oldValue);
                this.error = true;
                return;
            }
        }
        if (iCol == 4) {
            measure.setDesc((String)value);
        } else if (iCol == 5) {
            String format = (String)value;
            measure.setSASFormat((String)value);
            if (ModelUtilities.isBlank((String)format)) {
                try {
                    format = measure.getSASFormat();
                }
                catch (OLAPException oLAPException) {
                    // empty catch block
                }
                MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.MeasuresDetail.UseDefault.txt", (Object)format), (int)1);
                value = format;
            }
            measure.setSASFormat((String)value);
        } else if (iCol == 6) {
            measure.setUnits((String)value);
        } else if (iCol == 7) {
            measure.setNotes((String)value);
        }
        super.setValueAt(value, iRow, iCol);
    }

    public void setSortedList(ArrayList sortedList) {
        this.measures = sortedList;
    }
}

