/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.Statistic;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WATextField;
import com.sas.workspace.WAdminResource;
import java.awt.Color;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class CubeMeasuresHolapAssignStatGroupTable
extends JTable {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeMeasuresHolapAssignStatGroupTable.class);
    public TableValues tableValues;
    public Object[][] values;
    public TableColumnModel tcm;
    protected WAComboBox statField;
    private OLAPCube olapCube;
    protected PhysicalTable loadTable;
    private List measures;

    public CubeMeasuresHolapAssignStatGroupTable(OLAPCube inputOLAPCube) {
        this.setRowSelectionAllowed(true);
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
        this.olapCube = inputOLAPCube;
        this.tableValues = new TableValues();
    }

    public void setReadOnly() {
        this.setEnabled(false);
    }

    public void setMeasures(List inputMeasures) throws OLAPException {
        this.measures = inputMeasures;
        this.values = new Object[this.measures.size()][3];
        for (int i = this.measures.size() - 1; i >= 0; --i) {
            OLAPMeasure measure = (OLAPMeasure)this.measures.get(i);
            Statistic statistic = measure.getStatistic();
            this.values[i][0] = measure.getInputColumn().getSASColumnName();
            if (statistic == null) continue;
            this.values[i][1] = statistic;
            this.values[i][2] = measure.getGroupName();
        }
        this.setModel(this.tableValues);
        TableColumnModel tcm = this.getColumnModel();
        TableColumn col = tcm.getColumn(0);
        col.setPreferredWidth(140);
        col = tcm.getColumn(1);
        this.statField = new WAComboBox(Statistic.getStoredStatistics().toArray(), true);
        this.statField.setEditable(false);
        DefaultCellEditor statEditor = new DefaultCellEditor((JComboBox<?>)this.statField);
        col.setCellEditor(statEditor);
        col.setPreferredWidth(150);
        col = tcm.getColumn(2);
        WATextField groupField = new WATextField();
        groupField.setBorder((Border)new LineBorder(Color.black));
        DefaultCellEditor groupEditor = new DefaultCellEditor((JTextField)groupField);
        groupEditor.setClickCountToStart(1);
        col.setCellEditor(groupEditor);
        col.setPreferredWidth(120);
    }

    class TableValues
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        private static final int COLUMN_NAME = 0;
        private static final int STAT_NAME = 1;
        private static final int ANALYSIS_GROUP = 2;
        public final String[] columnNames = new String[]{bundle.getString("CubeDesigner.MeasuresDetail.NWAYCol.txt"), bundle.getString("CubeDesigner.MeasuresDetail.Stat.txt"), bundle.getString("CubeDesigner.MeasuresDetail.Analysis.txt")};

        TableValues() {
        }

        @Override
        public int getRowCount() {
            if (CubeMeasuresHolapAssignStatGroupTable.this.values == null) {
                return 0;
            }
            return CubeMeasuresHolapAssignStatGroupTable.this.values.length;
        }

        @Override
        public int getColumnCount() {
            if (CubeMeasuresHolapAssignStatGroupTable.this.values == null) {
                return 0;
            }
            return CubeMeasuresHolapAssignStatGroupTable.this.values[0].length;
        }

        @Override
        public Object getValueAt(int row, int inputColumn) {
            return CubeMeasuresHolapAssignStatGroupTable.this.values[row][inputColumn];
        }

        @Override
        public String getColumnName(int inputColumn) {
            return this.columnNames[inputColumn];
        }

        @Override
        public boolean isCellEditable(int row, int inputColumn) {
            return inputColumn != 0;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void setValueAt(Object value, int row, int column) {
            Object oldValue = CubeMeasuresHolapAssignStatGroupTable.this.tableValues.getValueAt(row, column);
            if (value == null || ModelUtilities.isBlank((String)value.toString())) {
                return;
            }
            OLAPMeasure measure = (OLAPMeasure)CubeMeasuresHolapAssignStatGroupTable.this.measures.get(row);
            if (column == 2) {
                if (value.equals(oldValue)) return;
                if (oldValue == null) {
                    oldValue = "";
                }
                if (value.equals("")) {
                    CubeMeasuresHolapAssignStatGroupTable.this.values[row][column] = oldValue;
                    return;
                }
                CubeMeasuresHolapAssignStatGroupTable.this.values[row][column] = value;
                this.fireTableCellUpdated(row, column);
                try {
                    int choice;
                    MeasureSet measureSet;
                    OLAPList oldValueMeasures;
                    boolean measureGroupSet = false;
                    if (!ModelUtilities.isBlank((String)((String)oldValue)) && (oldValueMeasures = (measureSet = CubeMeasuresHolapAssignStatGroupTable.this.olapCube.getMeasureSet()).getStoredMeasuresByGroupName((String)oldValue)).size() > 1 && (choice = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.HolapMeasures.ChangeAllGroupNames.txt"), null, (int)2, (int)0)) == 0) {
                        measureGroupSet = true;
                        measureSet.setGroupNames((String)oldValue, (String)value);
                        for (int i = CubeMeasuresHolapAssignStatGroupTable.this.measures.size() - 1; i >= 0; --i) {
                            if (!CubeMeasuresHolapAssignStatGroupTable.this.values[i][column].equals(oldValue)) continue;
                            CubeMeasuresHolapAssignStatGroupTable.this.values[i][column] = value;
                        }
                    }
                    if (measureGroupSet) return;
                    measure.setGroupName((String)value);
                    return;
                }
                catch (OLAPException error) {
                    ExceptionHandler.handleException((Exception)((Object)error));
                    CubeMeasuresHolapAssignStatGroupTable.this.values[row][column] = oldValue;
                    return;
                }
            }
            if (column != 1) return;
            if (value.equals(oldValue)) {
                return;
            }
            if (oldValue == null) {
                oldValue = "";
            }
            Statistic newStatistic = (Statistic)value;
            try {
                measure.setStatistic(newStatistic);
                CubeMeasuresHolapAssignStatGroupTable.this.values[row][column] = value;
                this.fireTableCellUpdated(row, column);
                return;
            }
            catch (OLAPException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
            }
        }
    }
}

