/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.OLAPColumn;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.visuals.CubeMeasureMapTable;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WAdminResource;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;

public class CubeMeasureMapPanel
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeMeasureMapPanel.class);
    protected OLAPCube cubeModel;
    protected CubeMeasureMapTable MeasureTable;

    public CubeMeasureMapPanel(OLAPCube CM) {
        this.cubeModel = CM;
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
    }

    public boolean validateData() {
        int rowtotal = this.MeasureTable.tablevalues.getRowCount();
        for (int i = 0; i < rowtotal; ++i) {
            OLAPMeasure nextMeasure = (OLAPMeasure)this.MeasureTable.values[i][0];
            String columnName = (String)this.MeasureTable.values[i][3];
            List tables = null;
            if (columnName == null) {
                MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.MeasureMap.instruct.txt"), (int)2);
                return false;
            }
            tables = (List)this.MeasureTable.aggregationColumns.get(columnName.toUpperCase());
            if (tables == null) continue;
            for (int k = 0; k < tables.size(); ++k) {
                OLAPColumn col = (OLAPColumn)tables.get(k);
                try {
                    nextMeasure.setAggregateColumn(col.getSASColumnName());
                    continue;
                }
                catch (OLAPException OLAPError) {
                    return ExceptionHandler.handleException((Exception)((Object)OLAPError));
                }
            }
        }
        return true;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            MeasureSet measureSet = null;
            OLAPList measuremodels = null;
            try {
                measureSet = this.cubeModel.getMeasureSet();
                measuremodels = measureSet.getMeasures();
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            this.MeasureTable._setMeasureModel(measuremodels, this.cubeModel);
            this.MeasureTable.revalidate();
        }
        return true;
    }

    private void _layoutWidgets() {
        this.MeasureTable = new CubeMeasureMapTable();
        JScrollPane topPanel = new JScrollPane(this.MeasureTable);
        this.MeasureTable.setName("MapMeasuresTable");
        this.MeasureTable.setPreferredScrollableViewportSize(new Dimension(200, 200));
        this.MeasureTable.setAutoResizeMode(0);
        this.MeasureTable.setToolTipText(bundle.getString("CubeDesigner.MeasureMap.ToolTip.txt"));
        this.add(topPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void onBack() {
        TableCellEditor ce = this.MeasureTable.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
    }

    public void onNext() {
        TableCellEditor ce = this.MeasureTable.getCellEditor();
        if (ce != null) {
            ce.stopCellEditing();
        }
    }
}

