/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.visuals.CubeGeneralLanguagePanel;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WAdminResource;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import javax.swing.JLabel;

public class CubeGeneralLanguageTab
extends WAPropertyTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeGeneralLanguageTab.class);
    private CubeGeneralLanguagePanel m_appPanel;
    public OLAPList listOfShared;
    public int messageCounter;

    public CubeGeneralLanguageTab(OLAPCube CM) throws OLAPException {
        this.m_appPanel = new CubeGeneralLanguagePanel(CM);
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("cd_general_translation");
        this.setLayout(new GridBagLayout());
        this._layoutWidgets();
        DimensionSet dimensionSet = CM.getDimensionSet();
        this.listOfShared = dimensionSet.getSharedDimensions();
        this.messageCounter = 1;
    }

    public boolean doDataExchange(boolean bSaveToModel) {
        if (this.listOfShared.size() > 0 && this.messageCounter == 1) {
            MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.Advanced.NoMLS.fmt.txt", null), (String)bundle.getString("CubeDesigner.MLSCaptions.NoMLS.window.title"), (int)1, (int)-1);
            this.messageCounter = 0;
        }
        this.m_appPanel.doDataExchange(bSaveToModel);
        return true;
    }

    public void saveDataToCubeModel() {
        this.m_appPanel.saveDataToCubeModel();
    }

    public void _layoutWidgets() {
        WATextArea m_instructions = new WATextArea();
        JLabel l = new JLabel();
        m_instructions.setFont(l.getFont());
        m_instructions.setColumns(30);
        m_instructions.setText(bundle.getString("CubeDesigner.TranslationPanel.Title.txt"));
        m_instructions.setBehavior(1);
        m_instructions.setBackground((Color)SystemColor.control);
        m_instructions.setAutosize(true);
        this.add((Component)m_instructions, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add((Component)((Object)this.m_appPanel), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(5, 0, 0, 0), 0, 0));
    }

    public boolean validateData() {
        return this.m_appPanel.validateData();
    }

    public void onCancel() {
        this.m_appPanel.onCancel();
    }
}

