/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.DimensionTable;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.studio.PhysicalTableSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class CubeDimensionTablesPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeDimensionTablesPanel.class);
    private PhysicalTableSelector tree;
    private OLAPCube olapCube;
    private OLAPList dimensionTables;
    private List deletedDimensions;
    private LanguageSet languageSet;
    private DimensionSet dimensionSet;
    private TableSet tableSet;
    private boolean isMultiLanguage;
    private boolean initialized;
    private boolean previousMLSStatus;
    private PhysicalTable previousPhysicalLoadTable;
    private List initialLanguages;
    private List currentListOfLanguages;
    private boolean languagesChanged;
    private boolean checkFinish;
    private String finishDeletedTables;

    public CubeDimensionTablesPanel(OLAPCube inputOLAPCube) {
        this.olapCube = inputOLAPCube;
        this.setLayout(new GridBagLayout());
        this.tableSet = this.olapCube.getTableSet();
        this.initialLanguages = new ArrayList();
        this.layoutWidgets();
    }

    public String getDeletedTables() {
        return this.finishDeletedTables;
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel) {
            try {
                this.isMultiLanguage = this.languageSet.isCubeMultipleLanguageSupported();
                if (!this.initialized) {
                    this.initialize();
                }
                PhysicalTable currentPhysicalTable = this.tableSet.getLoadTable().getTable();
                if (!this.currentListOfLanguages.equals(this.initialLanguages)) {
                    this.languagesChanged = true;
                    this.initialLanguages.clear();
                    this.initialLanguages.addAll(this.currentListOfLanguages);
                }
                if (this.previousMLSStatus != this.isMultiLanguage || currentPhysicalTable != this.previousPhysicalLoadTable || this.languagesChanged) {
                    this.tree.setMLS(this.isMultiLanguage);
                    this.tree.clearAndPopulate();
                    this.tree.clearTreeSelections();
                    this.initialize();
                    this.languagesChanged = false;
                    this.previousPhysicalLoadTable = currentPhysicalTable;
                    this.previousMLSStatus = this.isMultiLanguage;
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
        }
        return true;
    }

    protected void initialize() {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            try {
                this.initialized = true;
                this.dimensionSet = this.olapCube.getDimensionSet();
                this.dimensionTables = this.dimensionSet.getTables();
                ArrayList<PhysicalTable> physicalTables = new ArrayList<PhysicalTable>();
                ArrayList<String> excludeTable = new ArrayList<String>();
                int size = this.dimensionTables.size();
                for (int i = 0; i < size; ++i) {
                    DimensionTable dimTable = (DimensionTable)this.dimensionTables.get(i);
                    physicalTables.add(dimTable.getTable());
                }
                this.currentListOfLanguages = this.languageSet.getSelectedLocales();
                this.initialLanguages.addAll(this.currentListOfLanguages);
                this.previousPhysicalLoadTable = this.tableSet.getLoadTable().getTable();
                PhysicalTable loadTable = this.tableSet.getLoadTable().getTable();
                String id = loadTable.getId();
                excludeTable.add(id);
                this.tree.removeExclusionTables();
                this.tree.setExclusionTables(excludeTable);
                this.tree.initializeSelectedTables(physicalTables);
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.tree.populateStore();
                this.tree.moveDataToView();
                this.setCursor(Cursor.getPredefinedCursor(0));
                WsDescriptionWizardTab parentTab = (WsDescriptionWizardTab)this.getParent();
                if (this.isMultiLanguage) {
                    parentTab.setDescription(bundle.getString("CubeDesigner.DimensionTables.MLSinstruct.txt"));
                } else {
                    parentTab.setDescription(bundle.getString("CubeDesigner.DimensionTables.instruct.txt"));
                }
            }
            catch (MdException mdError) {
                ExceptionHandler.handleException((Exception)((Object)new OLAPException(mdError.getLocalizedMessage(), (Throwable)mdError, 12)));
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
            catch (OLAPException OLAPError) {
                ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }
    }

    public void onBack() {
        this.validateTables("Back");
    }

    public void setDeletedTables(String listOfDeletedTables) {
        this.finishDeletedTables = listOfDeletedTables;
    }

    public void setCheckFinish(boolean finish) {
        this.checkFinish = finish;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean validateTables(String backOrNext) {
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) {
            return false;
        }
        List tables = this.tree.getSelectedTables();
        if (this.dimensionTables.size() > 0) {
            String listOfTablesDeleted = "";
            ArrayList<DimensionTable> checkingDimensionTables = new ArrayList<DimensionTable>();
            try {
                int size = this.dimensionTables.size();
                for (int i = 0; i < size; ++i) {
                    DimensionTable currentDimensionTable = (DimensionTable)this.dimensionTables.get(i);
                    if (currentDimensionTable.isLoadTable()) continue;
                    PhysicalTable table = currentDimensionTable.getTable();
                    if (tables != null) {
                        if (tables.indexOf(table) != -1) continue;
                        checkingDimensionTables.add(currentDimensionTable);
                        continue;
                    }
                    checkingDimensionTables.add(currentDimensionTable);
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
            if (checkingDimensionTables.size() > 0) {
                if (this.deletedDimensions == null) {
                    this.deletedDimensions = new ArrayList();
                }
                this.deletedDimensions.clear();
                OLAPList allDimensions = null;
                try {
                    allDimensions = this.dimensionSet.getCubeDimensions();
                    int size = allDimensions.size();
                    for (int i = 0; i < size; ++i) {
                        OLAPDimension dimension = (OLAPDimension)allDimensions.get(i);
                        DimensionTable dimensionTable = dimension.getTable();
                        String name = dimensionTable.getSASTableName();
                        if (checkingDimensionTables.indexOf(dimensionTable) <= -1) continue;
                        if (listOfTablesDeleted.indexOf(name) < 0) {
                            listOfTablesDeleted = this.deletedDimensions.isEmpty() ? listOfTablesDeleted + " " + name : listOfTablesDeleted + ", " + name;
                        }
                        this.deletedDimensions.add(dimension);
                    }
                }
                catch (OLAPException OLAPError1) {
                    return ExceptionHandler.handleException((Exception)((Object)OLAPError1));
                }
                String errorMessage = null;
                errorMessage = this.deletedDimensions.size() == 1 ? bundle.formatString("CubeDesigner.DimensionTables.Delete.txt", (Object)listOfTablesDeleted) : bundle.formatString("CubeDesigner.DimensionTables.Delete.Multiple.txt", (Object)listOfTablesDeleted);
                if (listOfTablesDeleted.length() > 0) {
                    if (this.checkFinish) {
                        this.setDeletedTables(listOfTablesDeleted);
                        this.checkFinish = false;
                        return false;
                    }
                    int option = MessageUtil.displayMessage((String)errorMessage, (int)2, (int)2);
                    if (!(option == 0 | option == 0)) return false;
                    WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
                    parent.addWizardData("TABLECHANGED", (Object)"YES");
                    for (int t = 0; t < this.deletedDimensions.size(); ++t) {
                        OLAPDimension deleteDimension = (OLAPDimension)this.deletedDimensions.get(t);
                        try {
                            deleteDimension.delete();
                            continue;
                        }
                        catch (OLAPException oError) {
                            return ExceptionHandler.handleException((Exception)((Object)oError));
                        }
                    }
                    try {
                        AggregationSet aggregationSet = this.olapCube.getAggregationSet();
                        if (aggregationSet.getAggregations().size() > 0) {
                            aggregationSet.setResetLevels(true);
                            aggregationSet.resetLevels();
                        }
                    }
                    catch (OLAPException OLAPError2) {
                        return ExceptionHandler.handleException((Exception)((Object)OLAPError2));
                    }
                }
            }
        }
        if (tables != null) {
            this.dimensionTables.clear();
            int size = tables.size();
            for (int t = 0; t < size; ++t) {
                PhysicalTable phyTable = (PhysicalTable)tables.get(t);
                try {
                    DimensionTable dimTable = this.tableSet.getDimensionTable(phyTable);
                    this.dimensionTables.add((Object)dimTable);
                    continue;
                }
                catch (OLAPException OLAPError2) {
                    return ExceptionHandler.handleException((Exception)((Object)OLAPError2));
                }
            }
            return true;
        } else {
            this.dimensionTables.clear();
        }
        return true;
    }

    public void saveSettingsAndCleanUp() {
        this.tree.saveSettingsAndCleanUp();
    }

    public boolean validateData() {
        return this.validateTables("Next");
    }

    protected void layoutWidgets() {
        try {
            this.languageSet = this.olapCube.getLanguageSet();
            this.previousMLSStatus = this.isMultiLanguage = this.languageSet.isCubeMultipleLanguageSupported();
            this.tree = this.isMultiLanguage ? new PhysicalTableSelector((AbstractOLAPModel)this.olapCube, -1, true, false, true, false, false) : new PhysicalTableSelector((AbstractOLAPModel)this.olapCube, -1, true, false, false, false, false);
            this.tree.setName("DimensionTablesSelection");
            this.add((Component)((Object)this.tree), new GridBagConstraints(0, 0, 3, 3, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
    }
}

