/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.editor.LogListHolder;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.AggregationTable;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.LanguageSet;
import com.sas.olapadmin.designer.model.LoadTable;
import com.sas.olapadmin.designer.model.MeasureSet;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.OLAPMeasure;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.designer.visuals.CubeDesignerPlugin;
import com.sas.olapadmin.designer.visuals.CubeDimensionTablesTab;
import com.sas.olapadmin.designer.visuals.CubeFinishButtonDialog;
import com.sas.olapadmin.designer.visuals.CubeInputTab;
import com.sas.olapadmin.designer.visuals.CubeStructureMessagePanel;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.SavePanel;
import com.sas.olapadmin.utilities.SaveSasLogActionListener;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.olapadmin.utilities.studio.CubeSaveProcOlapDialog;
import com.sas.wadmin.visuals.ComboButton;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPropertyTab;
import com.sas.workspace.WARootPane;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATransitionWizardModel;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAWizardModel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WizardTabInfo;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import com.sas.workspace.WsButtonsLayout;
import com.sas.workspace.visuals.WsLogPropertyTab;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.plaf.basic.BasicBorders;

public class CubeDesigner
extends WAWizardDialog {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeDesigner.class);
    private static final String GENERAL = "GENERAL";
    private static final String DIMENSIONS = "DIMENSIONS";
    private static final String INPUT = "INPUT";
    private static final String DIMTABLES = "DIMTABLES";
    private static final String MEASURES = "MMEASURES";
    private static final String AGGRTABLES = "AGGRTABLES";
    private static final String OLAPFINISH = "OLAPFINISH";
    private static final String HMEASURES = "HMEASURES";
    private static final String ASGDETAIL = "ASGDETAIL";
    private static final String USERAGGRS = "USERAGGS";
    private static final String MEASUREMAP = "MEASUREMAP";
    private static final String RUSERAGGS = "RUSERAGGS";
    private static final String MOLAP = "MOLAP";
    private static final String HOLAP = "HOLAP";
    protected List detailItems;
    protected List detailAggrItems;
    protected List starItems;
    protected List starMLSItems;
    protected List starAggrItems;
    protected List starAggrMLSItems;
    protected List fullyItems;
    protected OLAPCube olapCube;
    protected JButton exportCode;
    protected ComboButton next;
    protected List errorList;
    private WsRunCode wsRunCode;
    private WsAppServer server;
    protected List currentTypeList;
    private static final int DETAIL = 0;
    private static final int DETAILAGGR = 1;
    private static final int STAR = 2;
    private static final int STARAGGR = 3;
    private static final int FULLY = 4;
    private static final int STARMLS = 5;
    private static final int STARMLSAGGR = 6;
    private static final int NOAGGRS = 7;
    private static final int DISABLE = 0;
    private static final int ENABLE = 1;
    public WsAbstractAction mapMeasuresAction;
    public WsAbstractAction storedAggrAction;
    private int whatTypeCube;
    private int previousCubeType;
    private AggregationSet aggregationSet;
    private DimensionSet dimensionSet;
    private TableSet tableSet;
    private MeasureSet measureSet;
    private JButton downNextArrow;
    private boolean okNext;
    private boolean noAggrsSelected;

    public CubeDesigner(Frame frame, String title) {
        super(frame, title, true);
        MdObjectStore MdOS = (MdObjectStore)this.getWizardData("OBJECTSTORE");
        this.setCanFinishEarly(true);
        try {
            this.olapCube = new OLAPCube(MdOS);
        }
        catch (OLAPException e) {
            this.olapCube = null;
        }
        if (this.olapCube != null) {
            this.Designer();
        }
    }

    public CubeDesigner(Frame frame, String title, OLAPCube CM) {
        super(frame, title, true);
        this.olapCube = CM;
        Workspace parent = Workspace.getWorkspace();
        parent.setCursor(new Cursor(3));
        this.Designer();
    }

    private void Designer() {
        if (this.olapCube.getErrorLevel() == 3) {
            this.olapCube.setErrorLevel(-1);
        }
        WATransitionWizardModel model = new WATransitionWizardModel();
        this.setWizardModel((WAWizardModel)model);
        CubeDesignerPlugin CDP = new CubeDesignerPlugin(this.olapCube);
        CDP.initializeWizard(this, model);
    }

    protected boolean onCancel() {
        boolean cancelOK = true;
        if (WAStandardDialog.isUserPreferenceToShowTheDiscardChangesMessage()) {
            Workspace workspace = Workspace.getWorkspace();
            JCheckBox checkbox = new JCheckBox();
            VisualUtilities.setButtonTextAndMnemonic(checkbox, bundle.getString("Common.ShowMessage.checkbox.label"));
            String message = new String(bundle.getString("CubeDesigner.DiscardChanges.txt"));
            Object[] allObjects = new Object[]{message, " ", checkbox};
            String titleMessage = bundle.getString("CubeDesigner.DiscardChanges.window.title");
            int optionSelected = JOptionPane.showConfirmDialog((Component)workspace, allObjects, titleMessage, 2, 2);
            WAStandardDialog.setUserPreferenceToShowTheDiscardChangesMessage((!checkbox.isSelected() ? 1 : 0) != 0);
            cancelOK = optionSelected == 0 ? super.onCancel() : false;
        } else {
            cancelOK = super.onCancel();
        }
        return cancelOK;
    }

    protected void initialize() {
        super.initialize();
        this.aggregationSet = this.olapCube.getAggregationSet();
        this.dimensionSet = this.olapCube.getDimensionSet();
        this.tableSet = this.olapCube.getTableSet();
        try {
            this.measureSet = this.olapCube.getMeasureSet();
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        this.previousCubeType = -1;
        this.mapMeasuresAction = new MapMeasuresAction();
        this.storedAggrAction = new StoredAggrAction();
        this.createNextList();
        this.next = new NewComboButton(null, (ArrayList)this.currentTypeList);
        this.downNextArrow = (JButton)this.next.getComponent(1);
        this.downNextArrow.addActionListener(new NextDropDownArrowListener());
        this.m_btnFinish = new JButton();
        this.m_btnNext = (JButton)this.next.getComponent(0);
        this.m_btnBack = new JButton();
        this.exportCode = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.exportCode, bundle.getString("CubeDesigner.Finish.saveProcCode.txt"));
        VisualUtilities.setButtonTextAndMnemonic(this.m_btnBack, bundle.getString("Common.Back.control.label"));
        VisualUtilities.setButtonTextAndMnemonic(this.m_btnNext, bundle.getString("Common.Next.control.label"));
        VisualUtilities.setButtonTextAndMnemonic(this.m_btnFinish, bundle.getString("Common.Finish.control.label"));
        this.m_btnBack.addActionListener((ActionListener)((Object)this));
        this.m_btnNext.addActionListener((ActionListener)((Object)this));
        this.m_btnFinish.addActionListener((ActionListener)((Object)this));
        this.exportCode.addActionListener(new SaveButtonListener());
        this.errorList = new ArrayList();
    }

    public void setFinishExportEnabled(boolean isEnabled) {
        this.m_btnFinish.setEnabled(isEnabled);
        this.exportCode.setEnabled(isEnabled);
    }

    public boolean isFinishEnabled() {
        return this.m_btnFinish.isEnabled();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean onFinish() {
        try {
            Workspace m_workspace = Workspace.getWorkspace();
            boolean okFinish = true;
            WizardTabInfo currentPanel = this.m_WizardModel.getCurrent();
            String panelName = currentPanel.getTabName();
            this.errorList.clear();
            okFinish = currentPanel.getTab().validateData();
            if (!okFinish) return false;
            if (panelName.equals(GENERAL)) {
                StringBuffer tableMessasges;
                boolean languagesChanged = this.olapCube.isLanguageChanged();
                if (languagesChanged) {
                    this.m_WizardModel.next();
                    this.m_WizardModel.next();
                    WizardTabInfo nextPanel = this.m_WizardModel.getCurrent();
                    WAPropertyTab dimensionTab = nextPanel.getTab();
                    ((CubeDimensionTablesTab)dimensionTab).setCheckFinish(true);
                    ((CubeDimensionTablesTab)dimensionTab).doDataExchange(false);
                    boolean validate = dimensionTab.validateData();
                    this.m_WizardModel.prev();
                    this.m_WizardModel.prev();
                    if (!validate) {
                        String deletedTables = ((CubeDimensionTablesTab)dimensionTab).getDeletedTables();
                        MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.Finish.DimensionTables.Delete.fmt.txt", (Object)deletedTables), (int)2);
                        return false;
                    }
                }
                if ((tableMessasges = this.tableSet.verifyMetadata()).length() > 0) {
                    this.errorList.add(tableMessasges.toString());
                } else {
                    this.dimensionSet.verifyDimensions();
                    this.measureSet.verifyMeasuresExist();
                }
            } else if (panelName.equals(INPUT) || panelName.equals(DIMTABLES)) {
                this.dimensionSet.verifyDimensions();
                this.measureSet.verifyMeasuresExist();
            } else if (!panelName.equals(OLAPFINISH)) {
                this.dimensionSet.verifyDimensions();
                this.measureSet.verifyMeasuresExist();
            }
            int errorCode = this.olapCube.getErrorLevel();
            if (errorCode == 1) {
                MessageUtil.displayMessage((String)bundle.getString("LoadTable.NoLoadTable.txt"));
                return false;
            }
            if (errorCode == 2) {
                MessageUtil.displayMessage((String)bundle.formatString("LoadTable.MissingLibrary.fmt.txt", (Object)this.tableSet.getLoadTable().getTable().getName()));
                return false;
            }
            if (this.errorList.size() > 0 || errorCode == 3) {
                boolean buildCube;
                boolean disabled;
                boolean okToGo;
                int option = 0;
                if (this.errorList.size() > 0) {
                    CubeStructureMessagePanel messagePanel = new CubeStructureMessagePanel(this.errorList, (AbstractOLAPModel)this.olapCube, new ArrayList());
                    option = MessageUtil.displayDetailsMessage((String)bundle.getString("Cube.MetadataChanges.txt"), (int)1, (int)0, (JComponent)messagePanel);
                }
                if (option != 0) return false;
                CubeFinishButtonDialog finishDialog = new CubeFinishButtonDialog(m_workspace, bundle.getString("CubeFinishDialog.finish.title"), this.olapCube);
                finishDialog.show();
                if (finishDialog.getReturnValue() != 1 || !(okToGo = this.runCode(disabled = finishDialog.isDisabled(), buildCube = finishDialog.isBuildSelected()))) return false;
                this.m_pnlMain.onParentOK();
                return okToGo;
            } else {
                boolean buildCube;
                boolean disabled;
                boolean okToGo;
                if (errorCode != -1) return false;
                CubeFinishButtonDialog finishDialog = new CubeFinishButtonDialog(m_workspace, bundle.getString("CubeFinishDialog.finish.title"), this.olapCube);
                finishDialog.show();
                if (finishDialog.getReturnValue() != 1 || !(okToGo = this.runCode(disabled = finishDialog.isDisabled(), buildCube = finishDialog.isBuildSelected()))) return false;
                this.m_pnlMain.onParentOK();
                return okToGo;
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
            return false;
        }
        catch (RemoteException remoteError) {
            ExceptionHandler.handleException((Exception)remoteError);
        }
        return false;
    }

    protected void movePanel(WsAbstractAction action) {
        WizardTabInfo currentPanel = this.m_WizardModel.getCurrent();
        WizardTabInfo nextPanel = null;
        WizardTabInfo[] visitedPanels = this.m_WizardModel.getVisitedPanels();
        int currentLocation = visitedPanels.length - 1;
        int whereToGo = this.currentTypeList.indexOf(action);
        if (whereToGo < currentLocation) {
            for (int backItUp = currentLocation - whereToGo; backItUp > 0; --backItUp) {
                nextPanel = backItUp == currentLocation - whereToGo ? currentPanel : this.m_WizardModel.getCurrent();
                this.m_WizardModel.prev();
                nextPanel.getTab().onBack();
            }
        } else {
            try {
                for (int nextToIt = whereToGo - currentLocation; nextToIt > 0; --nextToIt) {
                    nextPanel = nextToIt == whereToGo - currentLocation ? currentPanel : this.m_WizardModel.getCurrent();
                    this.m_WizardModel.next();
                    nextPanel.getTab().onNext();
                    nextPanel = this.m_WizardModel.getCurrent();
                    WAPropertyTab tab = nextPanel.getTab();
                    if (tab.hasBeenShown() || tab.getWizardPageType() == 2) continue;
                    tab.doDataExchange(false);
                }
                this.updateNavigationButtons();
            }
            catch (MdException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
            }
            catch (RemoteException remoteError) {
                ExceptionHandler.handleException((Exception)remoteError);
            }
        }
        this.m_btnBack.setEnabled(this.m_WizardModel.hasPrev());
        this.m_btnNext.setEnabled(this.m_WizardModel.hasNext());
        this.show();
    }

    protected void updateButtonsPanel() {
        if (CubeDesigner.isUsingNewStyle()) {
            this.m_pnlButtons.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        }
        this.m_pnlButtons.removeAll();
        JPanel subPanel2 = new JPanel((LayoutManager)new WsButtonsLayout());
        subPanel2.add(this.exportCode);
        JPanel subPanel1 = new JPanel(new cWizardButtonsPaneLayout());
        this.m_pnlButtons.setLayout(new BorderLayout());
        subPanel1.add(this.m_btnHelp);
        subPanel1.add(this.m_btnCancel);
        subPanel1.add(this.m_btnBack);
        subPanel1.add((Component)this.next);
        subPanel1.add(this.m_btnFinish);
        this.m_pnlButtons.add((Component)subPanel2, "West");
        this.m_pnlButtons.add((Component)subPanel1, "East");
        this.updateNavigationButtons();
    }

    protected void updateNavigationButtons() {
        try {
            this.m_btnBack.setEnabled(this.m_WizardModel.hasPrev());
            this.m_btnNext.setEnabled(this.m_WizardModel.hasNext());
            this.m_btnFinish.setEnabled(false);
            this.exportCode.setEnabled(false);
            WizardTabInfo currentPanel = this.m_WizardModel.getCurrent();
            String panelName = currentPanel.getTabName();
            boolean continueChecking = true;
            if (panelName.equals(USERAGGRS) || panelName.equals(OLAPFINISH)) {
                this.setFinishExportEnabled(true);
                continueChecking = false;
            } else if (panelName.equals(GENERAL)) {
                this.m_WizardModel.next();
                WizardTabInfo nextPanel = this.m_WizardModel.getCurrent();
                CubeInputTab inputTab = (CubeInputTab)nextPanel.getTab();
                continueChecking = !inputTab.hasTreeDataChanged();
                this.m_WizardModel.prev();
            }
            if (continueChecking) {
                LoadTable table = this.tableSet.getLoadTable();
                PhysicalTable physTable = null;
                if (table != null) {
                    physTable = table.getTable();
                }
                Map levels = this.dimensionSet.getLevels();
                OLAPList hierList = this.dimensionSet.getHierarchies();
                OLAPList measureList = this.measureSet.getMeasures();
                if (!(physTable == null || levels.isEmpty() || hierList.isEmpty() || measureList.isEmpty())) {
                    boolean isFully = this.tableSet.isLoadClassicSAS();
                    if (isFully) {
                        boolean cantGo = false;
                        int size = measureList.size();
                        for (int i = 0; i < size && !cantGo; ++i) {
                            OLAPMeasure measure = (OLAPMeasure)measureList.get(i);
                            if (measure.getStatistic() == null) {
                                cantGo = true;
                            }
                            if (measure.isNunique().booleanValue() || !ModelUtilities.isBlank((String)measure.getGroupName())) continue;
                            cantGo = true;
                        }
                        if (!cantGo) {
                            this.setFinishExportEnabled(true);
                        }
                    } else if (this.olapCube.getType().equals(HOLAP)) {
                        boolean mapOK = ((MapMeasuresAction)this.mapMeasuresAction).cubeIsOk();
                        boolean storedOk = ((StoredAggrAction)this.storedAggrAction).cubeIsOk();
                        if (mapOK && storedOk) {
                            this.setFinishExportEnabled(true);
                        } else {
                            this.setFinishExportEnabled(false);
                        }
                    } else {
                        this.m_btnFinish.setEnabled(true);
                        this.exportCode.setEnabled(true);
                    }
                }
            }
            if (!this.m_btnNext.isEnabled()) {
                ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnFinish);
            } else {
                ((WARootPane)this.getRootPane()).setRealDefaultButton(this.m_btnNext);
            }
            Component cmp = this.getDefaultFocusComponent();
            if (cmp != null) {
                cmp.requestFocus();
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
    }

    public int getTypeLoad() {
        try {
            String loadType = this.tableSet.getLoadType();
            String cubeType = this.olapCube.getType();
            LanguageSet languageSet = this.olapCube.getLanguageSet();
            if (loadType.equals(TableSet.DETAIL_TABLE) && cubeType.equals(MOLAP)) {
                this.whatTypeCube = 0;
            } else if (loadType.equals(TableSet.DETAIL_TABLE) && cubeType.equals(HOLAP)) {
                this.whatTypeCube = 1;
            } else if (loadType.equals(TableSet.STAR_SCHEMA) && cubeType.equals(MOLAP)) {
                this.whatTypeCube = languageSet.isCubeMultipleLanguageSupported() ? 5 : 2;
            } else if (loadType.equals(TableSet.STAR_SCHEMA) && cubeType.equals(HOLAP)) {
                this.whatTypeCube = languageSet.isCubeMultipleLanguageSupported() ? 6 : 3;
            } else if (loadType.equals(TableSet.FULLY_SUMMARIZED)) {
                this.whatTypeCube = 4;
            }
        }
        catch (OLAPException oError) {
            ExceptionHandler.handleException((Exception)((Object)oError));
        }
        return this.whatTypeCube;
    }

    private void enableDisableOptions(boolean tablehasnotchanged) {
        boolean canContinue = tablehasnotchanged;
        int size = this.currentTypeList.size();
        for (int i = 0; i < size; ++i) {
            WsAbstractAction action = (WsAbstractAction)this.currentTypeList.get(i);
            if (action instanceof GeneralAction || action instanceof InputAction) {
                action.setEnabled(true);
                continue;
            }
            if (canContinue) {
                if (action instanceof DimTableAction) {
                    canContinue = ((DimTableAction)action).cubeIsOk();
                    action.setEnabled(canContinue);
                    continue;
                }
                if (action instanceof DimensionAction) {
                    canContinue = ((DimensionAction)action).cubeIsOk();
                    action.setEnabled(canContinue);
                    continue;
                }
                if (action instanceof MeasuresAction) {
                    canContinue = ((MeasuresAction)action).cubeIsOk();
                    action.setEnabled(canContinue);
                    continue;
                }
                if (action instanceof StoredMeasuresAction) {
                    canContinue = ((StoredMeasuresAction)action).cubeIsOk();
                    action.setEnabled(canContinue);
                    continue;
                }
                if (action instanceof AssignMeasuresAction) {
                    canContinue = ((AssignMeasuresAction)action).cubeIsOk();
                    action.setEnabled(canContinue);
                    continue;
                }
                if (action instanceof DerivedMeasuresAction) {
                    canContinue = ((DerivedMeasuresAction)action).cubeIsOk();
                    action.setEnabled(canContinue);
                    continue;
                }
                if (action instanceof MeasureDetailAction) {
                    canContinue = ((MeasureDetailAction)action).cubeIsOk();
                    action.setEnabled(canContinue);
                    continue;
                }
                if (action instanceof ExternalTableAction) {
                    canContinue = ((ExternalTableAction)action).cubeIsOk();
                    action.setEnabled(canContinue);
                    continue;
                }
                if (action instanceof MapMeasuresAction) {
                    canContinue = ((MapMeasuresAction)action).cubeIsOk();
                    action.setEnabled(canContinue);
                    continue;
                }
                if (action instanceof StoredAggrAction) {
                    canContinue = ((StoredAggrAction)action).cubeIsOk();
                    action.setEnabled(canContinue);
                    continue;
                }
                if (action instanceof InternalAggregationAction) {
                    canContinue = ((InternalAggregationAction)action).cubeIsOk();
                    action.setEnabled(canContinue);
                    continue;
                }
                if (action instanceof AggregationAction) {
                    canContinue = ((AggregationAction)action).cubeIsOk();
                    action.setEnabled(canContinue);
                    continue;
                }
                if (action instanceof MLSCaptionAction) {
                    canContinue = ((MLSCaptionAction)action).cubeIsOk();
                    action.setEnabled(canContinue);
                    continue;
                }
                if (!(action instanceof SummaryAction)) continue;
                canContinue = ((SummaryAction)action).cubeIsOk();
                action.setEnabled(canContinue);
                continue;
            }
            action.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runCode(boolean disable, boolean buildCube) {
        String str1 = bundle.getString("WriteMetadataProgressIndicator.Msg.Title.txt");
        String str2 = bundle.getString("WriteMetadataProgressIndicator.Msg.Message.txt");
        boolean doUpdate = true;
        boolean doCreate = true;
        boolean continueCleanUp = false;
        boolean mustDelete = this.olapCube.physicallyExists();
        try {
            if (buildCube | mustDelete) {
                this.server = WsRunCode.getServer();
                if (this.server != null) {
                    this.wsRunCode = new WsRunCode(this.server);
                    if (this.wsRunCode.hasSubmitError) {
                        boolean bl = false;
                        return bl;
                    }
                } else {
                    if (mustDelete) {
                        MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.Finish.ServerRequired.txt"));
                    } else {
                        MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.Finish.ServerOptional.txt"));
                    }
                    boolean bl = false;
                    return bl;
                }
            }
            if (mustDelete && this.server != null) {
                boolean didDisableWork = false;
                if (disable) {
                    didDisableWork = this.disableEnableCube(0);
                }
                if (!didDisableWork && disable) {
                    boolean bl = false;
                    return bl;
                }
                this.wsRunCode.showLogMessagesInDetails(true);
                boolean submitError = this.wsRunCode.executeCode(this.olapCube.generateCodeDeletePhysical(), str2, str1);
                if (submitError) {
                    doUpdate = false;
                    doCreate = false;
                    boolean bl = false;
                    return bl;
                }
            } else if (mustDelete && this.server == null) {
                MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.Finish.NoEdit.txt"));
                doUpdate = false;
                doCreate = false;
                boolean didDisableWork = false;
                return didDisableWork;
            }
            if (doUpdate) {
                UpdateMetadata updateMetadata = new UpdateMetadata(this.olapCube);
                OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), str2, str1);
                request.setProgressShownOnStatusBar(false);
                request.execute((Runnable)updateMetadata);
                doCreate = updateMetadata.getReturnValue();
            }
            if (doCreate && buildCube && this.server != null) {
                String message = bundle.getString("CreateCubeProgressIndicator.Msg.Message.txt");
                String title = bundle.getString("CreateCubeProgressIndicator.Msg.Title.txt");
                this.wsRunCode.showLogMessagesInDetails(false);
                this.wsRunCode.executeCode(this.olapCube.generateCodeCreate(), message, title);
                if (disable) {
                    this.disableEnableCube(1);
                }
            } else if (doCreate && buildCube && this.server == null) {
                MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.Finish.NoCreate.txt"));
                boolean message = false;
                return message;
            }
            continueCleanUp = true;
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            HashMap<String, String> map = new HashMap<String, String>(1);
            map.put(this.olapCube.getFQID(), "Cube");
            try {
                Workspace.getMdFactory().fireMdObjectsModified(new MdFactoryEvent(factory, map));
            }
            catch (RemoteException e) {
                throw new OLAPException(bundle.getString("MdException.GenericError.txt"), (Throwable)e, 12);
            }
        }
        catch (OLAPException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
        finally {
            if (continueCleanUp) {
                this.cleanup();
            }
        }
        return true;
    }

    private void createNextList() {
        this.whatTypeCube = this.getTypeLoad();
        if (this.whatTypeCube == 0) {
            if (this.detailItems == null) {
                this.detailItems = new ArrayList();
                this.detailItems.add(new GeneralAction());
                this.detailItems.add(new InputAction());
                this.detailItems.add(new DimensionAction());
                this.detailItems.add(new MeasuresAction());
                this.detailItems.add(new AggregationAction());
                this.detailItems.add(new SummaryAction());
            }
            this.currentTypeList = this.detailItems;
        } else if (this.whatTypeCube == 1) {
            if (this.detailAggrItems == null) {
                this.detailAggrItems = new ArrayList();
                this.detailAggrItems.add(new GeneralAction());
                this.detailAggrItems.add(new InputAction());
                this.detailAggrItems.add(new DimensionAction());
                this.detailAggrItems.add(new MeasuresAction());
                this.detailAggrItems.add(new ExternalTableAction());
                this.detailAggrItems.add(this.mapMeasuresAction);
                this.detailAggrItems.add(this.storedAggrAction);
                this.detailAggrItems.add(new InternalAggregationAction());
                this.detailAggrItems.add(new SummaryAction());
            }
            this.currentTypeList = this.detailAggrItems;
        } else if (this.whatTypeCube == 2) {
            if (this.starItems == null) {
                this.starItems = new ArrayList();
                this.starItems.add(new GeneralAction());
                this.starItems.add(new InputAction());
                this.starItems.add(new DimTableAction());
                this.starItems.add(new DimensionAction());
                this.starItems.add(new MeasuresAction());
                this.starItems.add(new AggregationAction());
                this.starItems.add(new SummaryAction());
            }
            this.currentTypeList = this.starItems;
        } else if (this.whatTypeCube == 5) {
            if (this.starMLSItems == null) {
                this.starMLSItems = new ArrayList();
                this.starMLSItems.add(new GeneralAction());
                this.starMLSItems.add(new InputAction());
                this.starMLSItems.add(new DimTableAction());
                this.starMLSItems.add(new DimensionAction());
                this.starMLSItems.add(new MeasuresAction());
                this.starMLSItems.add(new AggregationAction());
                this.starMLSItems.add(new MLSCaptionAction());
                this.starMLSItems.add(new SummaryAction());
            }
            this.currentTypeList = this.starMLSItems;
        } else if (this.whatTypeCube == 6) {
            if (this.starAggrMLSItems == null) {
                this.starAggrMLSItems = new ArrayList();
                this.starAggrMLSItems.add(new GeneralAction());
                this.starAggrMLSItems.add(new InputAction());
                this.starAggrMLSItems.add(new DimTableAction());
                this.starAggrMLSItems.add(new DimensionAction());
                this.starAggrMLSItems.add(new MeasuresAction());
                this.starAggrMLSItems.add(new ExternalTableAction());
                this.starAggrMLSItems.add(this.mapMeasuresAction);
                this.starAggrMLSItems.add(this.storedAggrAction);
                this.starAggrMLSItems.add(new InternalAggregationAction());
                this.starAggrMLSItems.add(new MLSCaptionAction());
                this.starAggrMLSItems.add(new SummaryAction());
            }
            this.currentTypeList = this.starAggrMLSItems;
        } else if (this.whatTypeCube == 3) {
            if (this.starAggrItems == null) {
                this.starAggrItems = new ArrayList();
                this.starAggrItems.add(new GeneralAction());
                this.starAggrItems.add(new InputAction());
                this.starAggrItems.add(new DimTableAction());
                this.starAggrItems.add(new DimensionAction());
                this.starAggrItems.add(new MeasuresAction());
                this.starAggrItems.add(new ExternalTableAction());
                this.starAggrItems.add(this.mapMeasuresAction);
                this.starAggrItems.add(this.storedAggrAction);
                this.starAggrItems.add(new InternalAggregationAction());
                this.starAggrItems.add(new SummaryAction());
            }
            this.currentTypeList = this.starAggrItems;
        } else if (this.whatTypeCube == 4) {
            if (this.fullyItems == null) {
                this.fullyItems = new ArrayList();
                this.fullyItems.add(new GeneralAction());
                this.fullyItems.add(new InputAction());
                this.fullyItems.add(new DimensionAction());
                this.fullyItems.add(new StoredMeasuresAction());
                this.fullyItems.add(new AssignMeasuresAction());
                this.fullyItems.add(new DerivedMeasuresAction());
                this.fullyItems.add(new MeasureDetailAction());
                this.fullyItems.add(new ExternalTableAction());
                this.fullyItems.add(new StoredAggrAction());
                this.fullyItems.add(new InternalAggregationAction());
                this.fullyItems.add(new SummaryAction());
            }
            this.currentTypeList = this.fullyItems;
        }
    }

    private void checkForNoAggrTables(WizardTabInfo currentPanel, String nameOfPanel) {
        if (nameOfPanel.equals(AGGRTABLES) && currentPanel.getTab().getConditionState().equals("NOAGGRS")) {
            this.whatTypeCube = this.getTypeLoad();
            if (this.whatTypeCube == 1 || this.whatTypeCube == 6 || this.whatTypeCube == 3) {
                this.currentTypeList.remove(this.storedAggrAction);
                this.currentTypeList.remove(this.mapMeasuresAction);
                this.noAggrsSelected = true;
            }
        } else if (nameOfPanel.equals(AGGRTABLES) && this.noAggrsSelected && currentPanel.getTab().getConditionState().equals("NOTNWAY")) {
            this.whatTypeCube = this.getTypeLoad();
            if (this.whatTypeCube == 1) {
                if (!this.currentTypeList.contains(this.mapMeasuresAction)) {
                    this.currentTypeList.add(5, this.mapMeasuresAction);
                }
                if (!this.currentTypeList.contains(this.storedAggrAction)) {
                    this.currentTypeList.add(6, this.storedAggrAction);
                }
            } else if (this.whatTypeCube == 6 || this.whatTypeCube == 3) {
                if (!this.currentTypeList.contains(this.mapMeasuresAction)) {
                    this.currentTypeList.add(6, this.mapMeasuresAction);
                }
                if (!this.currentTypeList.contains(this.storedAggrAction)) {
                    this.currentTypeList.add(7, this.storedAggrAction);
                }
            }
        } else if (nameOfPanel.equals(USERAGGRS)) {
            this.whatTypeCube = this.getTypeLoad();
            if (this.whatTypeCube == 1 || this.whatTypeCube == 6 || this.whatTypeCube == 3) {
                AggregationSet aggregationSet = this.olapCube.getAggregationSet();
                try {
                    OLAPList aggregationTables = aggregationSet.getTables();
                    if (aggregationTables == null || aggregationTables.isEmpty()) {
                        this.currentTypeList.remove(this.storedAggrAction);
                        this.currentTypeList.remove(this.mapMeasuresAction);
                        this.noAggrsSelected = true;
                    } else if (this.whatTypeCube == 1) {
                        if (!this.currentTypeList.contains(this.mapMeasuresAction)) {
                            this.currentTypeList.add(5, this.mapMeasuresAction);
                        }
                        if (!this.currentTypeList.contains(this.storedAggrAction)) {
                            this.currentTypeList.add(6, this.storedAggrAction);
                        }
                    } else if (this.whatTypeCube == 6 || this.whatTypeCube == 3) {
                        if (!this.currentTypeList.contains(this.mapMeasuresAction)) {
                            this.currentTypeList.add(6, this.mapMeasuresAction);
                        }
                        if (!this.currentTypeList.contains(this.storedAggrAction)) {
                            this.currentTypeList.add(7, this.storedAggrAction);
                        }
                    }
                }
                catch (OLAPException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
            }
        } else if (nameOfPanel.equals(MEASUREMAP) || nameOfPanel.equals(RUSERAGGS)) {
            if (this.whatTypeCube == 1) {
                if (!this.currentTypeList.contains(this.mapMeasuresAction)) {
                    this.currentTypeList.add(5, this.mapMeasuresAction);
                }
                if (!this.currentTypeList.contains(this.storedAggrAction)) {
                    this.currentTypeList.add(6, this.storedAggrAction);
                }
            } else if (this.whatTypeCube == 6 || this.whatTypeCube == 3) {
                if (!this.currentTypeList.contains(this.mapMeasuresAction)) {
                    this.currentTypeList.add(6, this.mapMeasuresAction);
                }
                if (!this.currentTypeList.contains(this.storedAggrAction)) {
                    this.currentTypeList.add(7, this.storedAggrAction);
                }
            }
        }
    }

    private boolean disableEnableCube(int enableOrDisable) {
        boolean didItWork = false;
        try {
            Workspace workspace = Workspace.getWorkspace();
            workspace.setCursor(Cursor.getPredefinedCursor(3));
            List listOfServers = ModelUtilities.getServersForCube((OLAPCube)this.olapCube);
            String name = this.olapCube.getName();
            int count = 0;
            int numServers = listOfServers.size();
            if (listOfServers != null && listOfServers.size() > 0) {
                for (int i = 0; i < numServers; ++i) {
                    OlapServer olapServer = null;
                    LogicalServer server = (LogicalServer)listOfServers.get(i);
                    olapServer = new OlapServer(server);
                    if (enableOrDisable == 0) {
                        olapServer.disableCube(name);
                    } else {
                        olapServer.enableCube(name);
                    }
                    ++count;
                }
            }
            if (count == numServers) {
                didItWork = true;
            }
        }
        catch (OLAPException error) {
            WsLogPropertyTab logPropertyTab = new WsLogPropertyTab(1);
            try {
                LogListHolder logData = this.server.getLog();
                logPropertyTab.appendText(logData);
                logPropertyTab.scrollToTop();
                SavePanel panel = new SavePanel((WAPanel)logPropertyTab);
                panel.setPreferredSize(new Dimension(400, 350));
                panel.setSaveActionListener((ActionListener)new SaveSasLogActionListener(logData));
                MessageUtil.displayDetailsMessage((String)error.getLocalizedMessage(), (int)0, (JComponent)panel);
            }
            catch (WsAppServerFailException e3) {
                ExceptionHandler.handleException((Exception)((Object)e3));
            }
            return false;
        }
        return didItWork;
    }

    private void cleanup() {
        MdObjectStore objectStore = (MdObjectStore)this.getWizardData("OBJECTSTORE");
        if (objectStore != null) {
            try {
                objectStore.dispose();
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        objectStore = null;
        this.addWizardData("OBJECTSTORE", null);
        if (this.server != null) {
            this.wsRunCode.term();
        }
        this.server = null;
    }

    protected class NewComboButton
    extends ComboButton {
        private static final long serialVersionUID = 1L;

        public NewComboButton(Action actDefault, ArrayList alOptionActions) {
            super(actDefault, alOptionActions);
        }

        protected JButton createOptionsButton(MouseListener lsnrMouse) {
            JButton btnOptions = new JButton(bundle.getImageIcon("Common.ComboButton.Icon.Arrow.image"));
            btnOptions.setMargin(new Insets(1, 1, 1, 1));
            btnOptions.setBorder(new CompoundBorder((Border)new ComboButton.cButtonBorder((ComboButton)this, false), new BasicBorders.MarginBorder()));
            btnOptions.addMouseListener(lsnrMouse);
            btnOptions.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    if (CubeDesigner.this.okNext) {
                        NewComboButton.this.displayMenu();
                    }
                }
            });
            return btnOptions;
        }
    }

    protected class SummaryAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public SummaryAction() {
            super(bundle, "CubeDesigner.Summary.action.label", 256);
        }

        public boolean cubeIsOk() {
            try {
                OLAPList listOfMeasures = CubeDesigner.this.measureSet.getMeasures();
                if (listOfMeasures.size() < 1) {
                    return false;
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            CubeDesigner.this.movePanel(this);
        }
    }

    protected class MLSCaptionAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public MLSCaptionAction() {
            super(bundle, "CubeDesigner.MLSCaption.action.label", 256);
        }

        public boolean cubeIsOk() {
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            CubeDesigner.this.movePanel(this);
        }
    }

    protected class InternalAggregationAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public InternalAggregationAction() {
            super(bundle, "CubeDesigner.InternalAggregations.action.label", 256);
        }

        public boolean cubeIsOk() {
            try {
                OLAPList listOfMeasures = CubeDesigner.this.measureSet.getMeasures();
                if (listOfMeasures.size() < 1) {
                    return false;
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            CubeDesigner.this.movePanel(this);
        }
    }

    protected class AggregationAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public AggregationAction() {
            super(bundle, "CubeDesigner.Aggregations.action.label", 256);
        }

        public boolean cubeIsOk() {
            try {
                OLAPList listOfMeasures = CubeDesigner.this.measureSet.getMeasures();
                if (listOfMeasures.size() < 1) {
                    return false;
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            CubeDesigner.this.movePanel(this);
        }
    }

    class StoredAggrAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public StoredAggrAction() {
            super(bundle, "CubeDesigner.StoredAggregations.action.label", 256);
        }

        public boolean cubeIsOk() {
            try {
                OLAPList listOfAggregationTables = CubeDesigner.this.aggregationSet.getTables();
                if ((CubeDesigner.this.whatTypeCube == 3 || CubeDesigner.this.whatTypeCube == 1 || CubeDesigner.this.whatTypeCube == 6) && listOfAggregationTables.size() < 1) {
                    return false;
                }
                if (CubeDesigner.this.whatTypeCube == 3 || CubeDesigner.this.whatTypeCube == 1 || CubeDesigner.this.whatTypeCube == 6) {
                    OLAPList listOfMeasures = CubeDesigner.this.measureSet.getMeasures();
                    AggregationTable table = (AggregationTable)listOfAggregationTables.get(0);
                    int size = listOfMeasures.size();
                    for (int i = 0; i < size; ++i) {
                        OLAPMeasure measure = (OLAPMeasure)listOfMeasures.get(i);
                        Boolean isStored = measure.isStoredStatistic();
                        if (isStored == null) {
                            return false;
                        }
                        if (!isStored.booleanValue() || measure.getAggregateColumn(table) != null) continue;
                        return false;
                    }
                } else if (CubeDesigner.this.whatTypeCube == 4 && listOfAggregationTables.size() < 1) {
                    return false;
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            CubeDesigner.this.movePanel(this);
        }
    }

    class MapMeasuresAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public MapMeasuresAction() {
            super(bundle, "CubeDesigner.MapMeasures.action.label", 256);
        }

        public boolean cubeIsOk() {
            try {
                OLAPList listOfAggregationTables = CubeDesigner.this.aggregationSet.getTables();
                if (listOfAggregationTables.size() < 1) {
                    return false;
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            CubeDesigner.this.movePanel(this);
        }
    }

    protected class MeasureDetailAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public MeasureDetailAction() {
            super(bundle, "CubeDesigner.MeasureDetails.action.label", 256);
        }

        public boolean cubeIsOk() {
            try {
                OLAPList listOfStoredMeasures = CubeDesigner.this.measureSet.getMeasures();
                if (listOfStoredMeasures.size() < 1) {
                    return false;
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            CubeDesigner.this.movePanel(this);
        }
    }

    protected class DerivedMeasuresAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public DerivedMeasuresAction() {
            super(bundle, "CubeDesigner.SelectDerivedMeasures.action.label", 256);
        }

        public boolean cubeIsOk() {
            try {
                OLAPList listOfStoredMeasures = CubeDesigner.this.measureSet.getMeasures();
                if (listOfStoredMeasures.size() < 1) {
                    return false;
                }
                int size = listOfStoredMeasures.size();
                for (int i = 0; i < size; ++i) {
                    OLAPMeasure measure = (OLAPMeasure)listOfStoredMeasures.get(i);
                    Boolean isStored = measure.isStoredStatistic();
                    if (isStored == null) {
                        return false;
                    }
                    if (!isStored.booleanValue() || measure.getStatistic() != null && measure.getGroupName() != null) continue;
                    return false;
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            CubeDesigner.this.movePanel(this);
        }
    }

    protected class AssignMeasuresAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public AssignMeasuresAction() {
            super(bundle, "CubeDesigner.AssignStoredMeasures.action.label", 256);
        }

        public boolean cubeIsOk() {
            try {
                OLAPList listOfStoredMeasures = CubeDesigner.this.measureSet.getMeasures();
                if (listOfStoredMeasures.size() < 1) {
                    return false;
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            CubeDesigner.this.movePanel(this);
        }
    }

    protected class StoredMeasuresAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public StoredMeasuresAction() {
            super(bundle, "CubeDesigner.SelectStoredMeasures.action.label", 256);
        }

        public boolean cubeIsOk() {
            try {
                OLAPList listOfDimensions = CubeDesigner.this.dimensionSet.getCubeDimensions();
                if (listOfDimensions.size() < 1) {
                    return false;
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            CubeDesigner.this.movePanel(this);
        }
    }

    protected class ExternalTableAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public ExternalTableAction() {
            super(bundle, "CubeDesigner.ExternalAggregationsTables.action.label", 256);
        }

        public boolean cubeIsOk() {
            try {
                OLAPList listOfMeasures = CubeDesigner.this.measureSet.getMeasures();
                if (listOfMeasures.size() < 1) {
                    return false;
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            CubeDesigner.this.movePanel(this);
        }
    }

    protected class MeasuresAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public MeasuresAction() {
            super(bundle, "CubeDesigner.Measures.action.label", 256);
        }

        public boolean cubeIsOk() {
            try {
                List listOfDimensions = CubeDesigner.this.dimensionSet.getAllCubeDimensions();
                if (listOfDimensions.size() < 1) {
                    return false;
                }
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                return false;
            }
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            CubeDesigner.this.movePanel(this);
        }
    }

    protected class DimensionAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public DimensionAction() {
            super(bundle, "CubeDesigner.Dimension.action.label", 256);
        }

        public boolean cubeIsOk() {
            try {
                LoadTable loadTable = CubeDesigner.this.tableSet.getLoadTable();
                return loadTable != null && loadTable.getTable() != null;
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                return false;
            }
        }

        public void actionPerformed(ActionEvent e) {
            CubeDesigner.this.movePanel(this);
        }
    }

    protected class DimTableAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public DimTableAction() {
            super(bundle, "CubeDesigner.DimensionTables.label", 256);
        }

        public boolean cubeIsOk() {
            try {
                LoadTable loadTable = CubeDesigner.this.tableSet.getLoadTable();
                return loadTable != null && loadTable.getTable() != null;
            }
            catch (OLAPException oError) {
                ExceptionHandler.handleException((Exception)((Object)oError));
                return false;
            }
        }

        public void actionPerformed(ActionEvent e) {
            CubeDesigner.this.movePanel(this);
        }
    }

    protected class InputAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public InputAction() {
            super(bundle, "CubeDesigner.Input.action.label", 256);
        }

        public boolean cubeIsOk() {
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            CubeDesigner.this.movePanel(this);
        }
    }

    protected class GeneralAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public GeneralAction() {
            super(bundle, "CubeDesigner.General.action.label", 256);
        }

        public boolean cubeIsOk() {
            return true;
        }

        public void actionPerformed(ActionEvent e) {
            CubeDesigner.this.movePanel(this);
        }
    }

    protected class cWizardButtonsPaneLayout
    implements LayoutManager {
        protected static final int cxSmallButtonGap = 7;
        protected static final int cxLargeButtonGap = 20;
        protected static final int cxTotalButtonGap = 67;
        private static final int wTinyButtonGap = 1;
        private static final int wLargeButtonGap = 12;
        private static final int wSmallButtonGap = 5;

        protected cWizardButtonsPaneLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component c) {
        }

        @Override
        public void removeLayoutComponent(Component c) {
        }

        @Override
        public Dimension preferredLayoutSize(Container c) {
            int wTotalButtonGap = 67;
            int nButtons = 6;
            if (WAWizardDialog.isUsingNewStyle()) {
                if (!CubeDesigner.this.canFinishEarly()) {
                    --nButtons;
                    wTotalButtonGap = 18;
                } else {
                    wTotalButtonGap = 30;
                }
            }
            Dimension dimButton = this.getPreferredButtonSize();
            Dimension dimLayout = new Dimension(dimButton.width * nButtons + wTotalButtonGap, dimButton.height);
            Insets insContainer = c.getInsets();
            dimLayout.width += insContainer.left + insContainer.right;
            dimLayout.height += insContainer.top + insContainer.bottom;
            return dimLayout;
        }

        @Override
        public Dimension minimumLayoutSize(Container c) {
            return this.preferredLayoutSize(c);
        }

        @Override
        public void layoutContainer(Container c) {
            Insets insContainer = c.getInsets();
            boolean bLeftToRight = CubeDesigner.this.getComponentOrientation().isLeftToRight();
            int cxPanel = c.getWidth();
            Dimension dimButton = this.getPreferredButtonSize();
            int cxButton = dimButton.width;
            int cyButton = dimButton.height;
            if (!WAWizardDialog.isUsingNewStyle()) {
                int xBtn = bLeftToRight ? insContainer.left : cxPanel - insContainer.right - cxButton;
                CubeDesigner.this.m_btnHelp.setBounds(xBtn, insContainer.top, cxButton, cyButton);
                xBtn = bLeftToRight ? cxPanel - insContainer.right - cxButton : insContainer.left;
                CubeDesigner.this.m_btnFinish.setBounds(xBtn, insContainer.top, cxButton, cyButton);
                CubeDesigner.this.next.setBounds(xBtn += bLeftToRight ? -(cxButton + 20) : cxButton + 20, insContainer.top, cxButton, cyButton);
                CubeDesigner.this.m_btnBack.setBounds(xBtn += bLeftToRight ? -(cxButton + 7) : cxButton + 7, insContainer.top, cxButton, cyButton);
                CubeDesigner.this.m_btnCancel.setBounds(xBtn += bLeftToRight ? -(cxButton + 20) : cxButton + 20, insContainer.top, cxButton, cyButton);
            } else {
                int xBtn = bLeftToRight ? cxPanel - insContainer.right - cxButton : insContainer.left;
                CubeDesigner.this.m_btnHelp.setBounds(xBtn, insContainer.top, cxButton, cyButton);
                CubeDesigner.this.m_btnCancel.setBounds(xBtn += bLeftToRight ? -(cxButton + 5) : cxButton + 5, insContainer.top, cxButton, cyButton);
                CubeDesigner.this.m_btnFinish.setBounds(xBtn += bLeftToRight ? -(cxButton + 12) : cxButton + 12, insContainer.top, cxButton, cyButton);
                if (CubeDesigner.this.canFinishEarly()) {
                    xBtn += bLeftToRight ? -(cxButton + 12) : cxButton + 12;
                }
                CubeDesigner.this.next.setBounds(xBtn, insContainer.top, cxButton, cyButton);
                CubeDesigner.this.m_btnBack.setBounds(xBtn += bLeftToRight ? -(cxButton + 1) : cxButton + 1, insContainer.top, cxButton, cyButton);
                xBtn += bLeftToRight ? -(cxButton + 12) : cxButton + 1;
            }
        }

        protected Dimension getPreferredButtonSize() {
            cMaxDimension dim = new cMaxDimension(0, 0);
            dim.max(CubeDesigner.this.m_btnHelp.getPreferredSize());
            dim.max(CubeDesigner.this.next.getPreferredSize());
            dim.max(CubeDesigner.this.m_btnBack.getPreferredSize());
            dim.max(CubeDesigner.this.m_btnFinish.getPreferredSize());
            dim.max(CubeDesigner.this.m_btnCancel.getPreferredSize());
            return dim;
        }

        protected class cMaxDimension
        extends Dimension {
            private static final long serialVersionUID = 1L;

            public cMaxDimension(int Width, int Height) {
                super(Width, Height);
            }

            public void max(Dimension dim) {
                this.width = Math.max(this.width, dim.width);
                this.height = Math.max(this.height, dim.height);
            }
        }
    }

    class UpdateMetadata
    implements Runnable {
        OLAPCube cubeModel;
        public boolean returnValue = true;

        public UpdateMetadata(OLAPCube cubeModel) {
            this.cubeModel = cubeModel;
        }

        private void updateCubePaths() throws OLAPException {
            Vector cubePaths = VisualUtilities.getCubePaths();
            String cubePath = this.cubeModel.getPath();
            cubePaths.remove(cubePath);
            cubePaths.add(0, cubePath);
            VisualUtilities.setCubePaths();
        }

        private void updateWorkPaths() throws OLAPException {
            Vector workPaths = (Vector)CubeDesigner.this.getWizardData("WORKPATHS");
            if (workPaths != null) {
                String workPath = this.cubeModel.getWorkPath();
                if (!ModelUtilities.isBlank((String)workPath)) {
                    workPaths.remove(workPath);
                    workPaths.add(0, workPath);
                }
                VisualUtilities.setWorkPaths(workPaths);
            }
        }

        private void updateGlobalDataPaths() {
            Vector paths = (Vector)CubeDesigner.this.getWizardData("GLOBALDATAPATHS");
            if (paths != null) {
                VisualUtilities.setGlobalDataPaths(paths);
            }
        }

        private void updateAggregationDataPaths() {
            Vector paths = (Vector)CubeDesigner.this.getWizardData("AGGREGATIONDATAPATHS");
            if (paths != null) {
                VisualUtilities.setAggregationDataPaths(paths);
            }
        }

        private void updateGlobalIndexPaths() {
            Vector paths = (Vector)CubeDesigner.this.getWizardData("GLOBALINDEXPATHS");
            if (paths != null) {
                VisualUtilities.setGlobalIndexPaths(paths);
            }
        }

        private void updateAggregationIndexPaths() {
            Vector paths = (Vector)CubeDesigner.this.getWizardData("AGGREGATIONINDEXPATHS");
            if (paths != null) {
                VisualUtilities.setAggregationIndexPaths(paths);
            }
        }

        private void updateDataPaths() {
            this.updateGlobalDataPaths();
            this.updateAggregationDataPaths();
        }

        private void updateIndexPaths() {
            this.updateGlobalIndexPaths();
            this.updateAggregationIndexPaths();
        }

        private void updateDefaultPaths() throws OLAPException {
            this.updateCubePaths();
            this.updateWorkPaths();
            this.updateDataPaths();
            this.updateIndexPaths();
        }

        private void updateDefaultOLAPSchema() throws OLAPException {
            ModelUtilities.setDefaultOLAPSchema((OLAPSchema)this.cubeModel.getAssociatedOLAPSchema());
        }

        private void updateDefaultFolder() throws OLAPException {
            ModelUtilities.setDefaultFolder((Tree)this.cubeModel.getFolder());
        }

        private void updateDefaults() throws OLAPException {
            this.updateDefaultPaths();
            this.updateDefaultOLAPSchema();
            this.updateDefaultFolder();
        }

        @Override
        public void run() {
            try {
                this.cubeModel.updateMetadata();
                this.updateDefaults();
            }
            catch (OLAPException OLAPError) {
                this.returnValue = ExceptionHandler.handleException((Exception)((Object)OLAPError));
            }
        }

        public boolean getReturnValue() {
            return this.returnValue;
        }
    }

    private final class NextDropDownArrowListener
    implements ActionListener {
        private NextDropDownArrowListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            WizardTabInfo currentPanel = CubeDesigner.this.m_WizardModel.getCurrent();
            String nameOfPanel = currentPanel.getTabName();
            CubeDesigner.this.okNext = currentPanel.getTab().validateData();
            if (CubeDesigner.this.okNext) {
                boolean tableHasNotChanged = true;
                if (nameOfPanel.equalsIgnoreCase(CubeDesigner.GENERAL)) {
                    CubeDesigner.this.m_WizardModel.next();
                    WizardTabInfo nextPanel = CubeDesigner.this.m_WizardModel.getCurrent();
                    CubeInputTab inputTab = (CubeInputTab)nextPanel.getTab();
                    tableHasNotChanged = !inputTab.hasTreeDataChanged();
                    CubeDesigner.this.m_WizardModel.prev();
                }
                CubeDesigner.this.whatTypeCube = CubeDesigner.this.getTypeLoad();
                if (CubeDesigner.this.whatTypeCube != CubeDesigner.this.previousCubeType) {
                    CubeDesigner.this.createNextList();
                    CubeDesigner.this.next.setOptionActions((ArrayList)CubeDesigner.this.currentTypeList);
                    CubeDesigner.this.checkForNoAggrTables(currentPanel, nameOfPanel);
                    CubeDesigner.this.previousCubeType = CubeDesigner.this.whatTypeCube;
                } else {
                    CubeDesigner.this.checkForNoAggrTables(currentPanel, nameOfPanel);
                }
                CubeDesigner.this.enableDisableOptions(tableHasNotChanged);
            }
        }
    }

    private final class SaveButtonListener
    implements ActionListener {
        private SaveButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            WizardTabInfo currentPanel = CubeDesigner.this.m_WizardModel.getCurrent();
            boolean canExportcode = currentPanel.getTab().validateData();
            if (canExportcode) {
                Workspace m_workspace = Workspace.getWorkspace();
                CubeSaveProcOlapDialog saveProcDialog = new CubeSaveProcOlapDialog(m_workspace, bundle.getString("SaveProcCode.Title.txt"), (AbstractOLAPModel)CubeDesigner.this.olapCube);
                saveProcDialog.show();
            }
        }
    }
}

