/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.designer.visuals;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.AggregationTable;
import com.sas.olapadmin.designer.model.DimensionSet;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.model.TableSet;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.studio.PhysicalTableSelector;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

public class CubeAggregationTablesPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(CubeAggregationTablesPanel.class);
    private PhysicalTableSelector tree;
    private OLAPCube olapCube;
    public String conditionState;
    private boolean initialized;
    private OLAPList aggregationTables;
    private List physicalTables;
    private AggregationSet aggregationSet;
    private TableSet tableSet;
    private List removedROLAPAggregations;
    private List removedPhysicalTables;

    public CubeAggregationTablesPanel(OLAPCube inputOlapCube) {
        this.olapCube = inputOlapCube;
        this.setLayout(new GridBagLayout());
        this.layoutWidgets();
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (!saveToModel && Utilities.isConnectedToMetadataServer((boolean)true) && !this.initialized) {
            this.aggregationSet = this.olapCube.getAggregationSet();
            this.tableSet = this.olapCube.getTableSet();
            try {
                this.aggregationTables = this.aggregationSet.getTables();
                this.physicalTables = new ArrayList();
                int size = this.aggregationTables.size();
                for (int i = 0; i < size; ++i) {
                    AggregationTable aggrTable = (AggregationTable)this.aggregationTables.get(i);
                    this.physicalTables.add(aggrTable.getTable());
                }
            }
            catch (OLAPException e) {
                return ExceptionHandler.handleException((Exception)((Object)e));
            }
            try {
                if (!this.physicalTables.isEmpty()) {
                    this.tree.initializeSelectedTables(this.physicalTables);
                }
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.tree.populateStore();
                this.tree.moveDataToView();
                this.setCursor(Cursor.getPredefinedCursor(0));
                this.initialized = true;
            }
            catch (MdException mdError) {
                ExceptionHandler.handleException((Exception)((Object)new OLAPException(mdError.getLocalizedMessage(), (Throwable)mdError, 12)));
            }
            catch (RemoteException re) {
                Workspace.handleRemoteException((RemoteException)re);
            }
        }
        return true;
    }

    public void onBack() {
        try {
            int i;
            ArrayList tables;
            if (this.removedROLAPAggregations == null) {
                this.removedROLAPAggregations = new ArrayList();
            }
            if (this.removedPhysicalTables == null) {
                this.removedPhysicalTables = new ArrayList();
            }
            if ((tables = this.tree.getSelectedTables()) == null) {
                tables = new ArrayList();
            }
            if (this.aggregationTables != null) {
                int iSize = this.aggregationTables.size();
                for (i = 0; i < iSize; ++i) {
                    AggregationTable aggrTable = (AggregationTable)this.aggregationTables.get(i);
                    PhysicalTable rolapTable = aggrTable.getTable();
                    if (tables.contains(rolapTable)) continue;
                    try {
                        this.removedPhysicalTables.add(rolapTable);
                        OLAPList rolapAggregations = this.aggregationSet.getAggregationsByTable(aggrTable);
                        if (rolapAggregations == null) continue;
                        int jSize = rolapAggregations.size();
                        for (int j = 0; j < jSize; ++j) {
                            this.removedROLAPAggregations.add(rolapAggregations.get(j));
                        }
                        continue;
                    }
                    catch (OLAPException error) {
                        ExceptionHandler.handleException((Exception)((Object)error));
                    }
                }
            }
            if (tables != null) {
                if (this.aggregationTables != null) {
                    this.aggregationTables.clear();
                } else if (!tables.isEmpty()) {
                    this.aggregationTables = this.aggregationSet.getTables();
                }
                int size = tables.size();
                for (i = 0; i < size; ++i) {
                    try {
                        AggregationTable table = this.tableSet.getAggregationTable((PhysicalTable)tables.get(i));
                        if (!table.hasValidAggregateColumns()) continue;
                        this.aggregationTables.add((Object)table);
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    public boolean validateData() {
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) {
            return false;
        }
        ArrayList tables = this.tree.getSelectedTables();
        if (tables == null) {
            tables = new ArrayList();
        }
        try {
            this.aggregationTables = this.aggregationSet.getTables();
        }
        catch (OLAPException e) {
            return ExceptionHandler.handleException((Exception)((Object)e));
        }
        if (this.removedROLAPAggregations == null) {
            this.removedROLAPAggregations = new ArrayList();
        }
        if (this.removedPhysicalTables == null) {
            this.removedPhysicalTables = new ArrayList();
        }
        int iSize = this.aggregationTables.size();
        for (int i = 0; i < iSize; ++i) {
            AggregationTable aggrTable = (AggregationTable)this.aggregationTables.get(i);
            PhysicalTable rolapTable = aggrTable.getTable();
            if (tables.contains(rolapTable)) continue;
            try {
                this.removedPhysicalTables.add(rolapTable);
                OLAPList rolapAggregations = this.aggregationSet.getAggregationsByTable(aggrTable);
                if (rolapAggregations == null) continue;
                int jSize = rolapAggregations.size();
                for (int j = 0; j < jSize; ++j) {
                    this.removedROLAPAggregations.add(rolapAggregations.get(j));
                }
                continue;
            }
            catch (OLAPException error) {
                return ExceptionHandler.handleException((Exception)((Object)error));
            }
        }
        if (!this.removedROLAPAggregations.isEmpty()) {
            String errorMessage = bundle.formatString("CubeDesigner.RemoveROLAPAggregation.txt", (Object)this.removedPhysicalTables.toString());
            int option = MessageUtil.displayMessage((String)errorMessage, (int)2, (int)2);
            if (option == 0) {
                int size = this.removedROLAPAggregations.size();
                for (int i = 0; i < size; ++i) {
                    try {
                        OLAPAggregation nextAggregation = (OLAPAggregation)this.removedROLAPAggregations.get(i);
                        nextAggregation.delete();
                        continue;
                    }
                    catch (OLAPException error) {
                        this.removedROLAPAggregations.clear();
                        this.removedPhysicalTables.clear();
                        return ExceptionHandler.handleException((Exception)((Object)error));
                    }
                }
            } else {
                this.removedROLAPAggregations.clear();
                this.removedPhysicalTables.clear();
                return false;
            }
        }
        this.removedROLAPAggregations.clear();
        this.removedPhysicalTables.clear();
        this.aggregationTables.clear();
        ArrayList<AggregationTable> badTables = new ArrayList<AggregationTable>();
        int size = tables.size();
        for (int i = 0; i < size; ++i) {
            try {
                AggregationTable table = this.tableSet.getAggregationTable((PhysicalTable)tables.get(i));
                try {
                    if (table.hasValidAggregateColumns()) {
                        this.aggregationTables.add((Object)table);
                        continue;
                    }
                    badTables.add(table);
                    continue;
                }
                catch (IllegalArgumentException error) {
                    throw new OLAPException(bundle.formatString("CubeDesigner.AggregationTable.InvalidTable.NoColumns.fmt.txt", (Object)table), 0);
                }
                catch (IllegalStateException error) {
                    throw new OLAPException(bundle.formatString("CubeDesigner.AggregationTable.InvalidTable.NoColumns.fmt.txt", (Object)table), 0);
                }
            }
            catch (OLAPException error) {
                return ExceptionHandler.handleException((Exception)((Object)error));
            }
        }
        DimensionSet dimensionSet = this.olapCube.getDimensionSet();
        dimensionSet.setDimensionChanged(false);
        if (!badTables.isEmpty()) {
            StringBuffer tableNames = new StringBuffer();
            int size2 = badTables.size();
            for (int i = 0; i < size2; ++i) {
                AggregationTable table = (AggregationTable)badTables.get(i);
                tableNames.append(table.toString());
                if (i == size2 - 1) continue;
                tableNames.append(", ");
            }
            int option = MessageUtil.displayMessage((String)bundle.formatString("CubeDesigner.AggregationTable.InvalidTable.NoColumns.fmt.txt", (Object)tableNames.toString()), (int)2, (int)2);
            if (option == 0 && !this.aggregationTables.isEmpty()) {
                return true;
            }
            if (option == 2) {
                return false;
            }
        }
        if (this.aggregationTables.isEmpty()) {
            int option = MessageUtil.displayMessage((String)bundle.getString("CubeDesigner.UserAggregationsHolap.NoAggregationTables.txt"), (int)2, (int)2);
            return option == 0;
        }
        return true;
    }

    protected void layoutWidgets() {
        this.tree = new PhysicalTableSelector((AbstractOLAPModel)this.olapCube, -1, true, false, false, false, false);
        this.tree.setName("AggregationTablesSelection");
        this.add((Component)((Object)this.tree), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
    }

    public void saveSettingsAndCleanUp() {
        this.tree.saveSettingsAndCleanUp();
    }
}

