/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.cubeviewer;

import com.sas.metadata.remote.Cube;
import com.sas.olapadmin.cubeviewer.CubeViewerPanel;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.awt.Cursor;
import java.awt.Frame;

public class CubeViewerDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    protected static WAdminResource bundle = new WAdminResource(CubeViewerDialog.class);
    protected Cube cube;
    protected OlapServer olapServer;
    protected CubeViewerPanel memberpanel;
    private static WorkspaceFile fileAppDefaults = Workspace.getWorkspace().getAppDefaultsFile();

    public CubeViewerDialog(Workspace owner, String title, Cube cube, OlapServer olapServer) {
        super((Frame)owner, title, true);
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("cube_view_cube");
        this.setCloseButtonVisible(true);
        this.setOKButtonVisible(false);
        this.setCancelButtonVisible(false);
        this.setResizable(true);
        this.setApplyButtonVisible(true);
        this.cube = cube;
        this.olapServer = olapServer;
    }

    public void setMainPanel(CubeViewerPanel memberpanel) {
        this.memberpanel = memberpanel;
        super.setMainPanel((WAPanel)memberpanel);
    }

    protected void initialize() {
        super.initialize();
        VisualUtilities.setButtonTextAndMnemonic(this.m_btnApply, bundle.getString("CubeViewer.Reset.action.txt"));
        this.m_btnApply.setName("Reset");
        this.m_btnApply.setEnabled(true);
        this.m_btnApply.setToolTipText(bundle.getString("CubeViewer.Reset.action.tip"));
    }

    protected boolean onApply() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.memberpanel.applyReset();
        this.setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    protected boolean onCancel() {
        fileAppDefaults.setPropertyInt("ViewCube.height", this.getHeight());
        fileAppDefaults.setPropertyInt("ViewCube.width", this.getWidth());
        return true;
    }
}

