/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.calcmembers.formulas;

import com.sas.olapadmin.calcmembers.TimePeriodItem;
import com.sas.olapadmin.calcmembers.formulas.AbstractTimeFormula;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;

public class PeriodToDate
extends AbstractTimeFormula
implements ActionListener {
    private static WAdminResource bundle = new WAdminResource(PeriodToDate.class);
    private List timePeriods;
    private SpinnerNumberModel spinnerModel;
    private WAComboBox period;
    private JSpinner spinner;
    private JLabel spinnerLabel;
    private JFormattedTextField tf;

    public PeriodToDate(List inMeasures, List time, SpinnerNumberModel spinner, boolean sum) {
        super(inMeasures);
        this.timePeriods = time;
        this.spinnerModel = spinner;
        if (sum) {
            this.baseFormula = "Sum(<period>,<member>)";
            this.defaultName = bundle.getString("Sum.DefaultName.txt");
            this.label = bundle.getString("Sum.Label.txt");
        } else {
            this.baseFormula = "Avg(<period>,<member>)";
            this.defaultName = bundle.getString("Avg.DefaultName.txt");
            this.label = bundle.getString("Avg.Label.txt");
        }
    }

    @Override
    public JPanel getFormulaPanel() {
        super.getFormulaPanel();
        JLabel periodLabel = new JLabel(bundle.getString("TimeFormula.PeriodLabel.txt"));
        this.panel.add((Component)periodLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.period = new WAComboBox();
        periodLabel.setLabelFor((Component)this.period);
        int size = this.timePeriods.size();
        for (int i = 0; i < size; ++i) {
            this.period.addItem(this.timePeriods.get(i));
        }
        this.period.setSelectedIndex(0);
        this.period.setActionCommand("TIMEPERIOD");
        this.period.addActionListener((ActionListener)this);
        if (this.period.getItemCount() <= 0) {
            this.period.setEnabled(false);
        }
        this.panel.add((Component)this.period, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.spinnerLabel = new JLabel(bundle.getString("TimeFormula.NumberOfPeriodsLabel.txt"));
        this.panel.add((Component)this.spinnerLabel, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.spinner = new JSpinner(this.spinnerModel);
        this.spinnerLabel.setLabelFor(this.spinner);
        this.tf = ((JSpinner.NumberEditor)this.spinner.getEditor()).getTextField();
        this.tf.setColumns(4);
        if (this.period.getItemCount() == 1) {
            this.spinner.setVisible(true);
            this.spinnerLabel.setVisible(true);
        } else {
            this.spinner.setVisible(false);
            this.spinnerLabel.setVisible(false);
        }
        this.panel.add((Component)this.spinner, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 5, 10, 5), 0, 0));
        this.addLastField(this.panel);
        return this.panel;
    }

    @Override
    public String getFormulaText() {
        StringBuffer formulaText = new StringBuffer(super.getFormulaText());
        String timePeriod = "";
        TimePeriodItem item = (TimePeriodItem)this.period.getSelectedItem();
        String function = item.getFunction();
        timePeriod = function.equalsIgnoreCase("LastPeriods") ? function + "(" + this.spinner.getValue().toString() + ")" : function + "()";
        int start = formulaText.indexOf("<period>");
        while (start >= 0) {
            int end = start + 8;
            formulaText.replace(start, end, timePeriod);
            start = formulaText.indexOf("<period>", end);
        }
        return formulaText.toString();
    }

    @Override
    public boolean validateFormula() {
        boolean dataOK = super.validateFormula();
        if (this.period.getSelectedItem() == null) {
            MessageUtil.displayMessage((String)bundle.getString("Formula.MissingSelection.txt"), (int)0);
            dataOK = false;
        }
        return dataOK;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.period) {
            if (this.period.getSelectedIndex() == this.period.getItemCount() - 1) {
                this.spinner.setVisible(true);
                this.spinnerLabel.setVisible(true);
            } else {
                this.spinner.setVisible(false);
                this.spinnerLabel.setVisible(false);
            }
            WAComboBox obj = (WAComboBox)e.getSource();
            Object item = obj.getSelectedItem();
            WAWizardDialog parent = (WAWizardDialog)this.panel.getTopLevelAncestor();
            parent.addWizardData(obj.getActionCommand(), item);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public void refreshDisplay() {
        super.refreshDisplay();
        WAWizardDialog parent = (WAWizardDialog)this.panel.getTopLevelAncestor();
        Object item = parent.getWizardData("TIMEPERIOD");
        if (item != null) {
            this.period.setSelectedItem(item);
        }
    }
}

