/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.calcmembers.formulas;

import com.sas.olapadmin.calcmembers.formulas.AbstractFormula;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.studio.StructureTreeCellRenderer;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class DistinctCount
extends AbstractFormula
implements FocusListener {
    private static WAdminResource bundle = new WAdminResource(DistinctCount.class);
    private OLAPCube cube;
    private JTree tree;
    private static final String beginDistinct = "DistinctCount(";
    private static final String endDistinct = ".MEMBERS)";

    public DistinctCount(OLAPCube cube2) {
        this.defaultName = bundle.getString("DistinctCount.DefaultName.txt");
        this.label = bundle.getString("DistinctCount.Label.txt");
        this.cube = cube2;
    }

    @Override
    public String getFormulaText() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        Object userObject = node.getUserObject();
        String uniqueName = null;
        if (userObject instanceof OLAPDimension) {
            OLAPDimension selection = (OLAPDimension)userObject;
            uniqueName = selection.getUniqueName();
        } else if (userObject instanceof OLAPHierarchy) {
            OLAPHierarchy selection = (OLAPHierarchy)userObject;
            uniqueName = selection.getUniqueName();
        } else if (userObject instanceof OLAPLevel) {
            OLAPLevel selection = (OLAPLevel)userObject;
            uniqueName = selection.getUniqueName();
        }
        return beginDistinct + uniqueName + endDistinct;
    }

    @Override
    public JPanel getFormulaPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        DefaultMutableTreeNode cubeNode = new DefaultMutableTreeNode(this.cube);
        try {
            List dimensions = this.cube.getDimensionSet().getAllCubeDimensions();
            for (int i = 0; i < dimensions.size(); ++i) {
                OLAPDimension dimension = (OLAPDimension)dimensions.get(i);
                DefaultMutableTreeNode dimensionNode = new DefaultMutableTreeNode(dimension);
                cubeNode.add(dimensionNode);
                OLAPList hierarchies = dimension.getHierarchies();
                for (int j = 0; j < hierarchies.size(); ++j) {
                    OLAPHierarchy hierarchy = (OLAPHierarchy)hierarchies.get(j);
                    DefaultMutableTreeNode hierarchyNode = new DefaultMutableTreeNode(hierarchy);
                    dimensionNode.add(hierarchyNode);
                    OLAPList levels = hierarchy.getLevels();
                    for (int k = 0; k < levels.size(); ++k) {
                        OLAPLevel level = (OLAPLevel)levels.get(k);
                        DefaultMutableTreeNode levelNode = new DefaultMutableTreeNode(level);
                        hierarchyNode.add(levelNode);
                    }
                }
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        this.tree = new JTree(cubeNode);
        this.tree.setShowsRootHandles(true);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setCellRenderer(new StructureTreeCellRenderer());
        this.tree.addFocusListener(this);
        JScrollPane treePane = new JScrollPane(this.tree);
        treePane.setPreferredSize(new Dimension(100, 200));
        panel.add((Component)treePane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    public boolean validateFormula() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
        boolean dataOK = true;
        if (node == null) {
            dataOK = false;
            MessageUtil.displayMessage((String)bundle.getString("DistinctCount.NoSelection.txt"), (int)0);
        } else {
            Object userObject = node.getUserObject();
            if (userObject instanceof OLAPCube) {
                dataOK = false;
                MessageUtil.displayMessage((String)bundle.getString("DistinctCount.CubeNotAllowed.txt"), (int)0);
            }
        }
        return dataOK;
    }

    @Override
    public void refreshDisplay() {
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.tree.getMaxSelectionRow() < 0) {
            this.tree.setSelectionRow(0);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

