/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.calcmembers.formulas;

import com.sas.olapadmin.calcmembers.formulas.AbstractTimeFormula;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ComparePeriods
extends AbstractTimeFormula {
    private static WAdminResource bundle = new WAdminResource(ComparePeriods.class);
    private String timeDimensionName;
    private List timeHierarchies;
    private WAComboBox hierarchy;

    public ComparePeriods(List inMeasures, OLAPDimension timeDimension, List timeHiers, boolean parallel) {
        super(inMeasures);
        this.timeHierarchies = timeHiers;
        if (timeDimension != null) {
            this.timeDimensionName = timeDimension.getUniqueName();
        }
        if (!parallel) {
            this.defaultName = bundle.getString("CompareConsecutivePeriods.DefaultName.txt");
            this.label = bundle.getString("CompareConsecutivePeriods.Label.txt");
            this.baseFormula = "((<member>,<time>.CurrentMember) - (<member>,<time>.CurrentMember.PrevMember))";
        } else {
            this.defaultName = bundle.getString("CompareParallelPeriods.DefaultName.txt");
            this.label = bundle.getString("CompareParallelPeriods.Label.txt");
            this.baseFormula = "((<member>,<time>.CurrentMember) - (<member>,ParallelPeriod()))";
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WAComboBox obj = (WAComboBox)e.getSource();
        if (obj == this.hierarchy) {
            AbstractOLAPModel item = (AbstractOLAPModel)obj.getSelectedItem();
            WAWizardDialog parent = (WAWizardDialog)this.panel.getTopLevelAncestor();
            parent.addWizardData(obj.getActionCommand(), (Object)item);
        } else {
            super.actionPerformed(e);
        }
    }

    @Override
    public JPanel getFormulaPanel() {
        super.getFormulaPanel();
        JLabel hierarchyLabel = new JLabel(bundle.getString("TimeFormula.HierarchyLabel.txt"));
        this.panel.add((Component)hierarchyLabel, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 18, 2, new Insets(5, 5, 0, 5), 0, 0));
        this.hierarchy = new WAComboBox();
        hierarchyLabel.setLabelFor((Component)this.hierarchy);
        int size = this.timeHierarchies.size();
        for (int i = 0; i < size; ++i) {
            this.hierarchy.addItem(this.timeHierarchies.get(i));
        }
        this.hierarchy.setSelectedIndex(0);
        this.hierarchy.setActionCommand("TIMEHIERARCHY");
        this.hierarchy.addActionListener((ActionListener)this);
        this.panel.add((Component)this.hierarchy, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        this.addLastField(this.panel);
        return this.panel;
    }

    @Override
    public String getFormulaText() {
        StringBuffer formulaText = new StringBuffer(super.getFormulaText());
        String replaceString = this.timeDimensionName;
        if (this.timeHierarchies.size() > 1) {
            OLAPHierarchy selectedHierarchy = (OLAPHierarchy)this.hierarchy.getSelectedItem();
            replaceString = selectedHierarchy.getUniqueName();
        }
        int start = formulaText.indexOf("<time>");
        while (start >= 0) {
            int end = start + 6;
            formulaText.replace(start, end, replaceString);
            start = formulaText.indexOf("<time>", end);
        }
        return formulaText.toString();
    }

    @Override
    public void refreshDisplay() {
        super.refreshDisplay();
        WAWizardDialog parent = (WAWizardDialog)this.panel.getTopLevelAncestor();
        Object item = parent.getWizardData("TIMEHIERARCHY");
        if (item != null) {
            this.hierarchy.setSelectedItem(item);
        }
    }
}

