/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.calcmembers.formulas;

import com.sas.olapadmin.calcmembers.formulas.AbstractFormula;
import com.sas.olapadmin.designer.model.AbstractOLAPModel;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;

public abstract class AbstractTimeFormula
extends AbstractFormula
implements ActionListener {
    private static WAdminResource bundle = new WAdminResource(AbstractTimeFormula.class);
    protected String baseFormula = "<member>";
    private WAComboBox first;
    private List measures;
    protected JPanel panel;

    public AbstractTimeFormula(List inMeasures) {
        this.measures = inMeasures;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        WAComboBox obj = (WAComboBox)e.getSource();
        if (obj == this.first) {
            AbstractOLAPModel item = (AbstractOLAPModel)obj.getSelectedItem();
            WAWizardDialog parent = (WAWizardDialog)this.panel.getTopLevelAncestor();
            parent.addWizardData(obj.getActionCommand(), (Object)item);
        }
    }

    @Override
    public String getFormulaText() {
        StringBuffer formulaText = new StringBuffer(150);
        try {
            AbstractOLAPModel item = (AbstractOLAPModel)this.first.getSelectedItem();
            String uniqueName = this.getItemUniqueName(item);
            formulaText.append(this.baseFormula);
            int start = formulaText.indexOf("<member>");
            while (start >= 0) {
                int end = start + 8;
                formulaText.replace(start, end, uniqueName);
                start = formulaText.indexOf("<member>", end);
            }
        }
        catch (OLAPException e) {
            e.printStackTrace();
        }
        return formulaText.toString();
    }

    @Override
    public JPanel getFormulaPanel() {
        this.panel = new JPanel();
        this.panel.setLayout(new GridBagLayout());
        JLabel firstLabel = new JLabel(bundle.getString("TimeFormula.MeasureLabel.txt"));
        this.panel.add((Component)firstLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(10, 5, 0, 5), 0, 0));
        this.first = new WAComboBox();
        firstLabel.setLabelFor((Component)this.first);
        int size = this.measures.size();
        for (int i = 0; i < size; ++i) {
            this.first.addItem(this.measures.get(i));
        }
        this.first.setActionCommand("FIRST");
        this.first.setSelectedIndex(0);
        this.first.addActionListener((ActionListener)this);
        this.panel.add((Component)this.first, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 5, 5, 5), 0, 0));
        return this.panel;
    }

    public void addLastField(JPanel panel) {
        JLabel dummy = new JLabel("");
        panel.add((Component)dummy, new GridBagConstraints(0, -1, 1, 1, 0.0, 1.0, 18, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    public boolean validateFormula() {
        boolean dataOK = true;
        if (this.first.getSelectedItem() == null) {
            MessageUtil.displayMessage((String)bundle.getString("Formula.MissingSelection.txt"), (int)0);
            dataOK = false;
        }
        return dataOK;
    }

    @Override
    public void refreshDisplay() {
        WAWizardDialog parent = (WAWizardDialog)this.panel.getTopLevelAncestor();
        Object item = parent.getWizardData("FIRST");
        if (item != null) {
            this.first.setSelectedItem(item);
        }
    }
}

