/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.calcmembers;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDefinedMember;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAWizardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.rmi.RemoteException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class NewMemberTypeTab
extends WsDescriptionWizardTab {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(NewMemberTypeTab.class);
    private JRadioButton simple;
    private JRadioButton time;
    private JRadioButton custom;
    private ButtonGroup types;
    private OLAPDefinedMember calculation;

    public NewMemberTypeTab(OLAPDefinedMember calcObj) {
        super(bundle.getString("NewMemberWizard.Type.Instructions.txt"));
        this.calculation = calcObj;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("calculate_member_calc_type");
        this.layoutWidgets();
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this.types = new ButtonGroup();
        this.simple = new JRadioButton();
        VisualUtilities.setButtonTextAndMnemonic(this.simple, bundle.getString("NewMemberWizard.Type.Simple.txt"));
        this.simple.setActionCommand("SIMPLE");
        this.time = new JRadioButton();
        VisualUtilities.setButtonTextAndMnemonic(this.time, bundle.getString("NewMemberWizard.Type.Time.txt"));
        this.time.setActionCommand("TIME");
        this.custom = new JRadioButton();
        VisualUtilities.setButtonTextAndMnemonic(this.custom, bundle.getString("NewMemberWizard.Type.Custom.txt"));
        this.custom.setActionCommand("CUSTOM");
        this.types.add(this.simple);
        this.types.add(this.time);
        this.types.add(this.custom);
        this.simple.setSelected(true);
        this.add(this.simple, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.add(this.time, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.custom, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 0, 0, 0), 0, 0));
    }

    public String createFinishString() {
        OLAPCube cube = this.calculation.getOwningCube();
        String finishString1 = bundle.formatString("NewMemberWizard.Type.FinishInfo.fmt.txt", (Object)cube);
        String lineSeparator = System.getProperty("line.separator");
        int bufferLength = finishString1.length() + lineSeparator.length() * 2;
        StringBuffer finishString = new StringBuffer(bufferLength);
        finishString.append(finishString1).append(lineSeparator).append(lineSeparator);
        return finishString.toString();
    }

    public String getConditionState() {
        return this.types.getSelection().getActionCommand();
    }

    public boolean doDataExchange(boolean saveToModel) throws MdException, RemoteException {
        if (!saveToModel) {
            try {
                OLAPCube cube = this.calculation.getOwningCube();
                List dimensions = cube.getDimensionSet().getAllCubeDimensions();
                OLAPDimension timeDimension = null;
                for (int i = 0; i < dimensions.size() && timeDimension == null; ++i) {
                    OLAPDimension dimension = (OLAPDimension)dimensions.get(i);
                    if (!dimension.isTime()) continue;
                    timeDimension = dimension;
                }
                this.time.setEnabled(timeDimension != null);
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
        }
        return true;
    }

    public boolean validateData() {
        try {
            String type = this.types.getSelection().getActionCommand();
            if (type.equals("SIMPLE") || type.equals("TIME")) {
                this.calculation.setType("Calculated Measure");
            } else {
                try {
                    OLAPDimension dimension = this.calculation.getDimension();
                    if (dimension == null) {
                        this.calculation.setType("Calculated Measure");
                    } else {
                        this.calculation.setType("Calculated Member");
                    }
                }
                catch (OLAPException e) {
                    this.calculation.setType("Calculated Measure");
                }
            }
            WAWizardDialog parent = (WAWizardDialog)this.getTopLevelAncestor();
            parent.addWizardData("CALCULATIONTYPE", (Object)this.types.getSelection().getActionCommand());
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return true;
    }
}

