/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.aggregation;

import com.sas.olapadmin.aggregation.AnalysisRecommendDialog;
import com.sas.olapadmin.aggregation.AnalysisRecommendTableModel;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsTable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;

public class AnalysisRecommendTablePanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    static WAdminResource bundle = new WAdminResource(AnalysisRecommendTablePanel.class);
    AnalysisRecommendTableModel aggregationsModel;
    private OLAPCube olapCube;
    private OLAPList hierarchies;
    private WsTable recommendTable;
    private JButton selectAllButton;
    private JButton clearAllButton;
    private List analysisAggregations;
    JLabel aggrCountLabel;
    private int resultType;
    protected AnalysisRecommendDialog parent;
    private TableCellEditor cellEditor;

    public AnalysisRecommendTablePanel(AnalysisRecommendDialog owningDialog, OLAPCube oCube, List analysisResults, int rType) {
        this.resultType = rType;
        this.olapCube = oCube;
        this.parent = owningDialog;
        this.analysisAggregations = analysisResults;
        this.initialize();
    }

    public List getSelectedAggregationsInTable() {
        return this.aggregationsModel.getSelectedCheckboxValues();
    }

    public List getAggregationsInTable() {
        return this.aggregationsModel.getAggregationsInTable();
    }

    public void setAggregationsInTable(List analysisResults) {
        this.analysisAggregations = analysisResults;
    }

    protected void initialize() {
        OLAPList allAggregations = null;
        this.setLayout(new GridBagLayout());
        try {
            this.hierarchies = this.olapCube.getDimensionSet().getHierarchies();
            allAggregations = this.olapCube.getAggregationSet().getAggregations();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        this.aggregationsModel = new AnalysisRecommendTableModel((List)this.hierarchies, this.resultType, (List)allAggregations);
        this.recommendTable = new WsTable((WsAbstractTableModel)this.aggregationsModel);
        this.recommendTable.getRowHeader().setReorderingAllowed(false);
        this.recommendTable.getColumnHeader().setReorderingAllowed(false);
        this.recommendTable.setSelectionMode(2);
        this.recommendTable.setColumnAutoResizeMode(4);
        RecommendTableModelListener tableModelListener = new RecommendTableModelListener();
        this.recommendTable.getModel().addTableModelListener(tableModelListener);
        TableColumn newColumn = this.recommendTable.getColumnModel().getColumn(this.recommendTable.convertColumnIndexToView(1));
        newColumn.setResizable(false);
        JScrollPane tableScrollPane = new JScrollPane((Component)this.recommendTable);
        Dimension tableSize = new Dimension(550, 400);
        tableScrollPane.setPreferredSize(tableSize);
        WAPanel buttonPanel = new WAPanel();
        buttonPanel.setLayout((LayoutManager)new GridBagLayout());
        this.selectAllButton = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.selectAllButton, bundle.getString("AnalysisRecommend.SelectAll.action.label"));
        this.selectAllButton.setToolTipText(bundle.getString("AnalysisRecommend.SelectAll.action.tip"));
        this.selectAllButton.setName("SelectAllButton");
        this.selectAllButton.addActionListener(new SelectAllListener());
        this.clearAllButton = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.clearAllButton, bundle.getString("AnalysisRecommend.ClearAll.action.label"));
        this.clearAllButton.setToolTipText(bundle.getString("AnalysisRecommend.ClearAll.action.tip"));
        this.clearAllButton.setName("ClearAllButton");
        this.clearAllButton.addActionListener(new ClearAllListener());
        this.aggrCountLabel = new JLabel();
        this.aggrCountLabel.setText(bundle.formatString("AnalysisRecommend.AggrCount.fmt.control.label", (Object)new Integer(0), (Object)new Integer(0)));
        buttonPanel.add((Component)this.aggrCountLabel, (Object)new GridBagConstraints(0, 0, 1, 1, 0.8, 1.0, 17, 0, new Insets(0, 0, 0, 0), 0, 0));
        buttonPanel.add((Component)this.selectAllButton, (Object)new GridBagConstraints(1, 0, 1, 1, 0.1, 1.0, 13, 0, new Insets(0, 150, 0, 0), 0, 0));
        buttonPanel.add((Component)this.clearAllButton, (Object)new GridBagConstraints(2, 0, 1, 1, 0.1, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        JLabel tableLabel = new JLabel();
        VisualUtilities.setLabelTextAndMnemonic(tableLabel, bundle.getString("AnalysisRecommend.Table.control.label"));
        tableLabel.setLabelFor(tableScrollPane);
        this.add(tableLabel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.1, 18, 2, new Insets(0, 0, 5, 0), 0, 0));
        this.add(tableScrollPane, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.8, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)buttonPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.1, 17, 2, new Insets(0, 0, 5, 0), 0, 0));
        JSeparator separatorLine = new JSeparator(0);
        this.add(separatorLine, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 17, 2, new Insets(10, 0, 0, 0), 0, 1));
        if (this.analysisAggregations != null) {
            this.addAggregations(this.analysisAggregations);
        }
        int numAggrsInTable = this.aggregationsModel.getRowCount();
        this.aggrCountLabel.setText(bundle.formatString("AnalysisRecommend.AggrCount.fmt.control.label", (Object)new Integer(0), (Object)new Integer(numAggrsInTable)));
    }

    public AnalysisRecommendTableModel getTableModel() {
        return this.aggregationsModel;
    }

    public void addAggregations(List analysisResults) {
        this.aggregationsModel.addAggregationsToTable(analysisResults);
    }

    public boolean onOK() {
        if (this.recommendTable.getCellEditor() != null) {
            this.recommendTable.getCellEditor().stopCellEditing();
        }
        return true;
    }

    public boolean validateNames() {
        this.cellEditor = this.recommendTable.getCellEditor();
        if (this.cellEditor != null) {
            this.cellEditor.stopCellEditing();
        }
        return true;
    }

    class RecommendTableModelListener
    implements TableModelListener {
        RecommendTableModelListener() {
        }

        @Override
        public void tableChanged(TableModelEvent e) {
            int column = e.getColumn();
            if (column == 0) {
                int numAggrsInTable = AnalysisRecommendTablePanel.this.aggregationsModel.getRowCount();
                int numAggrsSelected = AnalysisRecommendTablePanel.this.getSelectedAggregationsInTable().size();
                AnalysisRecommendTablePanel.this.aggrCountLabel.setText(bundle.formatString("AnalysisRecommend.AggrCount.fmt.control.label", (Object)new Integer(numAggrsSelected), (Object)new Integer(numAggrsInTable)));
                if (numAggrsSelected > 0) {
                    AnalysisRecommendTablePanel.this.parent.setOKEnabled(true);
                } else {
                    AnalysisRecommendTablePanel.this.parent.setOKEnabled(false);
                }
            }
        }
    }

    class ClearAllListener
    implements ActionListener {
        ClearAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AnalysisRecommendTablePanel.this.aggregationsModel.clearSelections();
            int numAggrsInTable = AnalysisRecommendTablePanel.this.aggregationsModel.getRowCount();
            int numAggrsSelected = AnalysisRecommendTablePanel.this.getSelectedAggregationsInTable().size();
            AnalysisRecommendTablePanel.this.aggrCountLabel.setText(bundle.formatString("AnalysisRecommend.AggrCount.fmt.control.label", (Object)new Integer(numAggrsSelected), (Object)new Integer(numAggrsInTable)));
        }
    }

    class SelectAllListener
    implements ActionListener {
        SelectAllListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AnalysisRecommendTablePanel.this.aggregationsModel.selectAll();
            int numAggrsInTable = AnalysisRecommendTablePanel.this.aggregationsModel.getRowCount();
            int numAggrsSelected = AnalysisRecommendTablePanel.this.getSelectedAggregationsInTable().size();
            AnalysisRecommendTablePanel.this.aggrCountLabel.setText(bundle.formatString("AnalysisRecommend.AggrCount.fmt.control.label", (Object)new Integer(numAggrsSelected), (Object)new Integer(numAggrsInTable)));
        }
    }
}

