/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.aggregation;

import com.sas.olapadmin.aggregation.AnalysisRecommendTablePanel;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.List;

public class AnalysisRecommendDialog
extends WAStandardDialog {
    private static final long serialVersionUID = 1L;
    static WAdminResource bundle = new WAdminResource(AnalysisRecommendDialog.class);
    OLAPCube olapCube;
    AnalysisRecommendTablePanel centerPanel;
    private List selectedAggregations;
    private List analysisAggregations;
    private boolean cancelFlag;
    public static final int RESULT_TYPE_ARM = 0;
    public static final int RESULT_TYPE_CARDINALITY = 1;
    protected int resultType;

    public AnalysisRecommendDialog(Workspace owner, String title, OLAPCube oCube, List analysisResults, int rType) {
        super((Frame)owner, title, true);
        this.resultType = rType;
        this.olapCube = oCube;
        this.analysisAggregations = analysisResults;
        this.setHelpProduct("olapadmin");
        this.setHelpTopic("aggregation_dialog_analysis");
    }

    public void initialize() {
        this.centerPanel = new AnalysisRecommendTablePanel(this, this.olapCube, this.analysisAggregations, this.resultType);
        this.setMainPanel(this.centerPanel);
        this.setResizable(true);
        this.setPreferredSize(new Dimension(600, 400));
        super.initialize();
        this.cancelFlag = false;
        this.setOKEnabled(false);
    }

    public void setOKEnabled(boolean isEnabled) {
        this.m_btnOk.setEnabled(isEnabled);
    }

    public boolean onOK() {
        if (!this.centerPanel.onOK()) {
            return false;
        }
        this.selectedAggregations = this.centerPanel.getSelectedAggregationsInTable();
        try {
            for (int i = this.analysisAggregations.size() - 1; i >= 0; --i) {
                OLAPAggregation aggregation = (OLAPAggregation)this.analysisAggregations.get(i);
                if (this.selectedAggregations.contains(aggregation)) continue;
                aggregation.delete();
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return true;
    }

    public boolean onCancel() {
        this.cancelFlag = true;
        try {
            for (int i = this.analysisAggregations.size() - 1; i >= 0; --i) {
                OLAPAggregation aggregation = (OLAPAggregation)this.analysisAggregations.get(i);
                aggregation.delete();
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return true;
    }

    public boolean isCancelled() {
        return this.cancelFlag;
    }

    public List getSelectedAggregations() {
        return this.selectedAggregations;
    }
}

