/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.aggregation;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.aggregation.AggregationItem;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsIconTableColumn;
import com.sas.workspace.WsIntegerTableColumn;
import com.sas.workspace.WsStringTableColumn;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public class AggregationsTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(AggregationsTableModel.class);
    private static final int TOTAL_STATIC_COLS = 7;
    protected static final int NEW = 0;
    protected static final int OPTIONS = 1;
    protected static final int ANALYSIS = 2;
    protected static final int COUNT = 3;
    protected static final int TIME = 4;
    protected static final int AVGTIME = 5;
    protected static final int NAME = 6;
    protected static final int ARM_TUNING = 1;
    protected static final int CARDINALITY_TUNING = 2;
    protected static final int MANUAL_TUNING = 3;
    protected static final int NO_TUNINGMETHOD_SPECIFIED = 0;
    private static final int COLUMN_WIDTH = 85;
    private static final int COLUMN_NUMERIC_WIDTH = 45;
    private static final int COLUMN_ICON_WIDTH = 45;
    private static final int COLUMN_TIME_WIDTH = 90;
    private static final int LONG_WIDTH = 100;
    private List aggregationList;
    private List aggregationsInTable;
    private List hierarchies;
    private List hierarchyRemember;
    private OLAPHierarchy hierarchy;
    private Map hierarchyPositionMap;
    private Map newAggregationsTuningMethod;
    private static ImageIcon defaultStatusValue;
    private static ImageIcon defaultOptionsValue;
    private static ImageIcon newIcon;
    private static ImageIcon propertiesIcon;
    private static ImageIcon dropIcon;
    private boolean showLevelNumber;
    private int tuningMethodUsed;
    static Map values;
    int totalNumberOfColumns;

    public AggregationsTableModel(List hierarchyList) {
        this.hierarchies = hierarchyList;
        this.hierarchyRemember = new ArrayList();
        this.tuningMethodUsed = 0;
        this.hierarchyRemember.addAll(hierarchyList);
        this.initialize();
        this.setupFirstColumns();
        this.setupHierarchyColumns();
    }

    private void initialize() {
        this.aggregationList = new ArrayList();
        this.aggregationsInTable = new ArrayList();
        this.newAggregationsTuningMethod = new HashMap();
        newIcon = bundle.getImageIcon("AggregationsTable.New.icon");
        newIcon.setDescription(bundle.getString("Aggregations.TableModel.newImage.tip"));
        propertiesIcon = bundle.getImageIcon("AggregationsTable.Properties.icon");
        propertiesIcon.setDescription(bundle.getString("Aggregations.TableModel.optionImage.tip"));
        dropIcon = bundle.getImageIcon("AggregationsTable.Remove.icon");
        dropIcon.setDescription(bundle.getString("Aggregations.TableModel.dropImage.tip"));
        this.showLevelNumber = true;
    }

    private void setupFirstColumns() {
        this.totalNumberOfColumns = this.getColumnCount();
        this.m_aColumns = new WsAbstractTableColumn[this.totalNumberOfColumns];
        WsIconTableColumn newColumn = new WsIconTableColumn(0, bundle.getString("AggregationsTableModel.New.header.title"), 45);
        this.m_aColumns[0] = newColumn;
        defaultStatusValue = (ImageIcon)newColumn.createDefaultValue();
        values = new HashMap();
        values.put(newIcon, new Integer(0));
        values.put(dropIcon, new Integer(1));
        values.put(defaultStatusValue, new Integer(2));
        Comparator newColumnComparator = new Comparator(){

            public int compare(Object one, Object two) {
                ImageIcon image1 = (ImageIcon)one;
                ImageIcon image2 = (ImageIcon)two;
                return ((Integer)values.get(image1)).compareTo((Integer)values.get(image2));
            }
        };
        newColumn.setComparator(newColumnComparator);
        WsIconTableColumn optionsColumn = new WsIconTableColumn(1, bundle.getString("AggregationsTableModel.Options.header.title"), 45);
        JLabel renderer = (JLabel)((Object)optionsColumn.getCellRenderer());
        renderer.setIcon(propertiesIcon);
        optionsColumn.setEditable(false);
        defaultOptionsValue = (ImageIcon)optionsColumn.createDefaultValue();
        this.m_aColumns[1] = optionsColumn;
        WsIntegerTableColumn integerColumn = new WsIntegerTableColumn(3, bundle.getString("AggregationsTableModel.Count.header.title"), 45);
        integerColumn.setMissingValue(new Integer(-1));
        this.m_aColumns[2] = new WsStringTableColumn(2, bundle.getString("AggregationsTableModel.Analysis.header.title"), 100);
        this.m_aColumns[2].setEditable(false);
        this.m_aColumns[3] = integerColumn;
        this.m_aColumns[3].setEditable(false);
        this.m_aColumns[4] = new WsStringTableColumn(4, bundle.getString("AggregationsTableModel.Time.header.title"), 90);
        this.m_aColumns[4].setEditable(false);
        this.m_aColumns[5] = new WsStringTableColumn(5, bundle.getString("AggregationsTableModel.AvgTime.header.title"), 90);
        this.m_aColumns[5].setEditable(false);
        this.m_aColumns[6] = new WsStringTableColumn(6, bundle.getString("AggregationsTableModel.Name.header.title"), 85, 60);
        this.m_aColumns[6].setEditable(true);
    }

    private void setupHierarchyColumns() {
        this.hierarchyPositionMap = new HashMap();
        int hierarchyCount = this.getHierarchyCount();
        for (int p = 0; p < hierarchyCount; ++p) {
            this.hierarchy = (OLAPHierarchy)this.hierarchies.get(p);
            String hierName = this.hierarchy.getName();
            int position = p + 7 + this.getHiddenColumnCount();
            this.m_aColumns[position] = new WsStringTableColumn(position, hierName, 85);
            this.m_aColumns[position].setEditable(false);
            Integer pos = new Integer(position);
            this.hierarchyPositionMap.put(hierName, pos);
        }
    }

    public int getColumnCount() {
        return 7 + this.getHierarchyCount();
    }

    public int getHierarchyCount() {
        return this.hierarchies.size();
    }

    public void setHierarchies(List cubeHierarchies) {
        this.hierarchies = cubeHierarchies;
        this.setupHierarchyColumns();
    }

    public void hideDrillpathNumber() {
        this.showLevelNumber = false;
    }

    public void showDrillpathNumber() {
        this.showLevelNumber = true;
    }

    public String getToolTipAt(int iRow, int iCol) {
        ArrayList row;
        Object columnValue;
        if (iRow < this.m_lData.size() & (iCol == 0 | iCol == 1) && iCol == 0 & (columnValue = (row = (ArrayList)this.m_lData.get(iRow)).get(iCol)) != defaultStatusValue | iCol == 1 & columnValue != defaultOptionsValue) {
            ImageIcon icon = (ImageIcon)row.get(iCol);
            String tip = icon.getDescription();
            return tip;
        }
        return null;
    }

    public void moveDataToModel() {
        String avgtime = null;
        int nRows = this.m_lData.size();
        if (nRows > 0) {
            this.m_lData.clear();
            this.fireTableRowsDeleted(0, nRows - 1);
        }
        nRows = this.aggregationList.size();
        int columnCount = this.getColumnCount();
        for (int i = 0; i < nRows; ++i) {
            ArrayList<Object> alRow = new ArrayList<Object>(columnCount);
            OLAPAggregation aggregation = (OLAPAggregation)this.aggregationList.get(i);
            boolean aggrIsDropped = aggregation.isDropped();
            boolean aggrIsNew = aggregation.isNewObject();
            boolean aggrHasOptions = false;
            try {
                aggrHasOptions = aggregation.hasPerformanceOptions();
            }
            catch (OLAPException e1) {
                ExceptionHandler.handleException((Exception)((Object)e1));
            }
            if (aggrIsNew) {
                alRow.add(0, newIcon);
            } else if (aggrIsDropped) {
                alRow.add(0, dropIcon);
            } else {
                alRow.add(0, defaultStatusValue);
            }
            if (aggrHasOptions) {
                alRow.add(1, propertiesIcon);
            } else {
                alRow.add(1, defaultOptionsValue);
            }
            alRow.add(2, this.newAggregationsTuningMethod.get(aggregation));
            Integer count = aggregation.getCount();
            String time = "";
            avgtime = "";
            if (count == null) {
                count = new Integer(-1);
            } else {
                Double timeValue = aggregation.getTime();
                if (timeValue != null && (time = Utilities.formatTime((double)aggregation.getTime(), (boolean)true)) != null) {
                    double avgTimeValue = timeValue / count.doubleValue();
                    avgtime = Utilities.formatTime((double)avgTimeValue, (boolean)true);
                }
            }
            alRow.add(3, count);
            alRow.add(4, time);
            alRow.add(5, avgtime);
            alRow.add(6, aggregation.getName());
            try {
                int p;
                OLAPList hierarchiesInAggregation = aggregation.getHierarchies();
                for (p = 0; p < columnCount; ++p) {
                    alRow.add(7 + p, "");
                }
                for (p = 0; p < hierarchiesInAggregation.size(); ++p) {
                    this.hierarchy = (OLAPHierarchy)hierarchiesInAggregation.get(p);
                    OLAPList levelsInAggregation = aggregation.getLevelsByHierarchy(this.hierarchy);
                    Integer columnPosition = (Integer)this.hierarchyPositionMap.get(this.hierarchy.getName());
                    OLAPLevel lastLevel = (OLAPLevel)levelsInAggregation.get(levelsInAggregation.size() - 1);
                    String stringToDisplay = this.showLevelNumber ? levelsInAggregation.size() + ". " + lastLevel.toString() : lastLevel.toString();
                    alRow.set(columnPosition, stringToDisplay);
                }
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            this.m_lData.add(alRow);
        }
        this.fireTableModelPopulated();
        this.m_nRowInstances = nRows;
    }

    public boolean isCellEditable(int row, int column) {
        if (column == 6) {
            ArrayList dataRow = (ArrayList)this.m_lData.get(row);
            Object columnValue = dataRow.get(0);
            if (row == 0) {
                return false;
            }
            return !columnValue.equals(dropIcon);
        }
        return false;
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        OLAPAggregation aggregation = (OLAPAggregation)this.aggregationsInTable.get(iRow);
        if (iCol == 6) {
            aggregation.setName((String)value);
        }
        super.setValueAt(value, iRow, iCol);
    }

    public void addAggregationsToTable(List aggregations, int tuningMethod) {
        String lastAnalysis = "";
        for (int p = 0; p < aggregations.size(); ++p) {
            OLAPAggregation aggregationToCheck = (OLAPAggregation)aggregations.get(p);
            this.aggregationsInTable.add(aggregationToCheck);
            this.aggregationList.add(aggregationToCheck);
            this.tuningMethodUsed = tuningMethod;
            switch (this.tuningMethodUsed) {
                case 3: {
                    lastAnalysis = bundle.getString("Aggregations.TableColumn.LastAnalysis.Manual.txt");
                    break;
                }
                case 1: {
                    lastAnalysis = bundle.getString("Aggregations.TableColumn.LastAnalysis.ARMLog.txt");
                    break;
                }
                case 2: {
                    lastAnalysis = bundle.getString("Aggregations.TableColumn.LastAnalysis.Cardinality.txt");
                    break;
                }
                default: {
                    lastAnalysis = "";
                }
            }
            this.newAggregationsTuningMethod.put(aggregationToCheck, lastAnalysis);
        }
        this.moveDataToModel();
    }

    public boolean isAggregationItemInTable(AggregationItem aggrToVerify) throws OLAPException {
        Vector aggrToVerify_levels = aggrToVerify.getAggrLevels();
        boolean dupFlag = this.checkAggregationListForDuplicate(this.aggregationsInTable, aggrToVerify_levels);
        return dupFlag;
    }

    public boolean isAggregationItemInTable(OLAPAggregation aggrToVerify) throws OLAPException {
        OLAPList aggrToVerify_levels = aggrToVerify.getLevels();
        boolean dupFlag = this.checkAggregationListForDuplicate(this.aggregationsInTable, (List)aggrToVerify_levels);
        return dupFlag;
    }

    private boolean checkAggregationListForDuplicate(List listToCheck, List aggrToVerify_levels) throws OLAPException {
        boolean dupFlag = false;
        if (listToCheck.isEmpty()) {
            return false;
        }
        for (int k = 0; k < listToCheck.size(); ++k) {
            OLAPAggregation listToCheck_aggr = (OLAPAggregation)listToCheck.get(k);
            OLAPList listToCheckAggr_levels = listToCheck_aggr.getLevels();
            boolean match_level = true;
            if (aggrToVerify_levels.size() != listToCheckAggr_levels.size()) {
                match_level = false;
            } else {
                for (int m = 0; m < listToCheckAggr_levels.size(); ++m) {
                    OLAPLevel level = (OLAPLevel)listToCheckAggr_levels.get(m);
                    if (aggrToVerify_levels.contains(level)) continue;
                    match_level = false;
                }
            }
            if (!match_level) continue;
            dupFlag = true;
            break;
        }
        return dupFlag;
    }

    public boolean isAggregationNameUnique(String name, int row) {
        boolean unique = true;
        for (int i = 0; i < this.aggregationsInTable.size(); ++i) {
            OLAPAggregation aggregation = (OLAPAggregation)this.aggregationsInTable.get(i);
            if (row == i || !aggregation.getName().equalsIgnoreCase(name)) continue;
            unique = false;
            break;
        }
        return unique;
    }

    private int getIndexOfAggregationInTable(AggregationItem aggrToVerify) throws OLAPException {
        int indexInList = 0;
        Vector aggrToVerify_levels = aggrToVerify.getAggrLevels();
        if (!this.aggregationsInTable.isEmpty()) {
            for (int k = 0; k < this.aggregationsInTable.size(); ++k) {
                OLAPAggregation listToCheck_aggr = (OLAPAggregation)this.aggregationsInTable.get(k);
                OLAPList listToCheckAggr_levels = listToCheck_aggr.getLevels();
                boolean match_level = true;
                if (aggrToVerify_levels.size() != listToCheckAggr_levels.size()) {
                    match_level = false;
                } else {
                    for (int m = 0; m < listToCheckAggr_levels.size(); ++m) {
                        OLAPLevel level = (OLAPLevel)listToCheckAggr_levels.get(m);
                        if (aggrToVerify_levels.contains(level)) continue;
                        match_level = false;
                    }
                }
                if (!match_level) continue;
                indexInList = k;
                break;
            }
        }
        return indexInList;
    }

    public void updateOptionsColumnInTable() throws OLAPException {
        for (int i = 0; i < this.aggregationsInTable.size(); ++i) {
            OLAPAggregation aggregation = (OLAPAggregation)this.aggregationsInTable.get(i);
            if (aggregation.hasPerformanceOptions()) {
                this.setValueAt(propertiesIcon, i, 1);
                continue;
            }
            this.setValueAt(defaultOptionsValue, i, 1);
        }
    }

    public void updateStatisticsColumnsInTable(List armResultsList) throws OLAPException {
        this.aggregationsInTable = this.getAggregationsInTable();
        for (int m = 0; m < this.aggregationsInTable.size(); ++m) {
            OLAPAggregation aggregation = (OLAPAggregation)this.aggregationsInTable.get(m);
            if (aggregation.isNewObject()) continue;
            this.setValueAt(bundle.getString("Aggregations.TableColumn.LastAnalysis.ARMLog_NoMatch.txt"), m, 2);
        }
        for (int i = 0; i < armResultsList.size(); ++i) {
            AggregationItem aggregationItem = (AggregationItem)armResultsList.get(i);
            int aggregationInTableIndex = this.getIndexOfAggregationInTable(aggregationItem);
            if (aggregationInTableIndex <= 0) continue;
            double timeValue = aggregationItem.getTime();
            this.setValueAt(Utilities.formatTime((double)aggregationItem.getTime(), (boolean)true), aggregationInTableIndex, 4);
            Integer countValue = new Integer(aggregationItem.getCount());
            if (countValue == null) {
                countValue = new Integer(-1);
            }
            this.setValueAt(countValue, aggregationInTableIndex, 3);
            double avgTimeValue = timeValue / countValue.doubleValue();
            this.setValueAt(Utilities.formatTime((double)avgTimeValue, (boolean)true), aggregationInTableIndex, 5);
            this.setValueAt(bundle.getString("Aggregations.TableColumn.LastAnalysis.ARMLog.txt"), aggregationInTableIndex, 2);
            OLAPAggregation aggregation = (OLAPAggregation)this.aggregationsInTable.get(aggregationInTableIndex);
            aggregation.setCount(countValue);
            aggregation.setTime(new Double(timeValue));
        }
    }

    public void clearStatisticsColumnsInTable() {
        this.aggregationsInTable = this.getAggregationsInTable();
        for (int i = 0; i < this.m_nRowInstances; ++i) {
            this.setValueAt("", i, 4);
            this.setValueAt(new Integer(-1), i, 3);
        }
    }

    public List getAggregationsInTable() {
        return this.aggregationsInTable;
    }

    public void removeAggregation(OLAPAggregation aggregation, int selectedRow) {
        try {
            if (aggregation.isNewObject()) {
                aggregation.tuningDrop();
                if (this.newAggregationsTuningMethod.containsKey(aggregation)) {
                    this.newAggregationsTuningMethod.remove(aggregation);
                }
                if (this.aggregationList.contains(aggregation)) {
                    this.aggregationList.remove(aggregation);
                    this.aggregationsInTable.remove(aggregation);
                    this.deleteRow(selectedRow);
                    this.m_nRowInstances = this.aggregationList.size();
                }
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    public void dropExistingAggregation(OLAPAggregation aggregation) {
        try {
            aggregation.tuningDrop();
            if (this.aggregationList.contains(aggregation)) {
                int index = this.aggregationsInTable.indexOf(aggregation);
                this.setValueAt(dropIcon, index, 0);
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    public void removeDropOnExistingAggregation(OLAPAggregation aggregation) {
        try {
            aggregation.tuningAdd();
            int index = this.aggregationsInTable.indexOf(aggregation);
            this.setValueAt(defaultStatusValue, index, 0);
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
    }

    public boolean hasAggrsMarkedDropped(AggregationSet aggregationSet, OLAPAggregation aggregation) {
        OLAPList dropList;
        boolean hasDropped = false;
        if (aggregationSet != null && (dropList = aggregationSet.getDroppedAggregations()).contains((Object)aggregation)) {
            hasDropped = true;
        }
        return hasDropped;
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public void populateStore() throws MdException, RemoteException {
    }
}

