/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.aggregation;

import com.sas.metadata.remote.MdException;
import com.sas.olapadmin.designer.model.AggregationSet;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPHierarchy;
import com.sas.olapadmin.designer.model.OLAPLevel;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractTableColumn;
import com.sas.workspace.WsAbstractTableModel;
import com.sas.workspace.WsStringTableColumn;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;

public class AggregationsSelectorTableModel
extends WsAbstractTableModel {
    private static final long serialVersionUID = 1L;
    private static WAdminResource bundle = new WAdminResource(AggregationsSelectorTableModel.class);
    private static final int COLUMN_WIDTH = 100;
    private static final String NONE_VALUE = bundle.getString("Aggregations.Manual.NONE_VALUE.txt");
    private List hierarchies;
    private OLAPCube olapCube;
    private AggregationSet aggregationSet;
    private List levelsSelectedForAggregation = null;
    int totalNumberOfColumns;
    private Map levelsByColumnName;

    public AggregationsSelectorTableModel(OLAPCube cube) {
        this.olapCube = cube;
        try {
            this.hierarchies = cube.getDimensionSet().getHierarchies();
            this.aggregationSet = this.olapCube.getAggregationSet();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        this.levelsSelectedForAggregation = new ArrayList();
        this.setupHierarchyColumns();
        this.levelsByColumnName = new HashMap();
    }

    private void setupHierarchyColumns() {
        this.m_aColumns = new WsAbstractTableColumn[this.getColumnCount()];
        int hierarchyCount = this.getHierarchyCount();
        OLAPList levels = null;
        for (int p = 0; p < hierarchyCount; ++p) {
            OLAPHierarchy hierarchy = (OLAPHierarchy)this.hierarchies.get(p);
            try {
                levels = hierarchy.getLevels();
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            String[] suggestedValues = new String[levels.size() + 1];
            suggestedValues[0] = NONE_VALUE;
            for (int m = 0; m < levels.size(); ++m) {
                String levelNumber = m + 1 + ".";
                suggestedValues[m + 1] = levelNumber.concat(levels.get(m).toString());
            }
            String hierName = hierarchy.getName();
            WsStringTableColumn tableColumn = new WsStringTableColumn(p, hierName, 100, suggestedValues);
            this.m_aColumns[p] = tableColumn;
            this.m_aColumns[p].setCellRenderer((TableCellRenderer)new MyComboBoxRenderer(suggestedValues));
            DefaultCellEditor defaultEditor = new DefaultCellEditor(new JComboBox<String>(suggestedValues));
            this.m_aColumns[p].setCellEditor((TableCellEditor)defaultEditor);
        }
        List defaultRowValues = this.createDefaultRowValues();
        this.m_lData.add(defaultRowValues);
        this.fireTableModelPopulated();
    }

    public int getColumnCount() {
        return this.getHierarchyCount();
    }

    public int getHierarchyCount() {
        return this.hierarchies.size();
    }

    public boolean levelSelected() {
        boolean isLevel = false;
        if (!this.levelsSelectedForAggregation.isEmpty()) {
            isLevel = true;
        }
        return isLevel;
    }

    private boolean isLevelSelectedOnAnotherHierarchy(OLAPHierarchy hierarchyRemovingLevel, OLAPLevel checkLevel) {
        boolean isDuplicateLevelSelected = false;
        for (int i = 0; i < this.hierarchies.size(); ++i) {
            ArrayList levelsSelectedForHierarchy;
            OLAPHierarchy hierarchyToCheck = (OLAPHierarchy)this.hierarchies.get(i);
            if (hierarchyToCheck == hierarchyRemovingLevel || !this.levelsByColumnName.containsKey(hierarchyToCheck.getName()) || !(levelsSelectedForHierarchy = (ArrayList)this.levelsByColumnName.get(hierarchyToCheck.getName())).contains(checkLevel)) continue;
            isDuplicateLevelSelected = true;
        }
        return isDuplicateLevelSelected;
    }

    public OLAPAggregation createOLAPAggregationInSelector() {
        OLAPAggregation aggregation = null;
        if (!this.levelsSelectedForAggregation.isEmpty()) {
            OLAPList aggrLevels = null;
            try {
                aggregation = this.aggregationSet.createOLAPAggregation();
                String aggrname = this.createUniqueAggregationName();
                aggregation.setName(aggrname);
                aggregation.setDesc(this.createAggregationDescription(this.levelsSelectedForAggregation));
                aggrLevels = aggregation.getLevels();
                for (int p = 0; p < this.levelsSelectedForAggregation.size(); ++p) {
                    aggrLevels.add(this.levelsSelectedForAggregation.get(p));
                }
                aggregation.setType("MOLAP");
            }
            catch (OLAPException e2) {
                ExceptionHandler.handleException((Exception)((Object)e2));
            }
        }
        return aggregation;
    }

    public void resetAllSelections() {
        for (int i = 0; i < this.hierarchies.size(); ++i) {
            super.setValueAt((Object)NONE_VALUE, 0, i);
        }
        this.levelsSelectedForAggregation.clear();
        this.levelsByColumnName.clear();
    }

    public void setValueAt(Object value, int iRow, int iCol) {
        String selectedDisplayValue = (String)value;
        String selectedValue = selectedDisplayValue.substring(selectedDisplayValue.indexOf(".") + 1);
        OLAPHierarchy hierarchyColumn = (OLAPHierarchy)this.hierarchies.get(iCol);
        OLAPList hierarchyLevels = null;
        try {
            hierarchyLevels = hierarchyColumn.getLevels();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        String columnName = this.getColumnName(iCol);
        if (selectedValue != NONE_VALUE) {
            ArrayList levelsSelectedForHierarchy;
            if (this.levelsByColumnName.containsKey(columnName)) {
                levelsSelectedForHierarchy = (ArrayList)this.levelsByColumnName.get(columnName);
                this.removePreviousLevelsForSelectedColumn(levelsSelectedForHierarchy, hierarchyColumn, columnName);
            } else {
                levelsSelectedForHierarchy = new ArrayList();
            }
            int index = 0;
            for (int m = 0; m < hierarchyLevels.size(); ++m) {
                String levelString = hierarchyLevels.get(m).toString();
                if (!levelString.equals(selectedValue)) continue;
                index = m;
            }
            for (int i = 0; i <= index; ++i) {
                OLAPLevel levelToAdd = (OLAPLevel)hierarchyLevels.get(i);
                if (!this.levelsSelectedForAggregation.contains(levelToAdd)) {
                    this.levelsSelectedForAggregation.add(levelToAdd);
                }
                levelsSelectedForHierarchy.add(levelToAdd);
            }
            this.levelsByColumnName.put(columnName, levelsSelectedForHierarchy);
        } else {
            List previousLevels = (List)this.levelsByColumnName.get(columnName);
            this.removePreviousLevelsForSelectedColumn(previousLevels, hierarchyColumn, columnName);
            previousLevels = null;
        }
        super.setValueAt(value, iRow, iCol);
    }

    private void removePreviousLevelsForSelectedColumn(List prevLevels, OLAPHierarchy hierColumn, String colName) {
        for (int i = prevLevels.size() - 1; i >= 0; --i) {
            OLAPLevel levelToRemove = (OLAPLevel)prevLevels.get(i);
            if (!this.levelsSelectedForAggregation.contains(levelToRemove) || this.isLevelSelectedOnAnotherHierarchy(hierColumn, levelToRemove)) continue;
            this.levelsSelectedForAggregation.remove(levelToRemove);
        }
        this.levelsByColumnName.remove(colName);
        prevLevels.clear();
    }

    private String createUniqueAggregationName() {
        OLAPList existingAggregations = null;
        try {
            existingAggregations = this.aggregationSet.getAggregations();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        int aggrCounter = existingAggregations.size();
        String uniqueName = "AGGR" + ++aggrCounter;
        while (!this.uniqueAggregationNameVerified(uniqueName)) {
            uniqueName = "AGGR" + ++aggrCounter;
        }
        return uniqueName;
    }

    private boolean uniqueAggregationNameVerified(String name) {
        boolean unique = true;
        OLAPList existingAggregations = null;
        try {
            existingAggregations = this.aggregationSet.getAggregations();
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        for (int i = 0; i < existingAggregations.size(); ++i) {
            OLAPAggregation aggregation = (OLAPAggregation)existingAggregations.get(i);
            if (!aggregation.getName().equalsIgnoreCase(name)) continue;
            unique = false;
            break;
        }
        return unique;
    }

    private String createAggregationDescription(List levelList) {
        String aggrDescription = "";
        for (int n = 0; n < levelList.size(); ++n) {
            aggrDescription = aggrDescription.concat(((OLAPLevel)levelList.get(n)).toString() + " ");
        }
        return aggrDescription;
    }

    public void moveDataToModel() throws MdException, RemoteException {
    }

    public void populateStore() throws MdException, RemoteException {
    }

    public void moveDataToStore() throws MdException, RemoteException {
    }

    public class MyComboBoxRenderer
    extends WAComboBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public MyComboBoxRenderer(String[] items) {
            super((Object[])items);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                this.setForeground(table.getForeground());
                this.setBackground(table.getBackground());
            }
            this.setSelectedItem(value);
            return this;
        }
    }
}

