/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.aggregation;

import com.sas.olapadmin.aggregation.ARM_Analyzer;
import com.sas.olapadmin.aggregation.AggregationItem;
import com.sas.olapadmin.aggregation.AggregationTuningModel;
import com.sas.olapadmin.aggregation.AggregationsDisplayInterface;
import com.sas.olapadmin.aggregation.AnalysisRecommendDialog;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPAggregation;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.designer.visuals.VisualUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.tools.armreader.Transaction;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.OpRequestUI;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.filechooser.FileFilter;

public class AggregationsARMLogPanel
extends WAPanel {
    private static final long serialVersionUID = 1L;
    static WAdminResource bundle = new WAdminResource(AggregationsARMLogPanel.class);
    private static final String APPDEFAULTS_ARMLOG_DIR_KEY = "TUNING_ARMLOG_DEFAULTDIRECTORY";
    public ButtonGroup radioGroup;
    private JButton browseButton;
    private JLabel label_ARMlogFile;
    private JRadioButton AddUpdateRadio;
    private JRadioButton UpdateOnlyRadio;
    public Map hierarchyLevels;
    public String choice;
    private Vector generatedAggregations;
    protected static final String ADDUPDATE = "ADD";
    protected static final String UPDATEONLY = "UPDATE";
    protected OLAPList addList;
    private boolean errorDialogDisplayed;
    OLAPCube olapCube;
    OLAPAggregation aggregation;
    AggregationsDisplayInterface resultsDisplayObject;
    AggregationsARMLogPanel parent = this;
    JButton addUpdateButton;
    JFileChooser fileChooser;
    WAComboBox inp_ARMlogFile;
    AggregationTuningModel tuningModel;

    public AggregationsARMLogPanel(OLAPCube cube) {
        this.olapCube = cube;
        this.initialize();
    }

    protected void initialize() {
        this.generatedAggregations = new Vector();
        this.tuningModel = new AggregationTuningModel(this.olapCube);
        Dimension longField = new Dimension(200, 20);
        this.setLayout(new GridBagLayout());
        WAPanel methodSelectionPanel = new WAPanel();
        this.AddUpdateRadio = new JRadioButton();
        VisualUtilities.setButtonTextAndMnemonic(this.AddUpdateRadio, bundle.getString("Aggregations.AddUpdateRadio.control.label"));
        this.AddUpdateRadio.setActionCommand(ADDUPDATE);
        this.UpdateOnlyRadio = new JRadioButton();
        VisualUtilities.setButtonTextAndMnemonic(this.UpdateOnlyRadio, bundle.getString("Aggregations.UpdateOnlyRadio.control.label"));
        this.UpdateOnlyRadio.setActionCommand(UPDATEONLY);
        this.radioGroup = new ButtonGroup();
        this.radioGroup.add(this.AddUpdateRadio);
        this.radioGroup.add(this.UpdateOnlyRadio);
        this.AddUpdateRadio.addActionListener(new RadioListener());
        this.UpdateOnlyRadio.addActionListener(new RadioListener());
        this.label_ARMlogFile = new JLabel();
        this.inp_ARMlogFile = new WAComboBox();
        this.inp_ARMlogFile.loadItems(VisualUtilities.AGGREGATION_ARMLOG_PATHS, VisualUtilities.MAX_PATHS);
        VisualUtilities.setLabelTextAndMnemonic(this.label_ARMlogFile, bundle.getString("Aggregations.ARMAnalysis.LogFile.control.label"));
        this.label_ARMlogFile.setLabelFor((Component)this.inp_ARMlogFile);
        this.inp_ARMlogFile.setEditable(true);
        this.inp_ARMlogFile.setFocusable(true);
        this.inp_ARMlogFile.setSelectedItem((Object)"");
        this.inp_ARMlogFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (AggregationsARMLogPanel.this.inp_ARMlogFile.getText().equals("")) {
                    AggregationsARMLogPanel.this.addUpdateButton.setEnabled(false);
                } else {
                    AggregationsARMLogPanel.this.addUpdateButton.setEnabled(true);
                }
            }
        });
        this.inp_ARMlogFile.getEditor().getEditorComponent().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                if (AggregationsARMLogPanel.this.inp_ARMlogFile.getText().equals("")) {
                    AggregationsARMLogPanel.this.addUpdateButton.setEnabled(false);
                } else {
                    AggregationsARMLogPanel.this.addUpdateButton.setEnabled(true);
                }
            }
        });
        this.browseButton = new JButton();
        VisualUtilities.setButtonTextAndMnemonic(this.browseButton, bundle.getString("Aggregations.Browse.action.label"));
        this.addUpdateButton = new JButton();
        this.addUpdateButton.setEnabled(false);
        VisualUtilities.setButtonTextAndMnemonic(this.addUpdateButton, bundle.getString("Aggregations.ARM.Add.action.label"));
        this.addUpdateButton.setToolTipText(bundle.getString("Aggregations.ARM.Add.action.tip"));
        this.addUpdateButton.addActionListener(new AddUpdateListener());
        methodSelectionPanel.setLayout((LayoutManager)new GridBagLayout());
        methodSelectionPanel.add((Component)this.label_ARMlogFile, (Object)new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.inp_ARMlogFile.setPreferredSize(longField);
        methodSelectionPanel.add((Component)this.inp_ARMlogFile, (Object)new GridBagConstraints(0, 1, 2, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        methodSelectionPanel.add((Component)this.browseButton, (Object)new GridBagConstraints(2, 1, 1, 1, 0.2, 1.0, 18, 0, new Insets(0, 2, 0, 0), 0, 0));
        methodSelectionPanel.add((Component)this.AddUpdateRadio, (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        methodSelectionPanel.add((Component)this.UpdateOnlyRadio, (Object)new GridBagConstraints(0, 3, 1, 1, 0.2, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        methodSelectionPanel.add((Component)this.addUpdateButton, (Object)new GridBagConstraints(2, 4, 1, 1, 0.2, 1.0, 13, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.add((Component)methodSelectionPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.5, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        Workspace workspace = Workspace.getWorkspace();
        String defaultDirectory = workspace.getAppDefaultsFile().getPropertyString(APPDEFAULTS_ARMLOG_DIR_KEY);
        this.fileChooser = defaultDirectory == null || defaultDirectory.equals("") ? new JFileChooser() : new JFileChooser(defaultDirectory);
        this.fileChooser.addChoosableFileFilter(new armFilter());
        BrowseListener browseListener2 = new BrowseListener();
        this.browseButton.addActionListener(browseListener2);
        this.browseButton.setToolTipText(bundle.getString("Aggregations.Browse.action.tip"));
        this.browseButton.setEnabled(true);
        this.AddUpdateRadio.setSelected(true);
    }

    protected void preserveLastLogFileUsed() {
        String fileName = (String)this.inp_ARMlogFile.getSelectedItem();
        this.addUpdateButton.setEnabled(true);
        int numberItems = this.inp_ARMlogFile.getItemCount();
        boolean duplicate = false;
        for (int i = 0; i < numberItems; ++i) {
            String item = (String)this.inp_ARMlogFile.getItemAt(i);
            if (!item.equals(fileName)) continue;
            duplicate = true;
        }
        if (!duplicate) {
            this.inp_ARMlogFile.insertItemAt((Object)fileName, 0);
        }
        this.inp_ARMlogFile.saveItems(VisualUtilities.AGGREGATION_ARMLOG_PATHS, VisualUtilities.MAX_PATHS);
    }

    public List performArmAnalysis(String updateType) {
        this.errorDialogDisplayed = false;
        this.generatedAggregations.clear();
        String ARMlogFile = (String)this.inp_ARMlogFile.getSelectedItem();
        File ARM_File = new File(ARMlogFile);
        ArrayList emptyList = new ArrayList();
        if (ModelUtilities.isBlank((String)ARMlogFile)) {
            MessageUtil.displayMessage((String)bundle.getString("Warning.NoARMlog.txt"), (int)1);
            this.parent.setCursor(Cursor.getPredefinedCursor(0));
            this.errorDialogDisplayed = true;
            return emptyList;
        }
        boolean exists = new File(ARMlogFile).exists();
        if (!exists) {
            MessageUtil.displayMessage((String)bundle.getString("Error.ARMlogNoExist.txt"), (int)0);
            this.parent.setCursor(Cursor.getPredefinedCursor(0));
            this.errorDialogDisplayed = true;
            return emptyList;
        }
        this.preserveLastLogFileUsed();
        OpRequestUI request = new OpRequestUI((Frame)Workspace.getWorkspace(), bundle.getString("ProgressBar.AnalyzingARM.txt"), bundle.getString("ProgressBar.window.title"));
        request.setProgressShownOnStatusBar(false);
        try {
            Transaction[] completedTransactions;
            int length;
            ARM_Analyzer arm_analyzer = new ARM_Analyzer(this.olapCube, ARM_File);
            request.execute((Runnable)arm_analyzer);
            if (arm_analyzer.getReturnValue() && (length = (completedTransactions = arm_analyzer.getCompletedTransactions()).length) > 0) {
                this.generatedAggregations = updateType.equals(ADDUPDATE) ? arm_analyzer.processAnalyzerResults(completedTransactions) : arm_analyzer.processAnalyzerResultsForStatistics(completedTransactions);
            }
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return this.generatedAggregations;
    }

    public void setAnalysisDisplay(AggregationsDisplayInterface displayObject) {
        this.resultsDisplayObject = displayObject;
    }

    class AddUpdateListener
    implements ActionListener {
        AddUpdateListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AggregationsARMLogPanel.this.resultsDisplayObject.stopCellEditing();
            AggregationsARMLogPanel.this.parent.setCursor(Cursor.getPredefinedCursor(3));
            List aggregationList = null;
            AggregationsARMLogPanel.this.choice = AggregationsARMLogPanel.this.radioGroup.getSelection().getActionCommand();
            if (AggregationsARMLogPanel.this.choice.equals(AggregationsARMLogPanel.ADDUPDATE)) {
                aggregationList = AggregationsARMLogPanel.this.performArmAnalysis(AggregationsARMLogPanel.ADDUPDATE);
                if (AggregationsARMLogPanel.this.errorDialogDisplayed) {
                    return;
                }
                if (aggregationList == null || aggregationList.isEmpty()) {
                    AggregationsARMLogPanel.this.parent.setCursor(Cursor.getPredefinedCursor(0));
                    MessageUtil.displayMessage((String)bundle.getString("Aggregations.ARM.NoResults.InfoMessage.txt"));
                } else {
                    ArrayList<OLAPAggregation> newList = new ArrayList<OLAPAggregation>();
                    for (int i = 0; i < aggregationList.size(); ++i) {
                        AggregationItem aggregationItem = (AggregationItem)aggregationList.get(i);
                        boolean aggregationInTable = AggregationsARMLogPanel.this.resultsDisplayObject.isDuplicateAggregation(aggregationItem);
                        if (aggregationInTable) continue;
                        try {
                            AggregationsARMLogPanel.this.aggregation = AggregationsARMLogPanel.this.tuningModel.createAggregation(aggregationItem);
                            newList.add(AggregationsARMLogPanel.this.aggregation);
                            continue;
                        }
                        catch (OLAPException e1) {
                            ExceptionHandler.handleException((Exception)((Object)e1));
                        }
                    }
                    if (newList.isEmpty()) {
                        AggregationsARMLogPanel.this.parent.setCursor(Cursor.getPredefinedCursor(0));
                        MessageUtil.displayMessage((String)bundle.getString("Aggregations.ARM.NoResults.InfoMessage.txt"));
                    } else {
                        AnalysisRecommendDialog recommendDialog = new AnalysisRecommendDialog(Workspace.getWorkspace(), bundle.getString("AnalysisRecommend.window.title"), AggregationsARMLogPanel.this.olapCube, newList, 0);
                        recommendDialog.show();
                        if (!recommendDialog.isCancelled()) {
                            List selectedAggregations = recommendDialog.getSelectedAggregations();
                            if (selectedAggregations != null && selectedAggregations.size() > 0) {
                                AggregationsARMLogPanel.this.resultsDisplayObject.addAggregations(selectedAggregations, 1);
                                AggregationsARMLogPanel.this.resultsDisplayObject.scrollDown();
                            }
                            List statisticsList = AggregationsARMLogPanel.this.performArmAnalysis(AggregationsARMLogPanel.UPDATEONLY);
                            AggregationsARMLogPanel.this.resultsDisplayObject.updateStatistics(statisticsList);
                        }
                    }
                }
            } else {
                List statisticsList = AggregationsARMLogPanel.this.performArmAnalysis(AggregationsARMLogPanel.UPDATEONLY);
                AggregationsARMLogPanel.this.resultsDisplayObject.updateStatistics(statisticsList);
            }
            AggregationsARMLogPanel.this.resultsDisplayObject.enableDisableExportAndBuild();
            AggregationsARMLogPanel.this.parent.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    class RadioListener
    implements ActionListener {
        RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AggregationsARMLogPanel.this.choice = AggregationsARMLogPanel.this.radioGroup.getSelection().getActionCommand();
            if (AggregationsARMLogPanel.this.choice.equals(AggregationsARMLogPanel.ADDUPDATE)) {
                VisualUtilities.setButtonTextAndMnemonic(AggregationsARMLogPanel.this.addUpdateButton, bundle.getString("Aggregations.ARM.Add.action.label"));
                AggregationsARMLogPanel.this.addUpdateButton.setToolTipText(bundle.getString("Aggregations.ARM.Add.action.tip"));
            } else {
                AggregationsARMLogPanel.this.addUpdateButton.setToolTipText(bundle.getString("Aggregations.ARM.UpdateStats.action.tip"));
            }
        }
    }

    class BrowseListener
    implements ActionListener {
        BrowseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AggregationsARMLogPanel.this.fileChooser.setDialogTitle(bundle.getString("FileChooser.window.title"));
            AggregationsARMLogPanel.this.fileChooser.setApproveButtonText(bundle.getString("FileChooser.ApproveButton.action.label"));
            AggregationsARMLogPanel.this.fileChooser.setFileFilter(AggregationsARMLogPanel.this.fileChooser.getAcceptAllFileFilter());
            AggregationsARMLogPanel.this.fileChooser.showDialog((Component)Workspace.getWorkspace(), null);
            File selectedFile = AggregationsARMLogPanel.this.fileChooser.getSelectedFile();
            if (selectedFile != null) {
                String filename = selectedFile.toString();
                AggregationsARMLogPanel.this.inp_ARMlogFile.setSelectedItem((Object)filename);
                AggregationsARMLogPanel.this.addUpdateButton.setEnabled(true);
            }
            Workspace workspace = Workspace.getWorkspace();
            workspace.getAppDefaultsFile().setPropertyString(AggregationsARMLogPanel.APPDEFAULTS_ARMLOG_DIR_KEY, AggregationsARMLogPanel.this.fileChooser.getCurrentDirectory().getPath());
        }
    }

    class armFilter
    extends FileFilter {
        armFilter() {
        }

        @Override
        public boolean accept(File f) {
            String extension = this.getExtension(f);
            if (extension != null) {
                return extension.equalsIgnoreCase("arm");
            }
            return false;
        }

        public String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }

        @Override
        public String getDescription() {
            return bundle.getString("FileChooser.FileType.arm.txt");
        }
    }
}

