/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.olapadmin.actions.AbstractCubeSelectionAction;
import com.sas.olapadmin.cubeviewer.CubeViewerDialog;
import com.sas.olapadmin.cubeviewer.CubeViewerPanel;
import com.sas.olapadmin.designer.model.OlapServer;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.storage.olap.OLAPException;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.awt.Dimension;
import java.rmi.RemoteException;

public class ViewCubeAction
extends AbstractCubeSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(ViewCubeAction.class);
    private static WorkspaceFile fileAppDefaults = Workspace.getWorkspace().getAppDefaultsFile();

    public ViewCubeAction() {
        super(bundle, "Cube.View", 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        OlapServer olapServer = null;
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            Workspace workspace = Workspace.getWorkspace();
            MdObjectStore store = null;
            try {
                workspace.setCursor(Cursor.getPredefinedCursor(3));
                store = Workspace.getMdFactory().createObjectStore(null, "ViewCubeAction");
                SimpleObject obj = (SimpleObject)aSelectedObjects[0];
                Cube cube = (Cube)ObjectConverter.getInstance().convertToJOMAObject(store, obj);
                String title = bundle.formatString("CubeViewer.window.title.fmt.txt", (Object)cube.getName());
                olapServer = new OlapServer(cube);
                olapServer.connect();
                CubeViewerDialog cubeViewerDialog = new CubeViewerDialog(workspace, title, cube, olapServer);
                int height = fileAppDefaults.getPropertyInt("ViewCube.height", 550);
                int width = fileAppDefaults.getPropertyInt("ViewCube.width", 800);
                cubeViewerDialog.setPreferredSize(new Dimension(width, height));
                CubeViewerPanel memberpanel = new CubeViewerPanel(cube, olapServer);
                cubeViewerDialog.setMainPanel(memberpanel);
                cubeViewerDialog.show();
            }
            catch (OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)new com.sas.olapadmin.designer.model.OLAPException(bundle.getString("ViewCube.NoResultsDisplayed.informational.txt"), (Throwable)e, 1)));
            }
            catch (com.sas.olapadmin.designer.model.OLAPException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            catch (RemoteException e) {
                ExceptionHandler.handleException((Exception)e);
            }
            catch (MdException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            finally {
                try {
                    if (store != null) {
                        store.dispose();
                    }
                    if (olapServer != null) {
                        olapServer.disconnect();
                        olapServer = null;
                    }
                }
                catch (RemoteException e) {
                }
                catch (com.sas.olapadmin.designer.model.OLAPException e) {
                    MessageUtil.displayMessage((String)e.getLocalizedMessage());
                }
                Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(0));
            }
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        boolean selectionOk = super.isSelectionValid(selectedObjects);
        if (selectionOk) {
            AbstractCubeSelectionAction.getCubePermissions((SimpleObject)selectedObjects[0]);
            selectionOk = canReadCube & exists;
        }
        return selectionOk;
    }
}

