/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.olapadmin.actions.AbstractCubeSelectionAction;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.update.CubeUpdateDesigner;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.swing.visuals.util.Util;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;

public class UpdateCubeAction
extends AbstractCubeSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(UpdateCubeAction.class);
    public static final int INPLACE = 0;
    public static final int COPY = 1;
    private int type;

    public UpdateCubeAction(int inType) {
        super(bundle, "Cube.Update.InPlace", 257);
        this.type = inType;
        if (this.type == 1) {
            String text = bundle.getString("Cube.Update.NewGen.txt");
            int cMnem = Util.getDisplayedMnemonic((String)text);
            int iMnem = Util.getDisplayedMnemonicIndex((String)text);
            text = Util.getLabelWithoutMnemonic((String)text);
            this.setText(text);
            this.putValue("MnemonicKey", new Integer(cMnem));
            this.putValue("MnemonicIndex", new Integer(iMnem));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            UpdateCubeAction.clearCurrentObject();
            if (this.isSelectionValid(aSelectedObjects)) {
                if (this.isCurrentGeneration(aSelectedObjects[0])) {
                    Workspace workspace = Workspace.getWorkspace();
                    MdObjectStore store = null;
                    try {
                        store = Workspace.getMdFactory().createObjectStore(null, "UpdateCubeAction");
                        SimpleObject obj = (SimpleObject)aSelectedObjects[0];
                        Cube cube = (Cube)ObjectConverter.getInstance().convertToJOMAObject(store, obj);
                        workspace.setCursor(Cursor.getPredefinedCursor(3));
                        OLAPCube olapCube = new OLAPCube(cube);
                        workspace.setCursor(Cursor.getPredefinedCursor(0));
                        if (olapCube.getErrorLevel() != -1) {
                            MessageUtil.displayDetailsMessage((String)bundle.getString("Cube.MetadataChanges.txt"), (int)2, (String)olapCube.getCubeVerifyMessage().toString());
                        }
                        if (olapCube.getTableSet().isLoadClassicSAS()) {
                            MessageUtil.displayMessage((String)bundle.getString("CubeTreeNode.FunctionNotAvailable.ClassicSAS.txt"));
                        }
                        if (!olapCube.getAggregationSet().isNWAYGenerated()) {
                            MessageUtil.displayMessage((String)bundle.getString("CubeTreeNode.FunctionNotAvailable.NONWAY.txt"));
                        }
                        if (olapCube.needsReorganizing()) {
                            MessageUtil.displayMessage((String)bundle.getString("Reorganize.Required.txt"), (int)1);
                        }
                        if (this.type == 0) {
                            CubeUpdateDesigner wacubedlg = new CubeUpdateDesigner((Frame)workspace, bundle.formatString("CubeUpdate.InPlace.window.title.fmt.txt", (Object)olapCube.getName()), olapCube, 0);
                            wacubedlg.show();
                        }
                        CubeUpdateDesigner wacubedlg = new CubeUpdateDesigner((Frame)workspace, bundle.formatString("CubeUpdate.NewGen.window.title.fmt.txt", (Object)olapCube.getName()), olapCube, 1);
                        wacubedlg.show();
                    }
                    catch (OLAPException error) {
                        ExceptionHandler.handleException((Exception)((Object)error));
                    }
                    catch (RemoteException error) {
                        ExceptionHandler.handleException((Exception)error);
                    }
                    catch (MdException error) {
                        ExceptionHandler.handleException((Exception)((Object)error));
                    }
                    finally {
                        workspace.setCursor(Cursor.getPredefinedCursor(0));
                        try {
                            if (store != null) {
                                store.dispose();
                            }
                        }
                        catch (RemoteException error) {}
                    }
                }
            } else {
                MessageUtil.displayMessage((String)bundle.getString("Action.NoPermissions.txt"));
            }
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        boolean selectionOk = super.isSelectionValid(selectedObjects);
        if (selectionOk) {
            AbstractCubeSelectionAction.getCubePermissions((SimpleObject)selectedObjects[0]);
            selectionOk = canReadAllCube & canWriteAllCube & exists;
        }
        return selectionOk;
    }
}

