/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.olapadmin.actions.AbstractCubeSelectionAction;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPDimension;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.model.OLAPList;
import com.sas.olapadmin.update.ReorganizeLevelsDialog;
import com.sas.olapadmin.update.ReorganizeLevelsPanel;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;

public class ReorganizeLevelsAction
extends AbstractCubeSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(ReorganizeLevelsAction.class);

    public ReorganizeLevelsAction() {
        super(bundle, "Cube.Update.Reorganize", 257);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] selectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            ReorganizeLevelsAction.clearCurrentObject();
            if (this.isSelectionValid(selectedObjects)) {
                Workspace workspace = Workspace.getWorkspace();
                MdObjectStore store = null;
                if (this.isCurrentGeneration(selectedObjects[0])) {
                    try {
                        store = Workspace.getMdFactory().createObjectStore(null, "CoalesceActionPerformed");
                        SimpleObject obj = (SimpleObject)selectedObjects[0];
                        Cube cube = (Cube)ObjectConverter.getInstance().convertToJOMAObject(store, obj);
                        workspace.setCursor(Cursor.getPredefinedCursor(3));
                        OLAPCube olapCube = new OLAPCube(cube);
                        workspace.setCursor(Cursor.getPredefinedCursor(0));
                        if (olapCube.getErrorLevel() != -1) {
                            MessageUtil.displayDetailsMessage((String)bundle.getString("Cube.MetadataChanges.txt"), (int)2, (String)olapCube.getCubeVerifyMessage().toString());
                        }
                        if (olapCube.getLanguageSet().isCubeMultipleLanguageSupported()) {
                            MessageUtil.displayMessage((String)bundle.getString("Reorganize.NoMLSCubeAllowed.txt"), (int)1);
                        }
                        if (!this.containsUpdateableDimensions(olapCube)) {
                            MessageUtil.displayMessage((String)bundle.getString("Reorganize.NoUpdateableDimensions.txt"), (int)1);
                        }
                        ReorganizeLevelsDialog dialog = new ReorganizeLevelsDialog((Frame)Workspace.getWorkspace(), bundle.getString("ReorganizeDialog.window.title"), true, new ReorganizeLevelsPanel(olapCube));
                        dialog.setResizable(true);
                        dialog.show();
                    }
                    catch (OLAPException error) {
                        ExceptionHandler.handleException((Exception)((Object)error));
                    }
                    catch (RemoteException error) {
                        ExceptionHandler.handleException((Exception)error);
                    }
                    catch (MdException error) {
                        ExceptionHandler.handleException((Exception)((Object)error));
                    }
                    finally {
                        workspace.setCursor(Cursor.getPredefinedCursor(0));
                        try {
                            if (store != null) {
                                store.dispose();
                            }
                        }
                        catch (RemoteException error) {}
                    }
                }
            } else {
                MessageUtil.displayMessage((String)bundle.getString("Action.NoPermissions.txt"), (int)1);
            }
        }
    }

    private boolean containsUpdateableDimensions(OLAPCube olapCube) {
        boolean updateable = true;
        try {
            OLAPList dimensions = olapCube.getDimensionSet().getCubeDimensions();
            int numUpdateable = 0;
            for (int i = 0; i < dimensions.size(); ++i) {
                OLAPDimension dim = (OLAPDimension)dimensions.get(i);
                if (!dim.isUpdateable()) continue;
                ++numUpdateable;
            }
            updateable = numUpdateable > 0;
        }
        catch (OLAPException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return updateable;
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        boolean selectionOk = super.isSelectionValid(selectedObjects);
        if (selectionOk) {
            AbstractCubeSelectionAction.getCubePermissions((SimpleObject)selectedObjects[0]);
            selectionOk = canReadAllCube & canWriteAllCube & exists & canReadAllCubeData;
        }
        return selectionOk;
    }
}

