/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.olapadmin.actions.AboutAction;
import com.sas.olapadmin.actions.AbstractCubeSelectionAction;
import com.sas.olapadmin.actions.AbstractSelectionAction;
import com.sas.olapadmin.actions.AbstractSharedDimensionSelectionAction;
import com.sas.olapadmin.actions.AggregationsAction;
import com.sas.olapadmin.actions.AnalysisAction;
import com.sas.olapadmin.actions.ArrangeAction;
import com.sas.olapadmin.actions.BuildCubeAction;
import com.sas.olapadmin.actions.BuildSharedDimensionAction;
import com.sas.olapadmin.actions.CalcMemberAction;
import com.sas.olapadmin.actions.CascadeAction;
import com.sas.olapadmin.actions.ChangeSchemaAction;
import com.sas.olapadmin.actions.ChangeSharedDimensionSchemaAction;
import com.sas.olapadmin.actions.ClearCredentialsAction;
import com.sas.olapadmin.actions.ClearMessagesAction;
import com.sas.olapadmin.actions.CloseAllAction;
import com.sas.olapadmin.actions.CoalesceCubeAction;
import com.sas.olapadmin.actions.CopyAction;
import com.sas.olapadmin.actions.CopyToFolderAction;
import com.sas.olapadmin.actions.DeletePhysicalCubeAction;
import com.sas.olapadmin.actions.DeletePhysicalSharedDimensionAction;
import com.sas.olapadmin.actions.DeployJobCubeAction;
import com.sas.olapadmin.actions.DisplayLibnameAction;
import com.sas.olapadmin.actions.DisplayLibraryServerAction;
import com.sas.olapadmin.actions.EditCubeAction;
import com.sas.olapadmin.actions.EditSharedDimensionAction;
import com.sas.olapadmin.actions.EnableDisableCubeAction;
import com.sas.olapadmin.actions.ExitAction;
import com.sas.olapadmin.actions.ExportAction;
import com.sas.olapadmin.actions.ExportCodeAction;
import com.sas.olapadmin.actions.ExportSharedDimensionCodeAction;
import com.sas.olapadmin.actions.FindInFoldersAction;
import com.sas.olapadmin.actions.HelpContentsAction;
import com.sas.olapadmin.actions.ImportAction;
import com.sas.olapadmin.actions.ManagePermTables;
import com.sas.olapadmin.actions.MetadataProfileAction;
import com.sas.olapadmin.actions.MoveToFolderAction;
import com.sas.olapadmin.actions.NewCubeAction;
import com.sas.olapadmin.actions.NewDocumentAction;
import com.sas.olapadmin.actions.NewFolderAction;
import com.sas.olapadmin.actions.NewLibraryAction;
import com.sas.olapadmin.actions.NewNoteAction;
import com.sas.olapadmin.actions.NewOLAPSchemaAction;
import com.sas.olapadmin.actions.NewSharedDimensionAction;
import com.sas.olapadmin.actions.OpenDocumentAction;
import com.sas.olapadmin.actions.OptionsAction;
import com.sas.olapadmin.actions.PasteAction;
import com.sas.olapadmin.actions.PasteSpecialAction;
import com.sas.olapadmin.actions.PropertiesAction;
import com.sas.olapadmin.actions.QuickEditAction;
import com.sas.olapadmin.actions.RedeployJobCubeAction;
import com.sas.olapadmin.actions.RefreshCubeAction;
import com.sas.olapadmin.actions.RegisterTableAction;
import com.sas.olapadmin.actions.ReorganizeLevelsAction;
import com.sas.olapadmin.actions.ReorganizeSharedDimensionLevelsAction;
import com.sas.olapadmin.actions.SharedDimensionQuickEditAction;
import com.sas.olapadmin.actions.SyncCubeAction;
import com.sas.olapadmin.actions.UpdateCubeAction;
import com.sas.olapadmin.actions.UpdateSharedDimensionAction;
import com.sas.olapadmin.actions.UpgradeMetadataObjectAction;
import com.sas.olapadmin.actions.ViewCubeAction;
import com.sas.olapadmin.actions.ViewDataAction;
import com.sas.olapadmin.actions.ViewMessageWindow;
import com.sas.olapadmin.actions.ViewSearchAction;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.VersionValidator;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.swing.visuals.util.Util;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsAbstractToggleAction;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsDropMenuAction;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.WsUIUtilities;
import com.sas.workspace.WsWindowsDialog;
import com.sas.workspace.models.SimpleObject;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;

public class OLAPActionsManager
extends WsAbstractApplicationActionsManager {
    private static WAdminResource bundle = new WAdminResource(OLAPActionsManager.class);
    public static final String FILE = "File";
    public static final String FILE_NEW = "File:New";
    public static final String FILE_NEW_FOLDER = "File:New:Folder";
    public static final String FILE_NEW_CUBE = "File:New:Cube";
    public static final String FILE_NEW_LIBRARY = "File:New:Library";
    public static final String FILE_NEW_OLAPSCHEMA = "File:New:OLAPSchema";
    public static final String FILE_NEW_NOTE = "File:New:Note";
    public static final String FILE_NEW_DOCUMENT = "File:New:Document";
    public static final String FILE_NEW_SHARED_DIM = "File:New:SharedDim";
    public static final String FILE_CHANGE_PROFILE = "File:ChangeProfile";
    public static final String FILE_CLEAR_CREDENTIALS = "File:ClearCredentials";
    public static final String FILE_IMPORT = "File:ImportCube";
    public static final String FILE_REGISTER_TABLE = "File:RegisterTable";
    public static final String FILE_EXPORT = "File:ExportCube";
    public static final String FILE_EXIT = "File:Exit";
    public static final String EDIT = "Edit";
    public static final String EDIT_COPY = "Common:Copy";
    public static final String EDIT_PASTE = "Common:Paste";
    public static final String EDIT_PASTE_SPECIAL = "Common:PasteSpecial";
    public static final String EDIT_DELETE = "Common:Delete";
    public static final String EDIT_RENAME = "Common:Rename";
    public static final String EDIT_COPY_TO_FOLDER = "Edit:CopyToFolder";
    public static final String EDIT_MOVE_TO_FOLDER = "Edit:MoveToFolder";
    public static final String EDIT_FIND_IN_FOLDERS = "Edit:FindInFolders";
    public static final String EDIT_PROPERTIES = "Edit:Properties";
    public static final String VIEW = "View";
    public static final String VIEW_MESSAGE = "View:Message";
    public static final String VIEW_CLEAR = "View:Clear";
    public static final String VIEW_REFRESH = "Common:Refresh";
    public static final String ACTIONS = "Actions";
    public static final String CUBE_BUILD = "Cube:Build";
    public static final String CUBE_QUICK_EDIT = "Cube:QuickEdit";
    public static final String CUBE_EDIT = "Cube:Edit";
    public static final String CUBE_UPDATE_INPLACE = "Cube:InPlace";
    public static final String CUBE_UPDATE_NEWGEN = "Cube:NewGen";
    public static final String CUBE_UPDATE_COALESCE = "Cube:Coalesce";
    public static final String CUBE_UPDATE_REORGANIZE = "Cube:Reorganize";
    public static final String CUBE_VIEW = "Cube:View";
    public static final String CUBE_EXPORT_CODE = "Cube:ExportCode";
    public static final String CUBE_ENABLE = "Cube:Enable";
    public static final String CUBE_DISABLE = "Cube:Disable";
    public static final String CUBE_CALCMEM = "Cube:CalcMembers";
    public static final String CUBE_AGGREGATION = "Cube:Aggregations";
    public static final String CUBE_SYNCH = "Cube:Synch";
    public static final String CUBE_OLAPSCHEMA = "Cube:OLAPSchema";
    public static final String CUBE_DELETE_PHYSICAL = "Cube:DeletePhysical";
    public static final String CUBE_REFRESH_CUBE = "Cube:RefreshCube";
    public static final String SCHEDULING = "Scheduling";
    public static final String DEPLOY_JOBCUBE = "JobCube:Deploy";
    public static final String REDEPLOY_JOBCUBE = "JobCube:Redeploy";
    public static final String DOCUMENT_OPEN = "Document:Open";
    public static final String TOOLS = "Tools";
    public static final String TOOLS_IMPACT = "Tools:Impact";
    public static final String TOOLS_OPTIONS = "Tools:Options";
    public static final String TOOLS_PERMTABLES = "Tools:Manage_PermTables";
    public static final String WINDOW = "Window";
    public static final String WINDOW_CASCADE = "Window:Cascade";
    public static final String WINDOW_TILE_HORIZ = "Window:TileHorizontal";
    public static final String WINDOW_TILE_VERT = "Window:TileVertical";
    public static final String WINDOW_CLOSE = "Window:Close";
    public static final String WINDOW_CLOSE_ALL = "Window:CloseAll";
    public static final String WINDOW_ACTIVATE = "Window:Activate nn";
    public static final String HELP = "Help";
    public static final String HELP_CONTENTS = "Help:Contents";
    public static final String HELP_ABOUT = "Help:About";
    private static final String CONTEXT_UPDATE = "Context:Update";
    private static final String CONTEXT_MAINTAIN = "Context:Maintain";
    public static final String CONTEXT_UPGRADE_METADATA = "Context:Upgrade";
    private static final String TABLE_VIEW_DATA = "Actions:ViewData";
    private static final String TABLE_DISPLAY_LIBSERVER = "Actions:DisplayLibServer";
    private static final String LIBRARY_DISPLAY_LIBNAME = "Actions:DisplayLibname";
    private static final String SEARCH_FOLDER_VIEW = "Actions:ViewSearchFolder";
    public static final String BUILD_SHARED_DIMENSION = "Actions:SharedDimension";
    public static final String SHAREDDIM_EDIT = "SharedDim:Edit";
    public static final String SHAREDDIMENSION_QUICK_EDIT = "SharedDimension:QuickEdit";
    public static final String SHAREDDIMENSION_UPDATE_INPLACE = "SharedDimension:InPlace";
    public static final String SHAREDDIMENSION_UPDATE_REORGANIZE = "SharedDimension:Reorganize";
    public static final String SHAREDDIMENSION_EXPORT_CODE = "SharedDimension:ExportCode";
    public static final String SHAREDDIMENSION_OLAPSCHEMA = "SharedDimension:OLAPSchema";
    public static final String SHAREDDIMENSION_DELETE_PHYSICAL = "SharedDimension:DeletePhysical";
    private static final String CONTEXT_NEWFOLDER = "Common:NewFolder";
    private static final String SEPARATOR_NAME = "RemoveMe";
    private Map m_mapOldToNew;
    private JMenu mnuActions;
    private SelectionChangedListener selectionListener;
    private EditMenuListener mnuEditListener;
    private ContextPopupMenuListener mnuContextListener;
    private WsAbstractAction emptyRuntimeAction;
    private RefreshActionProxy refreshActionProxy;
    private VersionValidator m_validator;

    public OLAPActionsManager() {
        this.createOldToNewMap();
        this.selectionListener = new SelectionChangedListener();
        this.mnuEditListener = new EditMenuListener();
        this.mnuContextListener = new ContextPopupMenuListener();
        this.m_validator = VersionValidator.getInstance();
    }

    private void addMenuItemFor(String sActionKey, JMenu menu, Object[] objects) {
        WsAbstractAction action = this.getAction(sActionKey);
        if (action != null && action instanceof AbstractSelectionAction && ((AbstractSelectionAction)action).isValidForObjects(objects)) {
            menu.add(this.createMenuItem(sActionKey));
        }
    }

    private JMenuItem addPopupMenuItemFor(String sActionKey, JPopupMenu mnuPopup, WsActionContextInterface context) {
        JMenuItem menuItem = null;
        WsAbstractAction action = this.getAction(sActionKey);
        if (sActionKey.equals(CONTEXT_UPGRADE_METADATA)) {
            if (action.isEnabled()) {
                boolean createUpgradeMenuItem = true;
                Object[] aObjects = context.getSelectedObjects();
                for (int i = 0; i < aObjects.length; ++i) {
                    if (!(aObjects[i] instanceof SimpleObject)) {
                        createUpgradeMenuItem = false;
                        break;
                    }
                    SimpleObject sObject = (SimpleObject)aObjects[i];
                    String type = sObject.getPublicType();
                    if ("DeployedJob".equals(type) || "Job.CubeBuild".equals(type)) break;
                }
                if (createUpgradeMenuItem) {
                    menuItem = WsUIUtilities.createMenuItem((WsAbstractAction)action);
                }
            }
        } else if (this.isActionValidForContext(action, context)) {
            menuItem = WsUIUtilities.createMenuItem((WsAbstractAction)action);
            if (sActionKey.equals(EDIT_PROPERTIES)) {
                Font font = menuItem.getFont();
                menuItem.setFont(font.deriveFont(font.getStyle() | 1));
            }
        }
        if (menuItem != null) {
            mnuPopup.add(menuItem);
        }
        return menuItem;
    }

    public void appendPopupMenuActions(JPopupMenu popupMenu, WsActionContextInterface context) {
    }

    private void addNewItem(Object[] aObjects, JPopupMenu popupMenu) {
        if (aObjects.length == 1 && aObjects[0] instanceof SimpleObject && "Folder".equals(((SimpleObject)aObjects[0]).getPublicType())) {
            popupMenu.add(this.createFileNewMenu(CONTEXT_NEWFOLDER));
            popupMenu.add(this.createMenuItem(FILE_REGISTER_TABLE));
        }
    }

    private void addSeparator(JMenu menu) {
        Component comp;
        int iLastComp = menu.getItemCount() - 1;
        if (iLastComp >= 0 && !((comp = menu.getMenuComponent(iLastComp)) instanceof JSeparator)) {
            menu.add(new JSeparator(0));
        }
    }

    private void addSeparator(JPopupMenu popupMenu) {
        Component comp;
        int iLastComp = popupMenu.getComponentCount() - 1;
        if (iLastComp >= 0 && !((comp = popupMenu.getComponent(iLastComp)) instanceof JSeparator)) {
            popupMenu.addSeparator();
        }
    }

    public void attachAction(String sActionKey, WsAbstractAction action, boolean bAttach) {
        String sNew = (String)this.m_mapOldToNew.get(sActionKey);
        if (sNew != null) {
            sActionKey = sNew;
        }
        super.attachAction(sActionKey, action, bAttach);
    }

    private void createAccelerators() {
        this.getAction(EDIT_COPY).setAccelerator(KeyStroke.getKeyStroke(67, 2));
        this.getAction(EDIT_PASTE).setAccelerator(KeyStroke.getKeyStroke(86, 2));
        this.getAction(VIEW_REFRESH).setAccelerator(KeyStroke.getKeyStroke(116, 0));
        this.getAction(HELP_CONTENTS).setAccelerator(KeyStroke.getKeyStroke(112, 0));
    }

    protected void createActions() {
        this.emptyRuntimeAction = this.createEmptyAction(FILE, bundle, "File.menu.title", 256);
        this.createEmptyAction(FILE_NEW, bundle, "File.New", 258);
        this.registerAction(FILE_NEW_CUBE, new NewCubeAction());
        this.registerAction(FILE_NEW_LIBRARY, new NewLibraryAction());
        this.registerAction(FILE_NEW_OLAPSCHEMA, new NewOLAPSchemaAction());
        this.registerAction(FILE_NEW_FOLDER, new NewFolderAction());
        this.registerAction(FILE_NEW_NOTE, new NewNoteAction());
        this.registerAction(FILE_NEW_DOCUMENT, new NewDocumentAction());
        this.registerAction(FILE_REGISTER_TABLE, new RegisterTableAction());
        this.registerAction(FILE_NEW_SHARED_DIM, new NewSharedDimensionAction());
        this.registerAction(FILE_IMPORT, new ImportAction());
        this.registerAction(FILE_EXPORT, new ExportAction());
        this.registerAction(FILE_CHANGE_PROFILE, new MetadataProfileAction());
        this.registerAction(FILE_CLEAR_CREDENTIALS, new ClearCredentialsAction());
        this.registerAction(FILE_EXIT, new ExitAction());
        this.createEmptyAction(EDIT, bundle, "Edit.menu.title", 256);
        this.registerAction(EDIT_COPY, new CopyAction());
        this.registerAction(EDIT_PASTE, new PasteAction());
        this.registerAction(EDIT_PASTE_SPECIAL, new PasteSpecialAction());
        this.createAttachAction(EDIT_DELETE, bundle, "Edit.Delete", 2);
        this.createAttachAction(EDIT_RENAME, bundle, "Edit.Rename", 257);
        this.registerAction(EDIT_COPY_TO_FOLDER, new CopyToFolderAction());
        this.registerAction(EDIT_MOVE_TO_FOLDER, new MoveToFolderAction());
        this.registerAction(EDIT_FIND_IN_FOLDERS, new FindInFoldersAction());
        this.createAttachAction(EDIT_PROPERTIES, bundle, "Edit.Properties", 2);
        this.createEmptyAction(VIEW, bundle, "View.menu.title", 256);
        this.registerAction(VIEW_MESSAGE, (WsAbstractAction)new ViewMessageWindow());
        this.registerAction(VIEW_CLEAR, new ClearMessagesAction());
        this.refreshActionProxy = new RefreshActionProxy();
        this.createEmptyAction(ACTIONS, bundle, "Actions.menu.title", 256);
        this.registerAction(CUBE_BUILD, new BuildCubeAction());
        this.registerAction(CUBE_EDIT, new EditCubeAction());
        this.registerAction(CUBE_VIEW, new ViewCubeAction());
        this.registerAction(CUBE_EXPORT_CODE, new ExportCodeAction());
        this.registerAction(CUBE_ENABLE, new EnableDisableCubeAction(0));
        this.registerAction(CUBE_DISABLE, new EnableDisableCubeAction(1));
        this.registerAction(CUBE_CALCMEM, new CalcMemberAction());
        this.registerAction(CUBE_AGGREGATION, new AggregationsAction());
        this.registerAction(CUBE_UPDATE_INPLACE, new UpdateCubeAction(0));
        this.registerAction(CUBE_UPDATE_NEWGEN, new UpdateCubeAction(1));
        this.registerAction(CUBE_UPDATE_COALESCE, new CoalesceCubeAction());
        this.registerAction(CUBE_SYNCH, new SyncCubeAction());
        this.registerAction(CUBE_QUICK_EDIT, new QuickEditAction());
        this.registerAction(CUBE_UPDATE_REORGANIZE, new ReorganizeLevelsAction());
        this.registerAction(CUBE_OLAPSCHEMA, new ChangeSchemaAction());
        this.registerAction(CUBE_DELETE_PHYSICAL, new DeletePhysicalCubeAction());
        this.registerAction(CUBE_REFRESH_CUBE, new RefreshCubeAction());
        this.registerAction(SHAREDDIM_EDIT, new EditSharedDimensionAction());
        this.registerAction(TABLE_VIEW_DATA, new ViewDataAction());
        this.registerAction(TABLE_DISPLAY_LIBSERVER, new DisplayLibraryServerAction());
        this.registerAction(LIBRARY_DISPLAY_LIBNAME, new DisplayLibnameAction());
        this.registerAction(SEARCH_FOLDER_VIEW, new ViewSearchAction());
        this.registerAction(BUILD_SHARED_DIMENSION, new BuildSharedDimensionAction());
        this.registerAction(SHAREDDIMENSION_UPDATE_INPLACE, new UpdateSharedDimensionAction(0));
        this.registerAction(SHAREDDIMENSION_QUICK_EDIT, new SharedDimensionQuickEditAction());
        this.registerAction(SHAREDDIMENSION_UPDATE_REORGANIZE, new ReorganizeSharedDimensionLevelsAction());
        this.registerAction(SHAREDDIMENSION_EXPORT_CODE, new ExportSharedDimensionCodeAction());
        this.registerAction(SHAREDDIMENSION_OLAPSCHEMA, new ChangeSharedDimensionSchemaAction());
        this.registerAction(SHAREDDIMENSION_DELETE_PHYSICAL, new DeletePhysicalSharedDimensionAction());
        this.createEmptyAction(SCHEDULING, bundle, "Scheduling.menu.title", 257);
        this.registerAction(DEPLOY_JOBCUBE, new DeployJobCubeAction());
        this.registerAction(REDEPLOY_JOBCUBE, new RedeployJobCubeAction());
        this.registerAction(DOCUMENT_OPEN, new OpenDocumentAction());
        this.createEmptyAction(TOOLS, bundle, "Tools.menu.title", 256);
        this.registerAction(TOOLS_IMPACT, new AnalysisAction());
        this.registerAction(TOOLS_OPTIONS, new OptionsAction());
        this.registerAction(TOOLS_PERMTABLES, new ManagePermTables());
        this.createEmptyAction(WINDOW, bundle, "Window.menu.title", 256);
        this.registerAction(WINDOW_CASCADE, new CascadeAction());
        this.registerAction(WINDOW_TILE_HORIZ, new ArrangeAction(0));
        this.registerAction(WINDOW_TILE_VERT, new ArrangeAction(1));
        this.createAttachAction(WINDOW_CLOSE, bundle, "Window.Close", 257);
        this.registerAction(WINDOW_CLOSE_ALL, new CloseAllAction());
        this.createEmptyAction(HELP, bundle, "Help.menu.title", 256);
        this.registerAction(HELP_CONTENTS, new HelpContentsAction());
        this.registerAction(HELP_ABOUT, new AboutAction());
        this.registerAction("Application:Properties", new PropertiesAction());
        this.registerAction(CONTEXT_UPGRADE_METADATA, new UpgradeMetadataObjectAction());
        this.createEmptyAction(CONTEXT_UPDATE, bundle, "Context.Update.title", 257);
        this.createEmptyAction(CONTEXT_MAINTAIN, bundle, "Context.Maintain.title", 257);
        this.createAttachAction(CONTEXT_NEWFOLDER, bundle, "Context.NewFolder", 258);
        this.createAttachAction("Common:Print", bundle, "Print", 2);
    }

    protected JMenuBar createMenuBar() {
        this.createAccelerators();
        JMenuBar menuMain = new JMenuBar();
        JMenu mnuFile = this.createMenu(FILE);
        menuMain.add(mnuFile);
        mnuFile.add(this.createFileNewMenu(FILE_NEW_FOLDER));
        mnuFile.add(this.createMenuItem(FILE_REGISTER_TABLE));
        mnuFile.add(new JSeparator(0));
        mnuFile.add(this.createMenuItem(FILE_EXPORT));
        mnuFile.add(this.createMenuItem(FILE_IMPORT));
        mnuFile.add(new JSeparator(0));
        mnuFile.add(this.createMenuItem(FILE_CHANGE_PROFILE));
        mnuFile.add(this.createMenuItem(FILE_CLEAR_CREDENTIALS));
        mnuFile.add(new JSeparator(0));
        mnuFile.add(this.createMenuItem(FILE_EXIT));
        JMenu mnuEdit = this.createMenu(EDIT);
        mnuEdit.addMenuListener(this.mnuEditListener);
        menuMain.add(mnuEdit);
        mnuEdit.add(this.createMenuItem(EDIT_COPY));
        mnuEdit.add(this.createMenuItem(EDIT_PASTE));
        mnuEdit.add(this.createMenuItem(EDIT_PASTE_SPECIAL));
        mnuEdit.add(new JSeparator(0));
        mnuEdit.add(this.createMenuItem(EDIT_DELETE));
        mnuEdit.add(this.createMenuItem(EDIT_RENAME));
        mnuEdit.add(new JSeparator(0));
        mnuEdit.add(this.createMenuItem(EDIT_COPY_TO_FOLDER));
        mnuEdit.add(this.createMenuItem(EDIT_MOVE_TO_FOLDER));
        mnuEdit.add(new JSeparator(0));
        mnuEdit.add(this.createMenuItem(EDIT_FIND_IN_FOLDERS));
        mnuEdit.add(new JSeparator(0));
        mnuEdit.add(this.createMenuItem(EDIT_PROPERTIES));
        JMenu mnuView = this.createMenu(VIEW);
        menuMain.add(mnuView);
        mnuView.add(this.createCheckBoxMenuItem(VIEW_MESSAGE));
        mnuView.add(this.createMenuItem(VIEW_CLEAR));
        mnuView.add(new JSeparator(0));
        mnuView.add(this.createMenuItem(VIEW_REFRESH));
        this.mnuActions = this.createMenu(ACTIONS);
        menuMain.add(this.mnuActions);
        this.mnuActions.addMenuListener(new ActionsMenuListener());
        this.mnuActions.setEnabled(false);
        JMenu mnuTools = this.createMenu(TOOLS);
        menuMain.add(mnuTools);
        mnuTools.add(this.createMenuItem(TOOLS_IMPACT));
        mnuTools.add(this.createMenuItem(TOOLS_PERMTABLES));
        mnuTools.add(new JSeparator(0));
        mnuTools.add(this.createMenuItem(TOOLS_OPTIONS));
        JMenu mnuWindow = this.createMenu(WINDOW);
        mnuWindow.addMenuListener(new WindowMenuListener());
        menuMain.add(mnuWindow);
        mnuWindow.add(this.createMenuItem(WINDOW_CASCADE));
        mnuWindow.add(this.createMenuItem(WINDOW_TILE_HORIZ));
        mnuWindow.add(this.createMenuItem(WINDOW_TILE_VERT));
        mnuWindow.add(new JSeparator(0));
        mnuWindow.add(this.createMenuItem(WINDOW_CLOSE));
        mnuWindow.add(this.createMenuItem(WINDOW_CLOSE_ALL));
        JMenu mnuHelp = this.createMenu(HELP);
        menuMain.add(mnuHelp);
        mnuHelp.add(this.createMenuItem(HELP_CONTENTS));
        mnuHelp.add(this.createMenuItem(HELP_ABOUT));
        return menuMain;
    }

    private JMenu createFileNewMenu(String newFolderAction) {
        JMenu mnuNew = this.createMenu(FILE_NEW);
        mnuNew.add(this.createMenuItem(FILE_NEW_CUBE));
        mnuNew.add(this.createMenuItem(FILE_NEW_LIBRARY));
        mnuNew.add(this.createMenuItem(FILE_NEW_OLAPSCHEMA));
        mnuNew.add(this.createMenuItem(FILE_NEW_SHARED_DIM));
        mnuNew.add(this.createMenuItem(FILE_NEW_DOCUMENT));
        mnuNew.add(this.createMenuItem(FILE_NEW_NOTE));
        mnuNew.add(new JSeparator(0));
        mnuNew.add(this.createMenuItem(newFolderAction));
        return mnuNew;
    }

    private void createOldToNewMap() {
        this.m_mapOldToNew = new HashMap();
        this.m_mapOldToNew.put("close", WINDOW_CLOSE);
        this.m_mapOldToNew.put("delete", EDIT_DELETE);
        this.m_mapOldToNew.put("rename", EDIT_RENAME);
        this.m_mapOldToNew.put("refresh", VIEW_REFRESH);
    }

    public JPopupMenu createPopupMenuFor(WsActionContextInterface context) {
        JPopupMenu popupMenu = new JPopupMenu();
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            Object[] aObjects = context.getSelectedObjects();
            String contextType = context.getType();
            if ("InventoryTree".equals(contextType) && aObjects.length == 1 && aObjects[0] instanceof TypeDescriptorInterface) {
                try {
                    String sType = ((TypeDescriptorInterface)aObjects[0]).getTypeName();
                    JMenuItem newItem = null;
                    if ("Cube".equals(sType)) {
                        newItem = this.createMenuItem(FILE_NEW_CUBE);
                        WsUIUtilities.updateMenuItemText((JMenuItem)newItem, (String)bundle.getString("InventoryTree.ContextAction.NewCube.action.label"));
                    } else if ("Library".equals(sType)) {
                        newItem = this.createMenuItem(FILE_NEW_LIBRARY);
                        WsUIUtilities.updateMenuItemText((JMenuItem)newItem, (String)bundle.getString("InventoryTree.ContextAction.NewLibrary.action.label"));
                    } else if ("OLAPSchema".equals(sType)) {
                        newItem = this.createMenuItem(FILE_NEW_OLAPSCHEMA);
                        WsUIUtilities.updateMenuItemText((JMenuItem)newItem, (String)bundle.getString("InventoryTree.ContextAction.NewOLAPSchema.action.label"));
                    } else if ("Note".equals(sType)) {
                        newItem = this.createMenuItem(FILE_NEW_NOTE);
                        WsUIUtilities.updateMenuItemText((JMenuItem)newItem, (String)bundle.getString("InventoryTree.ContextAction.NewNote.action.label"));
                    } else if ("Document".equals(sType)) {
                        newItem = this.createMenuItem(FILE_NEW_DOCUMENT);
                        WsUIUtilities.updateMenuItemText((JMenuItem)newItem, (String)bundle.getString("InventoryTree.ContextAction.NewDocument.action.label"));
                    } else if ("Table".equals(sType)) {
                        newItem = this.createMenuItem(FILE_REGISTER_TABLE);
                    } else if ("SharedDimension".equals(sType)) {
                        newItem = this.createMenuItem(FILE_NEW_SHARED_DIM);
                        WsUIUtilities.updateMenuItemText((JMenuItem)newItem, (String)bundle.getString("InventoryTree.ContextAction.NewSharedDim.action.label"));
                    }
                    if (newItem != null) {
                        popupMenu.add(newItem);
                    }
                }
                catch (ServiceException e) {
                    ExceptionHandler.handleException((Exception)((Object)e));
                }
                catch (RemoteException e) {
                    ExceptionHandler.handleException((Exception)e);
                }
            }
            this.addPopupMenuItemFor(CONTEXT_UPGRADE_METADATA, popupMenu, context);
            if (aObjects.length == 1 && aObjects[0] instanceof SimpleObject) {
                SimpleObject obj = (SimpleObject)aObjects[0];
                String type = obj.getPublicType();
                if ("Folder".equals(obj.getPublicType())) {
                    this.addNewItem(aObjects, popupMenu);
                    this.addSeparator(popupMenu);
                    this.addPopupMenuItemFor(FILE_EXPORT, popupMenu, context);
                    this.addPopupMenuItemFor(FILE_IMPORT, popupMenu, context);
                    this.addSeparator(popupMenu);
                    this.addPopupMenuItemFor(EDIT_COPY, popupMenu, context);
                    this.addPopupMenuItemFor(EDIT_PASTE, popupMenu, context);
                    this.addPopupMenuItemFor(EDIT_PASTE_SPECIAL, popupMenu, context);
                    this.addSeparator(popupMenu);
                    this.addPopupMenuItemFor(EDIT_DELETE, popupMenu, context);
                    this.addPopupMenuItemFor(EDIT_RENAME, popupMenu, context);
                    this.addSeparator(popupMenu);
                } else if ("Cube".equals(type) || "Library".equals(type) || "Table".equals(type) || "OLAPSchema".equals(type) || "Job.CubeBuild".equals(type) || "Note".equals(type) || "Document".equals(type) || "DeployedJob".equals(type) || "SharedDimension".equals(type) || "SearchFolder".equals(type)) {
                    SimpleObject obj2;
                    this.addPopupMenuItemFor(DOCUMENT_OPEN, popupMenu, context);
                    this.addPopupMenuItemFor(TABLE_VIEW_DATA, popupMenu, context);
                    this.addPopupMenuItemFor(TABLE_DISPLAY_LIBSERVER, popupMenu, context);
                    this.addPopupMenuItemFor(LIBRARY_DISPLAY_LIBNAME, popupMenu, context);
                    this.addPopupMenuItemFor(SEARCH_FOLDER_VIEW, popupMenu, context);
                    this.addPopupMenuItemFor(CUBE_BUILD, popupMenu, context);
                    this.addPopupMenuItemFor(CUBE_EDIT, popupMenu, context);
                    this.addPopupMenuItemFor(CUBE_QUICK_EDIT, popupMenu, context);
                    JMenu updateMenu = this.createMenu(CONTEXT_UPDATE);
                    this.addPopupMenuItemFor(CUBE_UPDATE_INPLACE, updateMenu.getPopupMenu(), context);
                    this.addPopupMenuItemFor(CUBE_UPDATE_NEWGEN, updateMenu.getPopupMenu(), context);
                    this.addSeparator(updateMenu);
                    this.addPopupMenuItemFor(CUBE_UPDATE_COALESCE, updateMenu.getPopupMenu(), context);
                    this.addPopupMenuItemFor(CUBE_UPDATE_REORGANIZE, updateMenu.getPopupMenu(), context);
                    if (updateMenu.getItemCount() > 0) {
                        popupMenu.add(updateMenu);
                    }
                    this.addPopupMenuItemFor(CUBE_AGGREGATION, popupMenu, context);
                    this.addPopupMenuItemFor(CUBE_VIEW, popupMenu, context);
                    this.addPopupMenuItemFor(CUBE_EXPORT_CODE, popupMenu, context);
                    this.addSeparator(popupMenu);
                    this.createMaintainMenu(context, popupMenu);
                    this.addSeparator(popupMenu);
                    this.addPopupMenuItemFor(CUBE_DISABLE, popupMenu, context);
                    this.addPopupMenuItemFor(CUBE_ENABLE, popupMenu, context);
                    this.addPopupMenuItemFor(BUILD_SHARED_DIMENSION, popupMenu, context);
                    this.addPopupMenuItemFor(SHAREDDIM_EDIT, popupMenu, context);
                    this.addPopupMenuItemFor(SHAREDDIMENSION_QUICK_EDIT, popupMenu, context);
                    JMenu updateMenu2 = this.createMenu(CONTEXT_UPDATE);
                    this.addPopupMenuItemFor(SHAREDDIMENSION_UPDATE_INPLACE, updateMenu2.getPopupMenu(), context);
                    this.addPopupMenuItemFor(SHAREDDIMENSION_UPDATE_REORGANIZE, updateMenu2.getPopupMenu(), context);
                    if (updateMenu2.getItemCount() > 0) {
                        popupMenu.add(updateMenu2);
                    }
                    this.addPopupMenuItemFor(SHAREDDIMENSION_EXPORT_CODE, popupMenu, context);
                    Object[] aObjects2 = context.getSelectedObjects();
                    if (aObjects2.length == 1 && aObjects2[0] instanceof SimpleObject && "SharedDimension".equals((obj2 = (SimpleObject)aObjects2[0]).getPublicType())) {
                        AbstractSharedDimensionSelectionAction.getSharedDimensionPermissions((SimpleObject)aObjects2[0]);
                        if (AbstractSharedDimensionSelectionAction.exists) {
                            this.addSeparator(popupMenu);
                            JMenu updateMenu3 = this.createMenu(CONTEXT_MAINTAIN);
                            this.addPopupMenuItemFor(SHAREDDIMENSION_OLAPSCHEMA, updateMenu3.getPopupMenu(), context);
                            this.addPopupMenuItemFor(SHAREDDIMENSION_DELETE_PHYSICAL, updateMenu3.getPopupMenu(), context);
                            this.addSeparator(popupMenu);
                            if (updateMenu3.getItemCount() > 0) {
                                popupMenu.add(updateMenu3);
                            }
                        } else if (!AbstractSharedDimensionSelectionAction.exists) {
                            this.addSeparator(popupMenu);
                            this.addPopupMenuItemFor(SHAREDDIMENSION_OLAPSCHEMA, popupMenu, context);
                        }
                    }
                    JMenu jobsMenu = this.createMenu(SCHEDULING);
                    this.addPopupMenuItemFor(DEPLOY_JOBCUBE, jobsMenu.getPopupMenu(), context);
                    this.addPopupMenuItemFor(REDEPLOY_JOBCUBE, jobsMenu.getPopupMenu(), context);
                    this.addSeparator(jobsMenu.getPopupMenu());
                    RedeployJobCubeAction.addDeployedJobsToMenu(jobsMenu.getPopupMenu(), context);
                    this.removeSeparator(jobsMenu.getPopupMenu());
                    if (jobsMenu.getItemCount() > 0) {
                        popupMenu.add(jobsMenu);
                    }
                    this.addSeparator(popupMenu);
                    this.addPopupMenuItemFor(FILE_EXPORT, popupMenu, context);
                    this.addSeparator(popupMenu);
                    this.addPopupMenuItemFor(EDIT_DELETE, popupMenu, context);
                    this.addPopupMenuItemFor(EDIT_RENAME, popupMenu, context);
                    this.addSeparator(popupMenu);
                    this.addPopupMenuItemFor(EDIT_COPY_TO_FOLDER, popupMenu, context);
                    this.addPopupMenuItemFor(EDIT_MOVE_TO_FOLDER, popupMenu, context);
                    if ("InventoryTree".equals(contextType)) {
                        this.addPopupMenuItemFor(EDIT_FIND_IN_FOLDERS, popupMenu, context);
                    }
                    this.addSeparator(popupMenu);
                }
                this.addPopupMenuItemFor(EDIT_PROPERTIES, popupMenu, context);
                popupMenu.addPopupMenuListener(this.mnuContextListener);
            } else if (aObjects.length > 1) {
                this.addPopupMenuItemFor(FILE_EXPORT, popupMenu, context);
                this.addSeparator(popupMenu);
                this.addPopupMenuItemFor(EDIT_DELETE, popupMenu, context);
                this.addSeparator(popupMenu);
                this.addPopupMenuItemFor(EDIT_COPY_TO_FOLDER, popupMenu, context);
                this.addPopupMenuItemFor(EDIT_MOVE_TO_FOLDER, popupMenu, context);
                popupMenu.addPopupMenuListener(this.mnuContextListener);
            }
        }
        return popupMenu;
    }

    private void createMaintainMenu(WsActionContextInterface context, JPopupMenu popupMenu) {
        SimpleObject obj;
        Object[] aObjects = context.getSelectedObjects();
        if (aObjects.length == 1 && aObjects[0] instanceof SimpleObject && "Cube".equals((obj = (SimpleObject)aObjects[0]).getPublicType())) {
            JPopupMenu maintainPopup = null;
            JMenu maintainMenu = this.createMenu(CONTEXT_MAINTAIN);
            AbstractCubeSelectionAction.getCubePermissions((SimpleObject)aObjects[0]);
            maintainPopup = AbstractCubeSelectionAction.exists ? maintainMenu.getPopupMenu() : popupMenu;
            this.addPopupMenuItemFor(CUBE_CALCMEM, maintainPopup, context);
            this.addPopupMenuItemFor(CUBE_OLAPSCHEMA, maintainPopup, context);
            this.addPopupMenuItemFor(CUBE_SYNCH, maintainPopup, context);
            this.addSeparator(maintainPopup);
            this.addPopupMenuItemFor(TOOLS_IMPACT, maintainPopup, context);
            this.addSeparator(maintainPopup);
            this.addPopupMenuItemFor(CUBE_REFRESH_CUBE, maintainPopup, context);
            this.addPopupMenuItemFor(CUBE_DELETE_PHYSICAL, maintainPopup, context);
            this.removeSeparator(maintainPopup);
            if (maintainMenu.getItemCount() > 0) {
                popupMenu.add(maintainMenu);
            }
        }
    }

    private void removeSeparator(JPopupMenu popupMenu) {
        Component comp;
        int iLastComp = popupMenu.getComponentCount() - 1;
        if (iLastComp >= 0 && (comp = popupMenu.getComponent(iLastComp)) instanceof JSeparator) {
            popupMenu.remove(iLastComp);
        }
    }

    protected JToolBar createToolBar() {
        JToolBar bar = WsUIUtilities.createToolBar();
        bar.add(WsUIUtilities.createDropMenuButton((WsDropMenuAction)new NewDropMenuAction()));
        bar.addSeparator();
        bar.add(this.createToolButton(EDIT_COPY));
        bar.add(this.createToolButton(EDIT_PASTE));
        bar.add(this.createToolButton(EDIT_DELETE));
        bar.addSeparator();
        bar.add(this.createToolButton(EDIT_FIND_IN_FOLDERS));
        bar.add(this.createToolButton(VIEW_REFRESH));
        bar.addSeparator();
        bar.add(this.createToolButton(CUBE_BUILD));
        bar.add(this.createToolButton(CUBE_VIEW));
        bar.addSeparator();
        bar.add(this.createToolButton(CUBE_DISABLE));
        bar.add(this.createToolButton(CUBE_ENABLE));
        bar.add(this.createToolButton(CUBE_EDIT));
        bar.addSeparator();
        bar.add(this.createToolButton(FILE_REGISTER_TABLE));
        bar.add(this.createToolButton(CUBE_AGGREGATION));
        bar.add(this.createToolButton(CUBE_CALCMEM));
        bar.add(this.createToolButton(FILE_EXPORT));
        bar.addSeparator();
        bar.add(this.createToolButton(EDIT_PROPERTIES));
        return bar;
    }

    private AbstractSelectionAction getSelectionAction(String sActionKey) {
        return (AbstractSelectionAction)this.getAction(sActionKey);
    }

    private boolean isActionValidForContext(WsAbstractAction action, WsActionContextInterface context) {
        return action != null && action instanceof WsAbstractApplicationActionsManager.ContextualAction && ((WsAbstractApplicationActionsManager.ContextualAction)action).isValidForContext(context);
    }

    public void performDefaultActionFor(Object source, Object object, WsActionContextInterface context) {
        WsAbstractAction defaultAction;
        if (!(object instanceof SimpleObject)) {
            return;
        }
        String sType = ((SimpleObject)object).getPublicType();
        if (!"Folder".equals(sType) && (defaultAction = this.getAction(EDIT_PROPERTIES)) != null) {
            defaultAction.actionPerformed(new ActionEvent(source, 1001, "default"));
        }
    }

    private void setActionsMenuState(WsSelectionProvider provider) {
        String type;
        Object[] objects;
        this.mnuActions.setEnabled(false);
        if (provider != null && (objects = provider.getSelectedObjects()).length == 1 && objects[0] instanceof SimpleObject && ((type = ((SimpleObject)objects[0]).getPublicType()).equals("Cube") || type.equals("Table") || type.equals("SharedDimension") || type.equals("Library") || type.equals("Job.CubeBuild") || type.equals("Document") || type.equals("DeployedJob"))) {
            this.mnuActions.setEnabled(true);
        }
    }

    public void setSelectionProvider(WsSelectionProvider provider) {
        WsSelectionProvider m_provider = this.getSelectionProvider();
        if (m_provider == provider) {
            return;
        }
        if (m_provider != null) {
            m_provider.removeSelectionChangedListener((WsSelectionChangedListener)this.selectionListener);
        }
        AbstractCubeSelectionAction.clearCurrentObject();
        AbstractSharedDimensionSelectionAction.clearCurrentObject();
        super.setSelectionProvider(provider);
        m_provider = this.getSelectionProvider();
        this.setActionsMenuState(m_provider);
        this.selectionListener.resetState(m_provider);
        if (m_provider != null) {
            m_provider.addSelectionChangedListener((WsSelectionChangedListener)this.selectionListener);
        }
    }

    private class SelectionChangedListener
    implements WsSelectionChangedListener {
        private UpgradeContextHandler handler;

        private SelectionChangedListener() {
            this.handler = new UpgradeContextHandler();
        }

        public UpgradeContextHandler getUpgradeHandler() {
            return this.handler;
        }

        public void resetState(WsSelectionProvider provider) {
            if (provider != null) {
                this.handler.setSelectedObjects(provider.getSelectedObjects());
            } else {
                this.handler.setSelectedObjects(null);
            }
            this.handler.updateActions();
            this.handler.setupUpgradeContext();
        }

        public void selectionChanged(WsSelectionChangedEvent ev) {
            WsSelectionProvider provider = (WsSelectionProvider)ev.getSource();
            OLAPActionsManager.this.setActionsMenuState(provider);
            this.resetState(provider);
            AbstractCubeSelectionAction.clearCurrentObject();
            AbstractSharedDimensionSelectionAction.clearCurrentObject();
        }
    }

    class ActionsMenuListener
    implements MenuListener {
        ActionsMenuListener() {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            OLAPActionsManager.this.mnuActions.removeAll();
        }

        @Override
        public void menuSelected(MenuEvent e) {
            Object[] objects;
            WsSelectionProvider provider = OLAPActionsManager.this.getSelectionProvider();
            if (provider != null && (objects = provider.getSelectedObjects()).length == 1 && objects[0] instanceof SimpleObject) {
                Component comp;
                SimpleObject obj = (SimpleObject)objects[0];
                String type = obj.getPublicType();
                if ("Cube".equals(type)) {
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_BUILD, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_QUICK_EDIT, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_EDIT, OLAPActionsManager.this.mnuActions, objects);
                    JMenu updateMenu = OLAPActionsManager.this.createMenu(OLAPActionsManager.CONTEXT_UPDATE);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_UPDATE_INPLACE, updateMenu, objects);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_UPDATE_NEWGEN, updateMenu, objects);
                    OLAPActionsManager.this.addSeparator(updateMenu);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_UPDATE_COALESCE, updateMenu, objects);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_UPDATE_REORGANIZE, updateMenu, objects);
                    if (updateMenu.getItemCount() > 0) {
                        OLAPActionsManager.this.mnuActions.add(updateMenu);
                    }
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_AGGREGATION, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_VIEW, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_EXPORT_CODE, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addSeparator(OLAPActionsManager.this.mnuActions);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_CALCMEM, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_OLAPSCHEMA, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_SYNCH, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addSeparator(OLAPActionsManager.this.mnuActions);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_DISABLE, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_ENABLE, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addSeparator(OLAPActionsManager.this.mnuActions);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_REFRESH_CUBE, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.CUBE_DELETE_PHYSICAL, OLAPActionsManager.this.mnuActions, objects);
                } else if ("DeployedJob".equals(type)) {
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.REDEPLOY_JOBCUBE, OLAPActionsManager.this.mnuActions, objects);
                } else if ("Job.CubeBuild".equals(type)) {
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.DEPLOY_JOBCUBE, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.REDEPLOY_JOBCUBE, OLAPActionsManager.this.mnuActions, objects);
                } else if ("Library".equals(type)) {
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.LIBRARY_DISPLAY_LIBNAME, OLAPActionsManager.this.mnuActions, objects);
                } else if ("SharedDimension".equals(type)) {
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.BUILD_SHARED_DIMENSION, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.SHAREDDIM_EDIT, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.SHAREDDIMENSION_QUICK_EDIT, OLAPActionsManager.this.mnuActions, objects);
                    JMenu updateMenu2 = OLAPActionsManager.this.createMenu(OLAPActionsManager.CONTEXT_UPDATE);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.SHAREDDIMENSION_UPDATE_INPLACE, updateMenu2, objects);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.SHAREDDIMENSION_UPDATE_REORGANIZE, updateMenu2, objects);
                    if (updateMenu2.getItemCount() > 0) {
                        OLAPActionsManager.this.mnuActions.add(updateMenu2);
                    }
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.SHAREDDIMENSION_EXPORT_CODE, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addSeparator(OLAPActionsManager.this.mnuActions);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.SHAREDDIMENSION_OLAPSCHEMA, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addSeparator(OLAPActionsManager.this.mnuActions);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.SHAREDDIMENSION_DELETE_PHYSICAL, OLAPActionsManager.this.mnuActions, objects);
                } else if ("Table".equals(type)) {
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.TABLE_VIEW_DATA, OLAPActionsManager.this.mnuActions, objects);
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.TABLE_DISPLAY_LIBSERVER, OLAPActionsManager.this.mnuActions, objects);
                } else if ("Document".equals(type)) {
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.DOCUMENT_OPEN, OLAPActionsManager.this.mnuActions, objects);
                } else if ("SearchFolder".equals(type)) {
                    OLAPActionsManager.this.addMenuItemFor(OLAPActionsManager.SEARCH_FOLDER_VIEW, OLAPActionsManager.this.mnuActions, objects);
                }
                int iLastComp = OLAPActionsManager.this.mnuActions.getItemCount() - 1;
                if (iLastComp >= 0 && (comp = OLAPActionsManager.this.mnuActions.getMenuComponent(iLastComp)) instanceof JSeparator) {
                    OLAPActionsManager.this.mnuActions.remove(iLastComp);
                }
            }
        }
    }

    private class RefreshActionProxy
    extends WsAbstractAction
    implements WsAbstractApplicationActionsManager.AttachableAction,
    WsAbstractApplicationActionsManager.ContextualAction {
        private static final long serialVersionUID = 1L;
        private WsAbstractAction refreshAction;

        public RefreshActionProxy() {
            super(bundle, "View.Refresh", 2);
            this.refreshAction = null;
            this.refreshAction = OLAPActionsManager.this.createAttachAction(OLAPActionsManager.VIEW_REFRESH, bundle, "View.Refresh", 2);
            if (this.refreshAction == null || !(this.refreshAction instanceof WsAbstractApplicationActionsManager.AttachableAction) || !(this.refreshAction instanceof WsAbstractApplicationActionsManager.ContextualAction)) {
                throw new IllegalStateException("Unable to create refresh action");
            }
            this.setEnabled(this.refreshAction.isEnabled());
            OLAPActionsManager.this.registerAction(OLAPActionsManager.VIEW_REFRESH, this);
        }

        public void attach(WsAbstractAction act) {
            WsAbstractApplicationActionsManager.AttachableAction action = (WsAbstractApplicationActionsManager.AttachableAction)this.refreshAction;
            action.attach(act);
            this.setEnabled(this.refreshAction.isEnabled());
        }

        public void detach(WsAbstractAction act) {
            WsAbstractApplicationActionsManager.AttachableAction action = (WsAbstractApplicationActionsManager.AttachableAction)this.refreshAction;
            action.detach(act);
            this.setEnabled(false);
        }

        public boolean isValidForContext(WsActionContextInterface context) {
            WsAbstractApplicationActionsManager.ContextualAction action = (WsAbstractApplicationActionsManager.ContextualAction)this.refreshAction;
            return action.isValidForContext(context);
        }

        public void setEnabled(boolean bEnabled) {
            super.setEnabled(bEnabled);
            this.refreshAction.setEnabled(bEnabled);
        }

        public void setActive(boolean bActive) {
            super.setActive(bActive);
            this.refreshAction.setActive(bActive);
        }

        public void actionPerformed(ActionEvent e) {
            OLAPActionsManager.this.m_validator.clearObjectCache();
            this.refreshAction.actionPerformed(e);
        }
    }

    private class EditMenuListener
    implements MenuListener {
        private EditMenuListener() {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            JPopupMenu popup;
            JMenu menu = (JMenu)e.getSource();
            if (menu != null && (popup = menu.getPopupMenu()) != null) {
                OLAPActionsManager.this.selectionListener.getUpgradeHandler().handleUpgradeContextFor(popup);
            }
        }
    }

    private class ContextPopupMenuListener
    implements PopupMenuListener {
        private ContextPopupMenuListener() {
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            JPopupMenu popupMenu = (JPopupMenu)e.getSource();
            if (popupMenu != null) {
                OLAPActionsManager.this.selectionListener.getUpgradeHandler().handleUpgradeContextFor(popupMenu);
            }
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
        }
    }

    private class UpgradeContextHandler
    implements WsActionContextInterface {
        private String m_sType = "Context:Upgrade";
        private boolean upgradeAllowed = false;
        private boolean selectionCompatible = false;
        private AbstractSelectionAction upgradeAction = null;
        private UpgradeActionListener m_listener = new UpgradeActionListener();
        private Object[] empty = new Object[0];
        private Object[] m_selected = this.empty;
        private HashMap disabledActions = new HashMap(10);
        private Action enabledAction = null;
        private String enabledActionKey = null;

        private UpgradeContextHandler() {
        }

        private void setUpgradeAction() {
            if (this.upgradeAction == null) {
                this.upgradeAction = OLAPActionsManager.this.getSelectionAction(OLAPActionsManager.CONTEXT_UPGRADE_METADATA);
            }
            if (this.upgradeAction == null) {
                throw new IllegalStateException("Failed to create a new upgrade context: Upgrade action could not be found");
            }
        }

        public UpgradeActionListener getUpgradeActionListener() {
            return this.m_listener;
        }

        public boolean isEnabled() {
            return this.upgradeAllowed;
        }

        public String getType() {
            return this.m_sType;
        }

        public String toString() {
            return this.m_sType;
        }

        public Object[] getSelectedObjects() {
            return this.m_selected;
        }

        private void updateBoundProperties() {
            this.m_listener.disable();
            this.upgradeAllowed = false;
            this.selectionCompatible = false;
            if (this.m_selected.length > 0) {
                this.setUpgradeAction();
                this.selectionCompatible = this.upgradeAction.isSelectionCompatible(this.m_selected);
                this.upgradeAllowed = this.selectionCompatible ? false : this.upgradeAction.isValidForContext(this);
            }
        }

        public void setSelectedObjects(Object[] objects) {
            if (objects != null && Arrays.equals(objects, this.m_selected)) {
                return;
            }
            if (objects != null && objects.length > 0) {
                this.m_selected = new Object[objects.length];
                System.arraycopy(objects, 0, this.m_selected, 0, objects.length);
            } else {
                this.m_selected = this.empty;
            }
            this.updateBoundProperties();
        }

        public void addContextMenuItems(JPopupMenu mnuPopup) {
        }

        public void setupUpgradeContext() {
            this.setUpgradeAction();
            WsSelectionProvider currentProvider = OLAPActionsManager.this.getSelectionProvider();
            if (currentProvider != null) {
                Object[] currentObjects = currentProvider.getSelectedObjects();
                this.setSelectedObjects(currentObjects);
            } else {
                this.m_listener.disable();
                this.upgradeAllowed = false;
                this.selectionCompatible = false;
                this.m_selected = this.empty;
            }
            this.enabledAction = null;
            this.enabledActionKey = null;
            this.disabledActions.clear();
        }

        public void handleUpgradeContextFor(JComponent component) {
            Component[] aItems = component.getComponents();
            int nItems = aItems.length;
            if (this.upgradeAllowed || !this.selectionCompatible) {
                for (int iItem = 0; iItem < nItems; ++iItem) {
                    JMenuItem item;
                    Action action;
                    if (!(aItems[iItem] instanceof JMenuItem) || (action = (item = (JMenuItem)aItems[iItem]).getAction()) == null) continue;
                    String deleteLabel = Util.getDisplayLabel((String)bundle.getString("Edit.Delete.txt"));
                    String propertyLabel = Util.getDisplayLabel((String)bundle.getString("Edit.Properties.txt"));
                    String upgradeLabel = Util.getDisplayLabel((String)bundle.getString("OLAPActionsManager.ContextAction.UpgradeMetadataObject.txt"));
                    Class<?> actionClass = action.getClass();
                    boolean isAEmptyAction = actionClass.isInstance(OLAPActionsManager.this.emptyRuntimeAction);
                    if (isAEmptyAction || !(action instanceof WsAbstractAction) || action instanceof AbstractSelectionAction) continue;
                    String localizedName = (String)action.getValue("Name");
                    if (!action.isEnabled() && localizedName.equalsIgnoreCase(deleteLabel)) {
                        if (!this.upgradeAllowed) continue;
                        action.setEnabled(true);
                        this.enabledAction = action;
                        this.enabledActionKey = deleteLabel;
                        if (!this.disabledActions.containsKey(this.enabledActionKey)) continue;
                        this.disabledActions.remove(this.enabledActionKey);
                        continue;
                    }
                    if (this.upgradeAllowed && localizedName != null && !localizedName.equalsIgnoreCase(deleteLabel) && !localizedName.equalsIgnoreCase(propertyLabel) && !localizedName.equalsIgnoreCase(upgradeLabel)) {
                        action.setEnabled(false);
                        if (this.disabledActions.containsKey(localizedName)) continue;
                        this.disabledActions.put(localizedName, action);
                        continue;
                    }
                    if (this.upgradeAllowed || this.selectionCompatible || localizedName == null || localizedName.equalsIgnoreCase(propertyLabel)) continue;
                    action.setEnabled(false);
                    if (this.disabledActions.containsKey(localizedName)) continue;
                    this.disabledActions.put(localizedName, action);
                }
                this.m_listener.enable();
            }
        }

        private void updateAction(Action action, boolean enabled) {
            if (this.m_selected.length == 0) {
                if (enabled) {
                    action.setEnabled(false);
                }
            } else if (this.selectionCompatible) {
                String deleteLabel = Util.getDisplayLabel((String)bundle.getString("Edit.Delete.txt"));
                String renameLabel = Util.getDisplayLabel((String)bundle.getString("Edit.Rename.txt"));
                String localizedName = (String)action.getValue("Name");
                if (localizedName != null && localizedName.equalsIgnoreCase(deleteLabel)) {
                    OLAPActionsManager.this.m_validator.clearObjectCache();
                    action.setEnabled(ModelUtilities.isDeleteAllowed((Object[])this.m_selected));
                } else if (localizedName != null && localizedName.equalsIgnoreCase(renameLabel)) {
                    if (this.m_selected.length > 1) {
                        action.setEnabled(false);
                    } else {
                        OLAPActionsManager.this.m_validator.clearObjectCache();
                        action.setEnabled(ModelUtilities.isRenameAllowed((Object[])this.m_selected));
                    }
                } else if (action instanceof WsAbstractApplicationActionsManager.ContextualAction) {
                    action.setEnabled(((WsAbstractApplicationActionsManager.ContextualAction)action).isValidForContext((WsActionContextInterface)this));
                } else if (action instanceof WsAbstractApplicationActionsManager.SelectionAction) {
                    ((WsAbstractApplicationActionsManager.SelectionAction)action).setSelectionProvider(OLAPActionsManager.this.getSelectionProvider());
                } else if (enabled) {
                    action.setEnabled(false);
                } else {
                    action.setEnabled(true);
                }
            } else if (!this.upgradeAllowed && enabled) {
                action.setEnabled(false);
            }
        }

        private void updateActions() {
            Set keySet;
            if (this.enabledAction != null) {
                this.updateAction(this.enabledAction, true);
            }
            if ((keySet = this.disabledActions.keySet()) != null && !keySet.isEmpty()) {
                for (String key : keySet) {
                    Action disabled;
                    if (key == null || (disabled = (Action)this.disabledActions.get(key)) == null) continue;
                    this.updateAction(disabled, false);
                }
            }
            this.enabledAction = null;
            this.enabledActionKey = null;
            this.disabledActions.clear();
        }

        private class UpgradeActionListener
        implements PropertyChangeListener {
            private UpgradeActionListener() {
            }

            public void disable() {
                if (UpgradeContextHandler.this.upgradeAction != null) {
                    UpgradeContextHandler.this.upgradeAction.removePropertyChangeListener(this);
                }
            }

            public void enable() {
                if (UpgradeContextHandler.this.upgradeAction != null) {
                    PropertyChangeListener[] list = UpgradeContextHandler.this.upgradeAction.getPropertyChangeListeners();
                    boolean containsListener = false;
                    for (int i = 0; i < list.length; ++i) {
                        PropertyChangeListener current = list[i];
                        if (!this.equals(current)) continue;
                        containsListener = true;
                        break;
                    }
                    if (!containsListener) {
                        UpgradeContextHandler.this.upgradeAction.addPropertyChangeListener(this);
                    }
                }
            }

            protected void finalize() throws Throwable {
                try {
                    this.disable();
                }
                finally {
                    super.finalize();
                }
            }

            @Override
            public void propertyChange(PropertyChangeEvent ev) {
                Object source = ev.getSource();
                String propertyName = ev.getPropertyName();
                if (source instanceof UpgradeMetadataObjectAction && "enabled".equalsIgnoreCase(propertyName)) {
                    Boolean newValue = (Boolean)ev.getNewValue();
                    WsSelectionProvider provider = OLAPActionsManager.this.getSelectionProvider();
                    if (provider != null) {
                        Object[] currentObjects = provider.getSelectedObjects();
                        if (UpgradeContextHandler.this.m_selected != null && UpgradeContextHandler.this.m_selected.length > 0 && Arrays.equals(currentObjects, UpgradeContextHandler.this.m_selected) && newValue != null && newValue != UpgradeContextHandler.this.upgradeAllowed) {
                            UpgradeContextHandler.this.upgradeAllowed = newValue;
                            if (UpgradeContextHandler.this.upgradeAllowed) {
                                UpgradeContextHandler.this.selectionCompatible = false;
                            } else {
                                UpgradeContextHandler.this.selectionCompatible = true;
                            }
                            UpgradeContextHandler.this.updateActions();
                        }
                    }
                }
            }
        }
    }

    class WindowMenuListener
    implements MenuListener {
        WindowMenuListener() {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            Component[] aItems = menu.getMenuComponents();
            int nItems = aItems.length;
            for (int iItem = 0; iItem < nItems; ++iItem) {
                String sName;
                if (aItems[iItem] instanceof JMenuItem) {
                    JMenuItem item = (JMenuItem)aItems[iItem];
                    Action action = item.getAction();
                    if (action instanceof ActivateWindowAction) {
                        menu.remove(item);
                        continue;
                    }
                    if (!(action instanceof MoreWindowsAction)) continue;
                    menu.remove(item);
                    continue;
                }
                if (!(aItems[iItem] instanceof JSeparator) || (sName = aItems[iItem].getName()) == null || !sName.equals(OLAPActionsManager.SEPARATOR_NAME)) continue;
                menu.remove(aItems[iItem]);
            }
        }

        @Override
        public void menuSelected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            JInternalFrame[] aFrames = Workspace.getWorkspace().getDesktopWindowHandle().getAllFrames();
            if (aFrames.length > 0) {
                JSeparator sep = new JSeparator();
                sep.setName(OLAPActionsManager.SEPARATOR_NAME);
                menu.add(sep);
            }
            int nFrames = Math.min(aFrames.length, 9);
            for (int iFrame = 0; iFrame < nFrames; ++iFrame) {
                String key = new String(OLAPActionsManager.WINDOW_ACTIVATE).replace("nn", String.valueOf(iFrame));
                OLAPActionsManager.this.registerAction(key, (WsAbstractAction)new ActivateWindowAction(iFrame + 1, aFrames[iFrame]));
                JCheckBoxMenuItem item = OLAPActionsManager.this.createCheckBoxMenuItem(key);
                item.setSelected(aFrames[iFrame].isSelected());
                menu.add(item);
            }
            if (aFrames.length > 9) {
                JSeparator sep = new JSeparator();
                sep.setName(OLAPActionsManager.SEPARATOR_NAME);
                menu.add(sep);
                menu.add(new JMenuItem((Action)((Object)new MoreWindowsAction())));
            }
            boolean bAtLeastOne = aFrames.length > 0;
            OLAPActionsManager.this.getAction(OLAPActionsManager.WINDOW_CASCADE).setEnabled(bAtLeastOne);
            OLAPActionsManager.this.getAction(OLAPActionsManager.WINDOW_TILE_HORIZ).setEnabled(bAtLeastOne);
            OLAPActionsManager.this.getAction(OLAPActionsManager.WINDOW_TILE_VERT).setEnabled(bAtLeastOne);
            OLAPActionsManager.this.getAction(OLAPActionsManager.WINDOW_CLOSE_ALL).setEnabled(bAtLeastOne);
        }
    }

    class MoreWindowsAction
    extends WsAbstractAction {
        private static final long serialVersionUID = 1L;

        public MoreWindowsAction() {
            String sName = bundle.getString("Window.MoreWindows.txt");
            Integer mnem = new Integer(Util.getDisplayedMnemonic((String)sName));
            Integer index = new Integer(Util.getDisplayedMnemonicIndex((String)sName));
            ImageIcon icon = bundle.getImageIcon("Common.EmptyIcon.image");
            sName = Util.getLabelWithoutMnemonic((String)sName);
            this.putValue("Name", sName);
            this.putValue("MnemonicKey", mnem);
            this.putValue("MnemonicIndex", index);
            this.putValue("SmallIcon", icon);
        }

        public void actionPerformed(ActionEvent e) {
            WsWindowsDialog dlg = new WsWindowsDialog();
            dlg.setVisible(true);
        }
    }

    class ActivateWindowAction
    extends WsAbstractToggleAction {
        private static final long serialVersionUID = 1L;
        protected JInternalFrame m_frm;

        public ActivateWindowAction(int iFrame, JInternalFrame frm) {
            this.m_frm = frm;
            String sName = Integer.toString(iFrame) + " " + this.m_frm.getTitle();
            Integer mnem = new Integer(iFrame + 48);
            ImageIcon icon = bundle.getImageIcon("Common.EmptyIcon.image");
            this.putValue("Name", sName);
            this.putValue("MnemonicKey", mnem);
            this.putValue("SmallIcon", icon);
        }

        public void actionPerformed(ActionEvent e) {
            Workspace.getWorkspace().getDesktopWindowHandle().activateFrame(this.m_frm);
        }
    }

    class NewDropMenuAction
    extends WsDropMenuAction {
        private static final long serialVersionUID = 1L;

        public NewDropMenuAction() {
            super(bundle, "File.New");
            this.setDropMenu(OLAPActionsManager.this.createFileNewMenu(OLAPActionsManager.FILE_NEW_FOLDER).getPopupMenu());
        }
    }
}

