/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.OLAPSchema;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.actions.AbstractSelectionAction;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.services.ServiceException;
import com.sas.visuals.Resources;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.mgmt.visuals.OLAPSchemaWizard;
import com.sas.workspace.models.SimpleObject;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.rmi.RemoteException;

public class NewOLAPSchemaAction
extends AbstractSelectionAction
implements PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(NewOLAPSchemaAction.class);

    public NewOLAPSchemaAction() {
        super(bundle, "File.New.OLAPSchema", 256);
        this.setIcon(Resources.getImageIcon((String)"OLAPSchema.gif", (int)16));
        Workspace.getWorkspace().addPropertyChangeListener("MetadataProfile", (PropertyChangeListener)this);
        this.setEnabled(Workspace.getWorkspace().getProjectRepository() == null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object[] objects = null;
        if (this.m_provider != null) {
            objects = this.m_provider.getSelectedObjects();
        }
        this.actionPerformed(objects);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] selectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            MdObjectStore child = null;
            try {
                Workspace workspace = Workspace.getWorkspace();
                String repositoryID = Workspace.getMdFactory().getOMIUtil().getFoundationReposID();
                child = Workspace.getMdFactory().createObjectStore(null, "CreateOLAPSchema");
                Tree folder = null;
                if (selectedObjects != null && selectedObjects.length == 1 && selectedObjects[0] instanceof SimpleObject && "Folder".equals(((SimpleObject)selectedObjects[0]).getPublicType())) {
                    folder = (Tree)ObjectConverter.getInstance().convertToJOMAObject(child, (SimpleObject)selectedObjects[0]);
                }
                if (folder == null) {
                    folder = WsMetadataUtil.getDefaultFolder((MdObjectStore)child);
                }
                OLAPSchemaWizard dialog = new OLAPSchemaWizard((Frame)workspace, bundle.getString("OLAPSchemaWizard.window.title"), repositoryID, (MdStore)child, true);
                dialog.addWizardData("GROUP", (Object)folder);
                dialog.show();
                if (dialog.getReturnValue() == 1 || dialog.getReturnValue() == 3) {
                    OLAPSchema newSchema = (OLAPSchema)dialog.getWizardData("MASTEROBJECT");
                    ModelUtilities.setDefaultOLAPSchema((OLAPSchema)newSchema);
                }
            }
            catch (RemoteException exc) {
                ExceptionHandler.handleException((Exception)exc);
            }
            catch (MdException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            catch (ServiceException e) {
                ExceptionHandler.handleException((Exception)((Object)e));
            }
            finally {
                try {
                    if (child != null) {
                        child.dispose();
                    }
                }
                catch (RemoteException exc) {
                    ExceptionHandler.handleException((Exception)exc);
                }
            }
        }
    }

    @Override
    protected boolean isEnabledWhenNoSelectionProvider() {
        return true;
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        if (Workspace.getWorkspace().getProjectRepository() != null) {
            return false;
        }
        if (selectedObjects != null && selectedObjects.length == 1 && selectedObjects[0] instanceof SimpleObject && "Folder".equals(((SimpleObject)selectedObjects[0]).getPublicType())) {
            SimpleObject folder = (SimpleObject)selectedObjects[0];
            return ModelUtilities.getPermissionFromId((String)"WriteMemberMetadata", (String)folder.getMetadataType(), (String)folder.getID());
        }
        return true;
    }

    @Override
    public boolean isValidForContext(WsActionContextInterface context) {
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        this.setEnabled(Workspace.getWorkspace().getProjectRepository() == null);
    }
}

