/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.promotion.visuals.ImportWizard;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.Tree;
import com.sas.olapadmin.actions.AbstractSelectionAction;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.workspace.visuals.OLAPFoldersTree;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.app.TransportUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.util.Map;

public class ImportAction
extends AbstractSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(ImportAction.class);

    public ImportAction() {
        super(bundle, "File.Import", 258);
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            if (aSelectedObjects.length == 0) {
                this.showImportSASPackageDialog();
            } else {
                this.showImportSASPackageDialog((SimpleObject)aSelectedObjects[0]);
            }
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] aSelectedObjects) {
        Object obj;
        if (aSelectedObjects.length == 0) {
            return this.m_provider != null && this.m_provider instanceof OLAPFoldersTree;
        }
        return aSelectedObjects.length == 1 && (obj = aSelectedObjects[0]) instanceof SimpleObject && "Folder".equals(((SimpleObject)aSelectedObjects[0]).getPublicType());
    }

    @Override
    public boolean isValidForContext(WsActionContextInterface context) {
        if ("InventoryTree".equals(context.getType())) {
            return false;
        }
        Object[] aObjects = context.getSelectedObjects();
        if (aObjects.length == 0) {
            return false;
        }
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            if (aObjects[iObject] instanceof SimpleObject && "Folder".equals(((SimpleObject)aObjects[iObject]).getPublicType())) continue;
            return false;
        }
        return true;
    }

    private void showImportSASPackageDialog() {
        try {
            ServerInterface server = Workspace.getWorkspace().getUserContext().getAuthServer();
            SoftwareComponent target = (SoftwareComponent)server.getRootFolder().getRepositoryEntity();
            this.showImportSASPackageDialog((Root)target);
        }
        catch (RemoteException ex) {
            ExceptionHandler.handleException((Exception)ex);
        }
        catch (ServiceException ex) {
            ExceptionHandler.handleException((Exception)((Object)ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showImportSASPackageDialog(Root target) {
        try {
            ImportWizard wizard;
            Workspace.getWorkspace().setCursor(Cursor.getPredefinedCursor(3));
            TypeInterface[] aSupportedTypes = Factory.getInstance().getTypesSupported();
            String sWizardTitle = bundle.getString("ImportWizard.window.title");
            if (target instanceof Tree) {
                wizard = new ImportWizard((Tree)target, aSupportedTypes, sWizardTitle);
            } else if (target instanceof SoftwareComponent) {
                wizard = new ImportWizard((SoftwareComponent)target, aSupportedTypes, sWizardTitle);
            } else {
                throw new IllegalArgumentException("The supplied target must be of type Tree or SoftwareComponent");
            }
            Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
            wizard.show();
            if (wizard.getReturnValue() == 1 && wizard.objectsWereImported()) {
                TransportUtil.generateObjectsModifiedEvent((Map)wizard.getTargetObjectIDs());
            }
        }
        catch (LogicalTypeException ex) {
            ExceptionHandler.handleException((Exception)((Object)ex));
        }
        catch (RemoteException ex) {
            ExceptionHandler.handleException((Exception)ex);
        }
        finally {
            Workspace.getWorkspace().setCursor(Cursor.getDefaultCursor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showImportSASPackageDialog(SimpleObject folder) {
        try {
            MdObjectStore store = Workspace.getMdFactory().createObjectStore(null, "Import action");
            try {
                Tree target = (Tree)ObjectConverter.getInstance().convertToJOMAObject(store, folder);
                this.showImportSASPackageDialog((Root)target);
            }
            finally {
                store.dispose();
            }
        }
        catch (RemoteException ex) {
            ExceptionHandler.handleException((Exception)ex);
        }
        catch (MdException error) {
            ExceptionHandler.handleException((Exception)((Object)error));
        }
    }
}

