/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.logical.Factory;
import com.sas.olapadmin.actions.AbstractSelectionAction;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.services.ServiceException;
import com.sas.services.information.publicobject.TypeDescriptorInterface;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractApplicationFrameworkManager;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;

public class FindInFoldersAction
extends AbstractSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = WAdminResource.getBundle(FindInFoldersAction.class);

    public FindInFoldersAction() {
        super(bundle, "Edit.FindInFolders", 2);
    }

    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        WsAbstractApplicationFrameworkManager.getInstance().findInFolders((SimpleObject)aSelectedObjects[0]);
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        try {
            if (selectedObjects.length == 1 && selectedObjects[0] instanceof SimpleObject) {
                SimpleObject obj = (SimpleObject)selectedObjects[0];
                String publicType = obj.getPublicType();
                TypeDescriptorInterface typeDescriptor = Factory.getInstance().getMetadataServerInterface().getTypeDescriptor(publicType);
                return typeDescriptor != null && "Folder".equals(typeDescriptor.getContainerType());
            }
        }
        catch (RemoteException e) {
            ExceptionHandler.handleException((Exception)e);
        }
        catch (ServiceException e) {
            ExceptionHandler.handleException((Exception)((Object)e));
        }
        return false;
    }

    @Override
    public boolean isValidForContext(WsActionContextInterface context) {
        return this.isSelectionValid(context.getSelectedObjects());
    }
}

