/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.olapadmin.actions.AbstractCubeSelectionAction;
import com.sas.olapadmin.designer.model.ModelUtilities;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.designer.visuals.CubeDesigner;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.HashMap;

public class EditCubeAction
extends AbstractCubeSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(EditCubeAction.class);

    public EditCubeAction() {
        super(bundle, "Cube.Edit", 2);
        this.mustExist = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) return;
        EditCubeAction.clearCurrentObject();
        if (this.isSelectionValid(aSelectedObjects)) {
            if (!this.isCurrentGeneration(aSelectedObjects[0])) return;
            Workspace workspace = Workspace.getWorkspace();
            MdObjectStore store = null;
            try {
                store = Workspace.getMdFactory().createObjectStore(null, "EditCubeAction");
                SimpleObject obj = (SimpleObject)aSelectedObjects[0];
                Cube cube = (Cube)ObjectConverter.getInstance().convertToJOMAObject(store, obj);
                workspace.setCursor(Cursor.getPredefinedCursor(3));
                OLAPCube olapCube = new OLAPCube(cube);
                workspace.setCursor(Cursor.getPredefinedCursor(0));
                String verifyMessage = olapCube.getCubeVerifyMessage().toString();
                int errorLevel = olapCube.getErrorLevel();
                String message = "";
                if (!ModelUtilities.isBlank((String)verifyMessage)) {
                    if (errorLevel == 2) {
                        MessageUtil.displayMessage((String)verifyMessage);
                        errorLevel = 0;
                    } else if (errorLevel == 1) {
                        MessageUtil.displayMessage((String)bundle.getString("Cube.EditStructure.NoTable.txt"), (int)2);
                    } else {
                        errorLevel = 2;
                        message = bundle.getString("Cube.EditCubeStructure.MetadataChanges.txt");
                        MessageUtil.displayDetailsMessage((String)message, (int)errorLevel, (String)verifyMessage);
                    }
                }
                if (errorLevel != 2 && errorLevel != -1 && errorLevel != 1) return;
                CubeDesigner wacubedlg = new CubeDesigner((Frame)workspace, bundle.getString("CubeDesigner.window.title"), olapCube);
                wacubedlg.show();
                MdFactory factory = workspace.getMdObjectFactory();
                HashMap<String, String> map = new HashMap<String, String>(1);
                map.put(cube.getFQID(), cube.getCMetadataType());
                Workspace.getMdFactory().fireMdObjectsModified(new MdFactoryEvent(factory, map));
                return;
            }
            catch (OLAPException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
                return;
            }
            catch (RemoteException error) {
                ExceptionHandler.handleException((Exception)error);
                return;
            }
            catch (MdException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
                return;
            }
            finally {
                workspace.setCursor(Cursor.getPredefinedCursor(0));
                try {
                    if (store != null) {
                        store.dispose();
                    }
                }
                catch (RemoteException error) {}
            }
        }
        MessageUtil.displayMessage((String)bundle.getString("Action.NoPermissions.txt"));
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        boolean selectionOk = super.isSelectionValid(selectedObjects);
        if (selectionOk) {
            AbstractCubeSelectionAction.getCubePermissions((SimpleObject)selectedObjects[0]);
            selectionOk = canWriteAllCube & canReadAllCube;
        }
        return selectionOk;
    }
}

