/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.SASLibrary;
import com.sas.olapadmin.actions.AbstractSelectionAction;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.wadmin.visuals.SASLibnameDialog;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.metadata.WsMetadataUtil;
import com.sas.workspace.models.SimpleObject;
import java.rmi.RemoteException;
import java.util.ArrayList;

public class DisplayLibnameAction
extends AbstractSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(DisplayLibnameAction.class);

    public DisplayLibnameAction() {
        super(bundle, "Library.DisplayLibname", 257);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (Utilities.isConnectedToMetadataServer((boolean)true)) {
            MdFactory factory = Workspace.getWorkspace().getMdObjectFactory();
            SimpleObject library = (SimpleObject)aSelectedObjects[0];
            try {
                MdObjectStore store = factory.createObjectStore(null, "DisplayLibnameAction");
                try {
                    SASLibrary mdoLibrary = (SASLibrary)ObjectConverter.getInstance().convertToJOMAObject(store, library);
                    ArrayList<String> lAttributes = new ArrayList<String>();
                    lAttributes.add("IsPreassigned");
                    WsMetadataUtil.populateSimpleAttributes((Root)mdoLibrary, lAttributes);
                    if (mdoLibrary.getIsPreassigned() == 1) {
                        String sMessage = bundle.formatString("DisplayLibname.PreassignedLibrary.Message.fmt.txt", (Object)mdoLibrary.getName());
                        String sTitle = bundle.getString("DisplayLibname.PreassignedLibrary.window.title");
                        MessageUtil.displayMessage((String)sMessage, (String)sTitle, (int)1);
                    }
                    SASLibnameDialog dlg = new SASLibnameDialog(mdoLibrary);
                    dlg.show();
                }
                catch (MdException ex) {
                    ExceptionHandler.handleException((Exception)((Object)ex));
                }
                finally {
                    store.dispose();
                }
            }
            catch (RemoteException ex) {
                ExceptionHandler.handleException((Exception)ex);
            }
        }
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        return selectedObjects.length == 1 && selectedObjects[0] instanceof SimpleObject && "Library".equals(((SimpleObject)selectedObjects[0]).getPublicType());
    }

    @Override
    public boolean isValidForContext(WsActionContextInterface context) {
        return this.isSelectionValid(context.getSelectedObjects());
    }
}

