/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdFactoryEvent;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.olapadmin.actions.AbstractCubeSelectionAction;
import com.sas.olapadmin.designer.model.OLAPCube;
import com.sas.olapadmin.designer.model.OLAPException;
import com.sas.olapadmin.utilities.ExceptionHandler;
import com.sas.olapadmin.utilities.Utilities;
import com.sas.olapadmin.utilities.WsRunCode;
import com.sas.wadmin.app.ObjectConverter;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.Workspace;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.models.SimpleObject;
import java.awt.Cursor;
import java.rmi.RemoteException;
import java.util.HashMap;

public class BuildCubeAction
extends AbstractCubeSelectionAction {
    private static final long serialVersionUID = 1L;
    private static final WAdminResource bundle = new WAdminResource(BuildCubeAction.class);

    public BuildCubeAction() {
        super(bundle, "Cube.Build", 2);
        this.mustExist = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void actionPerformed(Object[] aSelectedObjects) {
        if (!Utilities.isConnectedToMetadataServer((boolean)true)) return;
        BuildCubeAction.clearCurrentObject();
        if (this.isSelectionValid(aSelectedObjects)) {
            if (!this.isCurrentGeneration(aSelectedObjects[0])) return;
            Workspace workspace = Workspace.getWorkspace();
            MdObjectStore store = null;
            String message = "";
            String title = "";
            WsRunCode wsRunCode = null;
            try {
                store = Workspace.getMdFactory().createObjectStore(null, "BuildActionPerformed");
                SimpleObject obj = (SimpleObject)aSelectedObjects[0];
                Cube cube1 = (Cube)ObjectConverter.getInstance().convertToJOMAObject(store, obj);
                workspace.setCursor(Cursor.getPredefinedCursor(3));
                OLAPCube olapCube = new OLAPCube(cube1);
                workspace.setCursor(Cursor.getPredefinedCursor(0));
                if (olapCube.getErrorLevel() != -1) {
                    MessageUtil.displayDetailsMessage((String)bundle.getString("Cube.MetadataChanges.txt"), (int)0, (String)olapCube.getCubeVerifyMessage().toString());
                    return;
                }
                int choice = MessageUtil.displayMessage((String)bundle.getString("Create.prompt.txt"), (String)bundle.getString("Create.Overwrite.window.title"), (int)2, (int)2);
                if (choice != 0) return;
                WsAppServer applicationServer = WsRunCode.getServer();
                if (applicationServer != null) {
                    wsRunCode = new WsRunCode(applicationServer);
                    if (wsRunCode.hasSubmitError) return;
                    if (olapCube.physicallyExists()) {
                        message = bundle.getString("DeleteCubeProgressIndicator.Msg.Message.txt");
                        title = bundle.getString("DeleteCubeProgressIndicator.Msg.window.title");
                        wsRunCode.executeCode(olapCube.generateCodeDeletePhysical(), message, title);
                    }
                    message = bundle.getString("CreateCubeProgressIndicator.Msg.Message.txt");
                    title = bundle.getString("CreateCubeProgressIndicator.Msg.window.title");
                    wsRunCode.executeCode(olapCube.generateCodeCreate(), message, title);
                    wsRunCode.term();
                    MdFactory factory = workspace.getMdObjectFactory();
                    HashMap<String, String> map = new HashMap<String, String>(1);
                    map.put(cube1.getFQID(), cube1.getCMetadataType());
                    Workspace.getMdFactory().fireMdObjectsModified(new MdFactoryEvent(factory, map));
                    return;
                }
                MessageUtil.displayMessage((String)bundle.getString("CubeTreeNode.NoCreate.txt"));
                return;
            }
            catch (OLAPException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
                return;
            }
            catch (RemoteException error) {
                ExceptionHandler.handleException((Exception)error);
                return;
            }
            catch (MdException error) {
                ExceptionHandler.handleException((Exception)((Object)error));
                return;
            }
            finally {
                try {
                    if (wsRunCode != null) {
                        wsRunCode.term();
                    }
                    if (store != null) {
                        store.dispose();
                    }
                }
                catch (RemoteException error) {
                    ExceptionHandler.handleException((Exception)error);
                }
                workspace.setCursor(Cursor.getPredefinedCursor(0));
            }
        }
        MessageUtil.displayMessage((String)bundle.getString("Action.NoPermissions.txt"));
    }

    @Override
    protected boolean isSelectionValid(Object[] selectedObjects) {
        boolean selectionOk = super.isSelectionValid(selectedObjects);
        if (selectionOk) {
            AbstractCubeSelectionAction.getCubePermissions((SimpleObject)selectedObjects[0]);
            selectionOk = canWriteAllCube & canReadAllCube;
        }
        return selectionOk;
    }
}

