/*
 * Decompiled with CFR 0.152.
 */
package com.sas.olapadmin.actions;

import com.sas.olapadmin.designer.model.VersionValidator;
import com.sas.workspace.WAdminResource;
import com.sas.workspace.WsAbstractAction;
import com.sas.workspace.WsAbstractApplicationActionsManager;
import com.sas.workspace.WsActionContextInterface;
import com.sas.workspace.WsSelectionChangedEvent;
import com.sas.workspace.WsSelectionChangedListener;
import com.sas.workspace.WsSelectionProvider;
import com.sas.workspace.models.SimpleObject;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;

public abstract class AbstractSelectionAction
extends WsAbstractAction
implements WsSelectionChangedListener,
WsAbstractApplicationActionsManager.ContextualAction,
WsAbstractApplicationActionsManager.SelectionAction,
PropertyChangeListener {
    private static final long serialVersionUID = 1L;
    protected WsSelectionProvider m_provider;
    protected VersionValidator m_validator;
    private Object[] selected = null;
    private boolean selectedObjectsCompatible;

    public AbstractSelectionAction() {
        this.setEnabled(this.isEnabledWhenNoSelectionProvider());
        this.m_validator = VersionValidator.getInstance();
        this.selectedObjectsCompatible = true;
    }

    public AbstractSelectionAction(WAdminResource bundle, String sResourceKey, int fFlags) {
        super(bundle, sResourceKey, fFlags);
        this.setEnabled(this.isEnabledWhenNoSelectionProvider());
        this.m_validator = VersionValidator.getInstance();
        this.selectedObjectsCompatible = true;
    }

    public void actionPerformed(ActionEvent e) {
        if (this.selected == null && this.m_provider == null) {
            throw new UnsupportedOperationException("Action performed occurred when no action is attached");
        }
        if (this.selected != null && this.selected.length > 0) {
            this.actionPerformed(this.selected);
        } else {
            this.actionPerformed(this.m_provider.getSelectedObjects());
        }
    }

    protected abstract void actionPerformed(Object[] var1);

    public WsSelectionProvider getSelectionProvider() {
        return this.m_provider;
    }

    protected boolean isSelectionCompatible() {
        boolean ret_val = true;
        if (this.m_provider != null) {
            ret_val = this.selectedObjectsCompatible;
        }
        return ret_val;
    }

    protected boolean isEnabledForIncompatibleObjects() {
        return this.isEnabledWhenNoSelectionProvider();
    }

    protected boolean isEnabledWhenNoSelectionProvider() {
        return false;
    }

    protected boolean isSelectionCompatible(Object[] aObjects) {
        boolean newValue = true;
        this.m_validator.removePropertyChangeListener((PropertyChangeListener)this);
        for (int iObject = 0; iObject < aObjects.length; ++iObject) {
            SimpleObject sObject;
            if (!(aObjects[iObject] instanceof SimpleObject) || !this.m_validator.isSupportedForVersioning(sObject = (SimpleObject)aObjects[iObject]) || this.m_validator.isVersionSupported(sObject)) continue;
            newValue = false;
            break;
        }
        if (newValue != this.selectedObjectsCompatible) {
            this.selectedObjectsCompatible = newValue;
        }
        this.m_validator.addPropertyChangeListener((PropertyChangeListener)this);
        return this.selectedObjectsCompatible;
    }

    protected abstract boolean isSelectionValid(Object[] var1);

    public boolean isValidForContext(WsActionContextInterface context) {
        Object[] selectedObjects = context.getSelectedObjects();
        return this.isValidForObjects(selectedObjects);
    }

    protected boolean isValidForObjects(Object[] selectedObjects) {
        if (selectedObjects.length == 0) {
            return false;
        }
        for (int i = 0; i < selectedObjects.length; ++i) {
            if (selectedObjects[i] instanceof SimpleObject) continue;
            return false;
        }
        return true;
    }

    @Override
    public void propertyChange(PropertyChangeEvent ev) {
        block4: {
            String propertyName;
            Object source;
            block5: {
                source = ev.getSource();
                propertyName = ev.getPropertyName();
                if (!(source instanceof VersionValidator) || !"VersionIncompatibleEvent".equals(propertyName)) break block5;
                Object newValue = ev.getNewValue();
                if (!(newValue instanceof SimpleObject) || !this.isSelectionCompatible() || this.selected == null) break block4;
                for (int i = 0; i < this.selected.length; ++i) {
                    if (!this.selected[i].equals(newValue)) continue;
                    this.selectedObjectsCompatible = false;
                    this.setEnabled(this.isEnabledForIncompatibleObjects());
                    break block4;
                }
                break block4;
            }
            if (source instanceof VersionValidator && "VersionCompatibleEvent".equals(propertyName)) {
                Object newValue = ev.getNewValue();
                if (!this.isSelectionCompatible() && this.selected != null) {
                    for (int i = 0; i < this.selected.length; ++i) {
                        if (!this.selected[i].equals(newValue)) continue;
                        this.selectedObjectsCompatible = true;
                        this.setEnabled(this.isSelectionValid(this.selected));
                        break;
                    }
                }
            }
        }
    }

    public void selectionChanged(WsSelectionChangedEvent ev) {
        Object[] aObjects = this.m_provider.getSelectedObjects();
        this.setSelectedObjects(aObjects);
    }

    private void setSelectedObjects(Object[] objects) {
        if (Arrays.equals(objects, this.selected)) {
            return;
        }
        this.selected = objects;
        if (this.m_provider == null) {
            throw new IllegalStateException("Provider should not be null when calling setSelectedObjects()");
        }
        if (this.isSelectionCompatible(objects) || this.isEnabledForIncompatibleObjects()) {
            this.setEnabled(this.isSelectionValid(objects));
        } else {
            this.setEnabled(false);
        }
    }

    public void setSelectionProvider(WsSelectionProvider provider) {
        if (this.m_provider == provider) {
            return;
        }
        this.selected = null;
        if (this.m_provider != null) {
            this.m_provider.removeSelectionChangedListener((WsSelectionChangedListener)this);
            this.m_validator.removePropertyChangeListener((PropertyChangeListener)this);
        }
        if (provider != null) {
            this.m_provider = provider;
            this.m_provider.addSelectionChangedListener((WsSelectionChangedListener)this);
            this.setSelectedObjects(this.m_provider.getSelectedObjects());
        } else {
            this.setEnabled(this.isEnabledWhenNoSelectionProvider());
            this.m_provider = null;
            this.selectedObjectsCompatible = true;
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.m_validator != null) {
                this.m_validator.removePropertyChangeListener((PropertyChangeListener)this);
                this.m_validator = null;
            }
            if (this.m_provider != null) {
                this.m_provider.removeSelectionChangedListener((WsSelectionChangedListener)this);
                this.m_provider = null;
            }
            this.selected = null;
        }
        finally {
            super.finalize();
        }
    }
}

