/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.mgmt;

import com.sas.batch.metadata.mgmt.AbstractMetadataMgmtUtility;
import com.sas.batch.metadata.mgmt.RB;
import com.sas.codepolicy.SASScope;
import com.sas.svcs.metadata.mgmt.client.MetadataRepositoryService;
import com.sas.svcs.metadata.mgmt.client.Repository;
import com.sas.text.Message;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.ParseException;

@SASScope
public class DeleteRepository
extends AbstractMetadataMgmtUtility {
    private String repositoryName;

    public DeleteRepository() {
        this.utilityName = "sas-delete-repository";
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public int execute() throws Exception {
        if (this.repositoryName == null || this.repositoryName.length() == 0) {
            this.logger.error(RB.getStringResource("DeleteRepository.NoRepositoryName.log"));
            this.returnCode = 8;
            return this.returnCode;
        }
        try {
            this.initialize();
            MetadataRepositoryService repositoryService = (MetadataRepositoryService)this.applicationContext.getBean("MetadataRepositoryService");
            Repository repository = repositoryService.getRepositoryByName(this.repositoryName);
            repositoryService.deleteRepository(repository);
            this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"DeleteRepository.Deleted.fmt.log", (Object)this.repositoryName));
        }
        finally {
            this.terminate();
        }
        return this.returnCode;
    }

    public static void main(String[] args) {
        DeleteRepository delete = new DeleteRepository();
        delete.executeBatch(args);
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        if (!super.parse(args)) {
            return false;
        }
        String[] remainingArgs = this.commandLine.getArgs();
        if (remainingArgs.length != 1) {
            this.displayHelp();
            return false;
        }
        this.setRepositoryName(remainingArgs[0]);
        return true;
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("DeleteRepository.HelpUsage.txt")});
    }
}

