/*
 * Decompiled with CFR 0.152.
 */
package com.sas.batch.metadata.mgmt;

import com.sas.batch.metadata.mgmt.AbstractMetadataMgmtUtility;
import com.sas.batch.metadata.mgmt.RB;
import com.sas.codepolicy.SASScope;
import com.sas.services.util.Names;
import com.sas.svcs.metadata.mgmt.client.MetadataRepositoryService;
import com.sas.svcs.metadata.mgmt.client.Operation;
import com.sas.svcs.metadata.mgmt.client.ProjectRepository;
import com.sas.svcs.metadata.mgmt.client.Repository;
import com.sas.svcs.metadata.mgmt.client.RepositoryCreationResult;
import com.sas.text.Message;
import java.util.ResourceBundle;
import org.apache.commons.cli.MissingOptionException;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

@SASScope
public class CreateProjectRepository
extends AbstractMetadataMgmtUtility {
    public static final String OPTION_DESC = "desc";
    public static final String OPTION_OWNER = "owner";
    public static final String OPTION_PATH = "path";
    private String owner;
    private String repositoryName;
    private String repositoryDesc;
    private String repositoryPath;

    public CreateProjectRepository() {
        this.utilityName = "sas-create-project-repository";
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        Names.validateOMRObjectName((String)repositoryName, (boolean)true);
        this.repositoryName = repositoryName;
    }

    public String getRepositoryDesc() {
        return this.repositoryDesc;
    }

    public void setRepositoryDesc(String repositoryDesc) {
        this.repositoryDesc = repositoryDesc;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public void setRepositoryPath(String repositoryPath) {
        this.repositoryPath = repositoryPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws Exception {
        if (this.repositoryName == null || this.repositoryName.length() == 0) {
            this.logger.error(RB.getStringResource("CreateRepository.NameMustBeSpecified.log"));
            this.returnCode = 8;
            return this.returnCode;
        }
        try {
            this.initialize();
            ProjectRepository repository = new ProjectRepository();
            repository.setName(this.repositoryName);
            repository.setProjectOwner(this.owner);
            if (this.repositoryDesc != null) {
                repository.setDescription(this.repositoryDesc);
            }
            if (this.repositoryPath != null && this.repositoryPath.length() > 0) {
                repository.setPath(this.repositoryPath);
            } else {
                repository.setPath("MetadataRepositories/" + Names.mapNameToFilesystem((String)repository.getName(), (int)0, null, null));
            }
            repository.setCreateRepositoryPath(true);
            MetadataRepositoryService repositoryService = (MetadataRepositoryService)this.applicationContext.getBean("MetadataRepositoryService");
            RepositoryCreationResult result = repositoryService.createRepository((Repository)repository);
            if (result != null) {
                if (result.getStatus() == Operation.Status.ERROR) {
                    this.returnCode = 8;
                    this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"CreateRepository.Created.Failure.fmt.log", (Object)this.repositoryName));
                } else {
                    this.returnCode = 0;
                    this.logger.info(Message.format((ResourceBundle)RB.getResources(), (String)"CreateRepository.Created.fmt.log", (Object)this.repositoryName));
                }
            } else {
                this.returnCode = 8;
                this.logger.error(Message.format((ResourceBundle)RB.getResources(), (String)"CreateRepository.Created.Failure.fmt.log", (Object)this.repositoryName));
            }
        }
        finally {
            this.terminate();
        }
        return this.returnCode;
    }

    public static void main(String[] args) {
        CreateProjectRepository creator = new CreateProjectRepository();
        creator.executeBatch(args);
    }

    protected Options getCommandLineOptions(boolean forHelpText) {
        Options options = super.getCommandLineOptions(forHelpText);
        Option option = new Option(OPTION_DESC, true, RB.getStringResource("CreateRepository.Desc.Option.txt"));
        option.setArgName(RB.getStringResource("CreateRepository.Desc.ArgName.txt"));
        options.addOption(option);
        option = new Option(OPTION_OWNER, true, RB.getStringResource("CreateProjectRepository.Owner.Option.txt"));
        option.setArgName(RB.getStringResource("CreateProjectRepository.Owner.ArgName.txt"));
        option.setRequired(true);
        options.addOption(option);
        option = new Option(OPTION_PATH, true, RB.getStringResource("CreateRepository.Path.Option.txt"));
        option.setArgName(RB.getStringResource("CreateRepository.Path.ArgName.txt"));
        options.addOption(option);
        return options;
    }

    protected boolean parse(String[] args) throws ParseException, MissingOptionException {
        String[] remainingArgs;
        if (!super.parse(args)) {
            return false;
        }
        if (this.commandLine.hasOption(OPTION_DESC)) {
            this.setRepositoryDesc(this.commandLine.getOptionValue(OPTION_DESC));
        }
        this.setOwner(this.commandLine.getOptionValue(OPTION_OWNER));
        if (this.commandLine.hasOption(OPTION_PATH)) {
            this.setRepositoryPath(this.commandLine.getOptionValue(OPTION_PATH));
        }
        if ((remainingArgs = this.commandLine.getArgs()).length != 1) {
            this.displayHelp();
            return false;
        }
        this.setRepositoryName(remainingArgs[0]);
        return true;
    }

    protected void displayHelp() {
        this.displayHelp(new String[]{RB.getStringResource("CreateProjectRepository.HelpUsage.txt")});
    }
}

