/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.jar.JarFile;
import java.util.regex.Pattern;

public final class Util {
    public static final Charset UTF8 = Charset.forName("UTF-8");
    static final String[] ZERO_STRINGS = new String[0];
    static final URL[] ZERO_URLS = new URL[0];
    static final File[] ZERO_FILES = new File[0];
    static final Class[] VOID = new Class[0];
    static final String RB_NAME = Util.getPkgRBName(Util.class);

    private Util() {
        throw new UnsupportedOperationException();
    }

    private static String getPkgPrefix(Object o) throws IllegalArgumentException {
        if (o == null) {
            throw Util.illegalNull("o");
        }
        Class<?> c = o instanceof Class ? (Class<?>)o : o.getClass();
        String cname = c.getName();
        int i = cname.lastIndexOf(46);
        return i >= 0 ? cname.substring(0, i + 1) : "";
    }

    private static String getPkgRBName(Object o) throws IllegalArgumentException {
        return Util.getPkgPrefix(o) + "Resources";
    }

    static ResourceBundle rb() {
        return ResourceBundle.getBundle(RB_NAME);
    }

    static String format(String key) {
        return Util.rb().getString(key);
    }

    static String format(String key, Object arg0) {
        return MessageFormat.format(Util.rb().getString(key), arg0);
    }

    static String format(String key, Object arg0, Object arg1) {
        return MessageFormat.format(Util.rb().getString(key), arg0, arg1);
    }

    static String format(String key, Object arg0, Object arg1, Object arg2) {
        return MessageFormat.format(Util.rb().getString(key), arg0, arg1, arg2);
    }

    static String format(String key, Object arg0, Object arg1, Object arg2, Object arg3) {
        return MessageFormat.format(Util.rb().getString(key), arg0, arg1, arg2, arg3);
    }

    static IllegalArgumentException illegalNegative(String paramName, long value) {
        return new IllegalArgumentException(MessageFormat.format(Util.rb().getString("Util.argError.negative.ex.fmt.txt"), paramName, new Long(value)));
    }

    static IllegalArgumentException illegalArgument(String paramName, Object value) {
        return new IllegalArgumentException(Util.format("Util.argError.ex.fmt.txt", paramName, value));
    }

    static IllegalArgumentException illegalNull(String paramName) {
        return new IllegalArgumentException(Util.format("Util.argError.null.ex.fmt.txt", paramName));
    }

    static File canonical(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.getCanonicalFile();
        }
        catch (IOException e) {
            return f.getAbsoluteFile();
        }
    }

    static String makeStrictRelativePath(File ancestor, File descendent) {
        File p;
        ArrayList<String> stack = new ArrayList<String>();
        for (p = descendent; p != null && !p.equals(ancestor); p = p.getParentFile()) {
            stack.add(p.getName());
        }
        if (p == null || stack.isEmpty()) {
            return null;
        }
        StringBuffer b = new StringBuffer();
        for (int i = stack.size() - 1; i >= 0; --i) {
            if (b.length() > 0) {
                b.append(File.separatorChar);
            }
            b.append((String)stack.get(i));
        }
        return b.toString();
    }

    static long lastMod(File f) {
        if (f == null) {
            return Long.MIN_VALUE;
        }
        long rc = f.lastModified();
        return rc == 0L && !f.exists() ? Long.MIN_VALUE : rc;
    }

    static void close(InputStream s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void close(OutputStream s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void close(Reader s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void close(Writer s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static void close(JarFile s) {
        if (s == null) {
            return;
        }
        try {
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static URL toURL(File f) {
        if (f == null) {
            return null;
        }
        try {
            return f.toURI().toURL();
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    static File toFile(URL u) {
        if (u == null) {
            return null;
        }
        String temp = u.toString();
        if ("jar".equals(u.getProtocol())) {
            if (!temp.endsWith("!/") || !temp.startsWith("jar:")) {
                return null;
            }
            try {
                u = new URL(temp.substring(4, temp.length() - 2));
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        if (!"file".equals(u.getProtocol())) {
            return null;
        }
        try {
            return Util.canonical(new File(new URI(temp)));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (temp.replace('\\', '/').startsWith("file://")) {
            return Util.canonical(new File(temp.substring(5)));
        }
        return Util.canonical(new File(u.getPath()));
    }

    static Method getAccessibleMethod(Object o, String methodName, Class[] sig, boolean noInstance, Class desiredReturnType) throws IllegalArgumentException {
        if (o == null) {
            throw Util.illegalNull("o");
        }
        if (methodName == null) {
            throw Util.illegalNull("methodName");
        }
        if (sig != null && sig.length > 0) {
            Class[] copy = new Class[sig.length];
            System.arraycopy(sig, 0, copy, 0, sig.length);
            for (int i = 0; i < sig.length; ++i) {
                if (copy[i] != null) continue;
                throw Util.illegalNull("sig[" + i + "]");
            }
            sig = copy;
        } else {
            sig = VOID;
        }
        Class<?> cls = o instanceof Class ? (Class<?>)o : o.getClass();
        try {
            Method m = cls.getMethod(methodName, sig);
            if (!(noInstance && !Modifier.isStatic(m.getModifiers()) || desiredReturnType != null && !desiredReturnType.isAssignableFrom(m.getReturnType()))) {
                return m;
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return null;
    }

    static Object invoke(Object o, String methodName, Class[] sig, Object[] args, Class desiredReturnType, Throwable[] rcProblem) throws IllegalArgumentException {
        Method m = Util.getAccessibleMethod(o, methodName, sig, o instanceof Class, desiredReturnType);
        Throwable t = null;
        Object rc = null;
        if (m != null) {
            try {
                rc = m.invoke(o, args);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException();
            }
            catch (InvocationTargetException e) {
                t = e.getCause();
            }
            catch (NullPointerException e) {
                throw new IllegalStateException();
            }
            catch (ExceptionInInitializerError e) {
                t = e;
            }
        } else {
            t = new NoSuchMethodException(methodName);
        }
        if (t != null && rcProblem != null && rcProblem.length > 0) {
            rcProblem[0] = t;
        }
        return rc;
    }

    static URL[] getClassLoaderURLs(ClassLoader cl) {
        if (cl == null) {
            return ZERO_URLS;
        }
        if (cl instanceof URLClassLoader) {
            return Util.copyAndRemoveNulls(((URLClassLoader)cl).getURLs());
        }
        Object rc = Util.invoke(cl, "getURLs", null, null, URL[].class, null);
        return rc instanceof URL[] ? Util.copyAndRemoveNulls((URL[])rc) : ZERO_URLS;
    }

    static URL[] copyAndRemoveNulls(URL[] a) {
        int i;
        if (a == null || a.length <= 0) {
            return ZERO_URLS;
        }
        URL[] copy = new URL[a.length];
        for (i = 0; i < a.length; ++i) {
            URL temp;
            copy[i] = temp = a[i];
            if (temp == null) break;
        }
        if (i >= a.length) {
            return copy;
        }
        int p = i++;
        while (i < a.length) {
            URL u = a[i];
            if (u != null) {
                copy[p++] = u;
            }
            ++i;
        }
        if (p <= 0) {
            return ZERO_URLS;
        }
        URL[] rc = new URL[p];
        System.arraycopy(copy, 0, rc, 0, p);
        return rc;
    }

    static File[] getPathFiles(String path) {
        if (path == null) {
            return ZERO_FILES;
        }
        StringTokenizer tok = new StringTokenizer(path, File.pathSeparator);
        int n = tok.countTokens();
        if (n <= 0) {
            return ZERO_FILES;
        }
        File[] rc = new File[n];
        for (int i = 0; i < n; ++i) {
            rc[i] = Util.canonical(new File(tok.nextToken()));
        }
        return rc;
    }

    static void addNewFileUrls(File[] files, LinkedHashSet rc) {
        if (files == null || files.length <= 0 || rc == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            URL u = Util.toURL(files[i]);
            if (u == null) continue;
            rc.add(u);
        }
    }

    public static File[] findMatchingFiles(File baseLoc, String pattern) {
        LinkedHashSet rc = new LinkedHashSet();
        Util.addMatchingFiles(baseLoc, pattern, rc);
        int n = rc.size();
        return n > 0 ? rc.toArray(new File[n]) : ZERO_FILES;
    }

    static void addMatchingFiles(File baseLoc, String pattern, Set rcFiles) throws IllegalArgumentException {
        int i;
        String s;
        File p;
        File pfile;
        boolean a;
        if (pattern == null) {
            throw Util.illegalNull("pattern");
        }
        if (pattern.length() <= 0) {
            return;
        }
        String npattern = pattern.replace('\\', '/').replace(File.separatorChar, '/');
        if (npattern.endsWith("/")) {
            npattern = npattern + "**";
        }
        if (baseLoc == null) {
            baseLoc = new File(".");
        }
        if (!(a = (pfile = new File(npattern)).isAbsolute()) && npattern.charAt(0) == '/') {
            npattern = npattern.substring(1);
            pfile = new File(npattern);
            a = pfile.isAbsolute();
        }
        if (!NameMatcher.containsWildcards(npattern)) {
            File match = Util.canonical(a ? pfile : new File(baseLoc, npattern));
            if (match.isFile()) {
                rcFiles.add(match);
            }
            return;
        }
        NameMatcher fileNamePattern = NameMatcher.nameMatcherFor(pfile.getName());
        if (fileNamePattern == null) {
            fileNamePattern = NameMatcher.nameMatcherFor("*");
            p = pfile;
        } else {
            p = pfile.getParentFile();
        }
        if (p == null && a) {
            throw Util.illegalArgument("pattern", pattern);
        }
        ArrayList<String> pieces = new ArrayList<String>();
        while (p != null) {
            File nextP = p.getParentFile();
            if (a && nextP == null) {
                baseLoc = p;
                break;
            }
            pieces.add(p.getName());
            p = nextP;
        }
        while (!pieces.isEmpty() && !NameMatcher.containsWildcards(s = (String)pieces.get(i = pieces.size() - 1))) {
            pieces.remove(i);
            baseLoc = new File(baseLoc, s);
        }
        if (!(baseLoc = Util.canonical(baseLoc)).isDirectory()) {
            return;
        }
        int n = pieces.size();
        NameMatcher[] dirPatterns = new NameMatcher[n];
        for (int i2 = 0; i2 < dirPatterns.length; ++i2) {
            dirPatterns[i2] = NameMatcher.nameMatcherFor((String)pieces.get(--n));
        }
        DirPathMatcher dirPathMatcher = new DirPathMatcher(dirPatterns);
        ArrayList<String> curPath = new ArrayList<String>();
        ArrayList<Comparable<Integer>> dirStack = new ArrayList<Comparable<Integer>>();
        Integer[] CODES = new Integer[4];
        for (int i3 = 0; i3 < CODES.length; ++i3) {
            CODES[i3] = new Integer(i3);
        }
        int rc = dirPathMatcher.calcDirMatch(curPath);
        if (rc == 0) {
            return;
        }
        dirStack.add(CODES[rc]);
        dirStack.add(baseLoc);
        while (!dirStack.isEmpty()) {
            boolean processSubDirs;
            File dir = (File)dirStack.remove(dirStack.size() - 1);
            if (dir == null) {
                if (curPath.isEmpty()) {
                    assert (false);
                    throw new IllegalStateException();
                }
                curPath.remove(curPath.size() - 1);
                continue;
            }
            int rc2 = (Integer)dirStack.remove(dirStack.size() - 1);
            assert (rc2 != 0);
            if (dir != baseLoc) {
                curPath.add(dir.getName());
                dirStack.add(null);
            }
            boolean processFiles = rc2 == 1 || rc2 == 3;
            boolean bl = processSubDirs = rc2 == 2 || rc2 == 3;
            assert (processFiles || processSubDirs);
            File[] listing = dir.listFiles();
            if (listing == null || listing.length <= 0) continue;
            int pMatchingFiles = listing.length;
            for (int i4 = listing.length - 1; i4 >= 0; --i4) {
                File f = listing[i4];
                String fname = f.getName();
                boolean file = false;
                boolean tested = false;
                if (processFiles && fileNamePattern.matches(fname)) {
                    file = f.isFile();
                    tested = true;
                    if (file) {
                        listing[--pMatchingFiles] = f;
                        continue;
                    }
                }
                if (!processSubDirs) continue;
                curPath.add(fname);
                int drc = dirPathMatcher.calcDirMatch(curPath);
                curPath.remove(curPath.size() - 1);
                if (drc == 0) continue;
                if (!tested) {
                    boolean bl2 = file = !f.isDirectory();
                }
                if (file) continue;
                dirStack.add(CODES[drc]);
                dirStack.add(f);
            }
            while (pMatchingFiles < listing.length) {
                rcFiles.add(listing[pMatchingFiles++]);
            }
        }
    }

    private static final class NameMatcher {
        private final Pattern m_regex;
        private final String m_pattern;
        private final boolean m_bRegex;

        static boolean containsWildcards(String s) {
            if (s == null || s.length() <= 0) {
                return false;
            }
            return s.indexOf(42) >= 0 || s.indexOf(63) >= 0;
        }

        static NameMatcher nameMatcherFor(String pattern) {
            return "**".equals(pattern) ? null : new NameMatcher(pattern);
        }

        NameMatcher(String pattern) {
            if (pattern == null) {
                throw Util.illegalNull("pattern");
            }
            if (pattern.length() <= 0) {
                throw Util.illegalArgument("pattern", pattern);
            }
            this.m_pattern = pattern;
            if (!NameMatcher.containsWildcards(pattern)) {
                this.m_regex = null;
                this.m_bRegex = false;
                return;
            }
            StringBuffer regex = new StringBuffer();
            int n = pattern.length();
            block5: for (int i = 0; i < n; ++i) {
                char c = pattern.charAt(i);
                switch (c) {
                    case '$': 
                    case '(': 
                    case '+': 
                    case '.': 
                    case '[': 
                    case '\\': 
                    case '^': 
                    case '{': 
                    case '|': {
                        regex.append('\\').append(c);
                        continue block5;
                    }
                    case '?': {
                        regex.append('.');
                        continue block5;
                    }
                    case '*': {
                        regex.append(".*");
                        continue block5;
                    }
                    default: {
                        regex.append(c);
                    }
                }
            }
            this.m_regex = Pattern.compile(regex.toString());
            this.m_bRegex = true;
        }

        boolean matches(String s) {
            if (s == null) {
                return false;
            }
            return this.m_bRegex ? this.m_regex.matcher(s).matches() : this.m_pattern.equals(s);
        }
    }

    private static final class DirPathMatcher {
        static final int F_THIS_DIR = 1;
        static final int F_MAYBE_DESCENDENTS = 2;
        private static final int NO = 0;
        private static final int THIS_ONLY = 1;
        private static final int NOT_THIS_MAYBE_DESCENDENTS = 2;
        private static final int THIS_AND_MAYBE_DESCENDENTS = 3;
        private final NameMatcher[] m_begin;
        private final NameMatcher[][] m_middle;
        private final NameMatcher[] m_end;

        DirPathMatcher(NameMatcher[] dirPatterns) throws IllegalArgumentException {
            int lastNull;
            int firstNull;
            if (dirPatterns == null) {
                throw Util.illegalNull("dirPatterns");
            }
            NameMatcher[] copy = new NameMatcher[dirPatterns.length];
            System.arraycopy(dirPatterns, 0, copy, 0, dirPatterns.length);
            for (firstNull = 0; firstNull < copy.length && copy[firstNull] != null; ++firstNull) {
            }
            if (firstNull >= copy.length) {
                this.m_begin = copy;
                this.m_middle = null;
                this.m_end = null;
                return;
            }
            if (firstNull > 0) {
                this.m_begin = new NameMatcher[firstNull];
                System.arraycopy(copy, 0, this.m_begin, 0, firstNull);
            } else {
                this.m_begin = null;
            }
            for (lastNull = copy.length - 1; lastNull > firstNull && copy[lastNull] != null; --lastNull) {
            }
            int endSubPathSize = copy.length - 1 - lastNull;
            if (endSubPathSize > 0) {
                this.m_end = new NameMatcher[endSubPathSize];
                System.arraycopy(copy, lastNull + 1, this.m_end, 0, endSubPathSize);
            } else {
                this.m_end = null;
            }
            if (firstNull == lastNull) {
                this.m_middle = null;
                return;
            }
            ArrayList<NameMatcher[]> middle = new ArrayList<NameMatcher[]>();
            ArrayList<NameMatcher> subPath = new ArrayList<NameMatcher>();
            boolean prevNull = true;
            for (int i = firstNull + 1; i <= lastNull; ++i) {
                NameMatcher m = copy[i];
                if (m != null) {
                    prevNull = false;
                    subPath.add(m);
                    continue;
                }
                if (prevNull) continue;
                prevNull = true;
                int n = subPath.size();
                if (n <= 0) {
                    assert (false);
                    throw new IllegalStateException();
                }
                middle.add(subPath.toArray(new NameMatcher[n]));
                subPath.clear();
            }
            if (!subPath.isEmpty()) {
                assert (false);
                throw new IllegalStateException();
            }
            int n = middle.size();
            this.m_middle = n <= 0 ? null : (NameMatcher[][])middle.toArray((T[])new NameMatcher[n][]);
        }

        int calcDirMatch(List curPath) throws IllegalArgumentException {
            int iPathEnd;
            int iPathStart;
            if (curPath == null) {
                throw Util.illegalNull("curPath");
            }
            int psize = curPath.size();
            if (this.m_begin != null) {
                if (this.m_begin.length == 0) {
                    return psize == 0 ? 1 : 0;
                }
                if (psize == 0) {
                    return 2;
                }
                for (int i = Math.min(this.m_begin.length, psize) - 1; i >= 0; --i) {
                    if (this.m_begin[i].matches((String)curPath.get(i))) continue;
                    return 0;
                }
                if (psize < this.m_begin.length) {
                    return 2;
                }
                if (this.m_middle == null && this.m_end == null) {
                    return psize == this.m_begin.length ? 1 : 0;
                }
                iPathStart = this.m_begin.length;
            } else {
                iPathStart = 0;
            }
            if (this.m_end != null) {
                if (this.m_end.length <= 0) {
                    assert (false);
                    throw new IllegalStateException();
                }
                int nPathRemaining = psize - iPathStart;
                if (nPathRemaining < this.m_end.length) {
                    return 2;
                }
                iPathEnd = psize;
                for (int i = this.m_end.length - 1; i >= 0; --i) {
                    if (this.m_end[i].matches((String)curPath.get(--iPathEnd))) continue;
                    return 2;
                }
            } else {
                iPathEnd = psize;
            }
            if (this.m_middle != null) {
                if (this.m_middle.length <= 0) {
                    assert (false);
                    throw new IllegalStateException();
                }
                for (int iSubPath = 0; iSubPath < this.m_middle.length; ++iSubPath) {
                    NameMatcher[] subPath = this.m_middle[iSubPath];
                    if (subPath == null || subPath.length <= 0) {
                        assert (false);
                        throw new IllegalStateException();
                    }
                    if ((iPathStart = DirPathMatcher.matchSubPath(curPath, subPath, iPathStart, iPathEnd)) >= 0) continue;
                    return 2;
                }
            }
            return 3;
        }

        private static int matchSubPath(List curPath, NameMatcher[] subPath, int iPathStart, int iPathEnd) {
            int maxBegin = iPathEnd - subPath.length;
            while (iPathStart <= maxBegin) {
                if (DirPathMatcher.isMatchAt(curPath, subPath, iPathStart)) {
                    return iPathStart + subPath.length;
                }
                ++iPathStart;
            }
            return -1;
        }

        private static boolean isMatchAt(List curPath, NameMatcher[] subPath, int iPathStart) {
            for (int i = 0; i < subPath.length; ++i) {
                if (subPath[i].matches((String)curPath.get(iPathStart + i))) continue;
                return false;
            }
            return true;
        }
    }
}

