/*
 * Decompiled with CFR 0.152.
 */
package com.sas.app;

import com.sas.app.GetSystemPropertyAction;
import java.security.AccessController;
import java.util.StringTokenizer;

final class RepositoryOptions {
    private static final String PROP_OPTIONS = "sas.app.repository.options";
    private static final String OPTIONS_DELIM = ",";
    private static final String O_NO_INDEX = "noindex";
    private static final String O_NO_TAINTED = "notaint";
    private static final String O_ALLOW_TAINTED = "allowTaint";
    private static final String O_SDS = "sdsenv";
    private static final String O_DEBUG = "debug";
    final boolean m_noindex;
    final boolean m_useTainted;
    final String m_sdsEnv;
    final boolean m_debug;

    RepositoryOptions() {
        this((String)AccessController.doPrivileged(new GetSystemPropertyAction(PROP_OPTIONS)));
    }

    RepositoryOptions(String optionsPropValue) {
        boolean notaint = false;
        boolean noindex = false;
        boolean debug = false;
        Boolean allowTaint = null;
        String sdsEnv = null;
        if (optionsPropValue != null) {
            StringTokenizer tok;
            StringTokenizer stringTokenizer = tok = OPTIONS_DELIM != null && OPTIONS_DELIM.length() > 0 ? new StringTokenizer(optionsPropValue, OPTIONS_DELIM) : new StringTokenizer(optionsPropValue);
            while (tok.hasMoreTokens()) {
                String s = tok.nextToken();
                if (O_NO_INDEX.equalsIgnoreCase(s)) {
                    noindex = true;
                    continue;
                }
                if (O_NO_TAINTED.equalsIgnoreCase(s)) {
                    notaint = true;
                    continue;
                }
                if (O_DEBUG.equalsIgnoreCase(s)) {
                    debug = true;
                    continue;
                }
                int equals = s.indexOf(61);
                if (equals <= 0) continue;
                String key = s.substring(0, equals).trim();
                String value = s.substring(equals + 1).trim();
                if (key.equals(O_ALLOW_TAINTED)) {
                    allowTaint = Boolean.valueOf(value);
                    continue;
                }
                if (key.equals(O_SDS)) {
                    sdsEnv = value;
                    continue;
                }
                if (!O_DEBUG.equalsIgnoreCase(s)) continue;
                debug = Boolean.parseBoolean(value);
            }
        }
        this.m_noindex = noindex;
        this.m_debug = debug;
        String string = this.m_sdsEnv = sdsEnv != null && sdsEnv.length() > 0 ? sdsEnv : null;
        boolean bl = allowTaint != null ? allowTaint : (notaint ? false : (this.m_useTainted = sdsEnv == null));
        if (debug) {
            System.out.println("Repository options effective:\n\tnoindex? " + noindex + "\n\tdebug? " + debug + "\n\tsdsenv = " + this.m_sdsEnv + "\n\tuseTainted? " + this.m_useTainted);
            System.out.flush();
        }
    }
}

