/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.transport.spi;

import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.document.client.Document;
import com.sas.svcs.content.document.client.DocumentService;
import com.sas.svcs.content.folder.client.Folder;
import com.sas.svcs.content.folder.client.FolderService;
import com.sas.svcs.content.framework.client.ObjectExistsException;
import com.sas.svcs.content.framework.client.ObjectNotFoundException;
import com.sas.svcs.content.framework.client.ValidationException;
import com.sas.svcs.content.navigation.client.ContainerNode;
import com.sas.svcs.content.navigation.client.NavigationNode;
import com.sas.svcs.content.navigation.client.NavigationService;
import com.sas.svcs.content.transport.client.ContentItem;
import com.sas.svcs.content.transport.spi.ExportPersistenceSupport;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipOutputStream;

public class JcrExportPersistenceSupport
implements ExportPersistenceSupport {
    public static final String ATTRIBUTES_FILE = "attributes.properties";
    FolderService folderService;
    DocumentService documentService;
    NavigationService navigationService;
    private String baseDirectory;
    private String packageId;
    private String type;

    public JcrExportPersistenceSupport(String baseDirectory, String packageId, String type) {
        this.baseDirectory = baseDirectory;
        this.packageId = packageId;
        this.type = type;
    }

    public void setFolderService(FolderService folderService) {
        this.folderService = folderService;
    }

    public void setDocumentService(DocumentService documentService) {
        this.documentService = documentService;
    }

    public void setNavigationService(NavigationService navigationService) {
        this.navigationService = navigationService;
    }

    @Override
    public boolean writeContentItem(ContentItem item) {
        Folder baseFolder = this.folderService.getFolderByPath(this.baseDirectory, 79L);
        if (baseFolder == null) {
            throw new RuntimeException("The base folder from the configuration must exist.");
        }
        Folder packageFolder = this.findOrCreateFolder(baseFolder, this.packageId, "Package Folder", true);
        Folder typeFolder = this.findOrCreateFolder(packageFolder, this.type, "Package Type Folder", true);
        Folder itemFolder = this.findOrCreateFolder(typeFolder, item.getName(), "Package Item Folder", true);
        Properties properties = item.getAttributes();
        if (properties != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                properties.store(baos, "");
                Document document = new Document();
                document.setContentStream(baos.toByteArray());
                baos.close();
                document.setName(ATTRIBUTES_FILE);
                document.setObjectType(82L);
                document.setDocumentType("text/plain");
                document = this.documentService.createDocument(itemFolder, document);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        try {
            Document document = new Document();
            document.setContentStream(item.getContent());
            String name = item.getContentName();
            if (name == null) {
                name = item.getName();
            }
            document.setName(name);
            document.setObjectType(82L);
            document.setDocumentType("application/octet-stream");
            document = this.documentService.createDocument(itemFolder, document);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return false;
    }

    @Override
    public ContentItem readContentItem(String name) {
        String path = this.baseDirectory + "/" + this.packageId + "/" + this.type + "/" + name;
        ContainerNode typeNode = (ContainerNode)this.navigationService.getObjectByPath(path, 79L);
        if (typeNode == null) {
            return null;
        }
        try {
            ContentItem item = new ContentItem();
            item.setName(name);
            List<NavigationNode> itemNodes = this.navigationService.getChildren(typeNode);
            for (NavigationNode nextItem : itemNodes) {
                ObjectIdentity identity = new ObjectIdentity(nextItem.getContentObject().getObjectType(), nextItem.getContentObject().getId());
                Document document = this.documentService.getDocumentById(identity);
                if (document.getName().equals(ATTRIBUTES_FILE)) {
                    ByteArrayInputStream bis = new ByteArrayInputStream(document.getContentStream());
                    Properties prop = new Properties();
                    prop.load(bis);
                    bis.close();
                    item.setAttributes(prop);
                    continue;
                }
                item.setContent(document.getContentStream());
                item.setContentName(document.getName());
            }
            return item;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public List<String> getItemNames() {
        ArrayList<String> result = new ArrayList<String>();
        String path = this.baseDirectory + "/" + this.packageId + "/" + this.type;
        ContainerNode typeNode = (ContainerNode)this.navigationService.getObjectByPath(path, 79L);
        if (typeNode == null) {
            return null;
        }
        try {
            List<NavigationNode> itemNodes = this.navigationService.getChildren(typeNode);
            for (NavigationNode nextItem : itemNodes) {
                result.add(nextItem.getContentObject().getName());
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
        return result;
    }

    private Folder findOrCreateFolder(Folder parent, String name, String description, boolean create) {
        String path = parent.getPath() + "/" + name;
        Folder folder = this.folderService.getFolderByPath(path, 79L);
        if (folder == null && create) {
            try {
                folder = this.folderService.createFolder(parent, this.type, description);
            }
            catch (ObjectNotFoundException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
            catch (ObjectExistsException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
            catch (ValidationException ex) {
                throw new RuntimeException(ex.getMessage(), ex);
            }
        }
        return folder;
    }

    @Override
    public void deletePackage() {
        String path = this.baseDirectory + "/" + this.packageId;
        ContainerNode packageNode = (ContainerNode)this.navigationService.getObjectByPath(path, 79L);
        if (packageNode == null) {
            return;
        }
        this.deleteContainer(packageNode);
    }

    private void deleteContainer(ContainerNode container) {
        try {
            List<NavigationNode> children = this.navigationService.getChildren(container);
            for (NavigationNode nextNode : children) {
                if (nextNode instanceof ContainerNode) {
                    this.deleteContainer((ContainerNode)nextNode);
                    continue;
                }
                this.deleteNode(nextNode);
            }
            this.deleteNode(container);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    private void deleteNode(NavigationNode node) {
        long objectType = node.getObjectType();
        try {
            if (objectType == 79L) {
                ObjectIdentity objectIdentity = new ObjectIdentity(objectType, node.getContentObject().getId());
                Folder folder = this.folderService.getFolderById(objectIdentity);
                this.folderService.deleteFolder(folder);
            } else if (objectType == 82L) {
                ObjectIdentity objectIdentity = new ObjectIdentity(objectType, node.getContentObject().getId());
                Document document = this.documentService.getDocumentById(objectIdentity);
                this.documentService.deleteDocument(document);
            }
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public void addPackageToZip(ZipOutputStream zipOut) {
    }
}

