/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.transport.spi;

import com.sas.svcs.content.transport.client.ContentItem;
import com.sas.svcs.content.transport.spi.ExportPersistenceSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class FileExportPersistenceSupport
implements ExportPersistenceSupport {
    public static final String ATTRIBUTES_FILE = "attributes.properties";
    private String baseDirectory;
    private String packageId;
    private String type;

    public FileExportPersistenceSupport(String baseDirectory, String packageId, String type) {
        this.baseDirectory = baseDirectory;
        this.packageId = packageId;
        this.type = type;
    }

    @Override
    public boolean writeContentItem(ContentItem item) {
        String name;
        boolean result = true;
        if (item == null) {
            return false;
        }
        if ((item.getContent() == null || item.getContent().length == 0) && item.getAttributes() == null) {
            return false;
        }
        File file = new File(this.baseDirectory + File.separator + this.packageId + File.separator + this.type + File.separator + item.getName());
        if (!file.mkdirs()) {
            return false;
        }
        Properties properties = item.getAttributes();
        if (properties != null) {
            File propFile = new File(file, ATTRIBUTES_FILE);
            try {
                FileOutputStream fos = new FileOutputStream(propFile);
                properties.store(fos, "attribute properties for " + item.getName());
                fos.close();
            }
            catch (IOException ex) {
                result = false;
            }
        }
        if ((name = item.getContentName()) == null) {
            name = item.getName();
        }
        try {
            File contentFile = new File(file, name);
            FileOutputStream fos = new FileOutputStream(contentFile);
            fos.write(item.getContent());
            fos.close();
        }
        catch (IOException ex) {
            result = false;
        }
        return result;
    }

    @Override
    public ContentItem readContentItem(String name) {
        ContentItem result = new ContentItem();
        result.setName(name);
        File file = new File(this.baseDirectory + File.separator + this.packageId + File.separator + this.type + File.separator + name);
        if (!file.exists()) {
            return null;
        }
        try {
            File propFile = new File(file, ATTRIBUTES_FILE);
            if (propFile.exists()) {
                FileInputStream fis = new FileInputStream(propFile);
                Properties prop = new Properties();
                prop.load(fis);
                fis.close();
                result.setAttributes(prop);
            }
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File nextFile = files[i];
                if (nextFile.getName().equals(ATTRIBUTES_FILE)) continue;
                result.setContentName(nextFile.getName());
                FileInputStream fis = new FileInputStream(nextFile);
                int bytesToRead = fis.available();
                byte[] content = new byte[bytesToRead];
                int bytesRead = fis.read(content);
                if (bytesRead < bytesToRead) {
                    System.out.println("input short.");
                }
                result.setContent(content);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    @Override
    public List<String> getItemNames() {
        ArrayList<String> result = new ArrayList<String>();
        File file = new File(this.baseDirectory + File.separator + this.packageId + File.separator + this.type);
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            result.add(files[i].getName());
        }
        return result;
    }

    @Override
    public void deletePackage() {
        File file = new File(this.baseDirectory + File.separator + this.packageId);
        if (!file.exists()) {
            return;
        }
        this.deleteDir(file);
    }

    private void deleteDir(File dirToDelete) {
        try {
            File[] fileList = dirToDelete.listFiles();
            for (int i = 0; i < fileList.length; ++i) {
                File nextFile = fileList[i];
                if (nextFile.isDirectory()) {
                    this.deleteDir(nextFile);
                    continue;
                }
                nextFile.delete();
            }
            dirToDelete.delete();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.getMessage(), ex);
        }
    }

    @Override
    public void addPackageToZip(ZipOutputStream zipOut) {
        String dir2zip = this.baseDirectory + "/" + this.packageId;
        this.zipDir(dir2zip, zipOut);
    }

    private void zipDir(String dir2zip, ZipOutputStream zos) {
        try {
            File zipDir = new File(dir2zip);
            String[] dirList = zipDir.list();
            byte[] readBuffer = new byte[2156];
            int bytesIn = 0;
            for (int i = 0; i < dirList.length; ++i) {
                File f = new File(zipDir, dirList[i]);
                if (f.isDirectory()) {
                    String filePath = f.getPath();
                    this.zipDir(filePath, zos);
                    continue;
                }
                FileInputStream fis = new FileInputStream(f);
                String zipPath = f.getPath().substring(this.baseDirectory.length() + this.packageId.length() + 1);
                ZipEntry anEntry = new ZipEntry(zipPath);
                zos.putNextEntry(anEntry);
                while ((bytesIn = fis.read(readBuffer)) != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                }
                fis.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

