/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.transport.client;

import com.sas.storage.editableproperties.SectionedPropertyMap;
import com.sas.svcs.commons.ObjectIdentity;
import com.sas.svcs.content.framework.client.ContentException;
import com.sas.svcs.content.transport.client.MalformedMappingException;
import com.sas.svcs.content.transport.client.TransportMapping;
import com.sas.svcs.content.transport.client.TransportMappingService;
import com.sas.svcs.content.transport.client.mapping.TransportPromptModel;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import org.springframework.util.Assert;

public class TransportMappingUtil {
    public static TransportMapping createMapping(TransportMappingService mappingService, File mappingFile) throws FileNotFoundException, ContentException {
        Assert.notNull((Object)mappingFile);
        try {
            FileReader reader = new FileReader(mappingFile);
            SectionedPropertyMap propertyMap = new SectionedPropertyMap();
            propertyMap.load((Reader)reader);
            ((Reader)reader).close();
            TransportMapping mapping = new TransportMapping();
            mapping.setName(mappingFile.getName());
            TransportPromptModel promptModel = mappingService.deserialize(propertyMap);
            mapping.setPromptModel(promptModel);
            return mapping;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (MalformedMappingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ContentException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static TransportMapping createMapping(TransportMappingService mappingService, String fileName) throws FileNotFoundException, ContentException {
        String extension = ".subprop";
        if (!fileName.endsWith(".subprop") && !fileName.endsWith(".subprop".toUpperCase())) {
            fileName = fileName + ".subprop";
        }
        File file = new File(fileName);
        return TransportMappingUtil.createMapping(mappingService, file);
    }

    public static TransportMapping uploadMapping(TransportMappingService mappingService, String fileName, ObjectIdentity parentIdentity) throws FileNotFoundException, ContentException {
        TransportMapping mapping = TransportMappingUtil.createMapping(mappingService, fileName);
        return mappingService.create(mapping, parentIdentity);
    }
}

