/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.content.search.client.value;

import com.sas.svcs.content.search.client.namepath.ValueFormatException;
import com.sas.svcs.content.search.client.value.BaseNonStreamValue;
import com.sas.svcs.content.search.client.value.StatefulValue;
import java.io.Serializable;
import java.util.Calendar;

public class LongValue
extends BaseNonStreamValue
implements Serializable,
StatefulValue {
    private static final long serialVersionUID = 2115837525193497922L;
    private final long value;

    protected LongValue(long value) {
        this.value = value;
    }

    protected LongValue(String value) throws ValueFormatException {
        this(LongValue.toLong(value));
    }

    protected static long toLong(String value) throws ValueFormatException {
        try {
            return Long.valueOf(value);
        }
        catch (NumberFormatException e) {
            throw new ValueFormatException(e);
        }
    }

    @Override
    public int getType() {
        return 3;
    }

    @Override
    public Calendar getDate() throws ValueFormatException {
        Calendar date = Calendar.getInstance();
        date.setTimeInMillis(this.value);
        return date;
    }

    @Override
    public long getLong() {
        return this.value;
    }

    @Override
    public String getString() {
        return Long.toString(this.value);
    }

    @Override
    public double getDouble() {
        return this.value;
    }
}

